/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;

public class SNCarryingConfigEditPlugin
extends AbstractBasePlugIn {
    private static final List<String> REMOVE_COLS = new ArrayList<String>(Arrays.asList("startdate,enddate,srcsupplier.number,srcsupplier.name,stockdate,suppliersn,descustomer.number,descustomer.name,shipmentdate,keeporg.number,keeporg.name,keeporg.fullname,keeporg.longnumber,dept.number,dept.name,dept.fullname,dept.longnumber,user.operatorname,user.operatornumber,bizhappendate,creator.number,creator.name,creator.picturefield,createtime,modifier.picturefield,modifytime,disabler.number,disabler.name,disabler.picturefield,disabledate,status,enable,nowinvaccid,isimport,sbillinvfluctuation,occupybillid,sourcebilltype.number,sourcebilltype.name,occupybilltype.number,occupybilltype.name,sourcebillentrytype,occupybillentrytype,sourcebillentryid,occupybillentryid,finalaudittrailid,masterfiletype.number,masterfiletype.name,masterfiletype.enable,project.number,project.name,project.longnumber,project.fullname,modifier.number,modifier.name,lot.number,material.isuseauxpty,material.auxpty.number,material.auxpty.name,auxpty,billid,invorg.fullname,invorg.longnumber,increaseinvcounter,substractinvcounter,traincreaseinvcounter,trasubstractinvcounter,warehouse.number,warehouse.name,location.number,location.name".split("\\,")));
    public static final String ISVIRTUALBILL = "isvirtualbill";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setPreConditionGrid();
        this.setRangeFilterGrid();
        this.bindFilterInfo();
    }

    private void bindFilterInfo() {
        String preconditionFilterStr = this.getModel().getDataEntity().getString("preconditionfilter_tag");
        FilterCondition precondition = null;
        precondition = StringUtils.isBlank((CharSequence)preconditionFilterStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)preconditionFilterStr, FilterCondition.class);
        FilterGrid preconditionGrid = (FilterGrid)this.getControl("precondition");
        preconditionGrid.SetValue(precondition);
        String snRangeFilterStr = this.getModel().getDataEntity().getString("snrangefilter_tag");
        FilterCondition snRange = null;
        snRange = StringUtils.isBlank((CharSequence)snRangeFilterStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)snRangeFilterStr, FilterCondition.class);
        FilterGrid snRangeGrid = (FilterGrid)this.getControl("snrange");
        snRangeGrid.SetValue(snRange);
    }

    private void setRangeFilterGrid() {
        IFormView view = this.getView();
        FilterGrid snrangeFilterGrid = (FilterGrid)view.getControl("snrange");
        EntityTypeUtil helper = new EntityTypeUtil();
        MainEntityType bdSnMainFile = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
        List snMainFileCols = helper.getFilterColumns((IDataEntityType)bdSnMainFile, true);
        List<String> muliLangTextFields = this.getRemoveFields(bdSnMainFile);
        REMOVE_COLS.addAll(muliLangTextFields);
        snMainFileCols = snMainFileCols.stream().filter(col -> {
            String fieldName = (String)col.get("fieldName");
            return !REMOVE_COLS.contains(fieldName);
        }).collect(Collectors.toList());
        snrangeFilterGrid.setEntityNumber("bd_snmainfile");
        snrangeFilterGrid.setFilterColumns(snMainFileCols);
        view.updateView("snrange");
    }

    private void setPreConditionGrid() {
        FilterGrid preconditionFilterGrid = (FilterGrid)this.getControl("precondition");
        MainEntityType entityType = this.getTargetBillMainEntityType();
        EntityTypeUtil helper = new EntityTypeUtil();
        if (entityType == null) {
            preconditionFilterGrid.setFilterColumns(Collections.emptyList());
        } else {
            List<String> removeFields = this.getRemoveFields(entityType);
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            cols = cols.stream().filter(i -> !removeFields.contains(i.get("fieldName"))).collect(Collectors.toList());
            preconditionFilterGrid.setEntityNumber(entityType.getName());
            preconditionFilterGrid.setFilterColumns(cols);
        }
        this.getView().updateView("precondition");
    }

    private MainEntityType getTargetBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = model.getDataEntity().getDynamicObject("targetbilltype");
        if (sourceBill == null) {
            return null;
        }
        String metaDataNo = sourceBill.getString("number");
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
            return mainEntityType;
        }
        catch (KDException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    private void setEnable() {
        Boolean isPreset = this.getModel().getDataEntity().getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conentpanel"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        switch (key) {
            case "targetbilltype": {
                DynamicObject newObject = (DynamicObject)changeDatas[0].getNewValue();
                DynamicObject oldObject = (DynamicObject)changeDatas[0].getOldValue();
                this.changeTargetBillType(newObject, oldObject);
                break;
            }
        }
    }

    private void changeTargetBillType(DynamicObject newObject, DynamicObject oldObject) {
        if (Objects.isNull(oldObject)) {
            this.setPreConditionGrid();
        } else {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("precondition", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u5207\u6362\u540e\uff0c\u524d\u7f6e\u6761\u4ef6\u5c06\u4f1a\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"SNCarryingConfigEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            this.getPageCache().put("oldTargetType", oldObject.getString("number"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String backId = event.getCallBackId();
        MessageBoxResult reult = event.getResult();
        switch (backId) {
            case "precondition": {
                this.changeTargetBillType(reult);
                break;
            }
        }
    }

    private void changeTargetBillType(MessageBoxResult result) {
        if (result.equals((Object)MessageBoxResult.Yes)) {
            FilterGrid preconditionFilterGrid = (FilterGrid)this.getView().getControl("precondition");
            this.clearFilterGrid(preconditionFilterGrid);
            this.setPreConditionGrid();
        } else {
            this.setOldInfo();
        }
    }

    private List<String> getRemoveFields(MainEntityType entityType) {
        Map allFields = entityType.getAllFields();
        ArrayList<String> removeFields = new ArrayList<String>();
        for (Map.Entry field : allFields.entrySet()) {
            if (!(field.getValue() instanceof MuliLangTextProp)) continue;
            removeFields.add((String)field.getKey());
        }
        removeFields.add(ISVIRTUALBILL);
        return removeFields;
    }

    private void setOldInfo() {
        String oldTargetType = this.getPageCache().get("oldTargetType");
        this.getModel().beginInit();
        this.getModel().setValue("targetbilltype", (Object)oldTargetType);
        this.getModel().endInit();
        this.getView().updateView("targetbilltype");
    }

    private void clearFilterGrid(FilterGrid preconditionFilterGrid) {
        FilterGrid.FilterGridState filterGridState = preconditionFilterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        List listFilter = condition.getFilterRow();
        listFilter.clear();
        condition.setFilterRow(listFilter);
        preconditionFilterGrid.SetValue(condition);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String preConditionFilterInfo = this.parseBillFilterInfo("precondition");
        model.setValue("preconditionfilter", (Object)(preConditionFilterInfo.length() < 200 ? preConditionFilterInfo : preConditionFilterInfo.substring(0, 200)));
        model.setValue("preconditionfilter_tag", (Object)preConditionFilterInfo);
        String snRangeFilterInfo = this.parseBillFilterInfo("snrange");
        model.setValue("snrangefilter", (Object)(snRangeFilterInfo.length() < 200 ? snRangeFilterInfo : snRangeFilterInfo.substring(0, 200)));
        model.setValue("snrangefilter_tag", (Object)snRangeFilterInfo);
    }

    private String parseBillFilterInfo(String type) {
        FilterGrid grid = (FilterGrid)this.getControl(type);
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }
}

