/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sbs.business.sn.mainfile.SNMainFileStatusCalHelper;
import kd.scmc.sbs.lang.SNLang;
import kd.scmc.sbs.mservice.SnInvaccRelRestoreServiceImpl;

public class SNMainFileFixEditPlugin
extends AbstractFormPlugin {
    private static final String BAR_DATA_STATUS = "updatedatastatus";
    private static final String BAR_INVACCREL = "updateinvaccrel";
    private static final String BAR_CLEAR_INFO = "clearinfo";
    private static final String BAR_REFRESH_COUNTER = "refreshcounter";
    private static final String SELECT_MAINFILE = "selectsnmainfile";
    private static final String ENTRY_SN_MIANFILE_INFO = "snmainfileinfo";
    private static final String E_SN_MAINFILE = "snmainfile";
    private static final String E_FIX_SNSTATUS = "fixsnstatus";
    private static final String BUTTON_FIXDATA = "fixdata";
    private static final String CONTROL_FILTERGRID = "filtergridap";
    private static final String SRVSUBMIT = "srvsubmit";
    private static final String SRVUNSUBMIT = "srvunsubmit";
    private static final String SRVAUDIT = "srvaudit";
    private static final String SRVUNAUDIT = "srvunaudit";
    private static final String LOTSRVAUDIT = "lotsrvaudit";
    private static final String LOTSRVUNAUDIT = "lotsrvunaudit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        this.addClickListeners(new String[]{BUTTON_FIXDATA, SRVSUBMIT, SRVUNSUBMIT, SRVAUDIT, SRVUNAUDIT, LOTSRVAUDIT, LOTSRVUNAUDIT});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilterGrid();
    }

    private void setFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTERGRID);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(cols);
        this.getView().updateView(CONTROL_FILTERGRID);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control c = (Control)e.getSource();
        switch (key = c.getKey()) {
            case "fixdata": {
                this.fixSelectSNData();
                break;
            }
            case "srvsubmit": {
                this.serviceCall("submit");
                break;
            }
            case "srvunsubmit": {
                this.serviceCall("unsubmit");
                break;
            }
            case "srvaudit": {
                this.serviceCall("audit");
                break;
            }
            case "srvunaudit": {
                this.serviceCall("unaudit");
                break;
            }
            case "lotsrvaudit": {
                this.serviceCall(LOTSRVAUDIT);
                break;
            }
            case "lotsrvunaudit": {
                this.serviceCall(LOTSRVUNAUDIT);
                break;
            }
        }
    }

    private void fixSelectSNData() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_SN_MIANFILE_INFO);
        int[] rowIndexs = grid.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showTipNotification(SNLang.plsSelectSnMainFile());
            return;
        }
        String sql = "UPDATE T_BD_SNMAINFILE SET fsbillinvfluctuation = ?,fincreaseinvcounter = ?,fsubstractinvcounter = ?,ftraincreaseinvcounter = ?,ftrasubstractinvcounter = ?,fsnstatus = ?WHERE FID = ?";
        ArrayList<Object[]> objs = new ArrayList<Object[]>(rowIndexs.length);
        for (int index : rowIndexs) {
            String sourceBillInvFluctuation = (String)this.getModel().getValue("sbillinvfluctuation", index);
            Integer increaseInvCounter = (Integer)this.getModel().getValue("increaseinvcounter", index);
            Integer substractInvCounter = (Integer)this.getModel().getValue("substractinvcounter", index);
            Integer transIncreaseInvCounter = (Integer)this.getModel().getValue("traincreaseinvcounter", index);
            Integer transSubstractInvCounter = (Integer)this.getModel().getValue("trasubstractinvcounter", index);
            String snstatus = (String)this.getModel().getValue(E_FIX_SNSTATUS, index);
            DynamicObject mainFileObj = (DynamicObject)this.getModel().getValue(E_SN_MAINFILE, index);
            Object[] obj = new Object[]{sourceBillInvFluctuation, increaseInvCounter, substractInvCounter, transIncreaseInvCounter, transSubstractInvCounter, snstatus, mainFileObj.getPkValue()};
            objs.add(obj);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
        DBRoute route = new DBRoute(entityType.getDBRouteKey());
        DB.executeBatch((DBRoute)route, (String)sql, objs);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"SNMainFileFixEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
        this.refreshCounter();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "updatedatastatus": {
                this.updateAllDataStatus();
                break;
            }
            case "updateinvaccrel": {
                this.updateInvaccRel();
                break;
            }
            case "clearinfo": {
                this.clearInfo();
                break;
            }
            case "refreshcounter": {
                this.refreshCounter();
                break;
            }
        }
    }

    private void refreshCounter() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_SN_MIANFILE_INFO);
        HashSet<Long> mainFileIds = new HashSet<Long>(16);
        for (DynamicObject obj : collection) {
            DynamicObject mainFile = obj.getDynamicObject(E_SN_MAINFILE);
            mainFileIds.add(mainFile.getLong("id"));
        }
        this.clearInfo();
        this.handleSNMainFileObjs(new QFilter("id", "in", mainFileIds));
    }

    private void clearInfo() {
        this.getModel().deleteEntryData(ENTRY_SN_MIANFILE_INFO);
    }

    private void updateAllDataStatus() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_snmainfile");
        DBRoute route = new DBRoute(entityType.getDBRouteKey());
        DB.execute((DBRoute)route, (String)"UPDATE T_BD_SNMAINFILE SET FSTATUS = 'C' ,FENABLE = '1'");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (key) {
            case "selectsnmainfile": {
                this.handleSelectMainFile((DynamicObjectCollection)newValue);
                break;
            }
            case "sbillinvfluctuation": 
            case "increaseinvcounter": 
            case "substractinvcounter": 
            case "traincreaseinvcounter": 
            case "trasubstractinvcounter": {
                this.mainFileInvCounterinfoChange(changeSet[0].getRowIndex());
                break;
            }
        }
    }

    private void mainFileInvCounterinfoChange(int index) {
        String sourceBillInvFluctuation = (String)this.getModel().getValue("sbillinvfluctuation", index);
        Integer increaseInvCounter = (Integer)this.getModel().getValue("increaseinvcounter", index);
        Integer substractInvCounter = (Integer)this.getModel().getValue("substractinvcounter", index);
        Integer transIncreaseInvCounter = (Integer)this.getModel().getValue("traincreaseinvcounter", index);
        Integer transSubstractInvCounter = (Integer)this.getModel().getValue("trasubstractinvcounter", index);
        String mainFileStatus = SNMainFileStatusCalHelper.calMainFileStatus(sourceBillInvFluctuation, increaseInvCounter, substractInvCounter, transIncreaseInvCounter, transSubstractInvCounter);
        this.getModel().setValue(E_FIX_SNSTATUS, (Object)mainFileStatus, index);
    }

    private void handleSelectMainFile(DynamicObjectCollection selectMainFiles) {
        this.clearInfo();
        if (selectMainFiles == null || selectMainFiles.size() == 0) {
            return;
        }
        HashSet<Long> mainFileIds = new HashSet<Long>();
        for (DynamicObject mianFileObj : selectMainFiles) {
            DynamicObject mainFiles = mianFileObj.getDynamicObject("fbasedataid");
            mainFileIds.add(mainFiles.getLong("id"));
        }
        this.handleSNMainFileObjs(new QFilter("id", "in", mainFileIds));
    }

    private void handleSNMainFileObjs(QFilter mainFileFilter) {
        DynamicObject[] mianFileObjs = BusinessDataServiceHelper.load((String)"bd_snmainfile", (String)"id,number,sbillinvfluctuation,increaseinvcounter,substractinvcounter,traincreaseinvcounter,trasubstractinvcounter,snstatus", (QFilter[])mainFileFilter.toArray(), (String)"number asc");
        this.getModel().beginInit();
        for (DynamicObject mianFileObj : mianFileObjs) {
            int index = this.getModel().createNewEntryRow(ENTRY_SN_MIANFILE_INFO);
            this.getModel().setValue(E_SN_MAINFILE, (Object)mianFileObj, index);
            this.getModel().setValue("srcsbillinvfluctuation", mianFileObj.get("sbillinvfluctuation"), index);
            this.getModel().setValue("srcincreaseinvcounter", mianFileObj.get("increaseinvcounter"), index);
            this.getModel().setValue("srcsubstractinvcounter", mianFileObj.get("substractinvcounter"), index);
            this.getModel().setValue("srctraincreaseinvcounter", mianFileObj.get("traincreaseinvcounter"), index);
            this.getModel().setValue("srctrasubstractinvcounter", mianFileObj.get("trasubstractinvcounter"), index);
            this.getModel().setValue("srcfixsnstatus", mianFileObj.get("snstatus"), index);
            this.getModel().setValue("sbillinvfluctuation", mianFileObj.get("sbillinvfluctuation"), index);
            this.getModel().setValue("increaseinvcounter", mianFileObj.get("increaseinvcounter"), index);
            this.getModel().setValue("substractinvcounter", mianFileObj.get("substractinvcounter"), index);
            this.getModel().setValue("traincreaseinvcounter", mianFileObj.get("traincreaseinvcounter"), index);
            this.getModel().setValue("trasubstractinvcounter", mianFileObj.get("trasubstractinvcounter"), index);
            this.getModel().setValue(E_FIX_SNSTATUS, mianFileObj.get("snstatus"), index);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_SN_MIANFILE_INFO);
    }

    private void serviceCall(String operate) {
        IDataModel model = this.getModel();
        DynamicObject billtypeObj = (DynamicObject)model.getValue("billtype");
        if (billtypeObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"SNMainFileFixEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return;
        }
        String billtype = billtypeObj.getString("number");
        DynamicObjectCollection bills = model.getEntryEntity("billlist");
        HashSet<String> billnos = new HashSet<String>(bills.size());
        for (DynamicObject bill : bills) {
            String billno = bill.getString("billno");
            if (billno == null || billno.isEmpty()) continue;
            billnos.add(billno);
        }
        if (billnos.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7f16\u53f7\u3002", (String)"SNMainFileFixEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return;
        }
        List billids = QueryServiceHelper.queryPrimaryKeys((String)billtype, (QFilter[])new QFilter("billno", "in", billnos).toArray(), null, (int)-1);
        if (billids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u636e,\u65e0\u9700\u6267\u884c\u3002", (String)"SNMainFileFixEditPlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return;
        }
        ArrayList billidsLong = new ArrayList(billids.size());
        billids.forEach(id -> {
            if (id != null && !id.equals(0L)) {
                billidsLong.add((Long)id);
            }
        });
        if (!billidsLong.isEmpty()) {
            if (LOTSRVAUDIT.equals(operate)) {
                DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"handleLotByOperate", (Object[])new Object[]{billtype, "audit", billidsLong});
            } else if (LOTSRVUNAUDIT.equals(operate)) {
                DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"handleLotByOperate", (Object[])new Object[]{billtype, "unaudit", billidsLong});
            } else {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"handleSNByBillOperate", (Object[])new Object[]{billtype, operate, billidsLong});
            }
        }
    }

    private void updateInvaccRel() {
        new SnInvaccRelRestoreServiceImpl().beforeExecuteSqlWithResult(null, null, null, null);
    }
}

