/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class BalanceinvSchemeUpdateServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog((String)"kd.scmc.sbs.mservice.BalanceinvSchemeUpdateServiceImpl");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "select a.fid as id,b.fdimension as dimension from t_sbs_balanceinvscheme a inner join t_msplan_invlevel b on a.finvlevelid = b.fid where a.finvlevelid !=0 and a.fdimensionid = 0";
        DataSet dataSet = DB.queryDataSet((String)BalanceinvSchemeUpdateServiceImpl.class.getName(), (DBRoute)scmRoute, (String)sql);
        HashMap<Long, Long> updateValue = new HashMap<Long, Long>(16);
        for (Object row : dataSet) {
            updateValue.put(row.getLong("id"), row.getLong("dimension"));
        }
        if (!updateValue.isEmpty()) {
            try {
                Object row;
                TXHandle handle = TX.requiresNew();
                row = null;
                try {
                    this.updateScheme(updateValue);
                    result.setSuccess(true);
                    result.setLog("data update successfully.");
                }
                catch (Throwable throwable) {
                    row = throwable;
                    throw throwable;
                }
                finally {
                    if (handle != null) {
                        if (row != null) {
                            try {
                                handle.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)row).addSuppressed(throwable);
                            }
                        } else {
                            handle.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                String exeMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.info(exeMsg);
                result.setSuccess(false);
                result.setErrorInfo(exeMsg);
            }
        }
        return result;
    }

    private void updateScheme(Map<Long, Long> value) {
        DBRoute scmRoute = new DBRoute("scm");
        String sql = "update t_sbs_balanceinvscheme set fdimensionid = ? where fid = ? ";
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(value.size());
        for (Map.Entry<Long, Long> entry : value.entrySet()) {
            Object[] objects = new Object[]{entry.getValue(), entry.getKey()};
            valueList.add(objects);
        }
        DB.executeBatch((DBRoute)scmRoute, (String)sql, valueList);
    }
}

