/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.mservice;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReserveScmParamUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        this.upgradeReservePeriod(scmRoute);
        this.upgradeAllowReserve(scmRoute);
        result.setSuccess(true);
        return result;
    }

    private void upgradeReservePeriod(DBRoute scmRoute) {
        try (TXHandle txHandle = TX.requiresNew();){
            QFilter materialQFilter = new QFilter("reservationperiod", ">", (Object)0);
            materialQFilter = materialQFilter.and("enable", "=", (Object)"1");
            if (QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])materialQFilter.toArray())) {
                String updateSql = "update t_sbs_scmcapplevelparam set fenable='1' where fnumber = 'RESERVE002'";
                DB.execute((DBRoute)scmRoute, (String)updateSql);
            }
        }
    }

    private void upgradeAllowReserve(DBRoute scmRoute) {
        try (TXHandle txHandle = TX.requiresNew();){
            QFilter materialQFilter = new QFilter("isreserve", "=", (Object)"0");
            materialQFilter = materialQFilter.and("enable", "=", (Object)"1");
            if (QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])materialQFilter.toArray())) {
                String updateSql = "update t_sbs_scmcapplevelparam set fenable='1' where fnumber = 'RESERVE001'";
                DB.execute((DBRoute)scmRoute, (String)updateSql);
            }
        }
    }
}

