/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.opplugin.reservation;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sbs.common.util.F7Utils;

public class ReserveSchemeValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        ExtendedDataEntity[] datas = this.getDataEntities();
        switch (key) {
            case "enable": {
                this.audit(datas);
                break;
            }
        }
    }

    private static String getMsgReserveSchemeBatchOp() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u6570\u636e\uff0c\u4e0d\u80fd\u8d85\u8fc71000\u6761\u3002", (String)"ReserveSchemeValidator_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveSchemeAutoReq() {
        return ResManager.loadKDString((String)"\u81ea\u52a8\u9884\u7559\u65b9\u6848\u201c\u540c\u4e00\u521b\u5efa\u7ec4\u7ec7\u548c\u540c\u4e00\u9700\u6c42\u5355\u636e\u201d\u7ef4\u5ea6\u4e0b\uff0c\u5df2\u5b58\u5728\u542f\u7528\u7684\u65b9\u6848\u201c%s\u201d\uff0c\u4e0d\u80fd\u542f\u7528\u591a\u6761\u3002", (String)"ReserveSchemeValidator_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveSchemeEnable() {
        return ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u91cd\u590d\u542f\u7528\u3002", (String)"ReserveSchemeValidator_2", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private void audit(ExtendedDataEntity[] datas) {
        if (datas.length > 1000) {
            throw new KDBizException(ReserveSchemeValidator.getMsgReserveSchemeBatchOp());
        }
        HashMap<String, ExtendedDataEntity> extDataMap = new HashMap<String, ExtendedDataEntity>(datas.length);
        HashSet<Object> requireBill = new HashSet<Object>();
        DynamicObject data = null;
        String dataKey = null;
        ExtendedDataEntity data4Check = null;
        for (ExtendedDataEntity extData : datas) {
            data = extData.getDataEntity();
            if (!data.getBoolean("isautoreserve")) continue;
            dataKey = this.getDataKey(data);
            data4Check = (ExtendedDataEntity)extDataMap.get(dataKey);
            if (data4Check == null) {
                extDataMap.put(dataKey, extData);
                requireBill.add(data.getDynamicObject("requirebill").getPkValue());
                continue;
            }
            this.addFatalErrorMessage(extData, String.format(ReserveSchemeValidator.getMsgReserveSchemeAutoReq(), data4Check.getBillNo()));
        }
        if (extDataMap.isEmpty()) {
            return;
        }
        QFilter fs = new QFilter("requirebill", "in", requireBill);
        fs.and("isautoreserve", "=", (Object)"1");
        fs.and("datastatus", "=", (Object)"1");
        String selectCols = F7Utils.getSelectCols("createorg", "requirebill", "id", "number");
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)ReserveSchemeValidator.class.getName(), (String)"sbs_reserve_st", (String)selectCols, (QFilter[])fs.toArray(), null);){
            for (Row row : queryDataSet) {
                dataKey = row.get("createorg") + "_" + row.get("requirebill");
                data4Check = (ExtendedDataEntity)extDataMap.get(dataKey);
                if (data4Check == null) continue;
                if (row.getLong("id").equals(data4Check.getDataEntity().getPkValue())) {
                    this.addErrorMessage(data4Check, ReserveSchemeValidator.getMsgReserveSchemeEnable());
                    continue;
                }
                this.addFatalErrorMessage(data4Check, String.format(ReserveSchemeValidator.getMsgReserveSchemeAutoReq(), row.get("number")));
            }
        }
    }

    private String getDataKey(DynamicObject data) {
        Object org = data.getDynamicObject("createorg").getPkValue();
        Object requireBill = data.getDynamicObject("requirebill").getPkValue();
        return org + "_" + requireBill;
    }
}

