/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.opplugin.sn;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SNBillConfigSaveValidator
extends AbstractValidator {
    private static int MAX_CFG_LIMITS = 10;

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            this.validMainEntity(extendedDataEntity);
            this.validOperateentry(extendedDataEntity);
            this.validSnmainfentry(extendedDataEntity);
            this.validInputSnEntry(extendedDataEntity);
        }
    }

    private void validInputSnEntry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject snBillConfig = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entries = snBillConfig.getDynamicObjectCollection("inputsnentity");
        for (DynamicObject entry : entries) {
            Integer seq = entry.getInt("seq");
            String billRelationCol = entry.getString("billsnrelationcol");
            if (StringUtils.isEmpty((String)billRelationCol)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7\u6620\u5c04\u914d\u7f6e\u7b2c{0}\u884c\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u5185\u5bb9\u3002", (String)"SNBillConfigSaveValidator_7", (String)"scmc-sbs-form", (Object[])new Object[]{seq}));
                continue;
            }
            String moveTrackCol = entry.getString("snmovetrackrelcol");
            if (StringUtils.isEmpty((String)moveTrackCol)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7\u6620\u5c04\u914d\u7f6e\u7b2c{0}\u884c\u672a\u914d\u7f6e\u5e8f\u5217\u53f7\u8f68\u8ff9\u5173\u8054\u8868\u5b57\u6bb5\u3002", (String)"SNBillConfigSaveValidator_8", (String)"scmc-sbs-form", (Object[])new Object[]{seq}));
                continue;
            }
            if (!entry.getBoolean("updatemainfile")) continue;
            String mainFileCol = entry.getString("snmainfilecol");
            String updateWayCol = entry.getString("updateway");
            if (StringUtils.isEmpty((String)mainFileCol)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7\u6620\u5c04\u914d\u7f6e\u7b2c{0}\u884c\u542f\u7528\u4e86\u201c\u66f4\u65b0\u5230\u4e3b\u6863\u201d\uff0c\u5b57\u6bb5\u201c\u5e8f\u5217\u53f7\u4e3b\u6863\u201d\u5fc5\u5f55\u3002", (String)"SNBillConfigSaveValidator_9", (String)"scmc-sbs-form", (Object[])new Object[]{seq}));
            }
            if (!StringUtils.isEmpty((String)updateWayCol)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7\u6620\u5c04\u914d\u7f6e\u7b2c{0}\u884c\u542f\u7528\u4e86\u201c\u66f4\u65b0\u5230\u4e3b\u6863\u201d\uff0c\u5b57\u6bb5\u201c\u8d4b\u503c\u65b9\u5f0f\u201d\u5fc5\u5f55\u3002", (String)"SBS-W-300188", (String)"scmc-sbs-form", (Object[])new Object[]{seq}));
        }
    }

    private void validMainEntity(ExtendedDataEntity extendedDataEntity) {
        MaterielProp materielProp;
        String realCol;
        MainEntityType billTypeInfo;
        Map property;
        int cfgnums;
        DynamicObject snbillConfig = extendedDataEntity.getDataEntity();
        Long id = snbillConfig.getLong("id");
        String billtype = snbillConfig.getDynamicObject("srcbillobj").getString("number");
        String billentry = snbillConfig.getString("srcbillentry");
        if (id.equals(0L) && (cfgnums = QueryServiceHelper.queryPrimaryKeys((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)billentry).toArray(), null, (int)-1).size()) >= MAX_CFG_LIMITS) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u76f8\u540c\u6765\u6e90\u5355\u636e+\u6765\u6e90\u5355\u636e\u4f53\u914d\u7f6e\u89c4\u5219\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u3002", (String)"SNBillConfigSaveValidator_0", (String)"scmc-sbs-form", (Object[])new Object[0]), MAX_CFG_LIMITS));
        }
        boolean snreqbill = snbillConfig.getBoolean("snreqbill");
        boolean allowsplit = snbillConfig.getBoolean("allowsplit");
        if (snreqbill && allowsplit) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\u201c\u4ec5\u5360\u7528\u5e8f\u5217\u53f7\u201d\u548c\u201c\u652f\u6301\u5206\u6279\u66f4\u65b0\u201d\u3002", (String)"SNBillConfigSaveValidator_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        String materialCol = snbillConfig.getString("materialcol");
        String materialMasterCol = snbillConfig.getString("materialmastercol");
        if (StringUtils.isEmpty((String)materialCol) && StringUtils.isEmpty((String)materialMasterCol)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5b57\u6bb5\u6807\u8bc6\u201c\u3001 \u201d\u7269\u6599\u5b57\u6bb5\u6807\u8bc6\u201d\u5fc5\u987b\u586b\u5199\u5176\u4e2d1\u4e2a\u5b57\u6bb5\u3002", (String)"SNBillConfigSaveValidator_5", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)materialCol) && (property = (billTypeInfo = EntityMetadataCache.getDataEntityType((String)billtype)).getAllFields()).containsKey(realCol = materialCol.substring(materialCol.indexOf(billentry) + billentry.length() + 1)) && (materielProp = (MaterielProp)property.get(realCol)) != null && !"bd_materialinventoryinfo".equals(materielProp.getBaseEntityId())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5b57\u6bb5\u6807\u8bc6\u201d\u4e0d\u662f\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SNBillConfigSaveValidator_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
    }

    private void validOperateentry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject snbillConfig = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entries = snbillConfig.getDynamicObjectCollection("operateentry");
        for (DynamicObject entry : entries) {
            Integer seq = entry.getInt("seq");
            String snServices = entry.getString("snservices");
            if (snServices == null) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u64cd\u4f5c\u6620\u5c04\u7b2c%s\u884c\u7684\u201c\u5e8f\u5217\u53f7\u670d\u52a1\u201d\u3002", (String)"SNBillConfigSaveValidator_2", (String)"scmc-sbs-form", (Object[])new Object[0]), seq));
                continue;
            }
            List<String> snServicesList = Arrays.asList(snServices.substring(1, snServices.length() - 1).split(","));
            if (snServicesList.size() < 2 || ",1,3,".equals(snServices) || ",3,1,".equals(snServices)) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6620\u5c04\u884c%d\u9009\u62e9\u591a\u4e2a\u5e8f\u5217\u53f7\u670d\u52a1\u65f6\u53ea\u5141\u8bb8\u201c\u5360\u7528\u201d\u548c\u201c\u5904\u7406\u201d\u7684\u7ec4\u5408\u3002", (String)"SNBillConfigSaveValidator_3", (String)"scmc-sbs-form", (Object[])new Object[0]), seq));
        }
    }

    private void validSnmainfentry(ExtendedDataEntity extendedDataEntity) {
        DynamicObject snbillConfig = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entries = snbillConfig.getDynamicObjectCollection("snmainfentry");
        boolean orgFlag = false;
        for (DynamicObject entry : entries) {
            String snmainfcol = entry.getString("snmainfcol");
            if (!"invorg".equals(snmainfcol)) continue;
            orgFlag = true;
        }
        if (!orgFlag) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u4e3b\u6863\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u521b\u5efa\u7ec4\u7ec7\u5b57\u6bb5\u6620\u5c04\u3002", (String)"SNBillConfigSaveValidator_4", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
    }
}

