/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.validator.balanceinv;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BalanceInvSchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> balanceInvOrgs = new HashSet<Long>(this.dataEntities.length);
        HashMap<String, String> signToNameMapping = new HashMap<String, String>(this.dataEntities.length);
        HashSet<String> noticedFields = new HashSet<String>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkDemAndSupEntry(dataEntity, balanceInvOrgs);
            this.checkMustInput(dataEntity);
            this.checkDemandOrgMapping(dataEntity, noticedFields);
            this.getFieldMapping(dataEntity, signToNameMapping);
        }
        this.checkPriorityFieldRef(signToNameMapping, noticedFields);
        this.checkMappingDimenFiledRef();
    }

    private void checkMappingDimenFiledRef() {
        DynamicObject sourceObj;
        DynamicObject targetObj;
        DynamicObject mappingDimen;
        DynamicObject entity;
        HashMap<String, String> demandSignToNameMapping = new HashMap<String, String>(this.dataEntities.length);
        HashMap<String, String> supplySignToNameMapping = new HashMap<String, String>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            entity = dataEntity.getDataEntity();
            mappingDimen = entity.getDynamicObject("mappingdimen");
            targetObj = mappingDimen.getDynamicObject("targetobj");
            sourceObj = mappingDimen.getDynamicObject("sourcebill");
            DynamicObjectCollection colsMap = mappingDimen.getDynamicObjectCollection("colsmap");
            for (DynamicObject mapping : colsMap) {
                if (targetObj.getString("number").equals("balanceinv_demandbill")) {
                    demandSignToNameMapping.put(mapping.getString("targetobjcol"), mapping.getString("targetobjcolno"));
                } else if (targetObj.getString("number").equals("balanceinv_supplybill")) {
                    supplySignToNameMapping.put(mapping.getString("targetobjcol"), mapping.getString("targetobjcolno"));
                }
                if (sourceObj.getString("number").equals("balanceinv_demandbill")) {
                    demandSignToNameMapping.put(mapping.getString("sourcebillcol"), mapping.getString("sourcebillcolno"));
                    continue;
                }
                if (!sourceObj.getString("number").equals("balanceinv_supplybill")) continue;
                supplySignToNameMapping.put(mapping.getString("sourcebillcol"), mapping.getString("sourcebillcolno"));
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            entity = dataEntity.getDataEntity();
            mappingDimen = entity.getDynamicObject("mappingdimen");
            targetObj = mappingDimen.getDynamicObject("targetobj");
            sourceObj = mappingDimen.getDynamicObject("sourcebill");
            String demandTip = targetObj.getString("number").equals("balanceinv_demandbill") ? ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvSchemeSaveValidator_13", (String)"scmc-sbs-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u6765\u6e90\u5355\u636e\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvSchemeSaveValidator_14", (String)"scmc-sbs-form", (Object[])new Object[0]);
            String supplyTip = sourceObj.getString("number").equals("balanceinv_supplybill") ? ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u6765\u6e90\u5355\u636e\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvSchemeSaveValidator_15", (String)"scmc-sbs-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ef4\u5ea6\u4e2d\uff0c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u7684\u5b57\u6bb5\u201c%1$s\u201d\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvSchemeSaveValidator_13", (String)"scmc-sbs-form", (Object[])new Object[0]);
            this.checkFieldMapping(dataEntity, demandSignToNameMapping, new HashSet<String>(1), "demandmodel", demandTip, true);
            this.checkFieldMapping(dataEntity, supplySignToNameMapping, new HashSet<String>(1), "supplymodel", supplyTip, true);
        }
    }

    private void checkPriorityFieldRef(Map<String, String> signToNameMapping, Set<String> noticedFields) {
        String tipMsg = ResManager.loadKDString((String)"\u9700\u6c42\u4f18\u5148\u7ea7\u6392\u5e8f\u7684\u5b57\u6bb5\u201c%1$s\u201d\uff0c\u5728\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u201c%2$s\u201d\u4e2d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvSchemeSaveValidator_12", (String)"scmc-sbs-form", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkFieldMapping(dataEntity, signToNameMapping, noticedFields, "demandmodel", tipMsg, true);
        }
    }

    private void checkFieldMapping(ExtendedDataEntity dataEntity, Map<String, String> signToNameMapping, Set<String> noticedFields, String modelFieldKey, String tipMsg, boolean nameFirst) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject demandModel = entity.getDynamicObject(modelFieldKey);
        DynamicObjectCollection dataSrcCfg = demandModel.getDynamicObjectCollection("entryentityds");
        if (dataSrcCfg.isEmpty()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\uff0c\u201c\u6570\u636e\u6e90\u914d\u7f6e\u201d\u4e3a\u5fc5\u5f55\u3002", (String)"BalanceInvSchemeSaveValidator_7", (String)"scmc-sbs-form", (Object[])new Object[0]), demandModel.getString("number")));
            return;
        }
        for (int i = 0; i < dataSrcCfg.size(); ++i) {
            DynamicObject dsEntry = (DynamicObject)dataSrcCfg.get(i);
            if (dsEntry.get("billfieldmap") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\uff0c\u201c\u6570\u636e\u6e90\u914d\u7f6e\u201d\u7b2c%2$s\u884c\u201c\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f16\u7801\u201d\u4e3a\u5fc5\u5f55\u3002", (String)"BalanceInvSchemeSaveValidator_8", (String)"scmc-sbs-form", (Object[])new Object[0]), demandModel.getString("number"), i + 1));
                continue;
            }
            DynamicObject srcBillDs = dsEntry.getDynamicObject("srcbillds");
            if ("invp_safestock_record".equals(srcBillDs.getString("number"))) continue;
            DynamicObject fieldMap = dsEntry.getDynamicObject("billfieldmap");
            DynamicObjectCollection colsMap = (fieldMap = BusinessDataServiceHelper.loadSingle((Object)fieldMap.getPkValue(), (String)"sbs_billfieldmapping")).getDynamicObjectCollection("colsmap");
            if (colsMap.isEmpty()) {
                for (Map.Entry<String, String> fieldEntry : signToNameMapping.entrySet()) {
                    String fieldKey = fieldEntry.getKey();
                    if (!noticedFields.add(fieldKey)) continue;
                    String fieldName = fieldEntry.getValue();
                    this.addErrorMessage(dataEntity, String.format(tipMsg, fieldMap.getString("number"), fieldName));
                }
                continue;
            }
            HashSet<String> signSet = new HashSet<String>(colsMap.size());
            for (DynamicObject map : colsMap) {
                signSet.add(map.getString("targetobjcol"));
            }
            for (Map.Entry<String, String> fieldEntry : signToNameMapping.entrySet()) {
                String fieldKey = fieldEntry.getKey();
                String fieldName = fieldEntry.getValue();
                if (signSet.contains(fieldKey) || noticedFields.contains(fieldKey)) continue;
                if (nameFirst) {
                    this.addErrorMessage(dataEntity, String.format(tipMsg, fieldName, fieldMap.getString("number")));
                } else {
                    this.addErrorMessage(dataEntity, String.format(tipMsg, fieldMap.getString("number"), fieldName));
                }
                noticedFields.add(fieldKey);
            }
        }
    }

    private void getFieldMapping(ExtendedDataEntity dataEntity, Map<String, String> signToNameMapping) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection priorityFieldMapping = entity.getDynamicObjectCollection("dempriorityentry");
        for (DynamicObject mapping : priorityFieldMapping) {
            String logo = mapping.getString("entrydemandlogo");
            String name = mapping.getString("entrydemandname");
            if (StringUtils.isEmpty((CharSequence)logo) || StringUtils.isEmpty((CharSequence)name)) continue;
            signToNameMapping.put(logo, name);
        }
    }

    private void checkDemandOrgMapping(ExtendedDataEntity dataEntity, Set<String> noticedFields) {
        HashMap<String, String> signToNameMapping = new HashMap<String, String>(this.dataEntities.length);
        signToNameMapping.put("entryentity.demandorg", ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"BalanceInvSchemeSaveValidator_10", (String)"scmc-sbs-form", (Object[])new Object[0]));
        String tipMsg = ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6a21\u578b\u5f15\u7528\u7684\u4f9b\u9700\u6a21\u578b\u5b57\u6bb5\u6620\u5c04\u201d%1$s\u201c\uff0c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u7684\u201c%2$s\u201d\u4e3a\u5fc5\u987b\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvSchemeSaveValidator_11", (String)"scmc-sbs-form", (Object[])new Object[0]);
        this.checkFieldMapping(dataEntity, signToNameMapping, noticedFields, "demandmodel", tipMsg, false);
    }

    private void checkMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection collection = entity.getDynamicObjectCollection("autoputparamentry");
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            if (!entry.getBoolean("autoput")) continue;
            Object targetBill = entry.get("targetputbill");
            Object botp = entry.get("autoputbotp");
            if (targetBill != null && botp != null) continue;
            String tip = String.format(ResManager.loadKDString((String)"\u6295\u653e\u53c2\u6570\u7b2c%s\u884c\uff0c\u81ea\u52a8\u6295\u653e\u4e3a\u662f\u65f6", (String)"BalanceInvSchemeSaveValidator_2", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1);
            tip = tip + ",";
            if (targetBill == null) {
                String tip1 = ResManager.loadKDString((String)"\u201c\u76ee\u6807\u5355\u636e\u201d", (String)"BalanceInvSchemeSaveValidator_3", (String)"scmc-sbs-form", (Object[])new Object[0]);
                tip = tip + tip1;
            }
            if (botp == null) {
                if (targetBill == null) {
                    String tip2 = ResManager.loadKDString((String)"\u3001", (String)"BalanceInvSchemeSaveValidator_6", (String)"scmc-sbs-form", (Object[])new Object[0]);
                    tip = tip + tip2;
                }
                String tip3 = ResManager.loadKDString((String)"\u201cBOTP\u89c4\u5219\u201d", (String)"BalanceInvSchemeSaveValidator_4", (String)"scmc-sbs-form", (Object[])new Object[0]);
                tip = tip + tip3;
            }
            String tip4 = ResManager.loadKDString((String)"\u4e3a\u5fc5\u586b\u3002", (String)"BalanceInvSchemeSaveValidator_5", (String)"scmc-sbs-form", (Object[])new Object[0]);
            tip = tip + tip4;
            this.addErrorMessage(dataEntity, tip);
        }
    }

    private void checkDemAndSupEntry(ExtendedDataEntity dataEntity, Set<Long> balanceInvOrgs) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject balanceInvOrg = entity.getDynamicObject("balanceinvorg");
        if (balanceInvOrg == null) {
            return;
        }
        balanceInvOrgs.add(balanceInvOrg.getLong("id"));
        if (!this.checkData(dataEntity, "demandsrcentry", "deminbalanceinv")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\uff0c\u5fc5\u987b\u6709\u4e00\u884c\u7684 \u201c\u53c2\u4e0e\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\u201d\u4e3a\u662f\u3002", (String)"BalanceInvSchemeSaveValidator_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        if (!this.checkData(dataEntity, "supplysrcentry", "supplyinbalanceinv")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u53c2\u6570\u7684\u4f9b\u5e94\u6570\u636e\u6765\u6e90\uff0c\u5fc5\u987b\u6709\u4e00\u884c\u7684 \u201c\u53c2\u4e0e\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\u201d\u4e3a\u662f\u3002", (String)"BalanceInvSchemeSaveValidator_16", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
    }

    private boolean checkData(ExtendedDataEntity dataEntity, String entityKey, String inCalKey) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection(entityKey);
        if (entries.isEmpty()) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < entries.size(); ++i) {
            Object botp;
            DynamicObject entry = (DynamicObject)entries.get(i);
            if (!entry.getBoolean(inCalKey)) continue;
            if ("demandsrcentry".equals(entityKey) && (botp = entry.get("demoutputbotp")) == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\u7b2c%s\u884c\uff0c\u201cBOTP\u89c4\u5219\u201d\u4e3a\u5fc5\u586b\u3002", (String)"BalanceInvSchemeSaveValidator_0", (String)"scmc-sbs-form", (Object[])new Object[0]), i + 1));
            }
            flag = true;
        }
        return flag;
    }
}

