/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.fi.gl.extpoint.report;

import kd.bos.entity.report.ReportQueryParam;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportParam {
    private final ReportType reportType;
    private final ReportQueryParam queryParam;

    public ReportParam(ReportType reportType, ReportQueryParam queryParam) {
        this.reportType = reportType;
        this.queryParam = queryParam;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public ReportQueryParam getQueryParam() {
        return this.queryParam;
    }

    public static enum ReportType {
        UNSUPPORTED("unsupported"),
        SUB_LEDGER("gl_rpt_subledger"),
        SUBSI_DIARY_LEDGER("gl_rpt_subsidiaryledger"),
        AUX_SUB_LEDGER("t_rpt_aux_subledger"),
        GENERAL_LEDGER("gl_rpt_generalledger"),
        MULTI_COLUMN_ACCOUNT("gl_rpt_multcolumnaccount");

        public final String entityId;

        public static ReportType of(String entityId) {
            switch (entityId) {
                case "gl_rpt_subledger": {
                    return SUB_LEDGER;
                }
                case "gl_rpt_subsidiaryledger": {
                    return SUBSI_DIARY_LEDGER;
                }
                case "t_rpt_aux_subledger": {
                    return AUX_SUB_LEDGER;
                }
                case "gl_rpt_generalledger": {
                    return GENERAL_LEDGER;
                }
                case "gl_rpt_multcolumnaccount": {
                    return MULTI_COLUMN_ACCOUNT;
                }
            }
            return UNSUPPORTED;
        }

        private ReportType(String entityId) {
            this.entityId = entityId;
        }
    }
}

