/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.fi.gl.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.fi.gl.business.GLServiceFactory;
import kd.sdk.fi.gl.interfaces.service.flex.IFlexValueFormatService;
import kd.sdk.fi.gl.interfaces.service.voucher.IVoucherQueryService;

public class VoucherQuerySDK {
    public static final String ENTRIES_ASSGRP_DISPLAY = "entries.assgrp.display";

    public static DataSet queryByEntryIds(Set<Long> voucherIds, Set<Long> entryIds, QFilter[] filters, String selectFields, String orderBys) {
        if (CollectionUtils.isEmpty(entryIds) || entryIds.size() > 100000) {
            throw new IllegalArgumentException("EntryIds size needs to be between [1,100000]. ");
        }
        if (ArrayUtils.isEmpty((Object[])filters)) {
            return VoucherQuerySDK.queryByIds(voucherIds, new QFilter("entries.id", "in", entryIds).toArray(), selectFields, orderBys);
        }
        return VoucherQuerySDK.queryByIds(voucherIds, (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("entries.id", "in", entryIds)), selectFields, orderBys);
    }

    public static DataSet queryByIds(Set<Long> voucherIds, QFilter[] filters, String selectFields, String orderBys) {
        if (CollectionUtils.isEmpty(voucherIds) || voucherIds.size() > 1000) {
            throw new IllegalArgumentException("VoucherIds size needs to be between [1,1000]. ");
        }
        if (StringUtils.isEmpty((String)selectFields)) {
            throw new IllegalArgumentException("SelectFields cannot be empty. ");
        }
        if (!selectFields.contains(ENTRIES_ASSGRP_DISPLAY)) {
            return GLServiceFactory.getService(IVoucherQueryService.class).queryByIds(voucherIds, filters, selectFields, orderBys);
        }
        Selects selects = new Selects(selectFields);
        try (DataSet dataSet = GLServiceFactory.getService(IVoucherQueryService.class).queryByIds(voucherIds, filters, selects.buildSelect(), orderBys);){
            DataSet result = new DataSetMapper(1000).map(dataSet, dataSet.getRowMeta(), rows -> VoucherQuerySDK.processRow(dataSet.getRowMeta(), rows));
            DataSet dataSet2 = result.select(selects.buildOutput());
            return dataSet2;
        }
    }

    static List<Object[]> processRow(RowMeta rowMeta, List<Row> rowList) {
        HashMap<Long, String> assGrpId2val = new HashMap<Long, String>(16);
        int assGrpIdIndex = rowMeta.getFieldIndex("entries.assgrp");
        int assGrpValIndex = rowMeta.getFieldIndex(ENTRIES_ASSGRP_DISPLAY);
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(rowList.size());
        for (Row row : rowList) {
            Object[] values = ((AbstractRow)row).values();
            valueList.add(values);
            assGrpId2val.put((Long)values[assGrpIdIndex], (String)values[assGrpValIndex]);
        }
        Map<Long, String> assGrpId2display = GLServiceFactory.getService(IFlexValueFormatService.class).getDisplayValue(assGrpId2val);
        for (Object[] values : valueList) {
            values[assGrpValIndex] = assGrpId2display.getOrDefault((Long)values[assGrpIdIndex], "");
        }
        return valueList;
    }

    static class DataSetMapper {
        private final int batchSize;
        private final List<Row> buffer;

        DataSetMapper(int batchSize) {
            this.batchSize = batchSize;
            this.buffer = new ArrayList<Row>(batchSize);
        }

        public DataSet map(DataSet dataSet, RowMeta rowMeta, Function<List<Row>, List<Object[]>> mapper) {
            DataSetBuilder builder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
            for (Row row : dataSet) {
                this.buffer.add(RowUtil.persist((Row)row));
                if (this.buffer.size() != this.batchSize) continue;
                List<Object[]> mappingValues = mapper.apply(this.buffer);
                for (Object[] mappingValue : mappingValues) {
                    builder.append(mappingValue);
                }
                this.buffer.clear();
            }
            if (!this.buffer.isEmpty()) {
                List<Object[]> mappingValues = mapper.apply(this.buffer);
                for (Object[] mappingValue : mappingValues) {
                    builder.append(mappingValue);
                }
                this.buffer.clear();
            }
            return builder.build();
        }
    }

    static class Selects {
        private final List<String[]> aliases;

        Selects(String selectFields) {
            this.aliases = Arrays.stream(selectFields.trim().split(",")).map(x -> x.trim().split(" ")).collect(Collectors.toList());
        }

        String buildSelect() {
            ArrayList<String> selects = new ArrayList<String>(this.aliases.size());
            for (CharSequence[] charSequenceArray : this.aliases) {
                if (charSequenceArray[0].startsWith(VoucherQuerySDK.ENTRIES_ASSGRP_DISPLAY)) {
                    selects.add("entries.assgrp");
                    selects.add("entries.assgrp.assvals entries.assgrp.display");
                    continue;
                }
                selects.add(String.join((CharSequence)" ", charSequenceArray));
            }
            return String.join((CharSequence)",", selects);
        }

        String[] buildOutput() {
            return (String[])this.aliases.stream().map(x -> {
                if (x[0].trim().startsWith(VoucherQuerySDK.ENTRIES_ASSGRP_DISPLAY)) {
                    return String.join((CharSequence)" ", x);
                }
                if (((String[])x).length > 1) {
                    return x[1];
                }
                return x[0];
            }).toArray(String[]::new);
        }
    }
}

