/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.common.plugin.perm;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.plugin.perm.service.BizMserviceInvokeService;
import kd.sdk.hr.common.plugin.perm.service.DataFilterService;
import kd.sdk.hr.common.plugin.perm.service.DimValueResultDTO;
import kd.sdk.hr.common.plugin.perm.service.FieldConfigMap;
import kd.sdk.hr.common.plugin.perm.service.FieldNameInfo;
import kd.sdk.hr.common.plugin.perm.service.PositionTypeEnum;

public class CommonPermissionValidateService {
    private static final Log LOG = LogFactory.getLog(CommonPermissionValidateService.class);
    private String entityId;
    private FieldNameInfo fieldNameInfo;
    private DimValueResultDTO orgdesignPermResult;
    private DimValueResultDTO orgteamPermResult;
    private Map<Long, List<Long>> stdpositionIdMap = new HashMap<Long, List<Long>>();
    private Map<Long, Long> stdPositionJobLevelScmMap = new HashMap<Long, Long>();
    private Map<Long, Long> stdPositionJobGradeScmMap = new HashMap<Long, Long>();
    private Map<Long, List<Long>> stdPositionJobLevelMap = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> stdPositionJobGradeMap = new HashMap<Long, List<Long>>();
    private Map<Long, Long> positionAdminorgMap = new HashMap<Long, Long>();
    private Map<Long, Long> positionJobLevelScmMap = new HashMap<Long, Long>();
    private Map<Long, Long> positionJobGradeScmMap = new HashMap<Long, Long>();
    private Map<Long, List<Long>> positionJobLevelMap = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> positionJobGradeMap = new HashMap<Long, List<Long>>();
    private Map<Long, Long> jobJobLevelScmMap = new HashMap<Long, Long>();
    private Map<Long, Long> jobJobGradeScmMap = new HashMap<Long, Long>();
    private Map<Long, List<Long>> jobJobLevelMap = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> jobJobGradeMap = new HashMap<Long, List<Long>>();
    private List<Long> jobList = new ArrayList<Long>();
    private List<Long> stdPosList = new ArrayList<Long>();
    private List<Long> jobLevelScmList = new ArrayList<Long>();
    private List<Long> jobGradeScmList = new ArrayList<Long>();
    private Map<Long, Long> jobLevelJobLevelScmMap = new HashMap<Long, Long>();
    private Map<Long, Long> jobGradeJobGradeScmMap = new HashMap<Long, Long>();
    private Map<String, String> fieldDisplayNameMap = new HashMap<String, String>();
    private Set<Long> stdPpositionIdList = new HashSet<Long>();
    private Set<Long> positionIdList = new HashSet<Long>();
    private Set<Long> jobIdList = new HashSet<Long>();
    private Set<Long> jobLevelScmIdList = new HashSet<Long>();
    private Set<Long> jobGradeScmIdList = new HashSet<Long>();
    private Set<Long> jobLevelIdList = new HashSet<Long>();
    private Set<Long> jobGradeIdList = new HashSet<Long>();

    private FieldNameInfo getFieldInfo() {
        if (this.fieldNameInfo == null) {
            this.fieldNameInfo = FieldConfigMap.getFieldName(this.entityId);
        }
        return this.fieldNameInfo;
    }

    private void init(List<DynamicObject> list, String entityId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        this.entityId = entityId;
        this.orgdesignPermResult = DataFilterService.getInstance().getOrgDesignPerm(entityId);
        this.orgteamPermResult = DataFilterService.getInstance().getOrgTeamPerm(entityId, this.getFieldInfo().getAdminOrgFieldName());
        for (String fieldName : this.getFieldInfo().getFieldNames()) {
            IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName);
            if (property == null) continue;
            this.fieldDisplayNameMap.put(fieldName, property.getDisplayName().getLocaleValue());
        }
        for (DynamicObject dyn : list) {
            if (dyn.containsProperty(this.getFieldInfo().getStdPositionFieldName())) {
                this.stdPpositionIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getStdPositionFieldName()));
            }
            if (dyn.containsProperty(this.getFieldInfo().getPositionFieldName())) {
                this.positionIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getPositionFieldName()));
            }
            if (dyn.containsProperty(this.getFieldInfo().getJobFieldName())) {
                this.jobIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getJobFieldName()));
            }
            if (dyn.containsProperty(this.getFieldInfo().getJobLevelScmFieldName())) {
                this.jobLevelScmIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getJobLevelScmFieldName()));
            }
            if (dyn.containsProperty(this.getFieldInfo().getJobGradeScmFieldName())) {
                this.jobGradeScmIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getJobGradeScmFieldName()));
            }
            if (dyn.containsProperty(this.getFieldInfo().getJobLevelFieldName())) {
                this.jobLevelIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getJobLevelFieldName()));
            }
            if (!dyn.containsProperty(this.getFieldInfo().getJobGradeFieldName())) continue;
            this.jobGradeIdList.add(this.getDynamicObjectFieldId(dyn, this.getFieldInfo().getJobGradeFieldName()));
        }
        this.stdPpositionIdList.removeIf(id -> id == 0L);
        this.positionIdList.removeIf(id -> id == 0L);
        this.jobIdList.removeIf(id -> id == 0L);
        this.jobLevelIdList.removeIf(id -> id == 0L);
        this.jobGradeIdList.removeIf(id -> id == 0L);
        this.initStdPosData();
        this.initPosData();
        this.initJobData();
        this.initJobLevelScmData();
        this.initJobGradeScmData();
        this.initJobLevelData();
        this.initJobGradeData();
    }

    private void initStdPosData() {
        Map<Long, Object> jobInfoByStdPosMap;
        List<Map<String, Object>> stdPositionResultMapList;
        List<Long> stdPosIdResultList;
        Map<Long, List<DynamicObject>> stdpositionResultMap;
        if (this.stdPpositionIdList.size() == 0) {
            return;
        }
        if (!this.orgteamPermResult.isAll() && (stdpositionResultMap = BizMserviceInvokeService.getInstance().queryStdPositionByOrg(this.orgteamPermResult.getOrgIds())) != null) {
            stdpositionResultMap.forEach((adminorgId, stdpositions) -> {
                if (!CollectionUtils.isEmpty((Collection)stdpositions)) {
                    this.stdpositionIdMap.put((Long)adminorgId, stdpositions.stream().map(dyInfo -> dyInfo.getLong("id")).collect(Collectors.toList()));
                }
            });
        }
        if (!this.orgdesignPermResult.isAll() && !CollectionUtils.isEmpty(stdPosIdResultList = BizMserviceInvokeService.getInstance().getStdPosIdsByUseorgIdList(this.orgdesignPermResult.getOrgIds()))) {
            this.stdPosList.addAll(stdPosIdResultList);
        }
        if ((stdPositionResultMapList = BizMserviceInvokeService.getInstance().getStandardIposition(new ArrayList<Long>(this.stdPpositionIdList))) != null) {
            stdPositionResultMapList.forEach(map -> {
                long id = CommonPermissionValidateService.getLongValOfCustomParam(map.get("id"));
                long joblevelscmId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("joblevelscm.id"));
                long jobgradescmId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("jobgradescm.id"));
                long jobId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("job"));
                this.stdPositionJobLevelScmMap.put(id, joblevelscmId);
                this.stdPositionJobGradeScmMap.put(id, jobgradescmId);
                if (jobId != 0L) {
                    this.jobIdList.add(jobId);
                }
            });
        }
        if ((jobInfoByStdPosMap = BizMserviceInvokeService.getInstance().queryJobLevelAndJobGradeByStdPositionIds(new ArrayList<Long>(this.stdPpositionIdList))) != null) {
            jobInfoByStdPosMap.forEach((stdPositionId, map) -> {
                List<DynamicObject> joblevels = this.getJobLevel((Map)map);
                List leveIdList = joblevels.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.stdPositionJobLevelMap.put((Long)stdPositionId, leveIdList);
                List<DynamicObject> jobgrades = this.getJobGrade((Map)map);
                List gradeIdList = jobgrades.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.stdPositionJobGradeMap.put((Long)stdPositionId, gradeIdList);
            });
        }
    }

    private void initPosData() {
        Map<Long, Object> jobInfoByPosMap;
        if (this.positionIdList.size() == 0) {
            return;
        }
        List<Map<String, Object>> positionResultMapList = BizMserviceInvokeService.getInstance().getHrIposition(new ArrayList<Long>(this.positionIdList));
        if (positionResultMapList != null) {
            positionResultMapList.forEach(map -> {
                long id = CommonPermissionValidateService.getLongValOfCustomParam(map.get("id"));
                long joblevelscmId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("highjoblevel.joblevelscm"));
                long jobgradescmId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("highjobgrade.jobgradescm"));
                long jobId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("job"));
                long adminorg = CommonPermissionValidateService.getLongValOfCustomParam(map.get("adminorg"));
                this.positionAdminorgMap.put(id, adminorg);
                this.positionJobLevelScmMap.put(id, joblevelscmId);
                this.positionJobGradeScmMap.put(id, jobgradescmId);
                if (jobId != 0L) {
                    this.jobIdList.add(jobId);
                }
            });
        }
        if ((jobInfoByPosMap = BizMserviceInvokeService.getInstance().queryJobLevelAndJobGradeByPositionIds(new ArrayList<Long>(this.positionIdList))) != null) {
            jobInfoByPosMap.forEach((positionId, map) -> {
                List<DynamicObject> joblevels = this.getJobLevel((Map)map);
                List leveIdList = joblevels.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.positionJobLevelMap.put((Long)positionId, leveIdList);
                List<DynamicObject> jobgrades = this.getJobGrade((Map)map);
                List gradeIdList = jobgrades.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.positionJobGradeMap.put((Long)positionId, gradeIdList);
            });
        }
    }

    private void initJobData() {
        Map<Long, Map<String, Object>> jobResultMap;
        List<Long> jobIdResultList;
        if (this.jobIdList.size() == 0) {
            return;
        }
        if (!this.orgdesignPermResult.isAll() && !CollectionUtils.isEmpty(jobIdResultList = BizMserviceInvokeService.getInstance().getJobIdsByUseorgIdList(this.orgdesignPermResult.getOrgIds()))) {
            this.jobList.addAll(jobIdResultList);
        }
        if ((jobResultMap = BizMserviceInvokeService.getInstance().getJobLevelGradeRangeInfoByJobIds(new ArrayList<Long>(this.jobIdList))) != null) {
            jobResultMap.forEach((jobId, map) -> {
                long joblevelscmId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("joblevelScmid"));
                long jobgradescmId = CommonPermissionValidateService.getLongValOfCustomParam(map.get("jobgradeScmid"));
                List joblevels = (List)map.get("joblevelRanges");
                List jobgrades = (List)map.get("jobgradeRanges");
                List leveIdList = joblevels.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                List gradeIdList = jobgrades.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                this.jobJobLevelScmMap.put((Long)jobId, joblevelscmId);
                this.jobJobGradeScmMap.put((Long)jobId, jobgradescmId);
                this.jobJobLevelMap.put((Long)jobId, leveIdList);
                this.jobJobGradeMap.put((Long)jobId, gradeIdList);
            });
        }
    }

    private void initJobLevelScmData() {
        List<Long> levelScmIdResultList;
        if (this.jobLevelScmIdList.size() == 0) {
            return;
        }
        if (!this.orgdesignPermResult.isAll() && !CollectionUtils.isEmpty(levelScmIdResultList = BizMserviceInvokeService.getInstance().getJobLevelScmIdsByUseorgIdList(this.orgdesignPermResult.getOrgIds()))) {
            this.jobLevelScmList.addAll(levelScmIdResultList);
        }
    }

    private void initJobGradeScmData() {
        List<Long> gradeScmIdResultList;
        if (this.jobGradeScmIdList.size() == 0) {
            return;
        }
        if (!this.orgdesignPermResult.isAll() && !CollectionUtils.isEmpty(gradeScmIdResultList = BizMserviceInvokeService.getInstance().getJobGradeScmIdsByUseorgIdList(this.orgdesignPermResult.getOrgIds()))) {
            this.jobGradeScmList.addAll(gradeScmIdResultList);
        }
    }

    private void initJobLevelData() {
        if (this.jobLevelIdList.size() == 0) {
            return;
        }
        this.jobLevelJobLevelScmMap = BizMserviceInvokeService.getInstance().getJobLevelScmIdByLevelIds(new ArrayList<Long>(this.jobLevelIdList));
    }

    private void initJobGradeData() {
        if (this.jobGradeIdList.size() == 0) {
            return;
        }
        this.jobGradeJobGradeScmMap = BizMserviceInvokeService.getInstance().getJobGradeScmIdByGradeIds(new ArrayList<Long>(this.jobGradeIdList));
    }

    private static long getLongValOfCustomParam(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        return Long.parseLong(object.toString());
    }

    private List<DynamicObject> getJobLevel(Map<String, Object> levelGradeMap) {
        if (!ObjectUtils.isEmpty(levelGradeMap) && !ObjectUtils.isEmpty((Object)levelGradeMap.get("joblevel"))) {
            return (List)levelGradeMap.get("joblevel");
        }
        return new ArrayList<DynamicObject>();
    }

    private List<DynamicObject> getJobGrade(Map<String, Object> levelGradeMap) {
        if (!ObjectUtils.isEmpty(levelGradeMap) && !ObjectUtils.isEmpty((Object)levelGradeMap.get("jobgrade"))) {
            return (List)levelGradeMap.get("jobgrade");
        }
        return new ArrayList<DynamicObject>();
    }

    public CommonPermissionValidateService(List<DynamicObject> list, String entityId) {
        if (CollectionUtils.isEmpty(list)) {
            LOG.info("validate_CommonPermissionValidateService_list is empty, entityId = " + entityId);
            return;
        }
        LOG.info("validate_CommonPermissionValidateService_start  entityId = " + entityId + " , list size = " + list.size());
        this.init(list, entityId);
        LOG.info("validate_CommonPermissionValidateService_end" + entityId);
    }

    public String validate(DynamicObject dyn) {
        String msg;
        LOG.info("validate_start");
        this.initValue(dyn);
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.validatePosition()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"'%1$s'\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7\u4e0e\u586b\u5199\u7684'%2$s'\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_2", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getPositionFieldName()), this.fieldDisplayNameMap.get(this.getFieldInfo().getAdminOrgFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateStdPosition()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"'%1$s'\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u672a\u5305\u542b\u586b\u5199\u7684'%2$s'\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_0", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getStdPositionFieldName()), this.fieldDisplayNameMap.get(this.getFieldInfo().getAdminOrgFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateStdPositionOrg()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"'%s'\u6240\u5c5e\u7684\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u60a8\u7684\u6570\u636e\u6743\u9650\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_3", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getStdPositionFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobOrg()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"'%s'\u6240\u5c5e\u7684\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u60a8\u7684\u6570\u636e\u6743\u9650\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_3", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobLevelScm()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5'%s'\u7ef4\u62a4\u7684\u6570\u636e\u6ca1\u6709\u5f15\u5165\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_1", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobLevelScmFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobGradeScm()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5'%s'\u7ef4\u62a4\u7684\u6570\u636e\u6ca1\u6709\u5f15\u5165\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_1", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobGradeScmFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobLevel()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5'%s'\u7ef4\u62a4\u7684\u6570\u636e\u6ca1\u6709\u5f15\u5165\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_1", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobLevelFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobGrade()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5'%s'\u7ef4\u62a4\u7684\u6570\u636e\u6ca1\u6709\u5f15\u5165\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_1", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobGradeFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobLevelSuitScm()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"'%s'\u6240\u5c5e\u804c\u7ea7\u65b9\u6848\u4e0e\u586b\u5199\u7684\u804c\u7ea7\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_4", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobLevelFieldName()));
            stringBuilder.append(msg);
        }
        if (!this.validateJobGradeSuitScm()) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"'%s'\u6240\u5c5e\u804c\u7b49\u65b9\u6848\u4e0e\u586b\u5199\u7684\u804c\u7b49\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e;", (String)"CommonPermissionValidateService_5", (String)"sdk-hr", (Object[])new Object[0]), this.fieldDisplayNameMap.get(this.getFieldInfo().getJobGradeFieldName()));
            stringBuilder.append(msg);
        }
        String result = stringBuilder.toString();
        LOG.info("validate_end ,result= " + result);
        return result;
    }

    private boolean validatePosition() {
        long adminorgId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getAdminOrgFieldName());
        long positionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionFieldName());
        if (positionId == 0L || adminorgId == 0L) {
            return true;
        }
        return adminorgId == this.positionAdminorgMap.getOrDefault(positionId, 0L);
    }

    private boolean validateStdPosition() {
        if (this.orgteamPermResult.isAll()) {
            return true;
        }
        long adminorgId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getAdminOrgFieldName());
        long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
        if (stdPositionId == 0L || adminorgId == 0L) {
            return true;
        }
        List<Long> stdPositionIdsInPerm = this.stdpositionIdMap.get(adminorgId);
        return !CollectionUtils.isEmpty(stdPositionIdsInPerm) && stdPositionIdsInPerm.contains(stdPositionId);
    }

    private boolean validateStdPositionOrg() {
        long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
        if (stdPositionId == 0L) {
            return true;
        }
        if (this.orgdesignPermResult.isAll()) {
            return true;
        }
        return this.stdPosList.contains(stdPositionId);
    }

    private boolean validateJobOrg() {
        long jobId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobFieldName());
        if (jobId == 0L) {
            return true;
        }
        if (this.orgdesignPermResult.isAll()) {
            return true;
        }
        return this.jobList.contains(jobId);
    }

    private boolean validateJobLevelScm() {
        long jobId;
        long positionId;
        long jobLevelScmId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobLevelScmFieldName());
        if (jobLevelScmId == 0L) {
            return true;
        }
        String positionType = String.valueOf(this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionTypeFieldName()));
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)positionType)) {
            long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
            if (stdPositionId != 0L) {
                long scmIdFromStd = this.stdPositionJobLevelScmMap.getOrDefault(stdPositionId, 0L);
                if (scmIdFromStd != 0L && jobLevelScmId != scmIdFromStd) {
                    return false;
                }
                if (jobLevelScmId == scmIdFromStd) {
                    return true;
                }
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)positionType) && (positionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionFieldName()).longValue()) != 0L) {
            long scmIdFromPos = this.positionJobLevelScmMap.getOrDefault(positionId, 0L);
            if (scmIdFromPos != 0L && jobLevelScmId != scmIdFromPos) {
                return false;
            }
            if (jobLevelScmId == scmIdFromPos) {
                return true;
            }
        }
        if ((jobId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobFieldName()).longValue()) != 0L) {
            long scmIdFromJob = this.jobJobLevelScmMap.getOrDefault(jobId, 0L);
            if (scmIdFromJob != 0L && jobLevelScmId != scmIdFromJob) {
                return false;
            }
            if (jobLevelScmId == scmIdFromJob) {
                return true;
            }
        }
        return this.orgdesignPermResult.isAll() || this.jobLevelScmList.contains(jobLevelScmId);
    }

    private boolean validateJobGradeScm() {
        long jobId;
        long positionId;
        long jobGradeScmId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobGradeScmFieldName());
        if (jobGradeScmId == 0L) {
            return true;
        }
        String positionType = String.valueOf(this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionTypeFieldName()));
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)positionType)) {
            long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
            if (stdPositionId != 0L) {
                long scmIdFromStd = this.stdPositionJobGradeScmMap.getOrDefault(stdPositionId, 0L);
                if (scmIdFromStd != 0L && jobGradeScmId != scmIdFromStd) {
                    return false;
                }
                if (jobGradeScmId == scmIdFromStd) {
                    return true;
                }
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)positionType) && (positionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionFieldName()).longValue()) != 0L) {
            long scmIdFromPos = this.positionJobGradeScmMap.getOrDefault(positionId, 0L);
            if (scmIdFromPos != 0L && jobGradeScmId != scmIdFromPos) {
                return false;
            }
            if (jobGradeScmId == scmIdFromPos) {
                return true;
            }
        }
        if ((jobId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobFieldName()).longValue()) != 0L) {
            long scmIdFromJob = this.jobJobGradeScmMap.getOrDefault(jobId, 0L);
            if (scmIdFromJob != 0L && jobGradeScmId != scmIdFromJob) {
                return false;
            }
            if (jobGradeScmId == scmIdFromJob) {
                return true;
            }
        }
        return this.orgdesignPermResult.isAll() || this.jobGradeScmList.contains(jobGradeScmId);
    }

    private boolean validateJobLevel() {
        long jobId;
        long positionId;
        long jobLevelId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobLevelFieldName());
        if (jobLevelId == 0L) {
            return true;
        }
        String positionType = String.valueOf(this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionTypeFieldName()));
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)positionType)) {
            long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
            if (stdPositionId != 0L) {
                List<Long> levelIdFromStd = this.stdPositionJobLevelMap.get(stdPositionId);
                if (!CollectionUtils.isEmpty(levelIdFromStd) && !levelIdFromStd.contains(jobLevelId)) {
                    return false;
                }
                if (!CollectionUtils.isEmpty(levelIdFromStd) && levelIdFromStd.contains(jobLevelId)) {
                    return true;
                }
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)positionType) && (positionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionFieldName()).longValue()) != 0L) {
            List<Long> levelIdFromPos = this.positionJobLevelMap.get(positionId);
            if (!CollectionUtils.isEmpty(levelIdFromPos) && !levelIdFromPos.contains(jobLevelId)) {
                return false;
            }
            if (!CollectionUtils.isEmpty(levelIdFromPos) && levelIdFromPos.contains(jobLevelId)) {
                return true;
            }
        }
        if ((jobId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobFieldName()).longValue()) != 0L) {
            List<Long> levelIdFromJob = this.jobJobLevelMap.get(jobId);
            if (!CollectionUtils.isEmpty(levelIdFromJob) && !levelIdFromJob.contains(jobLevelId)) {
                return false;
            }
            if (!CollectionUtils.isEmpty(levelIdFromJob) && levelIdFromJob.contains(jobLevelId)) {
                return true;
            }
        }
        long joblevelScmId = this.jobLevelJobLevelScmMap.get(jobLevelId);
        return this.orgdesignPermResult.isAll() || this.jobLevelScmList.contains(joblevelScmId);
    }

    private boolean validateJobLevelSuitScm() {
        long jobLevelId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobLevelFieldName());
        if (jobLevelId == 0L) {
            return true;
        }
        long joblevelScmId = this.jobLevelJobLevelScmMap.get(jobLevelId);
        long joblevelScmIdFieldValue = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobLevelScmFieldName());
        return joblevelScmIdFieldValue == 0L || joblevelScmIdFieldValue == joblevelScmId;
    }

    private boolean validateJobGradeSuitScm() {
        long jobGradeId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobGradeFieldName());
        if (jobGradeId == 0L) {
            return true;
        }
        long jobGradeScmId = this.jobGradeJobGradeScmMap.get(jobGradeId);
        long jobGradeScmIdFieldValue = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobGradeScmFieldName());
        return jobGradeScmIdFieldValue == 0L || jobGradeScmIdFieldValue == jobGradeScmId;
    }

    private boolean validateJobGrade() {
        long jobId;
        long positionId;
        long jobGradeId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobGradeFieldName());
        if (jobGradeId == 0L) {
            return true;
        }
        String positionType = String.valueOf(this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionTypeFieldName()));
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)positionType)) {
            long stdPositionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getStdPositionFieldName());
            if (stdPositionId != 0L) {
                List<Long> gradeIdFromStd = this.stdPositionJobGradeMap.get(stdPositionId);
                if (!CollectionUtils.isEmpty(gradeIdFromStd) && !gradeIdFromStd.contains(jobGradeId)) {
                    return false;
                }
                if (!CollectionUtils.isEmpty(gradeIdFromStd) && gradeIdFromStd.contains(jobGradeId)) {
                    return true;
                }
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)positionType) && (positionId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getPositionFieldName()).longValue()) != 0L) {
            List<Long> gradeIdFromPos = this.positionJobGradeMap.get(positionId);
            if (!CollectionUtils.isEmpty(gradeIdFromPos) && !gradeIdFromPos.contains(jobGradeId)) {
                return false;
            }
            if (!CollectionUtils.isEmpty(gradeIdFromPos) && gradeIdFromPos.contains(jobGradeId)) {
                return true;
            }
        }
        if ((jobId = this.getFieldInfo().getFieldValue(this.getFieldInfo().getJobFieldName()).longValue()) != 0L) {
            List<Long> gradeIdFromJob = this.jobJobGradeMap.get(jobId);
            if (!CollectionUtils.isEmpty(gradeIdFromJob) && !gradeIdFromJob.contains(jobGradeId)) {
                return false;
            }
            if (!CollectionUtils.isEmpty(gradeIdFromJob) && gradeIdFromJob.contains(jobGradeId)) {
                return true;
            }
        }
        long jobGradeScmId = this.jobGradeJobGradeScmMap.get(jobGradeId);
        return this.orgdesignPermResult.isAll() || this.jobGradeScmList.contains(jobGradeScmId);
    }

    private void initValue(DynamicObject data) {
        for (String fieldName : this.getFieldInfo().getFieldNames()) {
            long value = 0L;
            if (data.containsProperty(fieldName)) {
                value = this.getDynamicObjectFieldId(data, fieldName);
            }
            this.getFieldInfo().getFieldValueMap().put(fieldName, value);
        }
        LOG.info("validate_initvalue_data [" + this.getFieldInfo().toString() + "]");
    }

    private long getDynamicObjectFieldId(DynamicObject entity, String fieldName) {
        if (entity == null) {
            return 0L;
        }
        if (HRStringUtils.equals((String)fieldName, (String)this.getFieldInfo().getPositionTypeFieldName()) && HRStringUtils.isNotEmpty((String)entity.getString(fieldName))) {
            return Long.parseLong(entity.getString(fieldName));
        }
        if (!entity.containsProperty(fieldName)) {
            return 0L;
        }
        Object fieldValue = entity.get(fieldName);
        if (fieldValue == null) {
            return 0L;
        }
        if (fieldValue instanceof DynamicObject) {
            return ((DynamicObject)fieldValue).getLong("id");
        }
        if (fieldValue instanceof JSONObject) {
            return ((JSONObject)fieldValue).getLongValue("id");
        }
        return fieldValue instanceof Long ? (Long)fieldValue : 0L;
    }
}

