/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.business.mservice.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.enums.FlowTypeEnum;
import kd.sdk.hr.hpfs.business.config.repository.PerFlowRepository;
import kd.sdk.hr.hpfs.business.mservice.helper.HPFSNewChgHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.business.personflow.ICustomPersonFlowService;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class ChgRecordHelper {
    private static final Log LOG = LogFactory.getLog(ChgRecordHelper.class);
    private static final Set<String> MUST_INPUT_SET;
    private static final ThreadPool THREAD_POOL;

    public static void updIdsRecord(String entityNumber, DynamicObject source, DynamicObject newHis, PerChgBizInfoNew perChgInfoNew, String chgModel) {
        long idBefore = source.getLong("id");
        Long vidBefore = source.getDataEntityType().getProperties().get((Object)"sourcevid") != null ? source.getLong("sourcevid") : idBefore;
        Long idNew = newHis.getLong("id");
        perChgInfoNew.setEntityRecord(entityNumber, ChgRecordEntryDto.formatRecord(idBefore, vidBefore, idBefore, idNew, chgModel, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
    }

    public static void updIdsRecord(String entityNumber, DynamicObject source, DynamicObject newHis, PerChgBizInfoNew perChgInfoNew, String chgModel, String flowType) {
        long idBefore = source.getLong("id");
        Long vidBefore = source.getDataEntityType().getProperties().get((Object)"sourcevid") != null ? source.getLong("sourcevid") : idBefore;
        Long idNew = newHis.getLong("id");
        perChgInfoNew.setEntityRecord(entityNumber, ChgRecordEntryDto.formatRecord(idBefore, vidBefore, idBefore, idNew, chgModel, flowType, newHis));
    }

    public static void addChgIdRecord(String entityNum, PerChgBizInfoNew perChgBizInfoNew, Long idAfter, String flowType, DynamicObject dataDy) {
        perChgBizInfoNew.setEntityRecord(entityNum, ChgRecordEntryDto.formatNewRecord(idAfter, flowType, dataDy));
    }

    public static void unChgIdRecord(PerChgBizInfoNew perChgBizInfoNew, DynamicObject dataDy, String entityNum) {
        if (dataDy != null) {
            long boid = dataDy.getLong("boid");
            Long vidBefore = dataDy.getLong("sourcevid");
            perChgBizInfoNew.setEntityRecord(entityNum, ChgRecordEntryDto.formatRecord(boid, vidBefore, boid, null, ChgModeEnum.UNCHANGED.getChgMode(), ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), dataDy));
        }
    }

    public static long getChgEventId(PerChgBizInfoNew perChgInfoNew) {
        DynamicObject chgActionDy = perChgInfoNew.getChgActionDy();
        DynamicObject chgcategory = chgActionDy.getDynamicObject("chgcategory");
        return chgcategory != null ? chgcategory.getLong("chgevent.id") : 0L;
    }

    public static DynamicObject getHbssActionType(DynamicObject chgActionDy) {
        if (chgActionDy == null) {
            return null;
        }
        DynamicObject category = chgActionDy.getDynamicObject("chgcategory");
        if (category != null) {
            return category.getDynamicObject("actiontype");
        }
        return null;
    }

    public static void doWriteBackVidAfterSuccess(PerChgBizInfoNew perChgBizInfoNew, Map<String, Object> res) {
        LOG.info("==begin doWriteBackVidAfterSuccess==");
        try {
            ArrayList<Map<String, Object>> successDataList = new ArrayList(10);
            List data = (List)res.get("data");
            if (data != null) {
                Map dataMap = (Map)((Map)data.get(0)).get("data");
                successDataList = (List)dataMap.get("versionChangeRespDataList");
                ChgRecordHelper.writeBackVidAfterSuccess(successDataList, perChgBizInfoNew);
            }
        }
        catch (Exception e) {
            String errorInfo = String.format(Locale.ROOT, "CHG_HPFS_ERROR saveBatchData.parseVersionChangeRespDataList res error format res : %s", res == null ? null : SerializationUtils.toJsonString(res));
            LOG.error(errorInfo, (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("parseVersionChangeRespDataList", errorInfo), new Object[0]);
        }
    }

    private static void writeBackVidAfterSuccess(List<Map<String, Object>> dataRes, PerChgBizInfoNew perChgBizInfoNew) {
        HashMap<String, Map> idMaps = new HashMap<String, Map>(16);
        dataRes.forEach(row -> {
            DynamicObject[] dyns;
            String entityNumber = (String)row.get("entitynumber");
            for (DynamicObject dyn : dyns = (DynamicObject[])row.get("newDynamicObjects")) {
                if (dyn.getLong("boid") == dyn.getLong("id")) continue;
                idMaps.computeIfAbsent(entityNumber, mapNew -> new HashMap(1)).put(dyn.getLong("boid"), dyn.getLong("id"));
            }
            if (dyns.length == 1) {
                idMaps.computeIfAbsent(entityNumber, mapNew -> new HashMap(1)).put(dyns[0].getLong("boid"), dyns[0].getLong("sourcevid"));
            }
        });
        idMaps.forEach((entityName, idMap) -> idMap.forEach((boid, vid) -> {
            List<ChgRecordEntryDto> list = perChgBizInfoNew.getEntityRecord().get(entityName);
            if (CollectionUtils.isEmpty(list)) {
                perChgBizInfoNew.setEntityRecord((String)entityName, ChgRecordEntryDto.formatRecord(null, null, boid, vid, "", ""));
            } else {
                list.stream().filter(row -> boid.equals(row.getIdAfter()) || boid.equals(row.getIdBefore())).forEach(row -> row.setVidAfter((Long)vid));
            }
        }));
    }

    public static void addFileChgRecord(List<PerChgBizInfoNew> perChgList) {
        LOG.info("==addFileChgRecord begin ==");
        Iterator<PerChgBizInfoNew> iterator = perChgList.iterator();
        while (iterator.hasNext()) {
            QFilter statusFilter;
            QFilter sourceQFilter;
            HRBaseServiceHelper fileChgRedHelper = new HRBaseServiceHelper("hpfs_chgrecord");
            PerChgBizInfoNew perChgBizInfoNew = iterator.next();
            QFilter billQFilter = new QFilter("bill", "=", (Object)perChgBizInfoNew.getBillId());
            DynamicObject fileChgRedDy = fileChgRedHelper.loadDynamicObject(new QFilter[]{billQFilter, sourceQFilter = new QFilter("billsource", "=", (Object)perChgBizInfoNew.getBillSource()), statusFilter = new QFilter("datastatus", "in", Arrays.asList("0", "2"))});
            if (fileChgRedDy == null) {
                fileChgRedDy = fileChgRedHelper.generateEmptyDynamicObject();
            }
            if (fileChgRedDy.get("id") == null || fileChgRedDy.getLong("id") == 0L) {
                MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)"hpfs_chgrecord");
                long id = HPFSNewChgHelper.getId((DynamicObjectType)dyType);
                fileChgRedDy.set("id", (Object)id);
            }
            fileChgRedDy.set("event", (Object)perChgBizInfoNew.getEventId());
            fileChgRedDy.set("chgaction", (Object)perChgBizInfoNew.getChgActionId());
            fileChgRedDy.set("datastatus", (Object)"1");
            fileChgRedDy.set("bill", (Object)perChgBizInfoNew.getBillId());
            fileChgRedDy.set("billsource", (Object)perChgBizInfoNew.getBillSource());
            fileChgRedDy.set("effecttime", (Object)perChgBizInfoNew.getEffectivedate());
            fileChgRedDy.set("evententity", (Object)"hrpi_event");
            fileChgRedDy.set("billno", (Object)perChgBizInfoNew.getBillNo());
            fileChgRedDy.set("chgcategory", perChgBizInfoNew.getChgActionDy().get("chgcategory"));
            DynamicObjectCollection collection = fileChgRedDy.getDynamicObjectCollection("entryentity");
            ChgRecordHelper.formatCollection(perChgBizInfoNew, collection);
            HPFSNewChgHelper.setSysField(fileChgRedDy);
            fileChgRedHelper.saveOne(fileChgRedDy);
            perChgBizInfoNew.setChgRecordId(fileChgRedDy.getLong("id"));
        }
    }

    public static void generatePersonFlow(List<PerChgBizInfoNew> perChgList) {
        LOG.info("==generatePersonFlow begin ==");
        for (PerChgBizInfoNew perChgBizInfoNew : perChgList) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(8);
                params.put("flowTime", perChgBizInfoNew.getEffectivedate());
                params.put("chgAction", perChgBizInfoNew.getChgActionId());
                params.put("chgCategory", perChgBizInfoNew.getChgActionDy().get("chgcategory"));
                params.put("chgRecord", perChgBizInfoNew.getChgRecordId());
                ChgRecordHelper.generatePersonFlow(params);
            }
            catch (Exception e) {
                String errorInfo = String.format("==generatePersonFlow CHG_HPFS_ERROR generatePersonFlow chgActionId : %s, chgRecordId: %s", perChgBizInfoNew.getChgActionId(), perChgBizInfoNew.getChgRecordId());
                perChgBizInfoNew.setErrMsg(errorInfo);
                LOG.error(errorInfo, (Throwable)e);
            }
        }
    }

    public static Tuple<Boolean, String> generatePersonFlow(Map<String, Object> params) {
        LOG.info(MessageFormat.format("PersonFlowServiceImpl.generatePersonFlow param:{0}", params));
        Tuple<Boolean, String> checkResult = ChgRecordHelper.checkParams(params);
        if (!((Boolean)checkResult.item1).booleanValue()) {
            LOG.info(MessageFormat.format("PersonFlowServiceImpl.generatePersonFlow param check fail,error:{0}", checkResult.item2));
            return checkResult;
        }
        DynamicObject recordDy = RepositoryUtils.queryById("hpfs_chgrecord", HRJSONUtils.getLongValOfCustomParam((Object)params.get("chgRecord")));
        if (recordDy == null) {
            String errorMsg = "Can not found the chg record";
            LOG.info(MessageFormat.format("PersonFlowServiceImpl.generatePersonFlow param check fail,error:{0}", errorMsg));
            return Tuple.create((Object)Boolean.FALSE, (Object)errorMsg);
        }
        DynamicObjectCollection dyCols = ChgRecordHelper.createPersonFlow(params, recordDy);
        if (dyCols.size() == 0) {
            LOG.info("PersonFlowServiceImpl.generatePersonFlow dyCols size is zero, please check the flowtype, recordId is {}", (Object)recordDy.getString("id"));
        } else {
            THREAD_POOL.execute(() -> ChgRecordHelper.completePersonFlow((DynamicObject[])dyCols.toArray((Object[])new DynamicObject[dyCols.size()]), true), RequestContext.get());
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private static DynamicObjectCollection createPersonFlow(Map<String, Object> params, DynamicObject recordDy) {
        DynamicObjectCollection entry = recordDy.getDynamicObjectCollection("entryentity");
        Object flowTime = params.get("flowTime");
        Object chgAction = params.get("chgAction");
        Object chgCategory = params.get("chgCategory");
        Object chgRecord = params.get("chgRecord");
        DynamicObjectCollection personFlowCols = new DynamicObjectCollection();
        entry.stream().filter(item -> "hrpi_depemp".equals(item.getString("chgentity.number")) && !StringUtils.isEmpty((Object)item.getString("flowtype")) && !"0".equals(item.getString("flowtype"))).forEach(item -> {
            DynamicObject dy = PerFlowRepository.generate();
            dy.set("creator", (Object)RequestContext.get().getCurrUserId());
            dy.set("flowtime", flowTime);
            dy.set("chgaction", chgAction);
            dy.set("chgcategory", chgCategory);
            dy.set("chgrecord", chgRecord);
            dy.set("depemp", (Object)ChgRecordHelper.getDepEmp(item));
            dy.set("billsource", recordDy.get("billsource"));
            dy.set("bill", recordDy.get("bill"));
            dy.set("flowtype", item.get("flowtype"));
            personFlowCols.add((Object)dy);
        });
        if (personFlowCols.size() > 0) {
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICustomPersonFlowService.class, (String)"kd.sdk.hr.hpfs.business.personflow.ICustomPersonFlowService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.setCustomField(personFlowCols, recordDy, params);
                return null;
            });
            PerFlowRepository.save(personFlowCols);
        }
        return personFlowCols;
    }

    private static Tuple<Boolean, String> checkParams(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return Tuple.create((Object)Boolean.FALSE, (Object)"The parameter is empty");
        }
        for (String field : MUST_INPUT_SET) {
            if (!ObjectUtils.isEmpty((Object)params.get(field))) continue;
            return Tuple.create((Object)Boolean.FALSE, (Object)MessageFormat.format("Can not found the parameter {0}", field));
        }
        Long recordId = HRJSONUtils.getLongValOfCustomParam((Object)params.get("chgRecord"));
        DynamicObject[] dys = PerFlowRepository.query("id", new QFilter[]{new QFilter("chgRecord", "=", (Object)recordId)});
        if (dys != null && dys.length > 0) {
            return Tuple.create((Object)Boolean.FALSE, (Object)MessageFormat.format("Already exists the chgRecord:{0}", recordId));
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private static void completePersonFlow(DynamicObject[] dyCols, boolean isInit) {
        try {
            LOG.info("==begin completePersonFlow==");
            String depEmpKey = ChgRecordHelper.getDepEmpIdKey(isInit);
            ThreeTuple<List<Long>, Map<Long, Integer>, Map<Long, Integer>> countFlowRecord = ChgRecordHelper.countFlowRecord(dyCols, depEmpKey);
            List empList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listDataEmpOrgrelDys", (Object[])new Object[]{countFlowRecord.item1});
            HashMap empMap = Maps.newHashMapWithExpectedSize((int)empList.size());
            ArrayList employeeList = Lists.newArrayListWithExpectedSize((int)dyCols.length);
            empList.forEach(item -> {
                empMap.put(HRJSONUtils.getLongValOfCustomParam((Object)item.get("depemp.id")), item);
                employeeList.add(item.getLong("employee.id"));
            });
            List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{employeeList, "employee,enterprise", "hrpi_empentrel"});
            HashMap empentrelMap = Maps.newHashMapWithExpectedSize((int)empentrelList.size());
            empentrelList.forEach(item -> empentrelMap.put(HRJSONUtils.getLongValOfCustomParam(item.get("employee")), item));
            for (DynamicObject dy : dyCols) {
                Map empentrelInfo;
                Date flowTime = dy.getDate("flowtime");
                dy.set("flowyear", (Object)HRDateTimeUtils.getYear((Date)flowTime));
                dy.set("flowquarter", (Object)HRDateTimeUtils.getQuarter((Date)flowTime));
                dy.set("flowmonth", (Object)HRDateTimeUtils.getMonth((Date)flowTime));
                dy.set("flowweek", (Object)HRDateTimeUtils.getWeek((Date)flowTime));
                Long demEmpId = dy.getLong(depEmpKey);
                DynamicObject empInfo = (DynamicObject)empMap.get(demEmpId);
                ChgRecordHelper.setPersonInfo(empInfo, dy);
                Map map = empentrelInfo = empInfo == null ? null : (Map)empentrelMap.get(empInfo.get("employee.id"));
                if (empentrelInfo != null) {
                    dy.set("enterprise", empentrelInfo.get("enterprise"));
                }
                ChgRecordHelper.setExceptionStatus((Map)countFlowRecord.item2, (Map)countFlowRecord.item3, dy, depEmpKey);
                dy.set("completionresult", (Object)"0");
            }
        }
        catch (Exception exception) {
            LOG.error("PersonFlowServiceImpl.completePersonFlow fail", (Throwable)exception);
            for (DynamicObject dy : dyCols) {
                dy.set("completionresult", (Object)"1");
            }
        }
        PerFlowRepository.update(dyCols);
    }

    private static void setExceptionStatus(Map<Long, Integer> flowInCountMap, Map<Long, Integer> flowOutCountMap, DynamicObject dy, String depEmpKey) {
        String type = dy.getString("flowtype");
        Long depEmpId = dy.getLong(depEmpKey);
        String exceptionStatus = "0";
        if (FlowTypeEnum.OUT.getValue().equals(type)) {
            ChgRecordHelper.addCount(flowOutCountMap, depEmpId);
            Integer inCount = flowInCountMap.get(depEmpId);
            Integer outCount = flowOutCountMap.get(depEmpId);
            if (inCount == null || inCount < outCount) {
                exceptionStatus = "1";
            }
        }
        dy.set("exceptionstatus", (Object)exceptionStatus);
    }

    private static ThreeTuple<List<Long>, Map<Long, Integer>, Map<Long, Integer>> countFlowRecord(DynamicObject[] dyCols, String depEmpKey) {
        DynamicObject[] dys;
        ArrayList demEmpIds = Lists.newArrayListWithExpectedSize((int)dyCols.length);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)dyCols.length);
        HashMap<Long, Integer> flowInCountMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> flowOutCountMap = new HashMap<Long, Integer>(16);
        Arrays.stream(dyCols).forEach(item -> {
            demEmpIds.add(item.getLong(depEmpKey));
            ids.add(item.getLong("id"));
        });
        for (DynamicObject dy : dys = PerFlowRepository.query("id,flowtype,depemp", new QFilter[]{new QFilter("depemp", "in", (Object)demEmpIds).and(new QFilter("id", "not in", (Object)ids))})) {
            ChgRecordHelper.handleFlowCount(flowInCountMap, flowOutCountMap, dy, "depemp.id");
        }
        for (DynamicObject dy : dyCols) {
            if (!FlowTypeEnum.IN.getValue().equals(dy.getString("flowtype"))) continue;
            ChgRecordHelper.addCount(flowInCountMap, dy.getLong(depEmpKey));
        }
        return new ThreeTuple((Object)demEmpIds, flowInCountMap, flowOutCountMap);
    }

    private static void addCount(Map<Long, Integer> flowCountMap, Long depEmpId) {
        Integer count = flowCountMap.get(depEmpId);
        if (count == null) {
            flowCountMap.put(depEmpId, 1);
        } else {
            count = count + 1;
            flowCountMap.put(depEmpId, count);
        }
    }

    private static void handleFlowCount(Map<Long, Integer> flowInCountMap, Map<Long, Integer> flowOutCountMap, DynamicObject dy, String depEmpKey) {
        String type = dy.getString("flowtype");
        Long depEmpId = dy.getLong(depEmpKey);
        if (FlowTypeEnum.IN.getValue().equals(type)) {
            ChgRecordHelper.addCount(flowInCountMap, depEmpId);
        } else {
            ChgRecordHelper.addCount(flowOutCountMap, depEmpId);
        }
    }

    private static Long getDepEmp(DynamicObject dy) {
        if (ChgModeEnum.ADD_NEW.getChgMode().equals(dy.getString("chgmode"))) {
            return dy.getLong("idafter");
        }
        return dy.getLong("idbefore");
    }

    private static String getDepEmpIdKey(boolean isInit) {
        if (isInit) {
            return "depemp";
        }
        return "depemp.id";
    }

    private static void setPersonInfo(DynamicObject empInfo, DynamicObject dy) {
        if (empInfo == null) {
            return;
        }
        dy.set("person", empInfo.get("person.id"));
        dy.set("personname", empInfo.get("person.name"));
        dy.set("personnumber", empInfo.get("person.number"));
        dy.set("employee", empInfo.get("employee.id"));
        dy.set("cmpemp", empInfo.get("cmpemp.id"));
        dy.set("managescope", empInfo.get("cmpemp.managingscope.id"));
        dy.set("laborreltype", empInfo.get("employee.laborreltype.id"));
        ChgRecordHelper.setAdminOrgInfo(HRJSONUtils.getLongValOfCustomParam((Object)empInfo.get("adminorg.id")), dy);
    }

    private static void setAdminOrgInfo(Long adminOrgId, DynamicObject dy) {
        dy.set("adminorg", (Object)adminOrgId);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(adminOrgId);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{ids, dy.getDate("flowtime"), Boolean.TRUE});
        Map infoMap = (Map)result.get(String.valueOf(adminOrgId));
        if (infoMap != null) {
            dy.set("adminorghis", infoMap.get("id"));
            dy.set("orglonghisid", infoMap.get("adminorgstructvid"));
            dy.set("orglongnumber", infoMap.get("longnumber"));
        }
    }

    private static void formatCollection(PerChgBizInfoNew bizInfo, DynamicObjectCollection collection) {
        collection.clear();
        Map<String, List<ChgRecordEntryDto>> idsRecord = bizInfo.getEntityRecord();
        idsRecord.forEach((entityName, ids) -> ids.forEach(row -> {
            DynamicObject dynNew = collection.addNew();
            ChgRecordEntryDto.recordEntrySetValue(dynNew, entityName, row);
        }));
    }

    public static void deleteEntityRecord(PerChgBizInfoNew perChgBizInfoNew, String entityNum) {
        perChgBizInfoNew.getEntityRecord().remove(entityNum);
        Map<String, Object> personParams = perChgBizInfoNew.getPersonParams();
        if (personParams == null || personParams.size() == 0) {
            return;
        }
        Object data = personParams.get("data");
        if (HRObjectUtils.isEmpty((Object)data)) {
            return;
        }
        if (data instanceof List) {
            Iterator iterator = ((List)data).iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                Collection values = map.values();
                if (!HRCollUtil.isNotEmpty(values)) continue;
                values.forEach(value -> {
                    if (entityNum.equals(value.getDynamicObjectType().getName())) {
                        iterator.remove();
                    }
                });
            }
        }
    }

    public static DynamicObject getHisDyById(PerChgBizInfoNew perChgBizInfoNew, DynamicObject currentDy, String entityNum) {
        if (perChgBizInfoNew == null) {
            return ChgRecordHelper.createHisDyByCurDy(currentDy, entityNum);
        }
        List<ChgRecordEntryDto> chgRecordEntryList = perChgBizInfoNew.getEntityRecord().get(entityNum);
        if (HRCollUtil.isEmpty(chgRecordEntryList)) {
            return ChgRecordHelper.createHisDyByCurDy(currentDy, entityNum);
        }
        Optional<ChgRecordEntryDto> optional = chgRecordEntryList.stream().filter(chgRecordEntry -> chgRecordEntry.getDataDy() != null && ChgModeEnum.MODIFY.getChgMode().equals(chgRecordEntry.getChgMode())).findFirst();
        return optional.isPresent() ? optional.get().getDataDy() : ChgRecordHelper.createHisDyByCurDy(currentDy, entityNum);
    }

    private static DynamicObject createHisDyByCurDy(DynamicObject currentDy, String entityNum) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        DynamicObject newHisDy = (DynamicObject)dataEntityType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)currentDy, (DynamicObject)newHisDy);
        newHisDy.set("id", (Object)ORM.create().genLongId((IDataEntityType)dataEntityType));
        return newHisDy;
    }

    public static DynamicObject createDynamicObject(PerChgBizInfoNew perChgBizInfoNew, String entityNum) {
        if (perChgBizInfoNew == null) {
            return ChgRecordHelper.createDynamicObjectByEntityNum(entityNum);
        }
        List<ChgRecordEntryDto> chgRecordEntryList = perChgBizInfoNew.getEntityRecord().get(entityNum);
        if (HRCollUtil.isEmpty(chgRecordEntryList)) {
            return ChgRecordHelper.createDynamicObjectByEntityNum(entityNum);
        }
        Optional<ChgRecordEntryDto> optional = chgRecordEntryList.stream().filter(chgRecordEntry -> ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntry.getChgMode())).findFirst();
        return optional.isPresent() ? optional.get().getDataDy() : ChgRecordHelper.createDynamicObjectByEntityNum(entityNum);
    }

    private static DynamicObject createDynamicObjectByEntityNum(String entityNum) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)dataEntityType, null);
        long id = ORM.create().genLongId(entityNum);
        dataEntity.set("id", (Object)id);
        return dataEntity;
    }

    static {
        THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PerFlowService", (int)5, (int)1000);
        HashSet set = Sets.newHashSet();
        set.add("flowTime");
        set.add("chgAction");
        set.add("chgCategory");
        set.add("chgRecord");
        MUST_INPUT_SET = Collections.unmodifiableSet(set);
    }
}

