/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.business.mservice.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;

public class SendMsgHelper {
    private static final Log LOG = LogFactory.getLog(SendMsgHelper.class);

    public static void sendHpfsMsg(String msgPubNo, PerChgBizInfoNew bizInfoNew) {
        LOG.info("==sendHpfsMsg begin send msg==");
        String timestamp = String.valueOf(System.currentTimeMillis());
        DynamicObject chgActionDy = bizInfoNew.getChgActionDy();
        String msgNumber = Objects.isNull(bizInfoNew.getBillNo()) ? String.join((CharSequence)"_", chgActionDy.getString("number"), timestamp) : String.join((CharSequence)"_", bizInfoNew.getBillNo(), timestamp);
        HashMap<String, Object> messageParams = new HashMap<String, Object>(8);
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", msgPubNo);
        messageParams.put("msgTitle", SendMsgHelper.getMsgTitle(bizInfoNew, chgActionDy));
        messageParams.put("actionId", chgActionDy.getLong("action.id"));
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("affactionId", chgActionDy.getLong("id"));
        params.put("recordId", bizInfoNew.getChgRecordId());
        params.put("chgcategoryId", chgActionDy.getLong("chgcategory_id"));
        messageParams.put("params", SerializationUtils.serializeToBase64(params));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private static String getMsgTitle(PerChgBizInfoNew bizInfoNew, DynamicObject chgActionInfo) {
        PersonBean personBean = bizInfoNew.getPersonList().get(bizInfoNew.getPersonList().size() - 1);
        Long personId = personBean.getaPersonId() == 0L ? personBean.getbPersonId() : personBean.getaPersonId();
        QFilter idQFilter = new QFilter("id", "=", (Object)personId);
        DynamicObject personDy = new HRBaseServiceHelper("hrpi_person").loadDynamicObject(idQFilter);
        if (null == personDy) {
            return String.join((CharSequence)"_", chgActionInfo.getString("name"));
        }
        return String.join((CharSequence)"_", chgActionInfo.getString("name"), personDy.getString("name"), personDy.getString("number"));
    }
}

