/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;

public class InsertTableInfo {
    String[] pks;
    String[] entryIds;
    String tableName;
    String route;
    String selectField;
    String where;
    DynamicObjectType mt;
    List<InsertTableInfo> allInseartTableInfos;
    Map<String, InsertTableInfo> groupTableMap = new HashMap<String, InsertTableInfo>();

    public String getRoute() {
        return this.route;
    }

    public String getSelectField() {
        return this.selectField;
    }

    public String getWhere() {
        return this.where;
    }

    public List<InsertTableInfo> getAllInseartTableInfos() {
        return this.allInseartTableInfos;
    }

    public void setEntryIds(String[] entryIds) {
        this.entryIds = entryIds;
    }

    public Map<String, InsertTableInfo> getGroupTableMap() {
        return this.groupTableMap;
    }

    public String getTableName() {
        return this.tableName;
    }

    public InsertTableInfo(String[] pks, String[] entryIds, DynamicObjectType mt) {
        this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
        this.pks = pks;
        this.entryIds = entryIds;
        this.mt = mt;
        this.tableName = mt.getAlias();
        this.route = mt.getDBRouteKey();
        this.where = mt instanceof SubEntryType ? this.generateSubEntryWhere() : this.generateWhere();
        this.selectField = this.generateSelectField();
        this.generateEntryInsertTableInfo();
        this.generateGroupInsertTableInfo();
        if (StringUtils.isNotEmpty((CharSequence)this.tableName)) {
            this.allInseartTableInfos.add(this);
        }
        this.groupTableMap.forEach((groupTableKey, insertTableInfo) -> {
            if (StringUtils.isNotEmpty((CharSequence)insertTableInfo.getTableName())) {
                this.allInseartTableInfos.add((InsertTableInfo)insertTableInfo);
            }
        });
    }

    public InsertTableInfo(String[] pks, DynamicObjectType mt) {
        this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
        this.pks = pks;
        this.mt = mt;
        this.tableName = mt.getAlias();
        this.route = mt.getDBRouteKey();
        this.where = mt instanceof SubEntryType ? this.generateSubEntryWhere() : this.generateWhere();
        this.selectField = this.generateSelectField();
    }

    public InsertTableInfo(String[] pks, DynamicObjectType mt, String groupTable, String selectField) {
        this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
        this.pks = pks;
        this.tableName = mt.getAlias() + '_' + groupTable;
        this.route = mt.getDBRouteKey();
        this.where = this.generateWhere();
        this.selectField = selectField;
    }

    public InsertTableInfo(String[] pks, String route, String tableName, String selectField) {
        this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
        this.pks = pks;
        this.tableName = tableName;
        this.route = route;
        this.where = this.generateWhere();
        this.selectField = selectField;
    }

    public void appendSelectField(String field) {
        this.selectField = this.selectField + "," + field;
    }

    public void addToAllInseartTableInfos(List<InsertTableInfo> insertTableInfos) {
        this.allInseartTableInfos.addAll(insertTableInfos);
    }

    private void generateGroupInsertTableInfo() {
        DataEntityPropertyCollection properties = this.mt.getProperties();
        properties.forEach(iDataEntityProperty -> {
            String field = iDataEntityProperty.getAlias();
            String tableGroupKey = iDataEntityProperty.getTableGroup();
            if (StringUtils.isNotEmpty((CharSequence)field) && (StringUtils.isNotEmpty((CharSequence)tableGroupKey) || iDataEntityProperty instanceof MuliLangTextProp)) {
                InsertTableInfo groupInsertTableInfo;
                if (iDataEntityProperty instanceof MuliLangTextProp) {
                    tableGroupKey = "l";
                }
                if ((groupInsertTableInfo = this.groupTableMap.get(this.tableName + '_' + tableGroupKey)) == null) {
                    field = "l".equals(tableGroupKey) ? "fpkid,fid,flocaleid," + field : "fid," + field;
                    if (!(this.mt instanceof EntryType && "l".equals(tableGroupKey) || !StringUtils.isNotEmpty((CharSequence)(groupInsertTableInfo = new InsertTableInfo(this.pks, this.mt, tableGroupKey, field)).getTableName()))) {
                        this.groupTableMap.put(groupInsertTableInfo.getTableName(), groupInsertTableInfo);
                    }
                } else {
                    groupInsertTableInfo.appendSelectField(field);
                }
            }
            if (iDataEntityProperty instanceof MulBasedataProp && !(this.mt instanceof EntryType)) {
                this.allInseartTableInfos.add(new InsertTableInfo(this.pks, this.route, iDataEntityProperty.getAlias(), "fpkid,fid,fbasedataid"));
            }
        });
    }

    private void generateEntryInsertTableInfo() {
        DataEntityPropertyCollection properties = this.mt.getProperties();
        properties.forEach(iDataEntityProperty -> {
            if (iDataEntityProperty instanceof SubEntryProp) {
                InsertTableInfo entryInsertTableInfo = new InsertTableInfo(this.entryIds, ((SubEntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType());
                entryInsertTableInfo.appendSelectField("fentryid");
                this.allInseartTableInfos.add(entryInsertTableInfo);
            } else if (iDataEntityProperty instanceof EntryProp) {
                InsertTableInfo entryInsertTableInfo = new InsertTableInfo(this.pks, this.entryIds, ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType());
                entryInsertTableInfo.appendSelectField("fid");
                this.allInseartTableInfos.addAll(entryInsertTableInfo.getAllInseartTableInfos());
                this.groupTableMap.putAll(entryInsertTableInfo.getGroupTableMap());
            }
        });
    }

    private String generateSelectField() {
        DataEntityPropertyCollection properties = this.mt.getProperties();
        StringBuilder selectFieldSb = new StringBuilder();
        properties.forEach(iDataEntityProperty -> {
            String field = iDataEntityProperty.getAlias();
            if (StringUtils.isNotEmpty((CharSequence)field) && StringUtils.isEmpty((CharSequence)iDataEntityProperty.getTableGroup()) && !(iDataEntityProperty instanceof MuliLangTextProp) && !(iDataEntityProperty instanceof MulBasedataProp)) {
                selectFieldSb.append(field).append(',');
            }
        });
        selectFieldSb.delete(selectFieldSb.toString().length() - 1, selectFieldSb.toString().length());
        return selectFieldSb.toString();
    }

    private String generateWhere() {
        int d = 39;
        if (this.pks == null || this.pks.length == 0) {
            return "";
        }
        if (this.pks.length == 1) {
            return "fid = '" + this.pks[0] + '\'';
        }
        StringBuilder sb = new StringBuilder();
        sb.append("fid in (");
        for (String pk : this.pks) {
            sb.append('\'');
            sb.append(pk).append("',");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(')');
        return sb.toString();
    }

    private String generateSubEntryWhere() {
        int d = 39;
        if (this.pks == null || this.pks.length == 0) {
            return "";
        }
        if (this.pks.length == 1) {
            return "fentryid = '" + this.pks[0] + '\'';
        }
        StringBuilder sb = new StringBuilder();
        sb.append("fentryid in (");
        for (String pk : this.pks) {
            sb.append('\'');
            sb.append(pk).append("',");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return "InsertTableInfo{tableName='" + this.tableName + '\'' + ", route='" + this.route + '\'' + ", selectField='" + this.selectField + '\'' + ", where='" + this.where + '\'' + '}';
    }
}

