/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.common.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hpfs.business.service.impl.PerSaveSuccessService;
import kd.sdk.hr.hpfs.utils.HpfsSetSysAndEnddateUtils;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;

public class PerChgNewSyncOp
extends HRDataBaseOp {
    protected static final Log LOGGER = LogFactory.getLog(PerChgNewSyncOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.saveHPFSEffectMessage(e.getDataEntities());
    }

    public void saveHPFSEffectMessage(DynamicObject[] bills) {
        if (bills == null || bills.length < 1) {
            return;
        }
        Arrays.stream(bills).forEach(bill -> {
            try {
                this.setPreProperty((DynamicObject)bill);
                PerChgNewBillUtils.setEntryAndBillFields(bill);
                this.setBillProperty((DynamicObject)bill);
                PerChgNewBillUtils.setEntryFields(bill);
            }
            catch (Exception exception) {
                LOGGER.error("saveHPFSEffectMessage error billid is {} , error:", (Object)bill.getString("id"), (Object)exception);
            }
        });
        this.saveEntryFields(bills);
        List<PerChgBizInfoNew> perChgBizInfoNews = this.buildPersonParams(bills);
        this.saveBatchPersonAttach(perChgBizInfoNews);
    }

    protected void setPreProperty(DynamicObject bill) {
    }

    protected void setBillProperty(DynamicObject bill) {
    }

    public void saveEntryFields(DynamicObject[] bills) {
        String entityName = bills[0].getDataEntityType().getName();
        new HRBaseServiceHelper(entityName).save(bills);
    }

    private List<PerChgBizInfoNew> buildPersonParams(DynamicObject[] bills) {
        List<PerChgBizInfoNew> perChgBizInfoNews = this.personParamsBuilder(bills);
        this.buildCustomPersonParams(perChgBizInfoNews, bills);
        return perChgBizInfoNews;
    }

    private List<PerChgBizInfoNew> personParamsBuilder(DynamicObject[] bills) {
        PersonParamsBuilder builder = new PersonParamsBuilder();
        ArrayList<PerChgBizInfoNew> allPerList = new ArrayList<PerChgBizInfoNew>();
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = new PerChgBizInfoNew();
            perChgBizInfoNew.setBillId(bill.getLong("id"));
            perChgBizInfoNew.setBillNo(bill.getString("billno"));
            perChgBizInfoNew.setBillSource(bill.getDataEntityType().getName());
            perChgBizInfoNew.setChgActionId(bill.getLong("affaction.id"));
            this.prePersonParamsBuilder(perChgBizInfoNew, (DynamicObject)bill);
            allPerList.add(perChgBizInfoNew);
        });
        builder.validParamsAndBuildParams(allPerList);
        return allPerList;
    }

    protected void prePersonParamsBuilder(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
    }

    protected void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
    }

    protected void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews) {
        HpfsSetSysAndEnddateUtils.setSysDateAndEnddate(perChgBizInfoNews);
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            try {
                Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                LOGGER.info("saveBatchPersonAttach result:{}", (Object)result);
                Map<String, Object> delPersonParams = perChgBizInfoNew.getDelPersonParams();
                if (delPersonParams != null && delPersonParams.size() > 0) {
                    Object deleteBatchResult = HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericService", (String)"deleteBatch", (Object[])new Object[]{delPersonParams});
                    LOGGER.info("deleteBatchResult:{}", deleteBatchResult);
                }
                new PerSaveSuccessService().doIfPerSaveSuccessOperate((PerChgBizInfoNew)perChgBizInfoNew, result);
                this.updateByAcffactionResult((PerChgBizInfoNew)perChgBizInfoNew, (Boolean)result.get("success"));
            }
            catch (Exception e) {
                LOGGER.error("saveBatchPersonAttach error, billid is:{}", (Object)perChgBizInfoNew.getBillId(), (Object)e);
            }
        });
    }

    protected void updateByAcffactionResult(PerChgBizInfoNew perChgBizInfoNew, boolean affectionRecordResult) {
    }
}

