/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.opplugin;

import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hpfs.business.service.impl.PerSaveSuccessService;
import kd.sdk.hr.hpfs.common.enums.PerChgStatusEnum;
import kd.sdk.hr.hpfs.opplugin.PerChgTplSubmitEffectValidator;
import kd.sdk.hr.hpfs.opplugin.PerChgTplSubmitValidator;
import kd.sdk.hr.hpfs.utils.ChgRecordMsgUtils;
import kd.sdk.hr.hpfs.utils.HpfsSetSysAndEnddateUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;
import org.apache.commons.lang3.SerializationUtils;

public class PerChgTplSubmitEffectOp
extends HRDataBaseOp {
    protected static final Log LOGGER = LogFactory.getLog(PerChgTplSubmitEffectOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
        if (!args.getFieldKeys().contains("perchgbizinfo_tag")) {
            args.getFieldKeys().add("perchgbizinfo_tag");
        }
        if (!args.getFieldKeys().contains("errmsg_tag")) {
            args.getFieldKeys().add("errmsg_tag");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.getValidators().add(new PerChgTplSubmitValidator());
        args.getValidators().add(new PerChgTplSubmitEffectValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        this.saveEffectData(args.getDataEntities());
    }

    private void saveEffectData(DynamicObject[] bills) {
        if (bills == null || bills.length < 1) {
            return;
        }
        for (DynamicObject dynamicObject : bills) {
            ChgRecordMsgUtils.perChangeRecord(dynamicObject, this.getOption());
        }
        List<PerChgBizInfoNew> perChgBizInfoNews = Arrays.stream(bills).filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("perchgbizinfo_tag"))).map(dy -> (PerChgBizInfoNew)SerializationUtils.deserialize((byte[])Base64.getDecoder().decode(dy.getString("perchgbizinfo_tag")))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(perChgBizInfoNews)) {
            LOGGER.warn("==perChgTpl_saveEffectDataEmpty==");
            return;
        }
        this.saveBatchPersonAttach(perChgBizInfoNews, bills);
    }

    private void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        Map<String, DynamicObject> billMap = Arrays.stream(bills).collect(Collectors.toMap(dy -> dy.getString("billNo"), dy -> dy, (k1, k2) -> k2));
        HpfsSetSysAndEnddateUtils.setSysDateAndEnddate(perChgBizInfoNews);
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            try {
                DynamicObject billDy = (DynamicObject)billMap.get(perChgBizInfoNew.getBillNo());
                List<String> existStatus = ChgRecordMsgUtils.getStatus(billDy);
                Map<String, Object> result = new HashMap<String, Object>(4);
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "30")) {
                    result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                    LOGGER.info("perChgTpl_saveBatchPersonAttach_PerChgTplSubmitOp:{}", result);
                }
                if (ChgRecordMsgUtils.notSuccessTips(perChgBizInfoNew, result, billDy)) {
                    return;
                }
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_PERSON_S, true, perChgBizInfoNew);
                this.handleDelParams((PerChgBizInfoNew)perChgBizInfoNew, billDy, existStatus);
                this.setPersonCharge((PerChgBizInfoNew)perChgBizInfoNew, billDy, existStatus);
                new PerSaveSuccessService().afterPerSaveSuccess((PerChgBizInfoNew)perChgBizInfoNew, result, billDy);
                this.setBillStatus(billDy);
            }
            catch (Exception e) {
                LOGGER.error("perChgTpl_saveBatchPersonAttach_PerChgTplSubmitOp_Error, billid is:{}", (Object)perChgBizInfoNew.getBillId(), (Object)e);
            }
        });
    }

    private void setPersonCharge(PerChgBizInfoNew perChgBizInfoNew, DynamicObject billDy, List<String> existStatus) {
        try {
            if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "95")) {
                new PersonParamsBuilder().setChargePersonByPerChgNew(perChgBizInfoNew);
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_CHA_PERSON_S, true, perChgBizInfoNew);
            }
        }
        catch (Exception ex) {
            ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_CHA_PERSON_F, false, perChgBizInfoNew);
            LOGGER.error("==perChgTpl_setChargePersonByPerChgNew==", (Throwable)ex);
        }
    }

    private void setBillStatus(DynamicObject billDy) {
        List<String> afterStatusList = ChgRecordMsgUtils.getStatus(billDy);
        Set<String> allSuccessCode = PerChgStatusEnum.getAllSuccessCode();
        boolean allSuccess = true;
        for (String status : afterStatusList) {
            if (allSuccessCode.contains(status) || !HRStringUtils.isNotEmpty((String)status)) continue;
            allSuccess = false;
            break;
        }
        if (allSuccess) {
            billDy.set("perchgstatus", (Object)"99");
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{billDy});
    }

    private void handleDelParams(PerChgBizInfoNew perChgBizInfoNew, DynamicObject billDy, List<String> existStatus) {
        Map<String, Object> delPersonParams = perChgBizInfoNew.getDelPersonParams();
        if (delPersonParams != null && delPersonParams.size() > 0) {
            try {
                if (ChgRecordMsgUtils.notExistSuccessStep(existStatus, "100")) {
                    long eventId = ORM.create().genLongId("hrpi_event");
                    delPersonParams.put("eventId", eventId);
                    LOGGER.info("perChgTpl_invokeDiscardBO_start_eventId:{}", (Object)eventId);
                    Map discardBatchResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"discardBatch", (Object[])new Object[]{delPersonParams});
                    LOGGER.info("perChgTpl_deleteBatchResult_PerChgTplSubmitOp:{}", (Object)discardBatchResult);
                    if (((Boolean)discardBatchResult.get("success")).booleanValue()) {
                        ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_DISCARD_S, true, perChgBizInfoNew);
                    } else {
                        ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_DISCARD_F, false, perChgBizInfoNew);
                    }
                }
            }
            catch (Exception ex) {
                ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_DISCARD_F, false, perChgBizInfoNew);
                LOGGER.error("==perChgTpl_deleteBatchResultError==", (Throwable)ex);
            }
        }
    }
}

