/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hpfs.common.enums.PerChgStatusEnum;

public class ChgRecordMsgUtils {
    private static final Log LOG = LogFactory.getLog(ChgRecordMsgUtils.class);

    public static void setStatusAndMsgByEnum(DynamicObject billDy, PerChgStatusEnum perChgStatusEnum, boolean success, PerChgBizInfoNew params) {
        String code = perChgStatusEnum.getCode();
        String desc = perChgStatusEnum.getDesc();
        ChgRecordMsgUtils.setStatusAndMsg(billDy, desc, code, success, params);
    }

    public static void setStatusAndMsg(DynamicObject billDy, String codeInfo, String code, boolean success, PerChgBizInfoNew params) {
        StringBuilder infoCode = new StringBuilder();
        String existCode = billDy.getString("perchgstatus");
        if (HRStringUtils.isNotEmpty((String)existCode)) {
            boolean noMatch = Arrays.stream(existCode.split(",")).noneMatch(str -> str.equals(code));
            if (noMatch) {
                String deCode = PerChgStatusEnum.getAllMappingCodes().get(code);
                if (HRStringUtils.isNotEmpty((String)deCode)) {
                    existCode = existCode.replace(PerChgStatusEnum.UNEXECUTED.getCode(), "").replace("," + code, "");
                }
                if (code.equals(PerChgStatusEnum.SUCCESS.getCode())) {
                    existCode = ",";
                }
                infoCode.append(existCode).append(code).append(",");
            }
        } else {
            infoCode.append(",").append(code).append(",");
        }
        billDy.set("perchgstatus", (Object)infoCode.toString());
        if (params != null) {
            billDy.set("perchgbizinfo_tag", (Object)Base64.getEncoder().encodeToString(org.apache.commons.lang3.SerializationUtils.serialize((Serializable)params)));
        }
        if (success) {
            return;
        }
        String errInfo = billDy.getString("errmsg_tag");
        String traceId = RequestContext.get().getTraceId();
        HashMap<String, String> detail = new HashMap<String, String>();
        detail.put("codeInfo", codeInfo);
        detail.put("traceId", traceId);
        if (HRStringUtils.isNotEmpty((String)errInfo)) {
            Map hashMap = (Map)SerializationUtils.fromJsonString((String)errInfo, Map.class);
            hashMap.put(code, detail);
            billDy.set("errmsg_tag", (Object)SerializationUtils.toJsonString((Object)hashMap));
        } else {
            HashMap<String, HashMap<String, String>> hashMap = new HashMap<String, HashMap<String, String>>();
            hashMap.put(code, detail);
            billDy.set("errmsg_tag", (Object)SerializationUtils.toJsonString(hashMap));
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{billDy});
    }

    public static List<String> getStatus(DynamicObject billDy) {
        Object[] statusArr;
        List<Object> existStatus = new ArrayList<String>(10);
        String chgStatus = billDy.getString("perchgstatus");
        if (HRStringUtils.isNotEmpty((String)chgStatus) && HRArrayUtils.isNotEmpty((Object[])(statusArr = chgStatus.split(",")))) {
            existStatus = Arrays.asList(statusArr);
        }
        return existStatus;
    }

    public static boolean notExistSuccessStep(List<String> existStatus, String step) {
        return !existStatus.contains(step);
    }

    public static boolean notSuccessTips(PerChgBizInfoNew perChgBizInfoNew, Map<String, Object> res, DynamicObject billDy) {
        if (perChgBizInfoNew == null) {
            LOG.info("===perChgBizInfoNew_is null=");
            return true;
        }
        if (!perChgBizInfoNew.isSuccess()) {
            LOG.info("===perChgBizInfoNew_is fail=");
            ChgRecordMsgUtils.setStatusAndMsgByEnum(billDy, PerChgStatusEnum.SYNC_VALIDATE_F, false, perChgBizInfoNew);
            return true;
        }
        if (res == null) {
            LOG.info("==afterPerSaveSuccess_IHRPIPersonGenericService.validate api res is null");
            return true;
        }
        if (res.containsKey("success") && !((Boolean)res.get("success")).booleanValue()) {
            LOG.info("==afterPerSaveSuccess_IHRPIPersonGenericService_fail");
            ChgRecordMsgUtils.setStatusAndMsg(billDy, SerializationUtils.toJsonString(res), PerChgStatusEnum.SYNC_PERSON_F.getCode(), false, perChgBizInfoNew);
            return true;
        }
        return false;
    }

    public static void perChangeRecord(DynamicObject bill, OperateOption option) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("operation", 1010L);
        params.put("actionId", bill.getLong("affaction.id"));
        long pid = bill.getLong("bb_p_tid");
        long eid = bill.getLong("bb_e_tid");
        long did = bill.getLong("bb_d_tid");
        if (eid == 0L) {
            pid = bill.getLong("ba_p_tid");
            eid = bill.getLong("ba_p_tid");
            did = bill.getLong("ba_p_tid");
        }
        params.put("personId", pid);
        params.put("employeeId", eid);
        params.put("depEmpId", did);
        IDataEntityType dataEntityType = bill.getDataEntityType();
        String name = dataEntityType.getName();
        params.put("billSource", name);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)name);
        String appId = mainEntityType.getAppId();
        params.put("appId", appId);
        params.put("billId", bill.getLong("id"));
        params.put("billNo", bill.getString("billNo"));
        params.put("bsed", bill.getDate("b_effectivedate"));
        LOG.info("==perChangeRecord_params\uff1a{}", (Object)JSONObject.toJSONString(params));
        ChgRecordMsgUtils.sendMQMessage(JSONObject.toJSONString(params), "hpfs_chgrecord_queue");
    }

    private static void sendMQMessage(String params, String mqQueue) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", mqQueue);){
            pub.publish(params);
        }
    }
}

