/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.sdk.hr.common.bean.ChgActionMappedBean;
import kd.sdk.hr.common.helper.HpfsMetaDataServiceHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.HPFSNewChgHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.common.constants.HPFSConstants;
import kd.sdk.hr.hpfs.common.constants.PerChgNewBillTplConstants;
import kd.sdk.hr.hpfs.common.enums.ChgPerEntityClassifyEnum;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class PerChgNewBillUtils
implements PerChgNewBillTplConstants {
    private static final Log LOGGER = LogFactory.getLog(PerChgNewBillUtils.class);
    private static final HRBaseServiceHelper PER_ENTITY_CONF_HELPER = new HRBaseServiceHelper("hrpi_personentityconf");

    public static void setEntryAndBillFields(DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.setEntryAndBillFields-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        PerChgNewBillUtils.validMustInfo(mainBillDy);
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List<String> entryList = PerChgNewBillUtils.getEntryList(properties, "entry_");
        DynamicObject erManFileDy = mainBillDy.getDynamicObject("b_ermanfile");
        long afterPid = mainBillDy.getLong("ba_p_tid");
        if (afterPid != 0L) {
            LOGGER.info("###PerChgNewBillUtils.setEntryAndBillFields-is not Empty");
            PerChgNewBillUtils.setMainBillTplField(mainBillDy, entryList);
            PerChgNewBillUtils.setBillFieldByEntryField(mainBillDy, null);
            return;
        }
        PerChgNewBillUtils.setEntryAndBillFields(mainBillDy, erManFileDy, entryList, null);
        PerChgNewBillUtils.setExtUtilsEntryData(mainBillDy, null);
        LOGGER.info("###PerChgNewBillUtils.setEntryAndBillFields-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void setEntryFields(DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.setEntryFields-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        PerChgNewBillUtils.validMustInfo(mainBillDy);
        DynamicObject erManFileDy = mainBillDy.getDynamicObject("b_ermanfile");
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List entryList = Objects.isNull(erManFileDy) ? AFTER_THREE_PERSON : THREE_PERSON_ORDERS;
        Map<String, List<String>> entryAndFieldMap = PerChgNewBillUtils.getEntryAndFieldMap(mainBillDy, entryList);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)entryAndFieldMap.size());
        for (Map.Entry<String, List<String>> entryAndField : entryAndFieldMap.entrySet()) {
            Map<String, String> billFieldAndEntryFieldMap = PerChgNewBillUtils.getBillFieldAndEntryFieldMap(entryAndField);
            Map entryFieldAndValueMap = billFieldAndEntryFieldMap.entrySet().stream().collect(HashMap::new, (map, data) -> {
                if (properties.containsKey(data.getKey())) {
                    map.put(data.getValue(), mainBillDy.get((String)data.getKey()));
                }
            }, HashMap::putAll);
            resultMap.put(entryAndField.getKey(), entryFieldAndValueMap);
        }
        for (String entry : entryList) {
            DynamicObjectCollection dynamicObjectCollection;
            if (!PerChgNewBillUtils.containEntry(null, mainBillDy, entry) || Objects.isNull(dynamicObjectCollection = mainBillDy.getDynamicObjectCollection(entry))) continue;
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                dynamicObjectCollection.addNew();
            }
            if (dynamicObjectCollection.size() != 1) continue;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
            Map entryFieldAndValueMap = (Map)resultMap.get(entry);
            entryFieldAndValueMap.forEach((arg_0, arg_1) -> ((DynamicObject)dynamicObject).set(arg_0, arg_1));
        }
        LOGGER.info("###PerChgNewBillUtils.setEntryFields-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static DynamicObject[] loadEmpPosByEmployeeId(Collection<Long> employeeIdSet) {
        LOGGER.info("###PerChgNewBillUtils.loadEmpPosByEmployeeId-start employeeIdSet={}", employeeIdSet);
        QFilter employeeFilter = new QFilter("employee_id", "in", employeeIdSet);
        HRBaseServiceHelper empRelServiceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        return empRelServiceHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getBusinessStatus()});
    }

    public static void setMainBillTplField(DynamicObject mainBillDy, List<String> entryList) {
        LOGGER.info("###PerChgNewBillUtils.setMainBillTplField-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        PerChgNewBillUtils.setMainBillTplField(mainBillDy, entryList, null);
        LOGGER.info("###PerChgNewBillUtils.setMainBillTplField-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void setMainBillTplField(DynamicObject mainBillDy, List<String> entryList, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setMainBillTplField-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        PerChgNewBillUtils.setChgTypeDefaultValue(mainBillDy, entryList, view);
        PerChgNewBillUtils.setMainBillTplFieldExcludeChgType(mainBillDy, entryList, view);
        LOGGER.info("###PerChgNewBillUtils.setMainBillTplField-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void setMainBillTplFieldExcludeChgType(DynamicObject mainBillDy, List<String> entryList, IFormView view) {
        PerChgNewBillUtils.setBusinessStatusByChgType(mainBillDy, entryList, view);
        PerChgNewBillUtils.setEffectiveDateByChgType(mainBillDy, entryList, view);
    }

    private static void validMustInfo(DynamicObject mainBillDy) {
        if (Objects.isNull(mainBillDy.get("b_effectivedate"))) {
            throw new KDBizException("b_effectivedate cannot be empty");
        }
        if (Objects.isNull(mainBillDy.get("affaction"))) {
            throw new KDBizException("affaction cannot be empty");
        }
    }

    public static void setEntryAndBillFields(DynamicObject mainBillDy, DynamicObject erManFileDy, List<String> entryList, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setEntryAndBillFields-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        entryList.sort(PerChgNewBillUtils::compare);
        PerChgNewBillUtils.setThreePersonInfo(mainBillDy, erManFileDy, entryList, view);
        LOGGER.info("###PerChgNewBillUtils.setEntryAndBillFields-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setThreePersonInfo(DynamicObject mainBillDy, DynamicObject erManFileDy, List<String> entryList, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setThreePersonInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        Map<String, List<String>> entryAndFieldMap = PerChgNewBillUtils.getEntryAndFieldMap(mainBillDy, entryList);
        if (Objects.nonNull(erManFileDy)) {
            PerChgNewBillUtils.setBeforeThreePersonInfo(mainBillDy, erManFileDy, entryAndFieldMap);
        }
        PerChgNewBillUtils.setChgTypeDefaultValue(mainBillDy, THREE_PERSON_ORDERS, null);
        PerChgNewBillUtils.setAfterPeoplesIdByChgType(mainBillDy);
        PerChgNewBillUtils.setErManFileIdOfAfterDepEmp(erManFileDy, mainBillDy);
        PerChgNewBillUtils.setManageScopeOfAfterDepEmp(mainBillDy);
        PerChgNewBillUtils.setMainBillTplFieldExcludeChgType(mainBillDy, THREE_PERSON_ORDERS, null);
        LOGGER.info("###PerChgNewBillUtils.setThreePersonInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setBeforeThreePersonInfo(DynamicObject mainBillDy, DynamicObject erManFileDy, Map<String, List<String>> entryAndFieldMap) {
        if (PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_b_person")) {
            PerChgNewBillUtils.beforePersonInfo(entryAndFieldMap, erManFileDy, mainBillDy);
        } else {
            PerChgNewBillUtils.beforeBillPersonInfo(mainBillDy, erManFileDy, "bb_p_", "hrpi_person", "person.id");
        }
        if (PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_b_employee")) {
            PerChgNewBillUtils.beforeEmployeeInfo(entryAndFieldMap, erManFileDy, mainBillDy);
        } else {
            PerChgNewBillUtils.beforeBillPersonInfo(mainBillDy, erManFileDy, "bb_e_", "hrpi_employee", "employee.id");
        }
        if (PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_b_depemp")) {
            PerChgNewBillUtils.beforeDepEmpInfo(entryAndFieldMap, erManFileDy, mainBillDy);
        } else {
            PerChgNewBillUtils.beforeBillDepInfo(mainBillDy, erManFileDy);
        }
    }

    private static void beforeBillDepInfo(DynamicObject mainBillDy, DynamicObject erManFileDy) {
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List<String> bDepFields = properties.stream().filter(data -> data.getName().contains("bb_d_") && PerChgNewBillUtils.filterId(data.getName())).map(IMetadata::getName).collect(Collectors.toList());
        bDepFields.addAll(AFTER_DEP_FIELDS);
        Map<String, Object> depEmpFieldsAndValue = PerChgNewBillUtils.getEntryFieldsAndValue(erManFileDy, "hrpi_depemp", "depemp.id", bDepFields);
        Map<String, Object> relFieldsAndValue = PerChgNewBillUtils.getEntryFieldsAndValue(erManFileDy, "hrpi_empposorgrel", "empposrel.id", bDepFields);
        Map<String, Object> fieldAndValue = PerChgNewBillUtils.getFieldAndValue(bDepFields, erManFileDy);
        fieldAndValue.putAll(relFieldsAndValue);
        fieldAndValue.putAll(depEmpFieldsAndValue);
        fieldAndValue.forEach((key, value) -> {
            if (properties.containsKey(key)) {
                if (BEFORE_DEP_FIELDS.contains(key)) {
                    return;
                }
                if (AFTER_DEP_FIELDS.contains(key)) {
                    if (properties.containsKey((Object)("before" + key))) {
                        mainBillDy.set("before" + key, value);
                    }
                } else {
                    mainBillDy.set(key, value);
                }
            }
        });
    }

    private static void beforeBillPersonInfo(DynamicObject mainBillDy, DynamicObject erManFileDy, String prefix, String entityName, String pkField) {
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List<String> bFields = properties.stream().filter(data -> data.getName().contains(prefix)).map(IMetadata::getName).collect(Collectors.toList());
        if ("bb_e_".equals(prefix)) {
            bFields.addAll(AFTER_EMPLOYEE_FIELDS);
        }
        Map<String, Object> fieldAndValueMap = PerChgNewBillUtils.getEntryFieldsAndValue(erManFileDy, entityName, pkField, bFields);
        fieldAndValueMap.forEach((key, value) -> {
            if (properties.containsKey(key)) {
                if (BEFORE_EMPLOYEE_FIELDS.contains(key)) {
                    return;
                }
                if (AFTER_EMPLOYEE_FIELDS.contains(key)) {
                    if (properties.containsKey((Object)("before" + key)) && Objects.isNull(mainBillDy.get("before" + key))) {
                        mainBillDy.set("before" + key, value);
                    }
                    if (Objects.isNull(mainBillDy.get(key))) {
                        mainBillDy.set(key, value);
                    }
                } else {
                    mainBillDy.set(key, value);
                }
            }
        });
    }

    private static void setManageScopeOfAfterDepEmp(DynamicObject mainBillDy) {
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_depemp")) {
            PerChgNewBillUtils.setBillManageScopeAfterDepEmp(mainBillDy);
            LOGGER.info("###PerChgNewBillUtils.setBillManageScopeAfterDepEmp-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
            return;
        }
        LOGGER.info("###PerChgNewBillUtils.setManageScopeOfAfterDepEmp-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        DynamicObjectCollection entryEntityDyDys = mainBillDy.getDynamicObjectCollection("entry_a_depemp");
        if (CollectionUtils.isEmpty((Collection)entryEntityDyDys)) {
            return;
        }
        for (DynamicObject entryEntityDy : entryEntityDyDys) {
            if (Objects.nonNull(entryEntityDy.get("a_d_cmpemp"))) continue;
            String chgTypeValue = entryEntityDy.getString("a_d_chgtype");
            if (!ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue)) continue;
            entryEntityDy.set("a_d_cmpemp", mainBillDy.get("bb_d_cmpemp"));
            if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)"ba_d_cmpemp")) continue;
            mainBillDy.set("ba_d_cmpemp", mainBillDy.get("bb_d_cmpemp"));
        }
        LOGGER.info("###PerChgNewBillUtils.setManageScopeOfAfterDepEmp-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setBillManageScopeAfterDepEmp(DynamicObject mainBillDy) {
        if (Objects.isNull(mainBillDy.get("ba_d_cmpemp"))) {
            String chgTypeValue = mainBillDy.getString("ba_d_chgtype");
            if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue) && mainBillDy.getDataEntityType().getProperties().containsKey((Object)"ba_d_cmpemp")) {
                mainBillDy.set("ba_d_cmpemp", mainBillDy.get("bb_d_cmpemp"));
            }
        }
    }

    public static void setEffectiveDateByChgType(DynamicObject mainBillDy, List<String> entryList, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setEffectiveDateByChgType-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        if (Objects.isNull(mainBillDy.get("b_effectivedate"))) {
            return;
        }
        PerChgNewBillUtils.setMainBillEffectiveDate(mainBillDy, view);
        Date effectiveDateValue = (Date)mainBillDy.get("b_effectivedate");
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty(entryList)) {
            entryList = PerChgNewBillUtils.getEntryExcludeThreePersonList(properties, "entry_", THREE_PERSON_ORDERS);
        }
        for (String entry : entryList) {
            List chgTypes;
            DataEntityPropertyCollection entryEntityProperties;
            List effectiveDates;
            DynamicObjectCollection entryEntityDys;
            if (Objects.nonNull(view)) {
                if (!view.getModel().getDataEntityType().getProperties().containsKey((Object)entry)) continue;
                entryEntityDys = view.getModel().getEntryEntity(entry);
            } else {
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entry)) continue;
                entryEntityDys = mainBillDy.getDynamicObjectCollection(entry);
            }
            if (entryEntityDys.isEmpty() || CollectionUtils.isEmpty(effectiveDates = (entryEntityProperties = entryEntityDys.getDynamicObjectType().getProperties()).stream().filter(data -> data.getName().endsWith("_bsed")).map(IMetadata::getName).collect(Collectors.toList())) || CollectionUtils.isEmpty(chgTypes = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_chgtype")).map(IMetadata::getName).collect(Collectors.toList()))) continue;
            String chgType = (String)chgTypes.get(0);
            String effectiveDate = (String)effectiveDates.get(0);
            for (int i = 0; i < entryEntityDys.size(); ++i) {
                DynamicObject entryEntityDy = (DynamicObject)entryEntityDys.get(i);
                String chgTypeValue = entryEntityDy.getString(chgType);
                if (!ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue) && !ChgModeEnum.MODIFY.getChgMode().equals(chgTypeValue) && !ChgModeEnum.INVALID.getChgMode().equals(chgTypeValue)) continue;
                entryEntityDy.set(effectiveDate, (Object)effectiveDateValue);
                if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + effectiveDate))) {
                    mainBillDy.set('b' + effectiveDate, (Object)effectiveDateValue);
                    if (Objects.nonNull(view)) {
                        view.updateView('b' + effectiveDate);
                    }
                }
                if (!Objects.nonNull(view)) continue;
                entryEntityDy.set(effectiveDate, (Object)effectiveDateValue);
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + effectiveDate))) continue;
                view.getModel().setValue('b' + effectiveDate, (Object)effectiveDateValue);
            }
            if (!Objects.nonNull(view)) continue;
            view.updateView(entry);
        }
        LOGGER.info("###PerChgNewBillUtils.setEffectiveDateByChgType-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setMainBillEffectiveDate(DynamicObject mainBillDy, IFormView view) {
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_b_employee")) {
            PerChgNewBillUtils.setBillEffectiveDate(mainBillDy, view, "bb_e_chgtype", "bb_e_bsed");
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_employee")) {
            PerChgNewBillUtils.setBillEffectiveDate(mainBillDy, view, "ba_e_chgtype", "ba_e_bsed");
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_b_depemp")) {
            PerChgNewBillUtils.setBillEffectiveDate(mainBillDy, view, "bb_d_chgtype", "bb_d_bsed");
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_depemp")) {
            PerChgNewBillUtils.setBillEffectiveDate(mainBillDy, view, "ba_d_chgtype", "ba_d_bsed");
        }
    }

    private static void setBillEffectiveDate(DynamicObject mainBillDy, IFormView view, String chgType, String besd) {
        Date effectiveDateValue = (Date)mainBillDy.get("b_effectivedate");
        String chgTypeValue = mainBillDy.getString(chgType);
        if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue) || ChgModeEnum.MODIFY.getChgMode().equals(chgTypeValue) || ChgModeEnum.INVALID.getChgMode().equals(chgTypeValue)) {
            if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)besd)) {
                mainBillDy.set(besd, (Object)effectiveDateValue);
                if (Objects.nonNull(view)) {
                    view.updateView(besd);
                }
            }
            if (Objects.nonNull(view) && mainBillDy.getDataEntityType().getProperties().containsKey((Object)besd)) {
                view.getModel().setValue(besd, (Object)effectiveDateValue);
            }
        }
    }

    public static void setBusinessStatusByChgType(DynamicObject mainBillDy, List<String> entryList, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setBusinessStatusByChgType-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty(entryList)) {
            entryList = PerChgNewBillUtils.getEntryExcludeThreePersonList(properties, "entry_", THREE_PERSON_ORDERS);
        }
        PerChgNewBillUtils.setMainBIllDepStatus(mainBillDy, view);
        for (String entry : entryList) {
            List chgTypes;
            DataEntityPropertyCollection entryEntityProperties;
            List businessStatusList;
            DynamicObjectCollection entryEntityDys;
            if (Objects.nonNull(view)) {
                if (!view.getModel().getDataEntityType().getProperties().containsKey((Object)entry)) continue;
                entryEntityDys = view.getModel().getEntryEntity(entry);
            } else {
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entry)) continue;
                entryEntityDys = mainBillDy.getDynamicObjectCollection(entry);
            }
            if (entryEntityDys.isEmpty() || CollectionUtils.isEmpty(businessStatusList = (entryEntityProperties = entryEntityDys.getDynamicObjectType().getProperties()).stream().filter(data -> data.getName().endsWith("_businessstatus")).map(IMetadata::getName).collect(Collectors.toList())) || CollectionUtils.isEmpty(chgTypes = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_chgtype")).map(IMetadata::getName).collect(Collectors.toList()))) continue;
            String chgType = (String)chgTypes.get(0);
            String businessStatus = (String)businessStatusList.get(0);
            for (DynamicObject entryEntityDy : entryEntityDys) {
                String chgTypeValue = entryEntityDy.getString(chgType);
                if (ChgModeEnum.INVALID.getChgMode().equals(chgTypeValue)) {
                    entryEntityDy.set(businessStatus, (Object)"2");
                    if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + businessStatus))) continue;
                    mainBillDy.set('b' + businessStatus, (Object)"2");
                    if (!Objects.nonNull(view)) continue;
                    view.updateView('b' + businessStatus);
                    continue;
                }
                if (!ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue) && !ChgModeEnum.MODIFY.getChgMode().equals(chgTypeValue)) continue;
                entryEntityDy.set(businessStatus, (Object)"1");
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + businessStatus))) continue;
                mainBillDy.set('b' + businessStatus, (Object)"1");
                if (!Objects.nonNull(view)) continue;
                view.updateView('b' + businessStatus);
            }
            if (!Objects.nonNull(view)) continue;
            view.updateView(entry);
        }
        LOGGER.info("###PerChgNewBillUtils.setBusinessStatusByChgType-end mainBillDy={}", mainBillDy.getPkValue());
    }

    static void setMainBIllDepStatus(DynamicObject mainBillDy, IFormView view) {
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_b_depemp")) {
            PerChgNewBillUtils.setBillDepBusinessStatus(mainBillDy, view, "bb_d_chgtype", "bb_d_businessstatus");
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_depemp")) {
            PerChgNewBillUtils.setBillDepBusinessStatus(mainBillDy, view, "ba_d_chgtype", "ba_d_businessstatus");
        }
    }

    private static void setBillDepBusinessStatus(DynamicObject mainBillDy, IFormView view, String chgTypeField, String status) {
        String chgType = mainBillDy.getString(chgTypeField);
        if (ChgModeEnum.INVALID.getChgMode().equals(chgType)) {
            if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)status)) {
                mainBillDy.set(status, (Object)"2");
                if (Objects.nonNull(view)) {
                    view.updateView(status);
                }
            }
        } else if ((ChgModeEnum.ADD_NEW.getChgMode().equals(chgType) || ChgModeEnum.MODIFY.getChgMode().equals(chgType)) && mainBillDy.getDataEntityType().getProperties().containsKey((Object)status)) {
            mainBillDy.set(status, (Object)"1");
            if (Objects.nonNull(view)) {
                view.updateView(status);
            }
        }
    }

    private static void setErManFileIdOfAfterDepEmp(DynamicObject erManFileDy, DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.setErManFileIdOfAfterDepEmp-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        if (Objects.isNull(erManFileDy)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_ermanfile");
            erManFileDy = helper.generateEmptyDynamicObject();
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_depemp")) {
            PerChgNewBillUtils.setBillErManFileIdByAfterDepEmp(erManFileDy, mainBillDy);
            LOGGER.info("###PerChgNewBillUtils.setBillErManFileIdByAfterDepEmp-end mainBillDy={}", mainBillDy.getPkValue());
            return;
        }
        DynamicObjectCollection entryEntityDyDys = mainBillDy.getDynamicObjectCollection("entry_a_depemp");
        if (CollectionUtils.isEmpty((Collection)entryEntityDyDys)) {
            return;
        }
        for (DynamicObject entryEntityDy : entryEntityDyDys) {
            String chgTypeValue = entryEntityDy.getString("a_d_chgtype");
            if (entryEntityDy.getLong("a_d_mtid") != 0L) continue;
            if (StringUtils.isBlank((CharSequence)chgTypeValue)) {
                long id = erManFileDy.getLong("id");
                entryEntityDy.set("a_d_mtid", (Object)id);
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)"ba_d_mtid")) continue;
                mainBillDy.set("ba_d_mtid", (Object)id);
                continue;
            }
            if (!ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue)) continue;
            String entityName = erManFileDy.getDataEntityType().getName();
            long id = ORM.create().genLongId(entityName);
            entryEntityDy.set("a_d_mtid", (Object)id);
            if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)"ba_d_mtid")) continue;
            mainBillDy.set("ba_d_mtid", (Object)id);
        }
        LOGGER.info("###PerChgNewBillUtils.setErManFileIdOfAfterDepEmp-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setBillErManFileIdByAfterDepEmp(DynamicObject erManFileDy, DynamicObject mainBillDy) {
        String chgType = mainBillDy.getString("ba_d_chgtype");
        if (mainBillDy.getLong("ba_d_mtid") == 0L) {
            if (StringUtils.isBlank((CharSequence)chgType)) {
                long id = erManFileDy.getLong("id");
                if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)"ba_d_mtid")) {
                    mainBillDy.set("ba_d_mtid", (Object)id);
                }
            } else if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgType)) {
                String entityName = erManFileDy.getDataEntityType().getName();
                long id = ORM.create().genLongId(entityName);
                if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)"ba_d_mtid")) {
                    mainBillDy.set("ba_d_mtid", (Object)id);
                }
            }
        }
    }

    public static void beforeEmployeeInfo(Map<String, List<String>> entryAndFieldMap, DynamicObject erManFileDy, DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.beforeEmployeeInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        PerChgNewBillUtils.beforeCommBeforeEntryInfo(entryAndFieldMap, erManFileDy, "entry_b_employee", "hrpi_employee", "employee.id", mainBillDy);
        LOGGER.info("###PerChgNewBillUtils.beforeEmployeeInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void beforePersonInfo(Map<String, List<String>> entryAndFieldMap, DynamicObject erManFileDy, DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.beforePersonInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        PerChgNewBillUtils.beforeCommBeforeEntryInfo(entryAndFieldMap, erManFileDy, "entry_b_person", "hrpi_person", "person.id", mainBillDy);
        LOGGER.info("###PerChgNewBillUtils.beforePersonInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void beforeDepEmpInfo(Map<String, List<String>> entryAndFields, DynamicObject erManFileDy, DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.beforeDepEmpInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)"entry_b_depemp")) {
            return;
        }
        DynamicObjectCollection entryEntityDys = mainBillDy.getDynamicObjectCollection("entry_b_depemp");
        if (!CollectionUtils.isEmpty((Collection)entryEntityDys)) {
            return;
        }
        List<String> fields = entryAndFields.get("entry_b_depemp");
        Map<String, Object> depEmpFieldsAndValue = PerChgNewBillUtils.getEntryFieldsAndValue(erManFileDy, "hrpi_depemp", "depemp.id", fields);
        Map<String, Object> relFieldsAndValue = PerChgNewBillUtils.getEntryFieldsAndValue(erManFileDy, "hrpi_empposorgrel", "empposrel.id", fields);
        Map<String, Object> fieldAndValue = PerChgNewBillUtils.getFieldAndValue(fields, erManFileDy);
        fieldAndValue.putAll(relFieldsAndValue);
        fieldAndValue.putAll(depEmpFieldsAndValue);
        PerChgNewBillUtils.assignEntryAndBill("entry_b_depemp", mainBillDy, fields, fieldAndValue);
        LOGGER.info("###PerChgNewBillUtils.beforeDepEmpInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void beforeCommBeforeEntryInfo(Map<String, List<String>> entryAndFieldMap, DynamicObject erManFileDy, String entryEntity, String entityName, String pkField, DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.beforeCommBeforeEntryInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entryEntity)) {
            return;
        }
        DynamicObjectCollection entryEntityDys = mainBillDy.getDynamicObjectCollection(entryEntity);
        if (!CollectionUtils.isEmpty((Collection)entryEntityDys)) {
            return;
        }
        List<String> fields = entryAndFieldMap.get(entryEntity);
        Map<String, Object> fieldAndValue = PerChgNewBillUtils.getEntryFieldsAndValue(erManFileDy, entityName, pkField, fields);
        PerChgNewBillUtils.assignEntryAndBill(entryEntity, mainBillDy, fields, fieldAndValue);
        LOGGER.info("###PerChgNewBillUtils.beforeCommBeforeEntryInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void assignEntryAndBill(String entryEntity, DynamicObject mainBillDy, List<String> fields, Map<String, Object> fieldAndValue) {
        LOGGER.info("###PerChgNewBillUtils.assignEntryAndBill-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        Map<String, Object> billFieldAndValue = PerChgNewBillUtils.getBillFieldAndValue(fieldAndValue);
        if (Objects.isNull(mainBillDy)) {
            return;
        }
        DynamicObjectCollection entryEntityDys = mainBillDy.getDynamicObjectCollection(entryEntity);
        if (Objects.isNull(entryEntityDys)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)entryEntityDys)) {
            entryEntityDys.addNew();
        }
        for (DynamicObject entryEntityDy : entryEntityDys) {
            fieldAndValue.forEach((key, value) -> {
                if (fields.contains(key)) {
                    entryEntityDy.set(key, value);
                }
            });
        }
        billFieldAndValue.forEach((key, value) -> {
            if (mainBillDy.getDataEntityType().getProperties().containsKey(key)) {
                mainBillDy.set(key, value);
            }
        });
        LOGGER.info("###PerChgNewBillUtils.assignEntryAndBill-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static Map<String, Object> getEntryFieldsAndValue(DynamicObject erManFileDy, String entityName, String pkField, List<String> fields) {
        LOGGER.info("###PerChgNewBillUtils.assignEntryAndBill-start erManFileDy={}", (Object)erManFileDy);
        String realFields = PerChgNewBillUtils.getRealFields(fields, entityName);
        DynamicObject fieldsDy = new HRBaseServiceHelper(entityName).queryOne(realFields, (Object)erManFileDy.getLong(pkField));
        return PerChgNewBillUtils.getFieldAndValue(fields, fieldsDy);
    }

    public static List<String> getEntryList(DataEntityPropertyCollection properties, String pre) {
        return properties.stream().filter(data -> data.getName().startsWith(pre) && data instanceof EntryProp).map(IMetadata::getName).collect(Collectors.toList());
    }

    public static List<String> getEntryExcludeThreePersonList(DataEntityPropertyCollection properties, String pre, List<String> filterEntryList) {
        return properties.stream().filter(data -> data.getName().startsWith(pre) && data instanceof EntryProp && !filterEntryList.contains(data.getName())).map(IMetadata::getName).collect(Collectors.toList());
    }

    public static Map<String, List<String>> getEntryAndFieldMap(DynamicObject mainBillDy, List<String> entryList) {
        return entryList.stream().filter(entry -> mainBillDy.getDataEntityType().getProperties().containsKey(entry)).collect(Collectors.toMap(entry -> entry, entry -> {
            DynamicObjectCollection entryEntityDys = mainBillDy.getDynamicObjectCollection(entry);
            DataEntityPropertyCollection entryEntityProperties = entryEntityDys.getDynamicObjectType().getProperties();
            return entryEntityProperties.stream().filter(data -> (data.getName().contains("b_") || data.getName().contains("a_")) && PerChgNewBillUtils.filterId(data.getName())).map(IMetadata::getName).collect(Collectors.toList());
        }));
    }

    public static Map<String, String> getBillFieldAndEntryFieldMap(Map.Entry<String, List<String>> entryAndField) {
        return entryAndField.getValue().stream().collect(HashMap::new, (map, data) -> map.put(ENTRY_AND_BILL_FIELDS.getOrDefault(data, 'b' + data), data), HashMap::putAll);
    }

    public static boolean filterId(String fieldName) {
        return !fieldName.endsWith("_id");
    }

    public static String getRealFields(List<String> fields, String entityName) {
        ArrayList results = Lists.newArrayListWithCapacity((int)fields.size());
        DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)entityName).getProperties();
        for (String field : fields) {
            String fieldStr = field.substring(field.lastIndexOf(95) + 1);
            if (!properties.containsKey((Object)fieldStr)) continue;
            results.add(fieldStr);
        }
        return CollectionUtils.isEmpty((Collection)results) ? "" : String.join((CharSequence)",", results);
    }

    public static Map<String, Object> getBillFieldAndValue(Map<String, Object> fieldsAndValue) {
        return fieldsAndValue.entrySet().stream().collect(HashMap::new, (map, data) -> map.put(ENTRY_AND_BILL_FIELDS.getOrDefault(data.getKey(), 'b' + (String)data.getKey()), data.getValue()), HashMap::putAll);
    }

    public static Map<String, Object> getFieldAndValue(List<String> fields, DynamicObject dy) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fields.size());
        if (Objects.isNull(dy)) {
            return resultMap;
        }
        for (String field : fields) {
            String fieldStr = field.substring(field.lastIndexOf(95) + 1);
            if (field.endsWith("_tid") || field.endsWith("_mtid")) {
                fieldStr = "id";
            }
            if (!dy.getDataEntityType().getProperties().containsKey((Object)fieldStr)) continue;
            resultMap.put(field, dy.get(fieldStr));
        }
        return resultMap;
    }

    public static Map<String, Object> getDepEmpFieldAndValue(List<String> fields, DynamicObject dy) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fields.size());
        if (Objects.isNull(dy)) {
            return resultMap;
        }
        for (String field : fields) {
            String fieldStr = field.substring(field.lastIndexOf(95) + 1);
            if (field.endsWith("_tid")) {
                fieldStr = "depemp.id";
                resultMap.put(field, dy.get(fieldStr));
                continue;
            }
            if (!dy.getDataEntityType().getProperties().containsKey((Object)fieldStr)) continue;
            resultMap.put(field, dy.get(fieldStr));
        }
        return resultMap;
    }

    public static void setChgTypeDefaultValue(DynamicObject mainBillDy, List<String> entryList, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setChgTypeDefaultValue-start");
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty(entryList)) {
            entryList = PerChgNewBillUtils.getEntryExcludeThreePersonList(properties, "entry_", THREE_PERSON_ORDERS);
        }
        PerChgNewBillUtils.setBillDefChgType(mainBillDy, view, properties, AFTER_FIELD_DEP_PREFIX);
        Map<String, Long> threePersonId = PerChgNewBillUtils.getThreePersonId(mainBillDy, view);
        long bId = threePersonId.getOrDefault("bb_p_tid", 0L);
        PerChgNewBillUtils.setAfterPersonBillChgType(view, mainBillDy, bId);
        if (THREE_PERSON_ORDERS.equals(entryList)) {
            String name = mainBillDy.getDynamicObjectType().getName();
            if (PerChgNewBillUtils.isNewHom(mainBillDy) && HpfsMetaDataServiceHelper.isHomTpl(name)) {
                entryList = AFTER_THREE_PERSON;
            }
        }
        for (String entry : entryList) {
            DataEntityPropertyCollection entryEntityProperties;
            List chgTypes;
            DynamicObjectCollection entryEntityDys;
            boolean hasEntry;
            if (Objects.nonNull(view)) {
                hasEntry = view.getModel().getDataEntityType().getProperties().containsKey((Object)entry);
                if (!hasEntry || (entryEntityDys = view.getModel().getEntryEntity(entry)).isEmpty()) {
                    continue;
                }
            } else {
                hasEntry = mainBillDy.getDataEntityType().getProperties().containsKey((Object)entry);
                if (!hasEntry) continue;
                entryEntityDys = mainBillDy.getDynamicObjectCollection(entry);
                if (entryEntityDys.isEmpty()) {
                    entryEntityDys.addNew();
                }
            }
            if (CollectionUtils.isEmpty(chgTypes = (entryEntityProperties = entryEntityDys.getDynamicObjectType().getProperties()).stream().filter(data -> data.getName().endsWith("_chgtype")).map(IMetadata::getName).collect(Collectors.toList()))) continue;
            String chgType = (String)chgTypes.get(0);
            if ("entry_a_person".equals(entry)) {
                PerChgNewBillUtils.setAfterPersonChgType(mainBillDy, entryEntityDys, chgType, bId);
                if (Objects.nonNull(view)) {
                    view.updateView('b' + chgType);
                }
            } else {
                for (DynamicObject entryEntityDy : entryEntityDys) {
                    IDataEntityProperty prop;
                    if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + chgType)) && StringUtils.isNotBlank((CharSequence)mainBillDy.getString('b' + chgType))) {
                        entryEntityDy.set(chgType, (Object)mainBillDy.getString('b' + chgType));
                    }
                    if (StringUtils.isNotBlank((CharSequence)entryEntityDy.getString(chgType)) || !((prop = (IDataEntityProperty)entryEntityProperties.get((Object)chgType)) instanceof FieldProp) || ((FieldProp)prop).getDefValue() == null) continue;
                    entryEntityDy.set(prop.getName(), ((FieldProp)prop).getDefValue());
                    if (!properties.containsKey((Object)('b' + prop.getName()))) continue;
                    mainBillDy.set('b' + prop.getName(), ((FieldProp)prop).getDefValue());
                    if (!Objects.nonNull(view)) continue;
                    view.updateView('b' + prop.getName());
                }
            }
            if (!Objects.nonNull(view)) continue;
            view.updateView(entry);
        }
        LOGGER.info("###PerChgNewBillUtils.setChgTypeDefaultValue-end");
    }

    private static void setBillDefChgType(DynamicObject mainBillDy, IFormView view, DataEntityPropertyCollection properties, List<String> fields) {
        for (String fieldPreFix : fields) {
            String chgType;
            IDataEntityProperty prop;
            List chgTypes = properties.stream().filter(data -> data.getName().endsWith("_chgtype") && data.getName().startsWith(fieldPreFix)).map(IMetadata::getName).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(chgTypes) || !((prop = (IDataEntityProperty)properties.get((Object)(chgType = (String)chgTypes.get(0)))) instanceof FieldProp) || ((FieldProp)prop).getDefValue() == null || !properties.containsKey((Object)prop.getName())) continue;
            Object objType = mainBillDy.get(prop.getName());
            if (objType instanceof String) {
                String chgTypeStr = (String)objType;
                if (!HRStringUtils.isEmpty((String)chgTypeStr)) continue;
                mainBillDy.set(prop.getName(), ((FieldProp)prop).getDefValue());
                if (!Objects.nonNull(view)) continue;
                view.updateView(prop.getName());
                continue;
            }
            if (!Objects.isNull(mainBillDy.get(prop.getName()))) continue;
            mainBillDy.set(prop.getName(), ((FieldProp)prop).getDefValue());
            if (!Objects.nonNull(view)) continue;
            view.updateView(prop.getName());
        }
    }

    private static boolean isNewHom(DynamicObject mainBillDy) {
        if (mainBillDy.getDynamicObjectType().getProperties().containsKey((Object)"viewtype")) {
            return "1".equals(mainBillDy.getString("viewtype"));
        }
        return false;
    }

    private static void setAfterPersonBillChgType(IFormView view, DynamicObject mainBillDy, long bId) {
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List chgTypes = properties.stream().filter(data -> data.getName().endsWith("_chgtype") && data.getName().startsWith("ba_p_")).map(IMetadata::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(chgTypes)) {
            return;
        }
        String chgType = (String)chgTypes.get(0);
        if (Objects.nonNull(view)) {
            view.updateView('b' + chgType);
        }
        if (bId != 0L) {
            DynamicObject affActionDy = mainBillDy.getDynamicObject("affaction");
            if (Objects.isNull(affActionDy)) {
                return;
            }
            boolean createNewPersonInfo = affActionDy.getBoolean("createnewpersoninfo");
            if (createNewPersonInfo) {
                mainBillDy.set("ba_p_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
            }
        } else {
            mainBillDy.set("ba_p_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
        }
        if (Objects.nonNull(view)) {
            view.updateView("ba_p_chgtype");
        }
    }

    private static void setAfterPersonChgType(DynamicObject mainBillDy, DynamicObjectCollection entryEntityDys, String chgType, long bId) {
        LOGGER.info("###PerChgNewBillUtils.setAfterPersonChgType-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        for (int i = 0; i < entryEntityDys.size(); ++i) {
            DynamicObject entryEntityDy = (DynamicObject)entryEntityDys.get(i);
            if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + chgType)) && StringUtils.isNotBlank((CharSequence)mainBillDy.getString('b' + chgType))) {
                entryEntityDy.set(chgType, (Object)mainBillDy.getString('b' + chgType));
            }
            if (StringUtils.isNotBlank((CharSequence)entryEntityDy.getString("a_p_chgtype"))) continue;
            if (bId != 0L) {
                boolean createNewPersonInfo;
                DynamicObject affActionDy = mainBillDy.getDynamicObject("affaction");
                if (Objects.isNull(affActionDy) || !(createNewPersonInfo = affActionDy.getBoolean("createnewpersoninfo"))) continue;
                entryEntityDy.set("a_p_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
                mainBillDy.set("ba_p_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
                continue;
            }
            entryEntityDy.set("a_p_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
            mainBillDy.set("ba_p_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
        }
        LOGGER.info("###PerChgNewBillUtils.setAfterPersonChgType-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static void setExtUtilsEntryData(DynamicObject mainBillDy, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsEntryData-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        if (Objects.isNull(mainBillDy.get("b_ermanfile")) || !mainBillDy.getBoolean("affaction.isnewchgaction")) {
            return;
        }
        if (PerChgNewBillUtils.setExtUtilsEntryInfoByMappedInfo(mainBillDy, view)) {
            return;
        }
        PerChgNewBillUtils.setChgTypeDefaultValue(mainBillDy, null, view);
        PerChgNewBillUtils.setMainBillTplFieldExcludeChgType(mainBillDy, null, view);
        if (Objects.nonNull(view)) {
            PerChgNewBillUtils.setMainBillDyExtUtilsEntryByEntryInfo(mainBillDy, view);
        }
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsEntryData-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setMainBillDyExtUtilsEntryByEntryInfo(DynamicObject mainBillDy, IFormView view) {
        DataEntityPropertyCollection properties = mainBillDy.getDynamicObjectType().getProperties();
        List<String> entryList = PerChgNewBillUtils.getEntryExcludeThreePersonList(properties, "entry_", THREE_PERSON_ORDERS);
        for (String entry : entryList) {
            DynamicObjectCollection entryEntity = mainBillDy.getDynamicObjectCollection(entry);
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            entryEntity.addAll((Collection)view.getModel().getEntryEntity(entry));
        }
    }

    public static boolean setExtUtilsEntryInfoByMappedInfo(DynamicObject mainBillDy, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsEntryInfoByMappedInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        long chgActionId = mainBillDy.getLong("affaction.id");
        List<ChgActionMappedBean> chgActionMappedBeans = HPFSNewChgHelper.queryMapped(Collections.singleton(chgActionId));
        for (ChgActionMappedBean chgActionMappedBean : chgActionMappedBeans) {
            if (Objects.isNull(chgActionMappedBean)) {
                return true;
            }
            LOGGER.info("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-chgActionMappedBean {}", (Object)chgActionMappedBean.toString());
            if (!chgActionMappedBean.isSuccess()) {
                String errMsg = chgActionMappedBean.getErrMsg();
                if (Objects.nonNull(view)) {
                    view.showTipNotification(errMsg);
                    LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-errMsg {}", (Object)errMsg);
                }
                return true;
            }
            DynamicObject mappedDy = chgActionMappedBean.getMappedDy();
            if (Objects.isNull(mappedDy)) {
                LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-mappedDy is null");
                continue;
            }
            LOGGER.info("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-mappedDy {}", (Object)mappedDy);
            DynamicObjectCollection entryEntityDys = mappedDy.getDynamicObjectCollection("entryentity");
            String name = mainBillDy.getDynamicObjectType().getName();
            Set<String> allParentAndSelfEntityNames = HpfsMetaDataServiceHelper.getAllParentAndSelfEntityName(name, null);
            String personnelBusinessBill = mappedDy.getString("personnelbusinessbill.id");
            if (!allParentAndSelfEntityNames.contains(personnelBusinessBill)) {
                LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-allParentAndSelfEntityNames not exist personnelBusinessBill");
                continue;
            }
            PerChgNewBillUtils.setExtUtilsEntryInfo(mainBillDy, view, entryEntityDys, allParentAndSelfEntityNames);
            PerChgNewBillUtils.setExtUtilsFieldsInfo(mainBillDy, view, entryEntityDys);
        }
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsEntryInfoByMappedInfo-end mainBillDy={}", mainBillDy.getPkValue());
        return false;
    }

    private static void setExtUtilsFieldsInfo(DynamicObject mainBillDy, IFormView view, DynamicObjectCollection entryEntityDys) {
        List extinfoFieldsDys = entryEntityDys.stream().filter(data -> "n_extinfo_fields".equals(data.getString("sourceentry"))).filter(data -> Objects.nonNull(data.getDynamicObject("targetentity"))).collect(Collectors.toList());
        for (DynamicObject extInfoFieldsDy : extinfoFieldsDys) {
            PerChgNewBillUtils.setExtUtilsFieldsInfo(mainBillDy, extInfoFieldsDy, view);
        }
    }

    private static void setExtUtilsFieldsInfo(DynamicObject mainBillDy, DynamicObject entryEntityDy, IFormView view) {
        List<DynamicObject> aFieldEntryDys;
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsFieldsInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        String sourceEntry = entryEntityDy.getString("sourceentry");
        String targetEntity = entryEntityDy.getString("targetentity.number");
        DynamicObject targetEntityDy = entryEntityDy.getDynamicObject("targetentity");
        DynamicObjectCollection subEntryEntity = entryEntityDy.getDynamicObjectCollection("subentryentity");
        if (StringUtils.isBlank((CharSequence)sourceEntry) || StringUtils.isBlank((CharSequence)targetEntity) || Objects.isNull(subEntryEntity) || subEntryEntity.isEmpty()) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsFieldsInfo-entryEntityDy field is null");
            return;
        }
        List fieldEntryDys = subEntryEntity.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("loadpersoninfo")).collect(Collectors.toList());
        LOGGER.info("###PerChgNewBillUtil.setExtUtilsFieldsInfo-fieldEntryDys is {}", fieldEntryDys);
        if (CollectionUtils.isEmpty(fieldEntryDys)) {
            return;
        }
        List<DynamicObject> bFieldEntryDys = fieldEntryDys.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getString("sourcefieldtag")) && data.getString("sourcefieldtag").contains("_b_")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(bFieldEntryDys)) {
            List<DynamicObject> bTargetEntityDataOfExtFields = PerChgNewBillUtils.getTargetEntityDataOfExtFields(mainBillDy, targetEntityDy, true);
            PerChgNewBillUtils.setValue(mainBillDy, view, bFieldEntryDys, bTargetEntityDataOfExtFields);
        }
        if (!CollectionUtils.isEmpty(aFieldEntryDys = fieldEntryDys.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getString("sourcefieldtag")) && data.getString("sourcefieldtag").contains("_a_")).collect(Collectors.toList()))) {
            List<DynamicObject> aTargetEntityDataOfExtFields = PerChgNewBillUtils.getTargetEntityDataOfExtFields(mainBillDy, targetEntityDy, false);
            PerChgNewBillUtils.setValue(mainBillDy, view, aFieldEntryDys, aTargetEntityDataOfExtFields);
        }
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsFieldsInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    private static void setValue(DynamicObject mainBillDy, IFormView view, List<DynamicObject> aFieldEntryDys, List<DynamicObject> aTargetEntityDataOfExtFields) {
        if (!CollectionUtils.isEmpty(aTargetEntityDataOfExtFields)) {
            DynamicObject targetFieldDy = aTargetEntityDataOfExtFields.get(0);
            for (DynamicObject fieldDy : aFieldEntryDys) {
                String targetField = fieldDy.getString("targetfieldnew.number");
                String sourceField = fieldDy.getString("sourcefieldtag");
                Object sourceObject = targetFieldDy.get(targetField);
                LOGGER.info("###PerChgNewBillUtils.setValue-targetField={}", (Object)targetField);
                LOGGER.info("###PerChgNewBillUtils.setValue-sourceField={}", (Object)sourceField);
                DataEntityPropertyCollection targetProps = mainBillDy.getDataEntityType().getProperties();
                if (!targetProps.containsKey((Object)sourceField)) continue;
                if (Objects.isNull(view)) {
                    mainBillDy.set(sourceField, sourceObject);
                    continue;
                }
                view.getModel().setValue(sourceField, sourceObject);
                view.updateView(sourceField);
            }
        }
    }

    private static void setExtUtilsEntryInfo(DynamicObject mainBillDy, IFormView view, DynamicObjectCollection entryEntityDys, Set<String> allParentAndSelfEntityNames) {
        PerChgNewBillUtils.getEntityAndTarget(entryEntityDys, allParentAndSelfEntityNames, view);
        List entryEntityDyList = entryEntityDys.stream().filter(data -> data.getString("sourceentry").startsWith("entry_") && !THREE_PERSON_ORDERS.contains(data.getString("sourceentry"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entryEntityDyList)) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-entryEntityDyList is null");
            return;
        }
        for (DynamicObject entryEntityDy : entryEntityDyList) {
            PerChgNewBillUtils.setExtUtilsEntryInfo(mainBillDy, entryEntityDy, view);
        }
    }

    private static void getEntityAndTarget(DynamicObjectCollection entryEntityDys, Set<String> allParentAndSelfEntityNames, IFormView view) {
        if (Objects.isNull(view)) {
            return;
        }
        List entryEntityDyList = entryEntityDys.stream().filter(data -> data.getString("sourceentry").startsWith("entry_") && !THREE_PERSON_ORDERS.contains(data.getString("sourceentry"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entryEntityDyList)) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-entryEntityDyList is null");
            return;
        }
        HRPageCache hrPageCache = new HRPageCache(view);
        for (DynamicObject entryEntityDy : entryEntityDyList) {
            String sourceEntry = entryEntityDy.getString("sourceentry");
            String targetEntity = entryEntityDy.getString("targetentity.number");
            if (StringUtils.isBlank((CharSequence)sourceEntry) || StringUtils.isBlank((CharSequence)targetEntity)) {
                LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-entryEntityDy field is null");
                return;
            }
            hrPageCache.put(sourceEntry, (Object)targetEntity);
        }
    }

    private static void setExtUtilsEntryInfo(DynamicObject mainBillDy, DynamicObject entryEntityDy, IFormView view) {
        DynamicObjectCollection mainBillEntryEntityDys;
        long did;
        long eid;
        long pid;
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsEntryInfo-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        String sourceEntry = entryEntityDy.getString("sourceentry");
        String targetEntity = entryEntityDy.getString("targetentity.number");
        DynamicObjectCollection subEntryEntity = entryEntityDy.getDynamicObjectCollection("subentryentity");
        if (StringUtils.isBlank((CharSequence)sourceEntry) || StringUtils.isBlank((CharSequence)targetEntity) || Objects.isNull(subEntryEntity) || subEntryEntity.isEmpty()) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-entryEntityDy field is null");
            return;
        }
        Map<String, String> sourceFieldAndTargetField = subEntryEntity.stream().filter(data -> Objects.nonNull(data.getDynamicObject("targetfieldnew")) && data.getBoolean("loadpersoninfo")).collect(Collectors.toMap(data -> data.getString("sourcefieldtag"), data -> data.getString("targetfieldnew.number"), (o1, o2) -> o1));
        LOGGER.info("###PerChgNewBillUtil.setExtUtilsEntryInfo-sourceFieldAndTargetField is {}", sourceFieldAndTargetField);
        if (CollectionUtils.isEmpty(sourceFieldAndTargetField)) {
            return;
        }
        Map<String, Long> threePersonId = PerChgNewBillUtils.getThreePersonId(mainBillDy, view);
        if (sourceEntry.startsWith("entry_b_")) {
            pid = threePersonId.getOrDefault("bb_p_tid", 0L);
            eid = threePersonId.getOrDefault("bb_e_tid", 0L);
            did = threePersonId.getOrDefault("bb_d_tid", 0L);
        } else {
            pid = threePersonId.getOrDefault("ba_p_tid", 0L);
            eid = threePersonId.getOrDefault("ba_e_tid", 0L);
            did = threePersonId.getOrDefault("ba_d_tid", 0L);
        }
        if (pid == 0L || eid == 0L || did == 0L) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-entryEntityDy id is null");
            return;
        }
        List<DynamicObject> targetEntityDys = PerChgNewBillUtils.getTargetEntityData(mainBillDy, entryEntityDy, view);
        if (CollectionUtils.isEmpty(targetEntityDys)) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-targetEntityDys is null");
            return;
        }
        if (!mainBillDy.getDynamicObjectType().getProperties().containsKey((Object)sourceEntry)) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-sourceEntry is not exist");
            return;
        }
        Map<String, List<String>> entryAndFieldMap = PerChgNewBillUtils.getEntryAndFieldMap(mainBillDy, Collections.singletonList(sourceEntry));
        List<String> sourceFields = entryAndFieldMap.get(sourceEntry);
        if (Objects.nonNull(view)) {
            view.getModel().deleteEntryData(sourceEntry);
            view.getModel().batchCreateNewEntryRow(sourceEntry, targetEntityDys.size());
            mainBillEntryEntityDys = view.getModel().getEntryEntity(sourceEntry);
        } else {
            mainBillEntryEntityDys = mainBillDy.getDynamicObjectCollection(sourceEntry);
            targetEntityDys.forEach(data -> mainBillEntryEntityDys.addNew());
        }
        DataEntityPropertyCollection targetProperties = targetEntityDys.get(0).getDynamicObjectType().getProperties();
        for (int i = 0; i < mainBillEntryEntityDys.size(); ++i) {
            DynamicObject mainBillEntryEntityDy = (DynamicObject)mainBillEntryEntityDys.get(i);
            for (String sourceField : sourceFields) {
                String targetField;
                if (sourceField.endsWith("_tid")) {
                    mainBillEntryEntityDy.set(sourceField, targetEntityDys.get(i).get("id"));
                }
                if (sourceField.endsWith("_pid")) {
                    mainBillEntryEntityDy.set(sourceField, (Object)pid);
                }
                if (sourceField.endsWith("_eid")) {
                    mainBillEntryEntityDy.set(sourceField, (Object)eid);
                }
                if (sourceField.endsWith("_did")) {
                    mainBillEntryEntityDy.set(sourceField, (Object)did);
                }
                if (!sourceFieldAndTargetField.containsKey(sourceField) || !targetProperties.containsKey((Object)(targetField = sourceFieldAndTargetField.get(sourceField)))) continue;
                mainBillEntryEntityDy.set(sourceField, targetEntityDys.get(i).get(targetField));
            }
        }
        if (Objects.nonNull(view)) {
            view.updateView(sourceEntry);
        }
        LOGGER.info("###PerChgNewBillUtils.setExtUtilsEntryInfo-end mainBillDy={}", mainBillDy.getPkValue());
    }

    public static List<DynamicObject> getTargetEntityData(DynamicObject mainBillDy, DynamicObject entryEntityDy, IFormView formView) {
        long did;
        long eid;
        long pid;
        Map<String, Long> threePersonId = PerChgNewBillUtils.getThreePersonId(mainBillDy, formView);
        String sourceEntry = entryEntityDy.getString("sourceentry");
        if (sourceEntry.startsWith("entry_b_")) {
            pid = threePersonId.getOrDefault("bb_p_tid", 0L);
            eid = threePersonId.getOrDefault("bb_e_tid", 0L);
            did = threePersonId.getOrDefault("bb_d_tid", 0L);
        } else {
            pid = threePersonId.getOrDefault("ba_p_tid", 0L);
            eid = threePersonId.getOrDefault("ba_e_tid", 0L);
            did = threePersonId.getOrDefault("ba_d_tid", 0L);
        }
        if (pid == 0L || eid == 0L || did == 0L) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-entryEntityDy id is null");
            return Collections.emptyList();
        }
        String targetEntity = entryEntityDy.getString("targetentity.number");
        QFilter entityQFilter = new QFilter("entity", "in", (Object)targetEntity);
        Object[] personConfig = PER_ENTITY_CONF_HELPER.queryOriginalArray("number,name,classify,historytype,entity", new QFilter[]{entityQFilter});
        if (HRArrayUtils.isEmpty((Object[])personConfig)) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-personConfig is null");
            return Collections.emptyList();
        }
        HashMap personIds = Maps.newHashMapWithExpectedSize((int)3);
        personIds.put("person.id", pid);
        personIds.put("employee.id", eid);
        personIds.put("depemp.id", did);
        Map<String, List<DynamicObject>> targetEntityDataMap = PerChgNewBillUtils.getEntryAndTargetData((DynamicObject[])personConfig, personIds);
        return targetEntityDataMap.get(targetEntity);
    }

    public static List<DynamicObject> getTargetEntityDataOfExtFields(DynamicObject mainBillDy, DynamicObject targetEntityDy, boolean isBefore) {
        long did;
        long eid;
        long pid;
        if (isBefore) {
            pid = mainBillDy.getLong("bb_p_tid");
            eid = mainBillDy.getLong("bb_e_tid");
            did = mainBillDy.getLong("bb_d_tid");
        } else {
            pid = mainBillDy.getLong("ba_p_tid");
            eid = mainBillDy.getLong("ba_e_tid");
            did = mainBillDy.getLong("ba_d_tid");
        }
        if (pid == 0L || eid == 0L || did == 0L) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-entryEntityDy id is null");
            return Collections.emptyList();
        }
        String targetEntity = targetEntityDy.getString("number");
        QFilter entityQFilter = new QFilter("entity", "in", (Object)targetEntity);
        Object[] personConfig = PER_ENTITY_CONF_HELPER.queryOriginalArray("number,name,classify,historytype,entity", new QFilter[]{entityQFilter});
        if (HRArrayUtils.isEmpty((Object[])personConfig)) {
            LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfo-personConfig is null");
            return Collections.emptyList();
        }
        HashMap personIds = Maps.newHashMapWithExpectedSize((int)3);
        personIds.put("person.id", pid);
        personIds.put("employee.id", eid);
        personIds.put("depemp.id", did);
        Map<String, List<DynamicObject>> targetEntityDataMap = PerChgNewBillUtils.getEntryAndTargetData((DynamicObject[])personConfig, personIds);
        return targetEntityDataMap.get(targetEntity);
    }

    public static Map<String, Long> getThreePersonId(DynamicObject mainBillDy, IFormView view) {
        HashMap idFieldValueMap = Maps.newHashMapWithExpectedSize((int)6);
        PerChgNewBillUtils.setNoEntryThreePersonId(mainBillDy, view, idFieldValueMap);
        for (String entry : THREE_PERSON_ORDERS) {
            DynamicObjectCollection entryDys;
            if (Objects.nonNull(view)) {
                if (!view.getModel().getDataEntityType().getProperties().containsKey((Object)entry)) continue;
                entryDys = view.getModel().getEntryEntity(entry);
            } else {
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entry)) continue;
                entryDys = mainBillDy.getDynamicObjectCollection(entry);
            }
            if (CollectionUtils.isEmpty((Collection)entryDys)) continue;
            if ("entry_b_depemp".equals(entry) && entryDys.size() > 1) {
                long did = PerChgNewBillUtils.getDid(entryDys);
                idFieldValueMap.put("bb_d_tid", did);
                continue;
            }
            DataEntityPropertyCollection entryEntityProperties = entryDys.getDynamicObjectType().getProperties();
            List tids = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_tid")).map(IMetadata::getName).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tids)) continue;
            String tid = (String)tids.get(0);
            for (DynamicObject entryDy : entryDys) {
                long aLong = entryDy.getLong(tid);
                String idField = (String)ENTRY_PI_ID.get(entry);
                idFieldValueMap.put(idField, aLong);
            }
        }
        return idFieldValueMap;
    }

    static void setNoEntryThreePersonId(DynamicObject mainBillDy, IFormView view, Map<String, Long> entryEntityAndId) {
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_person")) {
            PerChgNewBillUtils.setFieldToMap(mainBillDy, view, entryEntityAndId, "bb_p_tid");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_a_person")) {
            PerChgNewBillUtils.setFieldToMap(mainBillDy, view, entryEntityAndId, "ba_p_tid");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_employee")) {
            PerChgNewBillUtils.setFieldToMap(mainBillDy, view, entryEntityAndId, "bb_e_tid");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_a_employee")) {
            PerChgNewBillUtils.setFieldToMap(mainBillDy, view, entryEntityAndId, "ba_e_tid");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_depemp")) {
            PerChgNewBillUtils.setFieldToMap(mainBillDy, view, entryEntityAndId, "bb_d_tid");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_a_employee")) {
            PerChgNewBillUtils.setFieldToMap(mainBillDy, view, entryEntityAndId, "ba_d_tid");
        }
    }

    private static void setFieldToMap(DynamicObject mainBillDy, IFormView view, Map<String, Long> fieldIdMap, String field) {
        if (Objects.nonNull(view)) {
            Object value = view.getModel().getValue(field);
            if (value instanceof Integer) {
                fieldIdMap.put(field, ((Integer)value).longValue());
            } else {
                fieldIdMap.put(field, (Long)value);
            }
        } else {
            fieldIdMap.put(field, mainBillDy.getLong(field));
        }
    }

    public static long getDid(DynamicObjectCollection entryEntity) {
        long did = 0L;
        if (entryEntity.size() == 1) {
            did = ((DynamicObject)entryEntity.get(0)).getLong("b_d_tid");
        } else {
            List tidList = entryEntity.stream().map(data -> data.getLong("b_d_tid")).collect(Collectors.toList());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_depemp");
            QFilter qFilter = new QFilter("id", "in", tidList);
            qFilter.and("isprimary", "=", (Object)"1");
            DynamicObject[] dys = helper.query("id", new QFilter[]{qFilter, RepositoryUtils.isCurrentVersion(), RepositoryUtils.isDataStatus()});
            if (Objects.nonNull(dys) && dys.length != 0) {
                did = dys[0].getLong("id");
            }
        }
        return did;
    }

    private static Map<String, List<DynamicObject>> getEntryAndTargetData(DynamicObject[] personConfig, Map<String, Long> personIds) {
        LOGGER.info("###PerChgNewBillUtils.getEntryAndTargetData-start personIds={}", personIds);
        Map<String, String> tableClassifyMap = Arrays.stream(personConfig).collect(Collectors.toMap(row -> row.getString("entity"), row -> row.getString("classify")));
        HashMap targetData = Maps.newHashMapWithExpectedSize((int)3);
        tableClassifyMap.entrySet().stream().filter(entrySet -> !HRStringUtils.equals((String)((String)entrySet.getValue()), (String)ChgPerEntityClassifyEnum.PERSON_MODEL.getClassify())).forEach(entrySet -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper((String)entrySet.getKey());
            ChgPerEntityClassifyEnum chgPerEntityClassify = ChgPerEntityClassifyEnum.getQueryFieldByClassify((String)entrySet.getValue());
            QFilter qFilter = new QFilter(chgPerEntityClassify.getForeign(), "=", personIds.get(chgPerEntityClassify.getForeign()));
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)((String)entrySet.getKey())).getProperties();
            if (properties.containsKey((Object)"datastatus")) {
                qFilter.and(RepositoryUtils.isDataStatus());
            }
            if (properties.containsKey((Object)"businessstatus")) {
                qFilter.and(RepositoryUtils.isBusinessStatusEffect());
            }
            DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{qFilter, RepositoryUtils.isCurrentVersion()});
            targetData.put(entrySet.getKey(), Arrays.asList(dys));
        });
        LOGGER.info("###PerChgNewBillUtils.getEntryAndTargetData-end personIds={}", personIds);
        return targetData;
    }

    public static void setAfterPeoplesIdByChgType(DynamicObject mainBillDy) {
        LOGGER.info("###PerChgNewBillUtils.setAfterPeoplesIdByChgType-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List<String> entryList = PerChgNewBillUtils.getEntryList(properties, "entry_a_");
        PerChgNewBillUtils.setMainBillAfterPersonId(mainBillDy);
        block8: for (String entry : entryList) {
            DataEntityPropertyCollection entryEntityProperties;
            List chgTypes;
            DynamicObjectCollection entryEntityDys;
            if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entry) || (entryEntityDys = mainBillDy.getDynamicObjectCollection(entry)).isEmpty() || CollectionUtils.isEmpty(chgTypes = (entryEntityProperties = entryEntityDys.getDynamicObjectType().getProperties()).stream().filter(data -> data.getName().endsWith("_chgtype")).map(IMetadata::getName).collect(Collectors.toList()))) continue;
            String chgType = (String)chgTypes.get(0);
            switch (entry) {
                case "entry_a_person": 
                case "entry_a_employee": 
                case "entry_a_depemp": {
                    List bIds = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_tid")).map(IMetadata::getName).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(bIds)) {
                        return;
                    }
                    String idField = (String)bIds.get(0);
                    for (DynamicObject entryEntityDy : entryEntityDys) {
                        if (entryEntityDy.getLong(idField) != 0L) continue;
                        String chgTypeValue = entryEntityDy.getString(chgType);
                        if (StringUtils.isBlank((CharSequence)chgTypeValue)) {
                            String bIdFiled = idField.replace("a_", "b_");
                            if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + bIdFiled))) continue;
                            entryEntityDy.set(idField, mainBillDy.get('b' + bIdFiled));
                            if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + idField))) continue;
                            mainBillDy.set('b' + idField, mainBillDy.get('b' + bIdFiled));
                            continue;
                        }
                        if (!ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue)) continue;
                        String name = entryEntityDy.getDataEntityType().getName();
                        String entityName = "hrpi_" + name.substring(name.lastIndexOf(95) + 1);
                        long id = ORM.create().genLongId(entityName);
                        entryEntityDy.set(idField, (Object)id);
                        if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)('b' + idField))) continue;
                        mainBillDy.set('b' + idField, (Object)id);
                    }
                    continue block8;
                }
            }
        }
        LOGGER.info("###PerChgNewBillUtils.setAfterPeoplesIdByChgType-end mainBillDy={}", mainBillDy.getPkValue());
    }

    static void setMainBillAfterPersonId(DynamicObject mainBillDy) {
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_person")) {
            PerChgNewBillUtils.setBillAfterPersonId(mainBillDy, "ba_p_chgtype", "ba_p_tid", "hrpi_person");
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_employee")) {
            PerChgNewBillUtils.setBillAfterPersonId(mainBillDy, "ba_e_chgtype", "ba_e_tid", "hrpi_employee");
        }
        if (!PerChgNewBillUtils.containEntry(null, mainBillDy, "entry_a_depemp")) {
            PerChgNewBillUtils.setBillAfterPersonId(mainBillDy, "ba_d_chgtype", "ba_d_tid", "hrpi_depemp");
        }
    }

    private static void setBillAfterPersonId(DynamicObject mainBillDy, String chgType, String pidField, String entityName) {
        String chgTypeValue = mainBillDy.getString(chgType);
        if (StringUtils.isBlank((CharSequence)chgTypeValue)) {
            String bIdFiled = pidField.replace("a_", "b_");
            if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)pidField) && mainBillDy.getDataEntityType().getProperties().containsKey((Object)bIdFiled)) {
                mainBillDy.set(pidField, mainBillDy.get(bIdFiled));
            }
        } else if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue)) {
            long id = ORM.create().genLongId(entityName);
            if (mainBillDy.getDataEntityType().getProperties().containsKey((Object)pidField)) {
                mainBillDy.set(pidField, (Object)id);
            }
        }
    }

    public static void setBillFieldByEntryField(DynamicObject mainBillDy, IFormView view) {
        LOGGER.info("###PerChgNewBillUtils.setBillFieldByEntryField-start mainBillDy={}", (Object)LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)mainBillDy, HPFSConstants.HR_PRIVACY_PROPERTIES));
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        PerChgNewBillUtils.setPersonMainBillField(mainBillDy, view, properties);
        Map<String, List<String>> entryAndFieldMap = PerChgNewBillUtils.getEntryAndFieldMap(mainBillDy, THREE_PERSON_ORDERS);
        for (Map.Entry<String, List<String>> entryAndField : entryAndFieldMap.entrySet()) {
            DynamicObjectCollection entryDys;
            String entryKey = entryAndField.getKey();
            if (Objects.nonNull(view)) {
                IDataModel model = view.getModel();
                if (!model.getDataEntityType().getProperties().containsKey((Object)entryKey)) continue;
                entryDys = model.getEntryEntity(entryKey);
            } else {
                if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entryKey)) continue;
                entryDys = mainBillDy.getDynamicObjectCollection(entryKey);
            }
            if (CollectionUtils.isEmpty((Collection)entryDys) || "entry_b_depemp".equals(entryKey) && entryDys.size() > 1) continue;
            for (DynamicObject entryDy : entryDys) {
                Map<String, String> billFieldAndEntryFieldMap = PerChgNewBillUtils.getBillFieldAndEntryFieldMap(entryAndField);
                Map fieldAndValueMap = billFieldAndEntryFieldMap.entrySet().stream().collect(HashMap::new, (map, data) -> {
                    if (properties.containsKey(data.getKey())) {
                        if (AFTER_BILL_FIELDS.contains(data.getKey()) && Objects.nonNull(mainBillDy.get((String)data.getKey()))) {
                            map.put(data.getKey(), mainBillDy.get((String)data.getKey()));
                            entryDy.set((String)AFTER_BILL_FIELDS_AND_ENTRY.get(data.getKey()), mainBillDy.get((String)data.getKey()));
                        } else {
                            map.put(data.getKey(), entryDy.get((String)data.getValue()));
                        }
                    }
                }, HashMap::putAll);
                if (Objects.nonNull(view)) {
                    fieldAndValueMap.forEach((key, value) -> {
                        if (properties.containsKey(key)) {
                            view.getModel().setValue(key, value);
                            view.updateView(key);
                        }
                    });
                    continue;
                }
                fieldAndValueMap.forEach((key, value) -> {
                    if (properties.containsKey(key)) {
                        mainBillDy.set(key, value);
                    }
                });
            }
            if (!Objects.nonNull(view)) continue;
            view.updateView(entryKey);
        }
        LOGGER.info("###PerChgNewBillUtils.setBillFieldByEntryField-end mainBillDy={}", mainBillDy.getPkValue());
    }

    static void setPersonMainBillField(DynamicObject mainBillDy, IFormView view, DataEntityPropertyCollection properties) {
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_person")) {
            PerChgNewBillUtils.setPersonBillField(mainBillDy, view, properties, "bb_p_", "ba_p_");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_employee")) {
            PerChgNewBillUtils.setPersonBillField(mainBillDy, view, properties, "bb_e_", "ba_e_");
        }
        if (!PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_depemp")) {
            PerChgNewBillUtils.setPersonBillField(mainBillDy, view, properties, "ba_d_", "bb_d_");
        }
    }

    private static void setPersonBillField(DynamicObject mainBillDy, IFormView view, DataEntityPropertyCollection properties, String bPrefix, String aPrefix) {
        List fields = properties.stream().filter(data -> data.getName().contains(bPrefix) || data.getName().contains(aPrefix)).map(IMetadata::getName).collect(Collectors.toList());
        if ("bb_e_".equals(bPrefix)) {
            fields.addAll(BEFORE_EMPLOYEE_FIELDS);
            fields.addAll(AFTER_EMPLOYEE_FIELDS);
        } else if ("ba_d_".equals(bPrefix)) {
            fields.addAll(BEFORE_DEP_FIELDS);
            fields.addAll(AFTER_DEP_FIELDS);
        }
        HashMap<String, Object> fieldAndValueDataMap = new HashMap<String, Object>(16);
        for (String field : fields) {
            if (!properties.containsKey((Object)field)) continue;
            fieldAndValueDataMap.put(field, mainBillDy.get(field));
        }
        if (Objects.nonNull(view)) {
            fieldAndValueDataMap.forEach((key, value) -> {
                if (properties.containsKey(key)) {
                    view.getModel().setValue(key, value);
                    view.updateView(key);
                }
            });
        } else {
            fieldAndValueDataMap.forEach((key, value) -> {
                if (properties.containsKey(key)) {
                    mainBillDy.set(key, value);
                }
            });
        }
    }

    public static void changeErManFile(DynamicObject mainBillDy, IFormView view, DynamicObject erManFileDy, Object oldErManFileDy) {
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List<String> entryList = PerChgNewBillUtils.getEntryList(properties, "entry_");
        if (Objects.isNull(oldErManFileDy) && !PerChgNewBillUtils.threePersonIsEmpty(view, mainBillDy)) {
            PerChgNewBillUtils.setBillFieldByEntryField(mainBillDy, view);
            return;
        }
        if (Objects.nonNull(view)) {
            entryList.stream().filter(data -> view.getModel().getDataEntityType().getProperties().containsKey(data)).forEach(data -> view.getModel().deleteEntryData(data));
        } else {
            entryList.stream().filter(data -> mainBillDy.getDataEntityType().getProperties().containsKey(data)).forEach(data -> mainBillDy.set(data, null));
        }
        PerChgNewBillUtils.setEntryAndBillFields(mainBillDy, erManFileDy, entryList, view);
        PerChgNewBillUtils.setEntryField(view, mainBillDy, entryList);
        PerChgNewBillUtils.setBillFieldByEntryField(mainBillDy, view);
        PerChgNewBillUtils.setExtUtilsEntryData(mainBillDy, view);
    }

    public static boolean threePersonIsEmpty(IFormView view, DynamicObject mainBillDy) {
        ArrayList<String> threeIds = new ArrayList<String>(10);
        boolean hasEntry = PerChgNewBillUtils.containEntry(view, mainBillDy, "entry_b_person");
        if (Objects.nonNull(view)) {
            IDataModel model = view.getModel();
            if (hasEntry) {
                List threePersons = BEFORE_THREE_PERSON.stream().filter(data -> view.getModel().getDataEntityType().getProperties().containsKey(data) && view.getModel().getEntryEntity(data).isEmpty()).collect(Collectors.toList());
                return threePersons.size() == 3;
            }
            for (String id : BEFORE_THREE_PERSON_ID) {
                Object value = model.getValue(id);
                PerChgNewBillUtils.addToList(threeIds, id, value);
            }
            return threeIds.size() == 3;
        }
        if (hasEntry) {
            List threePersons = BEFORE_THREE_PERSON.stream().filter(data -> mainBillDy.getDataEntityType().getProperties().containsKey(data) && CollectionUtils.isEmpty((Collection)mainBillDy.getDynamicObjectCollection(data))).collect(Collectors.toList());
            return threePersons.size() == 3;
        }
        for (String id : BEFORE_THREE_PERSON_ID) {
            Object value = mainBillDy.get(id);
            PerChgNewBillUtils.addToList(threeIds, id, value);
        }
        return threeIds.size() == 3;
    }

    static void addToList(List<String> threeIds, String id, Object value) {
        Long valueLong;
        if (value instanceof Integer) {
            Integer valueInt = (Integer)value;
            if (valueInt == 0) {
                threeIds.add(id);
            }
        } else if (value instanceof Long && (valueLong = (Long)value) == 0L) {
            threeIds.add(id);
        }
    }

    private static boolean containEntry(IFormView view, DynamicObject mainBillDy, String entryKey) {
        DataEntityPropertyCollection properties = Objects.nonNull(view) ? view.getModel().getDataEntityType().getProperties() : mainBillDy.getDataEntityType().getProperties();
        return properties.containsKey((Object)entryKey);
    }

    private static void setEntryField(IFormView view, DynamicObject mainBillDy, List<String> entryList) {
        if (Objects.isNull(view)) {
            return;
        }
        for (String entryEntity : entryList) {
            DynamicObjectCollection entryEntityDys;
            if (!mainBillDy.getDataEntityType().getProperties().containsKey((Object)entryEntity) || CollectionUtils.isEmpty((Collection)(entryEntityDys = mainBillDy.getDynamicObjectCollection(entryEntity)))) continue;
            view.getModel().updateEntryCache(entryEntityDys);
            view.updateView(entryEntity);
        }
    }

    private static int compare(Object o1, Object o2) {
        int index1;
        String pre = String.valueOf(o1);
        String suffix = String.valueOf(o2);
        int n = THREE_PERSON_ORDERS.contains(pre) ? THREE_PERSON_ORDERS.indexOf(pre) : (index1 = pre.startsWith("entry_b_") ? 6 : 7);
        int index2 = THREE_PERSON_ORDERS.contains(suffix) ? THREE_PERSON_ORDERS.indexOf(suffix) : (suffix.startsWith("entry_b_") ? 6 : 7);
        return index1 - index2;
    }
}

