/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hpfs.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.EmpBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;
import kd.sdk.hr.common.constants.HpfsChgNew;
import kd.sdk.hr.common.entity.DepEmpEntity;
import kd.sdk.hr.common.entity.DiscardChargePerson;
import kd.sdk.hr.hpfs.business.mservice.helper.AttachmentHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.HPFSNewChgHelper;
import kd.sdk.hr.hpfs.business.perchg.PerChgEmpSuprelHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.utils.PersonParamsUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class PersonParamsBuilder {
    private static final Log LOG = LogFactory.getLog(PersonParamsBuilder.class);
    private final String HISSTATUS_EFFECT = "1";
    private List<PerChgBizInfoNew> failData = new ArrayList<PerChgBizInfoNew>(16);
    private List<PerChgBizInfoNew> allData = new ArrayList<PerChgBizInfoNew>(16);
    private List<PerChgBizInfoNew> successData = new ArrayList<PerChgBizInfoNew>(16);
    private static final Set<String> ignoreKeys = new HashSet<String>();
    private Map<Long, PerChgBizInfoNew> addNewPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> invalidPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> modifyPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> unChgPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> addNewDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> invalidDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> modifyDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> unChgDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> addNewEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> invalidEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> modifyEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<Long, PerChgBizInfoNew> unChgEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
    private Map<String, List<Long>> fileTypeMaps = new HashMap<String, List<Long>>(16);

    public List<PerChgBizInfoNew> getFailData() {
        return this.failData;
    }

    public void setFailData(List<PerChgBizInfoNew> failData) {
        this.failData = failData;
    }

    public List<PerChgBizInfoNew> getSuccessData() {
        return this.successData;
    }

    public void setSuccessData(List<PerChgBizInfoNew> successData) {
        this.successData = successData;
    }

    private void getAddNewMap() {
        LOG.info(this.addNewPerMap.keySet().toString());
        LOG.info(this.addNewDepMap.keySet().toString());
        LOG.info(this.addNewEmpMap.keySet().toString());
    }

    public void validParamsAndBuildParams(List<PerChgBizInfoNew> allPerList) {
        this.allData = allPerList;
        if (CollectionUtils.isEmpty(allPerList)) {
            return;
        }
        LOG.info("==validParamsAndBuildParams:{}", allPerList);
        PersonParamsUtils.validMustInput(allPerList);
        Set chgActionSet = allPerList.stream().map(PerChgBizInfoNew::getChgActionId).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", chgActionSet);
        DynamicObject[] chgActions = RepositoryUtils.queryDynamicObjects("hpfs_chgaction", "", filter);
        if (chgActions == null || chgActions.length == 0) {
            for (PerChgBizInfoNew perChgBizInfoNew : allPerList) {
                StringBuilder sb = new StringBuilder();
                perChgBizInfoNew.setSuccess(false);
                PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u4e0d\u5b58\u5728\uff1b", (String)"HPFSNewChgSerivce_0", (String)"sdk-hr", (Object[])new Object[0]), sb);
                perChgBizInfoNew.setErrMsg(sb.toString());
            }
            return;
        }
        PersonParamsUtils.initChgAction(allPerList, chgActions);
        this.initSuccessDataAndFailData(allPerList);
        if (CollectionUtils.isEmpty(this.successData)) {
            return;
        }
        this.build4PerInfo();
        this.initSuccessDataAndFailData(allPerList);
    }

    private void initSuccessDataAndFailData(List<PerChgBizInfoNew> allPerList) {
        this.failData.clear();
        this.successData.clear();
        this.successData.addAll(allPerList.stream().filter(PerChgBizInfoNew::isSuccess).collect(Collectors.toList()));
        this.failData.addAll(allPerList.stream().filter(PerChgBizInfoNew2 -> !PerChgBizInfoNew2.isSuccess()).collect(Collectors.toList()));
    }

    public void build4PerInfo() {
        this.addNewPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.invalidPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.modifyPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.unChgPerMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.addNewDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.invalidDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.modifyDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.unChgDepMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.addNewEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.invalidEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.modifyEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.unChgEmpMap = new HashMap<Long, PerChgBizInfoNew>(16);
        this.fileTypeMaps = new HashMap<String, List<Long>>(16);
        HashSet<Long> billIds = new HashSet<Long>(this.successData.size());
        String billSource = this.successData.get(0).getBillSource();
        for (PerChgBizInfoNew perChgBizInfoNew : this.successData) {
            Long billId = perChgBizInfoNew.getBillId();
            billIds.add(billId);
        }
        QFilter idFilter = new QFilter("id", "in", billIds);
        DynamicObject[] targetDys = RepositoryUtils.queryDynamicObjects(billSource, "", idFilter);
        for (PerChgBizInfoNew perChgBizInfoNew : this.successData) {
            Long billId = perChgBizInfoNew.getBillId();
            DynamicObject target = Arrays.stream(targetDys).filter(targetDy -> targetDy.getLong("id") == billId.longValue()).findFirst().orElse(null);
            if (target == null) continue;
            PersonParamsUtils.setTplPropertyFromBill(target);
            perChgBizInfoNew.setDy(target);
            if (target.getDataEntityType().getProperties().containsKey((Object)"entry_b_person")) {
                LOG.warn("==build4PerInfo_has_Entry==");
                DynamicObjectCollection bPerCollection = target.getDynamicObjectCollection("entry_b_person");
                DynamicObjectCollection aPerCollection = target.getDynamicObjectCollection("entry_a_person");
                perChgBizInfoNew.setPersonList(PersonParamsUtils.setChgPerListByDyCollect(bPerCollection, aPerCollection));
            } else {
                perChgBizInfoNew.setPersonList(PersonParamsUtils.setChgPerListByDy(target));
            }
            if (target.getDataEntityType().getProperties().containsKey((Object)"entry_b_employee")) {
                DynamicObjectCollection bEmpCollection = target.getDynamicObjectCollection("entry_b_employee");
                DynamicObjectCollection aEmpCollection = target.getDynamicObjectCollection("entry_a_employee");
                perChgBizInfoNew.setEmpList(PersonParamsUtils.setChgEmpListByDycollect(bEmpCollection, aEmpCollection));
            } else {
                perChgBizInfoNew.setEmpList(PersonParamsUtils.setChgEmpListByDy(target));
            }
            if (target.getDataEntityType().getProperties().containsKey((Object)"entry_b_depemp")) {
                DynamicObjectCollection bDepmCollection = target.getDynamicObjectCollection("entry_b_depemp");
                DynamicObjectCollection ADepmCollection = target.getDynamicObjectCollection("entry_a_depemp");
                perChgBizInfoNew.setDepempList(PersonParamsUtils.setChgDepmListByDycollect(bDepmCollection, ADepmCollection));
                continue;
            }
            perChgBizInfoNew.setDepempList(PersonParamsUtils.setChgDepmListByDy(target));
        }
        this.buildSavePersonParams();
    }

    private void buildSavePersonParams() {
        for (PerChgBizInfoNew perChgBizInfoNew : this.successData) {
            List<PersonBean> personList = perChgBizInfoNew.getPersonList();
            List<EmpBean> empList = perChgBizInfoNew.getEmpList();
            if (CollectionUtils.isEmpty(empList)) continue;
            for (PersonBean personBean : personList) {
                personBean.setbNumber(empList.get(empList.size() - 1).getbEmpnumber());
                personBean.setaNumber(empList.get(empList.size() - 1).getaEmpnumber());
            }
        }
        this.buildPerChgMap();
        this.doBuildParams();
    }

    private void doBuildParams() {
        Map<Long, DynamicObject> modifyIdPersonMap = PersonParamsUtils.queryModifyData(this.modifyPerMap.keySet(), "hrpi_person");
        Map<Long, DynamicObject> invidIdPersonMap = PersonParamsUtils.queryModifyData(this.invalidPerMap.keySet(), "hrpi_person");
        Map<Long, DynamicObject> modifyIdEmpMap = PersonParamsUtils.queryModifyData(this.modifyEmpMap.keySet(), "hrpi_employee");
        Map<Long, DynamicObject> invidIdEmpMap = PersonParamsUtils.queryModifyData(this.invalidEmpMap.keySet(), "hrpi_employee");
        Map<Long, DynamicObject> modifyEmpIdEntMap = PersonParamsUtils.queryModifyDataSetKey(this.modifyEmpMap.keySet(), "hrpi_empentrel", "employee.id");
        Map<Long, DynamicObject> invidEmpIdEntMap = PersonParamsUtils.queryModifyDataSetKey(this.invalidEmpMap.keySet(), "hrpi_empentrel", "employee.id");
        Map<Long, DynamicObject> modifyIdDepMap = PersonParamsUtils.queryModifyData(this.modifyDepMap.keySet(), "hrpi_depemp");
        Map<Long, DynamicObject> invidIdDepMap = PersonParamsUtils.queryModifyData(this.invalidDepMap.keySet(), "hrpi_depemp");
        Map<Long, DynamicObject> modifyDepIdEmpposMap = PersonParamsUtils.queryModifyDataSetKey(this.modifyDepMap.keySet(), "hrpi_empposorgrel", "depemp.id");
        Map<Long, DynamicObject> invidDepIdEmpposMap = PersonParamsUtils.queryModifyDataSetKey(this.invalidDepMap.keySet(), "hrpi_empposorgrel", "depemp.id");
        Map<Long, DynamicObject> modifyDepIdEmpposAllMap = PersonParamsUtils.queryModifyDataSetKey(this.modifyDepMap.keySet(), "hrpi_emporgrelall", "depemp.id");
        Map<Long, DynamicObject> invidDepIdEmpposAllMap = PersonParamsUtils.queryModifyDataSetKey(this.invalidDepMap.keySet(), "hrpi_emporgrelall", "depemp.id");
        Map<Long, DynamicObject> modifyDepIdErfileMap = PersonParamsUtils.queryModifyDataSetKey(this.modifyDepMap.keySet(), "hspm_ermanfile", "depemp.id");
        Map<Long, DynamicObject> invidDepIdErFileMap = PersonParamsUtils.queryModifyDataSetKey(this.invalidDepMap.keySet(), "hspm_ermanfile", "depemp.id");
        DynamicObject[] allErFileDys = this.queryAllErFileMap("hspm_ermanfile", "org.id,employee.id,depemp.id,depemp.postype.id");
        DynamicObject[] allRecordDys = this.queryAllErFileMap("hrpi_laborrelrecord", null);
        long[] eventIds = ORM.create().genLongIds("hrpi_event", this.successData.size());
        for (int i = 0; i < this.successData.size(); ++i) {
            PerChgBizInfoNew perChgBizInfoNew = this.successData.get(i);
            List<PersonBean> personList = perChgBizInfoNew.getPersonList();
            List<EmpBean> empList = perChgBizInfoNew.getEmpList();
            List<DepempBean> depemList = perChgBizInfoNew.getDepempList();
            MainEntityType personType = EntityMetadataCache.getDataEntityType((String)"hrpi_person");
            MainEntityType perNonType = EntityMetadataCache.getDataEntityType((String)"hrpi_pernontsprop");
            MainEntityType perTsType = EntityMetadataCache.getDataEntityType((String)"hrpi_pertsprop");
            for (PersonBean personBean : personList) {
                String bChgType = personBean.getbChgMethod();
                String aChgType = personBean.getaChgMethod();
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(aChgType)) {
                    DynamicObject perDy = this.addPerson(perChgBizInfoNew, personBean, (DynamicObjectType)personType);
                    this.addPerNon(perChgBizInfoNew, perDy, personBean, (DynamicObjectType)perNonType);
                    this.addPerTs(perChgBizInfoNew, perDy, personBean, (DynamicObjectType)perTsType);
                }
                if (!ChgModeEnum.MODIFY.getChgMode().equals(bChgType) && !ChgModeEnum.INVALID.getChgMode().equals(bChgType)) continue;
                DynamicObject personDy = null;
                personDy = ChgModeEnum.MODIFY.getChgMode().equals(bChgType) ? modifyIdPersonMap.get(personBean.getbPersonId()) : invidIdPersonMap.get(personBean.getbPersonId());
                if (personDy == null) {
                    perChgBizInfoNew.setSuccess(false);
                    PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u9700\u8981\u53d8\u66f4\u6216\u8005\u5931\u6548\u81ea\u7136\u4eba\u6570\u636epersonid\u4e0d\u5b58\u5728\uff1b", (String)"PersonParamsBuilder_4", (String)"sdk-hr", (Object[])new Object[0]));
                    continue;
                }
                this.updPerson(perChgBizInfoNew, personBean, (DynamicObjectType)personType, personDy);
            }
            MainEntityType empType = EntityMetadataCache.getDataEntityType((String)"hrpi_employee");
            MainEntityType empEntRelType = EntityMetadataCache.getDataEntityType((String)"hrpi_empentrel");
            for (EmpBean empBean : empList) {
                DynamicObject empDy;
                String bChgType = empBean.getbChgMethod();
                String aChgType = empBean.getaChgMethod();
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(aChgType)) {
                    empDy = this.addEmp(perChgBizInfoNew, empBean, (DynamicObjectType)empType);
                    this.addEnt(perChgBizInfoNew, empBean, (DynamicObjectType)empEntRelType, empDy);
                }
                if (!ChgModeEnum.MODIFY.getChgMode().equals(bChgType) && !ChgModeEnum.INVALID.getChgMode().equals(bChgType)) continue;
                empDy = null;
                DynamicObject entDy = null;
                if (ChgModeEnum.MODIFY.getChgMode().equals(bChgType)) {
                    empDy = modifyIdEmpMap.get(empBean.getbEmpId());
                    entDy = modifyEmpIdEntMap.get(empBean.getbEmpId());
                } else {
                    empDy = invidIdEmpMap.get(empBean.getbEmpId());
                    entDy = invidEmpIdEntMap.get(empBean.getbEmpId());
                }
                if (empDy == null || entDy == null) {
                    perChgBizInfoNew.setSuccess(false);
                    PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u9700\u8981\u53d8\u66f4\u6216\u8005\u5931\u6548\u7684\u4f01\u4e1a\u4eba\u6570\u636eemployeeid\u4e0d\u5b58\u5728\uff1b", (String)"PersonParamsBuilder_5", (String)"sdk-hr", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject updEmp = this.updEmp(empDy, perChgBizInfoNew, empBean, (DynamicObjectType)empType);
                this.updEnt(entDy, perChgBizInfoNew, empBean, (DynamicObjectType)empEntRelType, updEmp);
            }
            MainEntityType depType = EntityMetadataCache.getDataEntityType((String)"hrpi_depemp");
            MainEntityType empposType = EntityMetadataCache.getDataEntityType((String)"hrpi_empposorgrel");
            MainEntityType empposAllType = EntityMetadataCache.getDataEntityType((String)"hrpi_emporgrelall");
            MainEntityType erfileType = EntityMetadataCache.getDataEntityType((String)"hspm_ermanfile");
            DynamicObjectCollection erfileCol = new DynamicObjectCollection((DynamicObjectType)erfileType, null);
            for (DepempBean depempBean : depemList) {
                DynamicObject empposAllDy;
                DynamicObject empposDy;
                DynamicObject depDy;
                String bChgType = depempBean.getbChgMethod();
                String aChgType = depempBean.getaChgMethod();
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(aChgType)) {
                    depDy = this.addDep(perChgBizInfoNew, depempBean, (DynamicObjectType)depType, modifyIdDepMap, invidIdDepMap);
                    empposDy = this.addEmppos(perChgBizInfoNew, depempBean, (DynamicObjectType)empposType, depDy);
                    empposAllDy = this.addEmpposAll(perChgBizInfoNew, depempBean, empposDy, (DynamicObjectType)empposAllType);
                    DynamicObject dynamicObject = this.addErfile(perChgBizInfoNew, depempBean, empposDy, (DynamicObjectType)erfileType);
                }
                if (!ChgModeEnum.MODIFY.getChgMode().equals(bChgType) && !ChgModeEnum.INVALID.getChgMode().equals(bChgType)) continue;
                depDy = null;
                empposDy = null;
                empposAllDy = null;
                DynamicObject erfileDy = null;
                if (ChgModeEnum.MODIFY.getChgMode().equals(bChgType)) {
                    depDy = modifyIdDepMap.get(depempBean.getbDepempId());
                    empposDy = modifyDepIdEmpposMap.get(depempBean.getbDepempId());
                    empposAllDy = modifyDepIdEmpposAllMap.get(depempBean.getbDepempId());
                    erfileDy = modifyDepIdErfileMap.get(depempBean.getbDepempId());
                } else {
                    depDy = invidIdDepMap.get(depempBean.getbDepempId());
                    empposDy = invidDepIdEmpposMap.get(depempBean.getbDepempId());
                    empposAllDy = invidDepIdEmpposAllMap.get(depempBean.getbDepempId());
                    erfileDy = invidDepIdErFileMap.get(depempBean.getbDepempId());
                }
                if (depDy == null || empposDy == null || erfileDy == null) {
                    perChgBizInfoNew.setSuccess(false);
                    PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u9700\u8981\u53d8\u66f4\u6216\u8005\u5931\u6548\u7ec4\u7ec7\u4eba\u6570\u636edepemid\u4e0d\u5b58\u5728\uff1b", (String)"PersonParamsBuilder_6", (String)"sdk-hr", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject updDy = this.updDep(perChgBizInfoNew, depempBean, depDy, (DynamicObjectType)depType);
                DynamicObject updEmpposDy = this.updEmppos(perChgBizInfoNew, depempBean, empposDy, (DynamicObjectType)empposType, updDy);
                if (empposAllDy != null) {
                    this.updEmpposAll(perChgBizInfoNew, depempBean, updEmpposDy, empposAllDy, (DynamicObjectType)empposAllType);
                }
                this.updErfile(perChgBizInfoNew, depempBean, updEmpposDy, erfileDy, (DynamicObjectType)erfileType);
            }
            this.buildInvalidEmpSuprel(perChgBizInfoNew);
            this.buildLaborRelRecord(perChgBizInfoNew, allErFileDys, allRecordDys, depemList);
            this.addQuitFile(perChgBizInfoNew, depemList, (DynamicObjectType)erfileType);
            perChgBizInfoNew.setEventId(eventIds[i]);
        }
        this.updateIdsRecord();
        AttachmentHelper.buildAttachParams(this.allData);
        this.initSuccessDataAndFailData(this.allData);
        PersonParamsUtils.readFieldMapped(this.successData);
        this.initSuccessDataAndFailData(this.allData);
        HPFSNewChgHelper.handlePersonParams(this.successData);
    }

    private DynamicObject[] queryAllErFileMap(String entityName, String selectPops) {
        List employeeBeans = this.successData.stream().map(PerChgBizInfoNew::getEmpList).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(employeeBeans)) {
            return new DynamicObject[0];
        }
        Set aEmpIds = employeeBeans.stream().map(EmpBean::getaEmpId).collect(Collectors.toSet());
        Set bEmpIds = employeeBeans.stream().map(EmpBean::getbEmpId).collect(Collectors.toSet());
        HashSet<Long> employeeIds = new HashSet<Long>(16);
        employeeIds.addAll(aEmpIds);
        employeeIds.addAll(bEmpIds);
        return PersonParamsUtils.queryModifyData(employeeIds, entityName, "employee.id", selectPops);
    }

    private void buildInvalidEmpSuprel(PerChgBizInfoNew perChgBizInfoNew) {
        Map<String, List<ChgRecordEntryDto>> entityRecord = perChgBizInfoNew.getEntityRecord();
        List<ChgRecordEntryDto> empChgRecord = entityRecord.get("hrpi_empposorgrel");
        if (null == empChgRecord || empChgRecord.size() == 0) {
            LOG.info("PersonParamsBuilder#buildInvalidEmpSuprel end, the empRecord is empty");
            return;
        }
        List<DynamicObject> invalidateEmps = empChgRecord.stream().filter(record -> HRStringUtils.equals((String)record.getChgMode(), (String)"2")).map(ChgRecordEntryDto::getDataDy).collect(Collectors.toList());
        List<ChgRecordEntryDto> invalidateEmpSuprelRecord = PerChgEmpSuprelHelper.invalidateEmpSuprelByEmp(invalidateEmps, ChgRecordHelper.getChgEventId(perChgBizInfoNew), new HashMap<String, Object>());
        if (null != invalidateEmpSuprelRecord && invalidateEmpSuprelRecord.size() > 0) {
            invalidateEmpSuprelRecord.forEach(record -> perChgBizInfoNew.setEntityRecord("hrpi_empsuprel", (ChgRecordEntryDto)record));
        }
    }

    private void buildLaborRelRecord(PerChgBizInfoNew perChgBizInfoNew, DynamicObject[] allErFileDys, DynamicObject[] allRecordDys, List<DepempBean> depemList) {
        try {
            Map<String, List<ChgRecordEntryDto>> entityRecord = perChgBizInfoNew.getEntityRecord();
            ArrayList<DynamicObject> newRecords = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> updateRecords = new ArrayList<DynamicObject>(10);
            Map<String, List<DynamicObject>> dbFileLaborRelMap = Arrays.stream(allErFileDys).collect(Collectors.groupingBy(this.laborRelKey()));
            List<ChgRecordEntryDto> files = entityRecord.get("hspm_ermanfile");
            List<Object> fileList = new ArrayList(10);
            Map<Object, Object> contextFileMap = new HashMap(16);
            HashMap<String, List<DynamicObject>> contextLabKeyFileMap = new HashMap(16);
            if (!CollectionUtils.isEmpty(files)) {
                fileList = files.stream().map(ChgRecordEntryDto::getDataDy).collect(Collectors.toList());
                contextFileMap = fileList.stream().collect(Collectors.groupingBy(dy -> PersonParamsUtils.getBasicDataValue(dy, "depemp")));
                contextLabKeyFileMap = fileList.stream().collect(Collectors.groupingBy(this.laborRelKey()));
            }
            Map<String, List<DynamicObject>> dbLaborRelMap = Arrays.stream(allRecordDys).collect(Collectors.groupingBy(this.laborRelKey()));
            Map<Long, DynamicObject> boIdLabMap = Arrays.stream(allRecordDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (key1, key2) -> key1));
            List<ChgRecordEntryDto> depEmpDto = entityRecord.get("hrpi_depemp");
            ArrayList<DynamicObject> depEmpList = new ArrayList(10);
            if (!CollectionUtils.isEmpty(depEmpDto)) {
                depEmpList = depEmpDto.stream().map(ChgRecordEntryDto::getDataDy).collect(Collectors.toList());
            }
            HashSet<Long> updateDepEmpIds = new HashSet<Long>(10);
            HashMap<Long, String> labBoIdMap = new HashMap<Long, String>(16);
            Set<Long> posCateGory = PersonParamsUtils.getPosCateGory();
            for (DepempBean depempBean : depemList) {
                Long depEmpId;
                DynamicObject posTypeDy;
                String bChgType = depempBean.getbChgMethod();
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(depempBean.getaChgMethod())) {
                    posTypeDy = depempBean.getaPostype();
                    if (posTypeDy != null && !posCateGory.contains(posTypeDy.getLong("id"))) continue;
                    depEmpId = depempBean.getaDeempId();
                    this.buildAddRecord((List)contextFileMap.get(depEmpId), newRecords);
                }
                if (!ChgModeEnum.INVALID.getChgMode().equals(bChgType) || (posTypeDy = depempBean.getbPostype()) != null && !posCateGory.contains(posTypeDy.getLong("id"))) continue;
                depEmpId = depempBean.getbDepempId();
                this.buildUpdateRecord((List)contextFileMap.get(depEmpId), dbLaborRelMap, updateRecords, updateDepEmpIds, depEmpId, labBoIdMap, depempBean, bChgType, perChgBizInfoNew);
            }
            Map<String, List<DynamicObject>> contextAddLaborRelMap = newRecords.stream().collect(Collectors.groupingBy(this.laborRelKey()));
            Map<String, List<DynamicObject>> contextUpdateLaborRelMap = updateRecords.stream().collect(Collectors.groupingBy(this.laborRelKey()));
            this.removeAddData(perChgBizInfoNew, newRecords, contextLabKeyFileMap, dbLaborRelMap, depEmpList, contextUpdateLaborRelMap, contextFileMap);
            this.removeUpdateData(perChgBizInfoNew, updateRecords, dbFileLaborRelMap, boIdLabMap, updateDepEmpIds, labBoIdMap, contextAddLaborRelMap);
        }
        catch (Exception ex) {
            LOG.error("buildLaborRelRecordError", (Throwable)ex);
        }
    }

    private void buildAddRecord(List<DynamicObject> fileList, List<DynamicObject> newRecords) {
        if (CollectionUtils.isEmpty(fileList)) {
            return;
        }
        HashSet<String> contextExist = new HashSet<String>(16);
        MainEntityType laborRelType = EntityMetadataCache.getDataEntityType((String)"hrpi_laborrelrecord");
        List addContextFiles = fileList.stream().filter(dy -> dy.getLong("boid") == 0L).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addContextFiles)) {
            for (DynamicObject file : addContextFiles) {
                String laborRelKey = this.getLaborRelKey(file);
                if (!contextExist.add(laborRelKey)) continue;
                DynamicObject newHis = (DynamicObject)laborRelType.createInstance();
                newHis.set("person", file.get("person"));
                newHis.set("employee", file.get("employee"));
                newHis.set("businessstatus", (Object)"1");
                newHis.set("startdate", file.get("startdate"));
                newHis.set("enddate", file.get("enddate"));
                newHis.set("sysenddate", file.get("sysenddate"));
                newHis.set("bsed", file.get("bsed"));
                newHis.set("bsled", file.get("bsled"));
                newHis.set("org", file.get("org"));
                PersonParamsUtils.wrapCommonField(newHis);
                newRecords.add(newHis);
            }
        }
    }

    private void buildUpdateRecord(List<DynamicObject> contextFileDys, Map<String, List<DynamicObject>> dbLaborRelMap, List<DynamicObject> updateRecords, Set<Long> updateFileIds, Long depEmpId, Map<Long, String> labBoIdMap, DepempBean depempBean, String chgType, PerChgBizInfoNew perChgBizInfoNew) {
        if (CollectionUtils.isEmpty(contextFileDys)) {
            return;
        }
        Set updateBoId = updateRecords.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        long chgEventId = ChgRecordHelper.getChgEventId(perChgBizInfoNew);
        String chgMethod = depempBean.getbChgMethod();
        MainEntityType laborRelType = EntityMetadataCache.getDataEntityType((String)"hrpi_laborrelrecord");
        for (DynamicObject fileDy : contextFileDys) {
            String laborRelKey = this.getLaborRelKey(fileDy);
            List<DynamicObject> dbRecords = dbLaborRelMap.get(laborRelKey);
            if (CollectionUtils.isEmpty(dbRecords)) continue;
            for (DynamicObject labDy : dbRecords) {
                long dbBoId = labDy.getLong("boid");
                if (updateBoId.contains(dbBoId)) continue;
                DynamicObject newHis = (DynamicObject)laborRelType.createInstance();
                HRDynamicObjectUtils.copy((DynamicObject)labDy, (DynamicObject)newHis);
                long boId = newHis.getLong("boid");
                long currUserId = RequestContext.get().getCurrUserId();
                newHis.set("modifier", (Object)currUserId);
                newHis.set("modifytime", (Object)new Date());
                newHis.set("bsed", fileDy.get("bsed"));
                newHis.set("sysenddate", fileDy.get("sysenddate"));
                newHis.set("enddate", fileDy.get("enddate"));
                newHis.set("id", labDy.get("id"));
                if (chgEventId != 1070L) {
                    newHis.set("businessstatus", (Object)("1".equals(fileDy.getString("businessstatus")) ? "1" : "2"));
                }
                newHis.set("initstatus", (Object)"2");
                updateRecords.add(newHis);
                labBoIdMap.put(boId, chgMethod);
            }
            updateFileIds.add(depEmpId);
        }
    }

    private void removeUpdateData(PerChgBizInfoNew perChgBizInfoNew, List<DynamicObject> updateRecords, Map<String, List<DynamicObject>> dbFileLaborRelMap, Map<Long, DynamicObject> boIdLabMap, Set<Long> updateDepEmpIds, Map<Long, String> labBoIdMap, Map<String, List<DynamicObject>> contextAddLaborRelMap) {
        Iterator<DynamicObject> updateIterator = updateRecords.iterator();
        Set<Long> posCateGory = PersonParamsUtils.getPosCateGory();
        while (updateIterator.hasNext()) {
            DynamicObject next = updateIterator.next();
            String updateKey = this.getLaborRelKey(next);
            List<Object> otherSomeFiles = new ArrayList(10);
            List<DynamicObject> contextAddDys = contextAddLaborRelMap.get(updateKey);
            List<DynamicObject> dbFileDys = dbFileLaborRelMap.get(updateKey);
            if (!CollectionUtils.isEmpty(dbFileDys)) {
                otherSomeFiles = dbFileDys.stream().filter(dy -> posCateGory.contains(dy.getLong("depemp.postype.id")) && !updateDepEmpIds.contains(dy.getLong("depemp.id"))).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(contextAddDys) && CollectionUtils.isEmpty(otherSomeFiles)) continue;
            updateIterator.remove();
        }
        if (CollectionUtils.isEmpty(updateRecords)) {
            return;
        }
        DynamicObject chgActionDy = perChgBizInfoNew.getChgActionDy();
        String flowType = chgActionDy.getString("beforeflowtype");
        long[] recordIds = ORM.create().genLongIds("hrpi_laborrelrecord", updateRecords.size());
        for (int idx = 0; idx < updateRecords.size(); ++idx) {
            DynamicObject newHis = updateRecords.get(idx);
            newHis.set("id", (Object)recordIds[idx]);
            long boId = newHis.getLong("boid");
            DynamicObject targetDy = boIdLabMap.get(boId);
            String chgModel = labBoIdMap.get(boId);
            ChgRecordHelper.updIdsRecord("hrpi_laborrelrecord", targetDy, newHis, perChgBizInfoNew, chgModel, flowType);
        }
    }

    private void removeAddData(PerChgBizInfoNew perChgBizInfoNew, List<DynamicObject> newRecords, Map<String, List<DynamicObject>> contextLabKeyFileMap, Map<String, List<DynamicObject>> dbLaborRelMap, List<DynamicObject> depEmpDys, Map<String, List<DynamicObject>> contextUpdateLaborRelMap, Map<Long, List<DynamicObject>> contextFileMap) {
        Iterator<DynamicObject> addIterator = newRecords.iterator();
        while (addIterator.hasNext()) {
            DynamicObject next = addIterator.next();
            String addKey = this.getLaborRelKey(next);
            List<DynamicObject> contextUpdateDys = contextUpdateLaborRelMap.get(addKey);
            boolean dbExistLab = dbLaborRelMap.containsKey(addKey);
            if (CollectionUtils.isEmpty(contextUpdateDys) && !dbExistLab) continue;
            addIterator.remove();
        }
        if (CollectionUtils.isEmpty(newRecords)) {
            List addDepEmpDys = depEmpDys.stream().filter(dy -> dy.getLong("boid") == 0L).collect(Collectors.toList());
            for (DynamicObject dy2 : addDepEmpDys) {
                DynamicObject fileDy;
                String laborRelKey;
                List<DynamicObject> recordDys;
                long depEmpId = dy2.getLong("id");
                List<DynamicObject> dys = contextFileMap.get(depEmpId);
                long recordId = PersonParamsUtils.getBasicDataValue(dy2, "laborrelrecord");
                if (0L != recordId || CollectionUtils.isEmpty(dys) || CollectionUtils.isEmpty(recordDys = dbLaborRelMap.get(laborRelKey = this.getLaborRelKey(fileDy = dys.get(0))))) continue;
                DynamicObject recordDy = recordDys.get(0);
                dy2.set("laborrelrecord", (Object)recordDy.getLong("id"));
            }
            return;
        }
        long[] recordIds = ORM.create().genLongIds("hrpi_laborrelrecord", newRecords.size());
        for (int idx = 0; idx < newRecords.size(); ++idx) {
            DynamicObject newHis = newRecords.get(idx);
            long recordId = recordIds[idx];
            newHis.set("id", (Object)recordId);
            String laborRelKey = this.getLaborRelKey(newHis);
            List<DynamicObject> fileDys = contextLabKeyFileMap.get(laborRelKey);
            List depEmpIds = fileDys.stream().map(dy -> PersonParamsUtils.getBasicDataValue(dy, "depemp")).collect(Collectors.toList());
            for (DynamicObject depEmp : depEmpDys) {
                long depEmpId = depEmp.getLong("id");
                if (!depEmpIds.contains(depEmpId)) continue;
                depEmp.set("laborrelrecord", (Object)recordId);
            }
            perChgBizInfoNew.setEntityRecord("hrpi_laborrelrecord", ChgRecordEntryDto.formatNewRecord(recordId, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        }
    }

    private Function<DynamicObject, String> laborRelKey() {
        return this::getLaborRelKey;
    }

    private String getLaborRelKey(DynamicObject dy) {
        long employeeId = PersonParamsUtils.getBasicDataValue(dy, "employee");
        long orgId = PersonParamsUtils.getBasicDataValue(dy, "org");
        return employeeId + "-" + orgId;
    }

    private void addQuitFile(PerChgBizInfoNew perChgInfoNew, List<DepempBean> depemList, DynamicObjectType erfileType) {
        long chgEventId = ChgRecordHelper.getChgEventId(perChgInfoNew);
        if (chgEventId == 1070L) {
            EmpBean empBean = perChgInfoNew.getEmpList().get(0);
            Long empId = empBean.getaEmpId();
            QFilter filter = new QFilter("employee.id", "=", (Object)empId).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf()).and("empposrel.isprimary", "=", (Object)"1");
            DynamicObject erFile = RepositoryUtils.queryDynamicObject("hspm_ermanfile", "", filter);
            if (erFile != null) {
                DynamicObject newHis = (DynamicObject)erfileType.createInstance();
                long id = ORM.create().genLongId((IDataEntityType)erfileType);
                HRDynamicObjectUtils.copy((DynamicObject)erFile, (DynamicObject)newHis, ignoreKeys);
                newHis.set("id", (Object)id);
                PersonParamsUtils.wrapCommonField(newHis);
                newHis.set("startdate", (Object)perChgInfoNew.getEffectivedate());
                newHis.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
                newHis.set("businessstatus", (Object)"1");
                newHis.set("filetype", (Object)1050L);
                newHis.set("filetype_id", (Object)1050L);
                perChgInfoNew.setEntityRecord("hspm_ermanfile", ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
            }
        }
    }

    private void updateIdsRecord() {
        Map<Long, DynamicObject> unchgPerIdDy = PersonParamsUtils.queryModifyData(this.unChgPerMap.keySet(), "hrpi_person");
        Map<Long, DynamicObject> unchgEmpIdDy = PersonParamsUtils.queryModifyData(this.unChgEmpMap.keySet(), "hrpi_employee");
        Map<Long, DynamicObject> unchgDepIdDy = PersonParamsUtils.queryModifyData(this.unChgDepMap.keySet(), "hrpi_depemp");
        for (PerChgBizInfoNew perChgBizInfoNew : this.successData) {
            List<PersonBean> personList = perChgBizInfoNew.getPersonList();
            List<EmpBean> empList = perChgBizInfoNew.getEmpList();
            List<DepempBean> depList = perChgBizInfoNew.getDepempList();
            if (CollectionUtils.isEmpty(personList) || CollectionUtils.isEmpty(empList) || CollectionUtils.isEmpty(depList)) {
                LOG.error("==person emloyee dep is null==");
            }
            PersonBean personBean = personList.get(0);
            Long personId = personBean.getbPersonId();
            ChgRecordHelper.unChgIdRecord(perChgBizInfoNew, unchgPerIdDy.get(personId), "hrpi_person");
            EmpBean empBean = empList.get(0);
            Long empId = empBean.getbEmpId();
            ChgRecordHelper.unChgIdRecord(perChgBizInfoNew, unchgEmpIdDy.get(empId), "hrpi_employee");
            for (DepempBean depBean : depList) {
                String chgType = depBean.getbChgMethod();
                if (!ChgModeEnum.UNCHANGED.getChgMode().equals(chgType)) continue;
                Long depId = depBean.getbDepempId();
                DynamicObject depDy = unchgDepIdDy.get(depId);
                ChgRecordHelper.unChgIdRecord(perChgBizInfoNew, depDy, "hrpi_depemp");
            }
        }
    }

    private void buildPerChgMap() {
        HashSet labAndPosTypes = Sets.newHashSetWithExpectedSize((int)this.successData.size());
        for (PerChgBizInfoNew perChgBizInfoNew : this.successData) {
            this.buildPerMap(perChgBizInfoNew);
            this.buidEmpMap(perChgBizInfoNew);
            this.buildDepMap(perChgBizInfoNew);
            List<DepempBean> depList = perChgBizInfoNew.getDepempList();
            List<EmpBean> empList = perChgBizInfoNew.getEmpList();
            if (CollectionUtils.isEmpty(empList)) continue;
            EmpBean empBean = empList.get(empList.size() - 1);
            for (DepempBean depempBean : depList) {
                long posTypeId;
                String bChgType = depempBean.getbChgMethod();
                String aChgType = depempBean.getaChgMethod();
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(aChgType)) {
                    long posTypeId2;
                    Long labTypeId = this.getLabTypeId(empBean);
                    long l = posTypeId2 = depempBean.getaPostype() != null ? depempBean.getaPostype().getLong("id") : 0L;
                    if (this.buildFileNotMatchMsg(perChgBizInfoNew, labTypeId, posTypeId2)) continue;
                    labAndPosTypes.add(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId2)));
                }
                if (!ChgModeEnum.INVALID.getChgMode().equals(bChgType) && !ChgModeEnum.MODIFY.getChgMode().equals(bChgType)) continue;
                long labTypeId = empBean.getbLaborreltypeDy() != null ? empBean.getbLaborreltypeDy().getLong("id") : 0L;
                long l = posTypeId = depempBean.getbPostype() != null ? depempBean.getbPostype().getLong("id") : 0L;
                if (this.buildFileNotMatchMsg(perChgBizInfoNew, labTypeId, posTypeId)) continue;
                labAndPosTypes.add(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId)));
            }
            this.fileTypeMaps = HPFSNewChgHelper.getFileTypeByLabAndPosTypeList(labAndPosTypes);
        }
    }

    private boolean buildFileNotMatchMsg(PerChgBizInfoNew perChgBizInfoNew, Long labTypeId, long posTypeId) {
        if (labTypeId == 0L || posTypeId == 0L) {
            perChgBizInfoNew.setSuccess(false);
            if (labTypeId == 0L && posTypeId == 0L) {
                PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u4efb\u804c\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u8005\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b", (String)"PersonParamsBuilder_7", (String)"sdk-hr", (Object[])new Object[0]));
            } else if (labTypeId == 0L) {
                PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u4e0d\u5b58\u5728;", (String)"PersonParamsBuilder_12", (String)"sdk-hr", (Object[])new Object[0]));
            } else {
                PersonParamsUtils.buildErrMsg(perChgBizInfoNew, ResManager.loadKDString((String)"\u4efb\u804c\u7c7b\u578b\u4e0d\u5b58\u5728;", (String)"PersonParamsBuilder_13", (String)"sdk-hr", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    private Long getLabTypeId(EmpBean empBean) {
        DynamicObject lab = empBean.getaLaborreltypeDy() != null ? empBean.getaLaborreltypeDy() : empBean.getbLaborreltypeDy();
        return lab != null ? lab.getLong("id") : 0L;
    }

    private void buildPerMap(PerChgBizInfoNew perChgBizInfoNew) {
        List<PersonBean> personList = perChgBizInfoNew.getPersonList();
        for (PersonBean personBean : personList) {
            Long bPersonId;
            String achgType = personBean.getaChgMethod();
            String bchgType = personBean.getbChgMethod();
            if (ChgModeEnum.ADD_NEW.getChgMode().equals(achgType)) {
                Long aPersonId = personBean.getaPersonId();
                this.addNewPerMap.put(aPersonId, perChgBizInfoNew);
            }
            if (ChgModeEnum.INVALID.getChgMode().equals(bchgType)) {
                bPersonId = personBean.getbPersonId();
                this.invalidPerMap.put(bPersonId, perChgBizInfoNew);
            }
            if (ChgModeEnum.MODIFY.getChgMode().equals(bchgType)) {
                bPersonId = personBean.getbPersonId();
                this.modifyPerMap.put(bPersonId, perChgBizInfoNew);
            }
            if (!ChgModeEnum.UNCHANGED.getChgMode().equals(bchgType)) continue;
            bPersonId = personBean.getbPersonId();
            this.unChgPerMap.put(bPersonId, perChgBizInfoNew);
        }
    }

    private void buidEmpMap(PerChgBizInfoNew perChgBizInfoNew) {
        List<EmpBean> empList = perChgBizInfoNew.getEmpList();
        for (EmpBean empBean : empList) {
            String achgType = empBean.getaChgMethod();
            String bchgType = empBean.getbChgMethod();
            Long bEmpId = empBean.getbEmpId();
            Long aEmpId = empBean.getaEmpId();
            if (ChgModeEnum.ADD_NEW.getChgMode().equals(achgType)) {
                this.addNewEmpMap.put(aEmpId, perChgBizInfoNew);
            }
            if (ChgModeEnum.INVALID.getChgMode().equals(bchgType)) {
                this.invalidEmpMap.put(bEmpId, perChgBizInfoNew);
            }
            if (ChgModeEnum.MODIFY.getChgMode().equals(bchgType)) {
                this.modifyEmpMap.put(bEmpId, perChgBizInfoNew);
            }
            if (!ChgModeEnum.UNCHANGED.getChgMode().equals(bchgType)) continue;
            this.unChgEmpMap.put(bEmpId, perChgBizInfoNew);
        }
    }

    private void buildDepMap(PerChgBizInfoNew perChgBizInfoNew) {
        List<DepempBean> depList = perChgBizInfoNew.getDepempList();
        for (DepempBean depBeanBean : depList) {
            String aChgType = depBeanBean.getaChgMethod();
            String bChgType = depBeanBean.getbChgMethod();
            Long bDepId = depBeanBean.getbDepempId();
            Long aDepId = depBeanBean.getaDeempId();
            if (ChgModeEnum.ADD_NEW.getChgMode().equals(aChgType)) {
                this.addNewDepMap.put(aDepId, perChgBizInfoNew);
            }
            if (ChgModeEnum.INVALID.getChgMode().equals(bChgType)) {
                this.invalidDepMap.put(bDepId, perChgBizInfoNew);
            }
            if (ChgModeEnum.MODIFY.getChgMode().equals(bChgType)) {
                this.modifyDepMap.put(bDepId, perChgBizInfoNew);
            }
            if (!ChgModeEnum.UNCHANGED.getChgMode().equals(bChgType)) continue;
            this.unChgDepMap.put(bDepId, perChgBizInfoNew);
        }
    }

    public DynamicObject updErfile(PerChgBizInfoNew perChgInfoNew, DepempBean depBean, DynamicObject empposDy, DynamicObject targetDy, DynamicObjectType erfileType) {
        DynamicObject newHis = (DynamicObject)erfileType.createInstance();
        List<EmpBean> empList = perChgInfoNew.getEmpList();
        EmpBean empBean = empList.get(empList.size() - 1);
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        long id = ORM.create().genLongId((IDataEntityType)erfileType);
        newHis.set("id", (Object)id);
        newHis.set("org", (Object)depBean.getbOrg());
        newHis.set("affiliateadminorg", (Object)depBean.getbAffiliateadminorg());
        newHis.set("empgroup", (Object)depBean.getbEmpgroup());
        if (depBean.getbPostype() != null && empBean.getbLaborreltypeDy() != null) {
            Long posTypeId = depBean.getbPostype().getLong("id");
            Long labTypeId = empBean.getbLaborreltypeDy().getLong("id");
            List<Long> fileTypeIds = this.fileTypeMaps.get(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId)));
            this.showFileTypeError(perChgInfoNew, fileTypeIds);
            if (!CollectionUtils.isEmpty(fileTypeIds)) {
                newHis.set("filetype", (Object)fileTypeIds.get(0));
            }
        }
        if (Objects.isNull(newHis.get("filetype"))) {
            this.emptyErrorMsg(perChgInfoNew);
        }
        if ("1".equals(depBean.getbBusinessStatus())) {
            newHis.set("businessstatus", (Object)"1");
        } else {
            newHis.set("businessstatus", (Object)"-1");
        }
        PersonParamsUtils.wrapCommonField(newHis);
        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.ermanFileProps, empposDy, newHis);
        ChgRecordHelper.updIdsRecord("hspm_ermanfile", targetDy, newHis, perChgInfoNew, depBean.getbChgMethod());
        return newHis;
    }

    public DynamicObject updEmpposAll(PerChgBizInfoNew perChgInfoNew, DepempBean depBean, DynamicObject empposDy, DynamicObject targetDy, DynamicObjectType empposAllType) {
        DynamicObject newHis = (DynamicObject)empposAllType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        long id = ORM.create().genLongId((IDataEntityType)empposAllType);
        newHis.set("id", (Object)id);
        newHis.set("postype", depBean.getbPostype() != null ? depBean.getbPostype().get("name") : null);
        newHis.set("adminorg", depBean.getbAdminorg() != null ? depBean.getbAdminorg().get("name") : null);
        newHis.set("position", depBean.getbPosition() != null ? depBean.getbPosition().get("name") : null);
        newHis.set("stdposition", depBean.getbStdposition() != null ? depBean.getbStdposition().get("name") : null);
        newHis.set("job", depBean.getbJob() != null ? depBean.getbJob().get("name") : null);
        newHis.set("apositiontype", empposDy.get("apositiontype"));
        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.empExpAllProps, empposDy, newHis);
        PersonParamsUtils.wrapCommonField(newHis);
        ChgRecordHelper.updIdsRecord("hrpi_emporgrelall", targetDy, newHis, perChgInfoNew, depBean.getbChgMethod());
        return newHis;
    }

    public DynamicObject updEmppos(PerChgBizInfoNew perChgInfoNew, DepempBean depBean, DynamicObject targetDy, DynamicObjectType empposType, DynamicObject depDy) {
        DynamicObject newHis = (DynamicObject)empposType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        long id = ORM.create().genLongId((IDataEntityType)empposType);
        newHis.set("id", (Object)id);
        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.depToEmpposProps, depDy, newHis);
        HPFSNewChgHelper.setValue(newHis, "isprimary", depDy.get("isprimary"));
        newHis.set("id", (Object)id);
        DynamicObject chgActionDy = perChgInfoNew.getChgActionDy();
        newHis.set("posstatus", (Object)depBean.getbPosstatus());
        PersonParamsUtils.setPositionVal(newHis, depBean, true, false);
        long chgEventId = ChgRecordHelper.getChgEventId(perChgInfoNew);
        if (chgEventId == 1070L) {
            newHis.set("islatestrecord", (Object)"1");
        }
        PersonParamsUtils.wrapCommonField(newHis);
        String flowType = chgActionDy.getString("beforeflowtype");
        ChgRecordHelper.updIdsRecord("hrpi_empposorgrel", targetDy, newHis, perChgInfoNew, depBean.getbChgMethod(), flowType);
        return newHis;
    }

    public DynamicObject updDep(PerChgBizInfoNew perChgInfoNew, DepempBean depBean, DynamicObject targetDy, DynamicObjectType depType) {
        DynamicObject newHis = (DynamicObject)depType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        long id = ORM.create().genLongId((IDataEntityType)depType);
        newHis.set("id", (Object)id);
        newHis.set("bsed", (Object)depBean.getbBsed());
        newHis.set("bsled", (Object)depBean.getbBsled());
        newHis.set("sysenddate", (Object)depBean.getbSysEnddate());
        newHis.set("adminorg", (Object)depBean.getbAdminorg());
        newHis.set("startdate", (Object)depBean.getbStartdate());
        newHis.set("enddate", (Object)depBean.getbEnddate());
        newHis.set("postype", (Object)depBean.getbPostype());
        newHis.set("businessstatus", (Object)depBean.getbBusinessStatus());
        newHis.set("cmpemp", (Object)depBean.getbManagescope());
        PersonParamsUtils.setPositionVal(newHis, depBean, false, false);
        PersonParamsUtils.wrapCommonField(newHis);
        DynamicObject chgActionDy = perChgInfoNew.getChgActionDy();
        String flowType = chgActionDy.getString("beforeflowtype");
        ChgRecordHelper.updIdsRecord("hrpi_depemp", targetDy, newHis, perChgInfoNew, depBean.getbChgMethod(), flowType);
        return newHis;
    }

    public DynamicObject addErfile(PerChgBizInfoNew perChgInfoNew, DepempBean depempBean, DynamicObject empposDy, DynamicObjectType erfileType) {
        List<PersonBean> personList = perChgInfoNew.getPersonList();
        List<EmpBean> empList = perChgInfoNew.getEmpList();
        EmpBean empBean = empList.get(empList.size() - 1);
        String empNumber = empBean.getaEmpnumber();
        DynamicObject newHis = (DynamicObject)erfileType.createInstance();
        PersonParamsUtils.wrapSameFieldFromSourceForInit(newHis, empposDy);
        newHis.set("id", (Object)depempBean.getaErfileId());
        newHis.set("org", (Object)depempBean.getaOrg());
        newHis.set("affiliateadminorg", (Object)depempBean.getaAffiliateadminorg());
        newHis.set("empgroup", (Object)depempBean.getaEmpgroup());
        newHis.set("empposrel", (Object)empposDy);
        newHis.set("number", (Object)empNumber);
        newHis.set("person_id", (Object)personList.get(personList.size() - 1).getaPersonId());
        newHis.set("empentrel_id", (Object)empBean.getaEntId());
        newHis.set("name", (Object)personList.get(personList.size() - 1).getaName());
        newHis.set("pernontsprop", (Object)personList.get(personList.size() - 1).getaPernonId());
        newHis.set("businessstatus", (Object)"1");
        newHis.set("hbsscmpemp", empposDy.getDynamicObject("cmpemp") != null ? empposDy.get("cmpemp.managingscope") : Long.valueOf(0L));
        newHis.set("issystem", (Object)true);
        if (depempBean.getaPostype() != null) {
            Long posTypeId = depempBean.getaPostype().getLong("id");
            Long labTypeId = this.getLabTypeId(empBean);
            List<Long> fileTypeIds = this.fileTypeMaps.get(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId)));
            this.showFileTypeError(perChgInfoNew, fileTypeIds);
            if (!CollectionUtils.isEmpty(fileTypeIds)) {
                newHis.set("filetype", (Object)fileTypeIds.get(0));
            }
        }
        if (Objects.isNull(newHis.get("filetype"))) {
            this.emptyErrorMsg(perChgInfoNew);
        }
        PersonParamsUtils.wrapCommonField(newHis);
        perChgInfoNew.setEntityRecord("hspm_ermanfile", ChgRecordEntryDto.formatNewRecord(depempBean.getaErfileId(), ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        return newHis;
    }

    private void showFileTypeError(PerChgBizInfoNew perChgInfoNew, List<Long> fileTypeIds) {
        if (CollectionUtils.isEmpty(fileTypeIds)) {
            this.emptyErrorMsg(perChgInfoNew);
        } else if (fileTypeIds.size() > 1) {
            Object[] fileTypeDys = HPFSNewChgHelper.queryFileTypeByIds(fileTypeIds);
            StringBuilder sb = new StringBuilder();
            if (HRArrayUtils.isNotEmpty((Object[])fileTypeDys)) {
                for (int idx = 0; idx < fileTypeDys.length; ++idx) {
                    Object fileTypeDy = fileTypeDys[idx];
                    String name = fileTypeDy.getString("name");
                    sb.append(name);
                    if (idx == fileTypeDys.length - 1) continue;
                    sb.append("\u3001");
                }
            }
            PersonParamsUtils.buildFailMsg(perChgInfoNew, String.format(ResManager.loadKDString((String)"\u5339\u914d\u5230\u591a\u4e2a\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\uff1a%s\u3002\u8bf7\u524d\u5f80\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u8c03\u6574\u9002\u7528\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u3001\u9002\u7528\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u3001\u9002\u7528\u4efb\u804c\u7c7b\u578b", (String)"PersonParamsBuilder_11", (String)"sdk-hr", (Object[])new Object[0]), sb.toString()));
        }
    }

    private void emptyErrorMsg(PerChgBizInfoNew perChgInfoNew) {
        PersonParamsUtils.buildFailMsg(perChgInfoNew, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4efb\u4f55\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u3002\u8bf7\u524d\u5f80\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u7c7b\u578b\u8c03\u6574\u9002\u7528\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u3001\u9002\u7528\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u3001\u9002\u7528\u4efb\u804c\u7c7b\u578b", (String)"PersonParamsBuilder_10", (String)"sdk-hr", (Object[])new Object[0]));
    }

    public DynamicObject addEmpposAll(PerChgBizInfoNew perChgInfoNew, DepempBean depempBean, DynamicObject empposDy, DynamicObjectType empposAllType) {
        DynamicObject newHis = (DynamicObject)empposAllType.createInstance();
        long id = ORM.create().genLongId((IDataEntityType)empposAllType);
        newHis.set("id", (Object)id);
        depempBean.setaEmpposAllId(id);
        newHis.set("postype", depempBean.getaPostype() != null ? depempBean.getaPostype().get("name") : null);
        newHis.set("adminorg", depempBean.getaAdminorg() != null ? depempBean.getaAdminorg().get("name") : null);
        newHis.set("position", depempBean.getaPosition() != null ? depempBean.getaPosition().get("name") : null);
        newHis.set("stdposition", depempBean.getaStdposition() != null ? depempBean.getaStdposition().get("name") : null);
        newHis.set("variationtype", perChgInfoNew.getChgActionDy() != null ? perChgInfoNew.getChgActionDy().getLocaleString("name") : "");
        newHis.set("job", depempBean.getaJob() != null ? depempBean.getaJob().get("name") : null);
        newHis.set("isinsystem", empposDy.get("isinsystem"));
        newHis.set("apositiontype", empposDy.get("apositiontype"));
        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.empExpAllProps, empposDy, newHis);
        PersonParamsUtils.wrapCommonField(empposDy);
        perChgInfoNew.setEntityRecord("hrpi_emporgrelall", ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        return newHis;
    }

    public DynamicObject addEmppos(PerChgBizInfoNew perChgInfoNew, DepempBean depempBean, DynamicObjectType empposType, DynamicObject depDy) {
        DynamicObject newHis = (DynamicObject)empposType.createInstance();
        long id = ORM.create().genLongId((IDataEntityType)empposType);
        PersonParamsUtils.wrapPropsFromSourceToDy(HpfsChgNew.depToEmpposProps, depDy, newHis);
        HPFSNewChgHelper.setValue(newHis, "isprimary", depDy.get("isprimary"));
        newHis.set("id", (Object)id);
        depempBean.setaEmpposId(id);
        DynamicObject chgActionDy = perChgInfoNew.getChgActionDy();
        newHis.set("variationtype", (Object)ChgRecordHelper.getHbssActionType(chgActionDy));
        newHis.set("posstatus", (Object)depempBean.getaPosstatus());
        newHis.set("depemp", (Object)depempBean.getaDeempId());
        newHis.set("businessstatus", (Object)"1");
        PersonParamsUtils.setPositionVal(newHis, depempBean, true, true);
        PersonParamsUtils.wrapCommonField(newHis);
        String flowType = chgActionDy.getString("afterflowtype");
        perChgInfoNew.setEntityRecord("hrpi_empposorgrel", ChgRecordEntryDto.formatNewRecord(id, flowType, newHis));
        return newHis;
    }

    public DynamicObject addDep(PerChgBizInfoNew perChgInfoNew, DepempBean depempBean, DynamicObjectType depType, Map<Long, DynamicObject> modifyIdDepMap, Map<Long, DynamicObject> invidIdDepMap) {
        String aPositionType;
        List<PersonBean> personList = perChgInfoNew.getPersonList();
        List<EmpBean> empList = perChgInfoNew.getEmpList();
        DynamicObject busiDy = perChgInfoNew.getDy();
        DynamicObject newHis = (DynamicObject)depType.createInstance();
        newHis.set("person", (Object)personList.get(personList.size() - 1).getaPersonId());
        newHis.set("employee", (Object)empList.get(empList.size() - 1).getaEmpId());
        newHis.set("id", (Object)depempBean.getaDeempId());
        if (depempBean.getaManagescope() == null) {
            newHis.set("cmpemp", (Object)depempBean.getbManagescope());
        } else {
            newHis.set("cmpemp", (Object)depempBean.getaManagescope());
        }
        newHis.set("adminorg", (Object)depempBean.getaAdminorg());
        newHis.set("apositiontype", (Object)PersonParamsUtils.getPostType(depempBean, true));
        newHis.set("startdate", (Object)depempBean.getaStartdate());
        newHis.set("enddate", (Object)depempBean.getaEnddate());
        newHis.set("postype", (Object)depempBean.getaPostype());
        newHis.set("bsed", (Object)depempBean.getaBsed());
        newHis.set("bsled", (Object)depempBean.getaBsled());
        newHis.set("sysenddate", (Object)depempBean.getaSysEnddate());
        newHis.set("businessstatus", (Object)"1");
        String aIsPrimary = depempBean.getaIsPrimary();
        if (StringUtils.isNotBlank((CharSequence)aIsPrimary)) {
            newHis.set("isprimary", (Object)aIsPrimary);
        }
        if (StringUtils.isNotBlank((CharSequence)(aPositionType = depempBean.getaPositionType()))) {
            newHis.set("apositiontype", (Object)aPositionType);
        }
        PersonParamsUtils.setPositionVal(newHis, depempBean, false, true);
        PersonParamsUtils.wrapCommonField(newHis);
        DynamicObject chgActionDy = perChgInfoNew.getChgActionDy();
        String flowType = chgActionDy.getString("afterflowtype");
        perChgInfoNew.setEntityRecord("hrpi_depemp", ChgRecordEntryDto.formatNewRecord(depempBean.getaDeempId(), flowType, newHis));
        return newHis;
    }

    public DynamicObject addCmpEmp(PerChgBizInfoNew perChgInfoNew, DynamicObjectType cmpempType) {
        DynamicObject dy = (DynamicObject)cmpempType.createInstance();
        long id = ORM.create().genLongId((IDataEntityType)cmpempType);
        List<EmpBean> empList = perChgInfoNew.getEmpList();
        List<PersonBean> personList = perChgInfoNew.getPersonList();
        dy.set("id", (Object)id);
        dy.set("person", (Object)personList.get(personList.size() - 1).getaPernonId());
        dy.set("employee", (Object)empList.get(empList.size() - 1).getaEmpId());
        dy.set("businessstatus", (Object)"1");
        perChgInfoNew.setCmpempDy(dy);
        PersonParamsUtils.wrapCommonField(dy);
        return dy;
    }

    public DynamicObject updPerson(PerChgBizInfoNew perChgInfoNew, PersonBean personBean, DynamicObjectType personType, DynamicObject targetDy) {
        long id = ORM.create().genLongId((IDataEntityType)personType);
        DynamicObject newHis = (DynamicObject)personType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        newHis.set("id", (Object)id);
        newHis.set("number", (Object)personBean.getbNumber());
        PersonParamsUtils.wrapCommonField(newHis);
        ChgRecordHelper.updIdsRecord("hrpi_person", targetDy, newHis, perChgInfoNew, personBean.getbChgMethod());
        return newHis;
    }

    private DynamicObject updEnt(DynamicObject targetDy, PerChgBizInfoNew perNew, EmpBean empBean, DynamicObjectType entType, DynamicObject emp) {
        DynamicObject newHis = (DynamicObject)entType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        long id = ORM.create().genLongId((IDataEntityType)entType);
        newHis.set("id", (Object)id);
        newHis.set("enterprise", (Object)empBean.getbEnterpriseDy());
        newHis.set("startdate", (Object)empBean.getbStartdate());
        newHis.set("enddate", (Object)empBean.getbEnddate());
        newHis.set("laborrelstatus", (Object)empBean.getbLaborrelstatusDy());
        newHis.set("laborreltype", (Object)empBean.getbLaborreltypeDy());
        newHis.set("labrelstatusprd", empBean.getbLaborrelstatusDy().get("labrelstatusprd"));
        newHis.set("empnumber", (Object)empBean.getbEmpnumber());
        newHis.set("sysenddate", (Object)empBean.getbSysEnddate());
        newHis.set("bsed", (Object)empBean.getbBsed());
        newHis.set("bsled", (Object)empBean.getbBsled());
        String chgType = empBean.getbChgMethod();
        HPFSNewChgHelper.checkBusistatus(chgType, newHis);
        PersonParamsUtils.wrapCommonField(newHis);
        ChgRecordHelper.updIdsRecord("hrpi_empentrel", targetDy, newHis, perNew, empBean.getbChgMethod());
        return newHis;
    }

    private DynamicObject addEnt(PerChgBizInfoNew perNew, EmpBean empBean, DynamicObjectType entType, DynamicObject emp) {
        List<PersonBean> personList = perNew.getPersonList();
        PersonBean personBean = personList.get(personList.size() - 1);
        DynamicObject newHis = (DynamicObject)entType.createInstance();
        long id = ORM.create().genLongId((IDataEntityType)entType);
        newHis.set("id", (Object)id);
        empBean.setaEntId(id);
        newHis.set("enterprise", (Object)empBean.getaEnterpriseDy());
        newHis.set("startdate", (Object)empBean.getaStartdate());
        newHis.set("enddate", (Object)empBean.getaEnddate());
        newHis.set("laborrelstatus", (Object)empBean.getaLaborrelstatusDy());
        newHis.set("laborreltype", (Object)empBean.getaLaborreltypeDy());
        newHis.set("labrelstatusprd", empBean.getaLaborrelstatusDy().get("labrelstatusprd"));
        newHis.set("empnumber", (Object)empBean.getaEmpnumber());
        newHis.set("person_id", (Object)personBean.getaPersonId());
        newHis.set("employee_id", (Object)empBean.getaEmpId());
        newHis.set("businessstatus", (Object)"1");
        newHis.set("sysenddate", (Object)empBean.getaSysEnddate());
        newHis.set("bsed", (Object)empBean.getaBsed());
        newHis.set("bsled", (Object)empBean.getbBsled());
        perNew.setEntityRecord("hrpi_empentrel", ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        PersonParamsUtils.wrapCommonField(newHis);
        return newHis;
    }

    private DynamicObject updEmp(DynamicObject targetDy, PerChgBizInfoNew perNew, EmpBean empBean, DynamicObjectType empType) {
        long id = ORM.create().genLongId((IDataEntityType)empType);
        DynamicObject newHis = (DynamicObject)empType.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)targetDy, (DynamicObject)newHis);
        newHis.set("id", (Object)id);
        newHis.set("empnumber", (Object)empBean.getbEmpnumber());
        newHis.set("enterprise", (Object)empBean.getbEnterpriseDy());
        newHis.set("startdate", (Object)empBean.getbStartdate());
        newHis.set("enddate", (Object)empBean.getbEnddate());
        newHis.set("laborreltype", (Object)empBean.getbLaborreltypeDy());
        newHis.set("laborrelstatus", (Object)empBean.getbLaborrelstatusDy());
        newHis.set("sysenddate", (Object)empBean.getbSysEnddate());
        newHis.set("bsed", (Object)empBean.getbBsed());
        newHis.set("bsled", (Object)empBean.getbBsled());
        String chgType = empBean.getbChgMethod();
        HPFSNewChgHelper.checkBusistatus(chgType, newHis);
        PersonParamsUtils.wrapCommonField(newHis);
        ChgRecordHelper.updIdsRecord("hrpi_employee", targetDy, newHis, perNew, empBean.getbChgMethod());
        return newHis;
    }

    private DynamicObject addEmp(PerChgBizInfoNew perNew, EmpBean empBean, DynamicObjectType empType) {
        DynamicObject newHis = (DynamicObject)empType.createInstance();
        String aNumber = empBean.getaEmpnumber();
        List<PersonBean> personList = perNew.getPersonList();
        newHis.set("id", (Object)empBean.getaEmpId());
        newHis.set("empnumber", (Object)aNumber);
        newHis.set("person", (Object)personList.get(personList.size() - 1).getaPersonId());
        newHis.set("enterprise", (Object)empBean.getaEnterpriseDy());
        newHis.set("startdate", (Object)empBean.getaStartdate());
        newHis.set("enddate", (Object)empBean.getaEnddate());
        newHis.set("laborreltype", (Object)empBean.getaLaborreltypeDy());
        newHis.set("laborrelstatus", (Object)empBean.getaLaborrelstatusDy());
        newHis.set("businessstatus", (Object)"1");
        newHis.set("sysenddate", (Object)empBean.getaSysEnddate());
        newHis.set("bsed", (Object)empBean.getaBsed());
        newHis.set("bsled", (Object)empBean.getaBsled());
        perNew.setEntityRecord("hrpi_employee", ChgRecordEntryDto.formatNewRecord(empBean.getaEmpId(), ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        PersonParamsUtils.wrapCommonField(newHis);
        return newHis;
    }

    private DynamicObject addPerson(PerChgBizInfoNew perNew, PersonBean personBean, DynamicObjectType personType) {
        DynamicObject newHis = (DynamicObject)personType.createInstance();
        String aNumber = personBean.getaNumber();
        newHis.set("id", (Object)personBean.getaPersonId());
        newHis.set("number", (Object)aNumber);
        newHis.set("ishrcreate", (Object)1);
        PersonParamsUtils.wrapCommonField(newHis);
        perNew.setEntityRecord("hrpi_person", ChgRecordEntryDto.formatNewRecord(personBean.getaPersonId(), ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        return newHis;
    }

    private DynamicObject addPerNon(PerChgBizInfoNew perNew, DynamicObject personDy, PersonBean personBean, DynamicObjectType perNonType) {
        DynamicObject newHis = (DynamicObject)perNonType.createInstance();
        long id = ORM.create().genLongId((IDataEntityType)perNonType);
        PersonParamsUtils.wrapCommonField(newHis);
        newHis.set("person", (Object)personDy);
        newHis.set("id", (Object)id);
        personBean.setaPernonId(id);
        perNew.setEntityRecord("hrpi_pernontsprop", ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        return newHis;
    }

    private DynamicObject addPerTs(PerChgBizInfoNew perNew, DynamicObject personDy, PersonBean personBean, DynamicObjectType perTsType) {
        DynamicObject newHis = (DynamicObject)perTsType.createInstance();
        long id = ORM.create().genLongId((IDataEntityType)perTsType);
        PersonParamsUtils.wrapCommonField(newHis);
        newHis.set("person", (Object)personDy);
        newHis.set("id", (Object)id);
        newHis.set("bsed", (Object)new Date());
        personBean.setaPerTsId(id);
        perNew.setEntityRecord("hrpi_pertsprop", ChgRecordEntryDto.formatNewRecord(id, ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), newHis));
        return newHis;
    }

    public Map<String, Object> setChargePerson(List<DepEmpEntity> depEmpEntities) {
        Map<String, Object> retMap = new HashMap<String, Object>(4);
        try {
            List<Map<String, Object>> chargePersonParamList = this.buildChargePersonList(depEmpEntities);
            if (CollectionUtils.isEmpty(chargePersonParamList)) {
                retMap.put("code", 200);
                LOG.warn("synLeaderReturnEmpty");
                return retMap;
            }
            retMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePerson", (Object[])new Object[]{chargePersonParamList});
            LOG.info("synLeaderReturn-->{},resp-->{}", chargePersonParamList, retMap);
        }
        catch (Exception ex) {
            retMap.put("code", 500);
            LOG.error("setChargePersonError", (Throwable)ex);
        }
        return retMap;
    }

    public Map<String, Object> updateChargePerson(List<Map<String, Object>> chargePersonParamList) {
        Map<String, Object> retMap = new HashMap<String, Object>(4);
        for (Map<String, Object> chargePersonParamMap : chargePersonParamList) {
            chargePersonParamMap.put("operatetype", "2");
        }
        if (CollectionUtils.isEmpty(chargePersonParamList)) {
            retMap.put("code", 200);
            LOG.info("synLeaderReturnEmpty");
            return retMap;
        }
        retMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePerson", (Object[])new Object[]{chargePersonParamList});
        LOG.info("synLeaderReturn-->{},resp-->{}", chargePersonParamList, retMap);
        return retMap;
    }

    public Map<String, Object> discardChargePerson(List<DiscardChargePerson> discardChargePersonList) {
        Map<String, Object> retMap = new HashMap<String, Object>(4);
        try {
            List<Map<String, Object>> chargePersonParamList = this.buildDiscardChargePersonList(discardChargePersonList);
            if (CollectionUtils.isEmpty(chargePersonParamList)) {
                retMap.put("code", 200);
                LOG.warn("discardChargePerson.chargePersonParamList is empty.");
                return retMap;
            }
            retMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePerson", (Object[])new Object[]{chargePersonParamList});
            LOG.info("discardChargePerson-->{},resp-->{}", chargePersonParamList, retMap);
        }
        catch (Exception ex) {
            retMap.put("code", 500);
            LOG.error("setChargePersonError", (Throwable)ex);
        }
        return retMap;
    }

    public void setChargePersonByPerChgNew(PerChgBizInfoNew perChgBizInfoNew) {
        DepEmpEntity depEmpEntity;
        DynamicObjectCollection aEntryADepemps;
        DynamicObjectCollection bEntryBDepemps;
        DynamicObject bill = perChgBizInfoNew.getDy();
        long aDepempId = bill.getLong("ba_d_tid");
        long bDepempId = bill.getLong("bb_d_tid");
        String aChgType = bill.getString("ba_d_chgtype");
        String bChgType = bill.getString("bb_d_chgtype");
        ArrayList<DepEmpEntity> bDepEmpEntities = new ArrayList<DepEmpEntity>();
        ArrayList<DepEmpEntity> aDepEmpEntities = new ArrayList<DepEmpEntity>();
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"entry_b_depemp") && (bEntryBDepemps = (DynamicObjectCollection)bill.get("entry_b_depemp")) != null) {
            String entityName = bill.getDataEntityType().getName();
            if ("ham_dispback".equals(entityName)) {
                ChgRecordEntryDto chgRecordEntry = perChgBizInfoNew.getEntityRecord().get("hrpi_depemp").stream().filter(chgRecordEntryDto -> ChgModeEnum.INVALID.getChgMode().equals(chgRecordEntryDto.getChgMode())).findFirst().get();
                DepEmpEntity depEmpEntity2 = new DepEmpEntity(null, null, chgRecordEntry.getDataDy().getLong("boid"), chgRecordEntry.getChgMode());
                bDepEmpEntities.add(depEmpEntity2);
            } else {
                bEntryBDepemps.forEach(entryBDepemp -> {
                    DepEmpEntity depEmpEntity = new DepEmpEntity(null, null, entryBDepemp.getLong("b_d_tid"), entryBDepemp.getString("b_d_chgtype"));
                    bDepEmpEntities.add(depEmpEntity);
                });
            }
        }
        if (properties.containsKey((Object)"entry_a_depemp") && (aEntryADepemps = (DynamicObjectCollection)bill.get("entry_a_depemp")) != null) {
            aEntryADepemps.forEach(entryADepemp -> {
                DepEmpEntity depEmpEntity = new DepEmpEntity(entryADepemp.getLong("a_d_tid"), entryADepemp.getString("a_d_chgtype"), null, null);
                aDepEmpEntities.add(depEmpEntity);
            });
        }
        if (bDepEmpEntities.size() == 0) {
            depEmpEntity = new DepEmpEntity(null, null, bDepempId, bChgType);
            bDepEmpEntities.add(depEmpEntity);
        }
        if (aDepEmpEntities.size() == 0) {
            depEmpEntity = new DepEmpEntity(aDepempId, aChgType, null, null);
            aDepEmpEntities.add(depEmpEntity);
        }
        bDepEmpEntities.addAll(aDepEmpEntities);
        List<Map<String, Object>> list = this.buildChargePersonList(bDepEmpEntities);
        LOG.info("IHRPIChargeService#setChargePerson param: {}", (Object)list.size());
        if (HRCollUtil.isNotEmpty(list)) {
            HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePerson", (Object[])new Object[]{list});
        }
    }

    public void updateDepEmpIdByPerChgNew(PerChgBizInfoNew perChgBizInfoNew, Long chargeId) {
        DynamicObject bill = perChgBizInfoNew.getDy();
        if (Objects.isNull(bill)) {
            return;
        }
        Long aDepempId = null;
        ArrayList chargePersonParamList = Lists.newArrayListWithExpectedSize((int)1);
        DynamicObjectCollection aEntryADepemps = (DynamicObjectCollection)bill.get("entry_a_depemp");
        if (aEntryADepemps != null && aEntryADepemps.size() > 0) {
            DynamicObject entryADepemp = (DynamicObject)aEntryADepemps.get(0);
            aDepempId = entryADepemp.getLong("a_d_tid");
            HashMap chargeMap = Maps.newHashMapWithExpectedSize((int)3);
            chargeMap.put("id", chargeId);
            chargeMap.put("chargeperson", aDepempId);
            chargePersonParamList.add(chargeMap);
            LOG.info("PersonParamsBuilder#updateDepEmpIdByPerChgNew.chargePersonParamList={}", (Object)chargePersonParamList);
        }
        this.updateChargePerson(chargePersonParamList);
    }

    public List<Map<String, Object>> buildChargePersonList(List<DepEmpEntity> depEmpEntities) {
        LOG.info("synLeaderParam-->{}", depEmpEntities);
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(10);
        Set aDepEmpIds = depEmpEntities.stream().map(DepEmpEntity::getaDepempId).collect(Collectors.toSet());
        Set bDepEmpIds = depEmpEntities.stream().map(DepEmpEntity::getbDepempId).collect(Collectors.toSet());
        HashSet<Long> allIds = new HashSet<Long>(16);
        allIds.addAll(bDepEmpIds);
        allIds.addAll(aDepEmpIds);
        Map<Long, DynamicObject> empposDyMap = PersonParamsUtils.queryModifyDataSetKey(allIds, "hrpi_empposorgrel", "depemp.id");
        ArrayList<DynamicObject> empDys = new ArrayList<DynamicObject>(empposDyMap.values());
        List postIds = empDys.stream().map(dy -> dy.getLong("position.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", postIds);
        DynamicObject[] postDys = RepositoryUtils.queryDynamicObjects("hbpm_positionhr", "isleader,id,name,number,adminorg", qFilter);
        Map<Long, DynamicObject> postMap = Arrays.stream(postDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        for (DepEmpEntity depEmpEntity : depEmpEntities) {
            String aChgMode = depEmpEntity.getaChgMode();
            if (ChgModeEnum.ADD_NEW.getChgMode().equals(aChgMode)) {
                Long aDepId = depEmpEntity.getaDepempId();
                this.buildChargePerson(retList, empposDyMap, postMap, aDepId, "1");
            }
            String bChgMode = depEmpEntity.getbChgMode();
            if (!ChgModeEnum.INVALID.getChgMode().equals(bChgMode)) continue;
            Long bDepId = depEmpEntity.getbDepempId();
            this.buildChargePerson(retList, empposDyMap, postMap, bDepId, "0");
        }
        return retList;
    }

    private void buildChargePerson(List<Map<String, Object>> retList, Map<Long, DynamicObject> empposDyMap, Map<Long, DynamicObject> postMap, Long aDepId, String chgModel) {
        if (aDepId == null || aDepId == 0L) {
            return;
        }
        DynamicObject empPosDy = empposDyMap.get(aDepId);
        if (empPosDy == null) {
            return;
        }
        long postId = empPosDy.getLong("position.id");
        DynamicObject postDy = postMap.get(postId);
        if (postDy != null && "1".equals(postDy.getString("isleader"))) {
            String operateType = HRStringUtils.equals((String)"1", (String)chgModel) ? "0" : "1";
            Date effDt = HRStringUtils.equals((String)"1", (String)chgModel) ? empPosDy.getDate("startdate") : empPosDy.getDate("enddate");
            Date leffDt = empPosDy.getDate("enddate");
            HashMap<String, Object> chargePersonParam = new HashMap<String, Object>();
            chargePersonParam.put("operatetype", operateType);
            chargePersonParam.put("person", empPosDy.getLong("person_id"));
            chargePersonParam.put("depemp", empPosDy.getLong("depemp_id"));
            chargePersonParam.put("adminorg", empPosDy.getLong("adminorg_id"));
            chargePersonParam.put("effdt", effDt);
            chargePersonParam.put("leffdt", leffDt);
            chargePersonParam.put("changesource", 1030L);
            chargePersonParam.put("isSynChargeToUser", false);
            retList.add(chargePersonParam);
        }
    }

    public List<Map<String, Object>> buildDiscardChargePersonList(List<DiscardChargePerson> discardChargePersonList) {
        ArrayList chargePersonList = Lists.newArrayListWithExpectedSize((int)discardChargePersonList.size());
        for (DiscardChargePerson discardChargePerson : discardChargePersonList) {
            HashMap chargePersonMap = Maps.newHashMapWithExpectedSize((int)4);
            Long depEmpId = discardChargePerson.getDepEmpId();
            Long adminOrgId = discardChargePerson.getAdminOrgId();
            Boolean isExcludeManual = discardChargePerson.isExcludeManual();
            chargePersonMap.put("depemp", depEmpId);
            chargePersonMap.put("adminorg", adminOrgId);
            chargePersonMap.put("isexcludemanual", isExcludeManual);
            chargePersonMap.put("operatetype", "3");
            chargePersonMap.put("changesource", 1050L);
            chargePersonList.add(chargePersonMap);
        }
        return chargePersonList;
    }

    static {
        ignoreKeys.add("id");
        ignoreKeys.add("boid");
        ignoreKeys.add("iscurrentversion");
        ignoreKeys.add("datastatus");
        ignoreKeys.add("ismodify");
        ignoreKeys.add("sourcevid");
        ignoreKeys.add("firstbsed");
        ignoreKeys.add("changebsed");
        ignoreKeys.add("bred");
        ignoreKeys.add("brled");
        ignoreKeys.add("brfd");
        ignoreKeys.add("filetype");
        ignoreKeys.add("dependencytype");
        ignoreKeys.add("dependency");
        ignoreKeys.add("empgroup");
        ignoreKeys.add("startdate");
        ignoreKeys.add("enddate");
        ignoreKeys.add("businessstatus");
    }
}

