/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageCallBackType;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.ProgressBarAp;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkService;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.DynamicObjectScale;
import kd.sdk.hr.hspm.common.utils.InfoGroupApprovalUtil;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

@SdkService(name="\u5ba1\u6279\u5e2e\u52a9\u7c7b")
public class ApprovalHelper {
    private static final Log LOGGER = LogFactory.getLog(ApprovalHelper.class);
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    private static final HRBaseServiceHelper DEPEMP_HELPER = new HRBaseServiceHelper("hrpi_depemp");
    public static final String KEY_APPROVAL_SUMBIT_CALLBACK = "ApprovalSubmitCallBack";
    public static final String KEY_HOMEPAGE_CLOSE_CALLBACK = "HomePageCloseCallBack";
    public static final String PERM_SUBMIT_ID = "3+IV9XQ9HIYA";

    public static void viewChangeRecord(IFormView view) {
        MobileFormShowParameter showParameter;
        String ispreview = view.getPageCache().get("ispreview");
        if (HRStringUtils.isNotEmpty((String)ispreview)) {
            return;
        }
        LOGGER.info("viewAuditRecord");
        boolean isOldHss = "hss_businessoffice".equals(view.getFormShowParameter().getParentFormId());
        if (!isOldHss && !CommonUtil.hasPerm("hspm_changerecord", "47150e89000000ac", "hssc", view)) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        if (ApprovalHelper.isMobile(view)) {
            showParameter = new MobileFormShowParameter();
            showParameter.setFormId("hspm_changerecordmob");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            showParameter = new FormShowParameter();
            showParameter.setFormId("hspm_changerecord");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Long personId = Long.valueOf(view.getPageCache().get("personId"));
            showParameter.setPageId(view.getPageId() + "hspm_changerecord" + personId);
        }
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void viewAuditRecord(IFormView view) {
        MobileListShowParameter showParameter;
        String ispreview = view.getPageCache().get("ispreview");
        if (HRStringUtils.isNotEmpty((String)ispreview)) {
            return;
        }
        LOGGER.info("viewAuditRecord");
        boolean isOldHss = "hss_businessoffice".equals(view.getFormShowParameter().getParentFormId());
        if (!isOldHss && !CommonUtil.hasPerm("hspm_infoapproval", "47150e89000000ac", "hssc", view)) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        Long personId = Long.valueOf(view.getPageCache().get("personId"));
        if (ApprovalHelper.isMobile(view)) {
            showParameter = new MobileListShowParameter();
            showParameter.setFormId("bos_moblist");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            showParameter = new ListShowParameter();
            showParameter.setFormId("bos_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPageId(view.getPageId() + "viewAuditRecord" + personId);
        }
        showParameter.setHasRight(true);
        showParameter.setBillFormId("hspm_infoapproval");
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("person", "=", (Object)personId));
        showParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)showParameter);
    }

    private static boolean isMobile(IFormView view) {
        return view instanceof MobileFormView;
    }

    public static Map<String, List<Map<String, Object>>> getAuditFieldMap(IFormView view) {
        HashMap<String, List<Map<String, Object>>> updateFieldMap = new HashMap<String, List<Map<String, Object>>>();
        Map allCache = view.getPageCache().getAll();
        for (Map.Entry entry : allCache.entrySet()) {
            String key = (String)entry.getKey();
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            String cacheValue = (String)entry.getValue();
            List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            updateFieldMap.put(key.replace("-entrycache", ""), groupFields);
        }
        return updateFieldMap;
    }

    public static boolean existAuditInfo(IFormView view) {
        Map<String, List<Map<String, Object>>> auditMap = ApprovalHelper.getAuditFieldMap(view);
        ApprovalHelper.compareAndRemoveNoChangeEntry(auditMap, view);
        if (auditMap.size() == 0) {
            return false;
        }
        String personIdStr = view.getPageCache().get("personId");
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(Long.parseLong(personIdStr));
        if (bill == null) {
            return !ApprovalHelper.removeOldVersonData(view);
        }
        if (!"G".equals(bill.getString("billstatus"))) {
            return false;
        }
        return ApprovalHelper.isChange(bill, auditMap);
    }

    private static boolean isChange(DynamicObject bill, Map<String, List<Map<String, Object>>> auditMap) {
        DynamicObjectCollection dynamicObjects = bill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            LOGGER.info(MessageFormat.format("compare_auditMap:{0}", auditMap));
            HashMap<String, List> auditDbMap = new HashMap<String, List>(dynamicObjects.size());
            for (DynamicObject dynamicObject : dynamicObjects) {
                String firstGroup = "0000".equals(dynamicObject.getString("firstgroupnum")) ? "0000" : dynamicObject.getString("firstgroup");
                List list = auditDbMap.computeIfAbsent(firstGroup, val -> new ArrayList());
                list.add(dynamicObject);
            }
            if (auditMap.size() != auditDbMap.size()) {
                return true;
            }
            for (Map.Entry entry : auditDbMap.entrySet()) {
                List<Map<String, Object>> mapList = auditMap.get(entry.getKey());
                if (mapList == null) {
                    return true;
                }
                List dbList = (List)entry.getValue();
                LOGGER.info(MessageFormat.format("mapList:{0}, dbList:{1}", mapList, dbList));
                if (mapList.size() != dbList.size()) {
                    return true;
                }
                Set set = dbList.stream().map(val -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append(val.getString("entityname"));
                    sb.append(val.getString("fieldname"));
                    sb.append(val.getLong("dataid"));
                    sb.append(val.getString("newvalue"));
                    return sb.toString();
                }).collect(Collectors.toSet());
                for (Map<String, Object> map : mapList) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(map.get("entityName"));
                    sb.append(map.get("fieldname"));
                    sb.append(map.get("dataid"));
                    Object newValue = map.get("newvalue");
                    if (newValue != null) {
                        sb.append(newValue.toString());
                    }
                    if (set.contains(sb.toString())) continue;
                    LOGGER.info(MessageFormat.format("change--set:{0}, sb:{1}", set, sb));
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean removeOldVersonData(IFormView view) {
        String billId = view.getPageCache().get("submitVerson");
        if (HRStringUtils.isNotEmpty((String)billId)) {
            DynamicObject bill = INFOAPPROVAL_HELPER.queryOne("billstatus", (Object)Long.parseLong(billId));
            Boolean flag = "C".equals(bill.getString("billstatus")) || "F".equals(bill.getString("billstatus"));
            if (!HRObjectUtils.isEmpty((Object)bill) && flag.booleanValue()) {
                ApprovalHelper.removeFieldCache(view);
                return true;
            }
        }
        return false;
    }

    public static void submitConfirm(IFormView view, IFormPlugin formPlugin) {
        if (!CommonUtil.hasPerm(view.getEntityId(), PERM_SUBMIT_ID, "hssc", view)) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        Map<String, List<Map<String, Object>>> updateFieldMap = ApprovalHelper.getAuditFieldMap(view);
        ApprovalHelper.compareAndRemoveNoChangeEntry(updateFieldMap, view);
        if (updateFieldMap.size() == 0) {
            view.showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_1", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        String configJson = view.getPageCache().get("cnfjson");
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
        List mainentry = (List)infoGroupConfig.get("mainentry");
        String personIdStr = view.getPageCache().get("personId");
        Long personId = Long.parseLong(personIdStr);
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
        if (bill != null) {
            if ("B".equals(bill.getString("billstatus")) || "D".equals(bill.getString("billstatus"))) {
                view.showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5ba1\u6279\u5355\u636e\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ApprovalHelper_5", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection backUpEntity = ApprovalHelper.backUpEntity(entity);
            entity.clear();
            ApprovalHelper.handleHeadAudit(entity, updateFieldMap, infoGroupConfig);
            for (Map entry : mainentry) {
                String gName = (String)entry.get("groupname");
                List<Map<String, Object>> groupFields = updateFieldMap.get(gName);
                if (CollectionUtils.isEmpty(groupFields)) continue;
                List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(entry);
                ApprovalHelper.addDataToEntity(gName, Boolean.FALSE, groups, groupFields, entity);
                ApprovalHelper.addDataToEntity(gName, Boolean.TRUE, groups, groupFields, entity);
            }
            if (entity.size() == 0) {
                LOGGER.error("entity is null");
                view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_0", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            if (backUpEntity != null && !ApprovalHelper.check(view, entity, backUpEntity)) {
                return;
            }
        } else if (ApprovalHelper.existConflict(view)) {
            return;
        }
        ApprovalHelper.handleTip(view, formPlugin, updateFieldMap, infoGroupConfig);
    }

    private static void compareAndRemoveNoChangeEntry(Map<String, List<Map<String, Object>>> updateFieldMap, IFormView view) {
        Set<Map.Entry<String, List<Map<String, Object>>>> entries = updateFieldMap.entrySet();
        Iterator<Map.Entry<String, List<Map<String, Object>>>> iterator = entries.iterator();
        boolean isCacheChange = false;
        while (iterator.hasNext()) {
            Map.Entry<String, List<Map<String, Object>>> entry = iterator.next();
            List<Map<String, Object>> fieldValueList = entry.getValue();
            if (fieldValueList == null || fieldValueList.size() == 0) {
                iterator.remove();
                ApprovalHelper.updateSyncCacheToDataBase(view);
                continue;
            }
            boolean isSingleRowTpl = InfoGroupHelper.isSingleRowTpl(String.valueOf(fieldValueList.get(0).get("entityName")));
            Boolean isRemove = Boolean.TRUE;
            Iterator<Map<String, Object>> fieldValueListIterator = fieldValueList.iterator();
            while (fieldValueListIterator.hasNext()) {
                Map<String, Object> fieldValueMap = fieldValueListIterator.next();
                Boolean isNew = Objects.nonNull(fieldValueMap.get("isnew")) ? Boolean.valueOf(String.valueOf(fieldValueMap.get("isnew"))) : Boolean.FALSE;
                Boolean isDel = Objects.nonNull(fieldValueMap.get("isdel")) ? Boolean.valueOf(String.valueOf(fieldValueMap.get("isdel"))) : Boolean.FALSE;
                String fieldType = String.valueOf(fieldValueMap.get("fieldtype"));
                if (HRStringUtils.isEmpty((String)fieldType)) continue;
                Object newValue = ApprovalHelper.replaceNullValue(fieldType, fieldValueMap.get("newvalue"));
                Object oldValue = ApprovalHelper.replaceNullValue(fieldType, fieldValueMap.get("oldvalue"));
                if (isDel.booleanValue() || isNew.booleanValue() || new DynamicObjectScale(newValue, oldValue).balance() != 0) {
                    isRemove = Boolean.FALSE;
                    continue;
                }
                if (!isSingleRowTpl) continue;
                fieldValueListIterator.remove();
                PageCacheUtils.getHomePageCache(view).put(entry.getKey() + "-entrycache", SerializationUtils.toJsonString(fieldValueList));
                isCacheChange = true;
            }
            if (!isRemove.booleanValue()) continue;
            iterator.remove();
            PageCacheUtils.getHomePageCache(view).remove(entry.getKey() + "-entrycache");
            isCacheChange = true;
        }
        if (isCacheChange) {
            ApprovalHelper.updateSyncCacheToDataBase(view);
        }
    }

    private static Boolean fieldIsChange(Map<String, Object> fieldValueMap) {
        Boolean isNew = Objects.nonNull(fieldValueMap.get("isnew")) ? Boolean.valueOf(String.valueOf(fieldValueMap.get("isnew"))) : Boolean.FALSE;
        String fieldType = String.valueOf(fieldValueMap.get("fieldtype"));
        if (HRStringUtils.isEmpty((String)fieldType)) {
            return Boolean.FALSE;
        }
        Object newValue = ApprovalHelper.replaceNullValue(fieldType, fieldValueMap.get("newvalue"));
        Object oldValue = ApprovalHelper.replaceNullValue(fieldType, fieldValueMap.get("oldvalue"));
        if (!isNew.booleanValue() && new DynamicObjectScale(newValue, oldValue).balance() != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object replaceNullValue(String fieldType, Object value) {
        if (HRStringUtils.equals((String)fieldType, (String)"MuliLangTextProp") || HRStringUtils.equals((String)fieldType, (String)"TextProp")) {
            if (value == null || HRStringUtils.isEmpty((String)String.valueOf(value).trim())) {
                return "";
            }
        } else if (HRStringUtils.equals((String)fieldType, (String)"BasedataProp") && value == null) {
            return 0;
        }
        return value;
    }

    private static void handleTip(IFormView view, IFormPlugin formPlugin, Map<String, List<Map<String, Object>>> updateFieldMap, Map<String, Object> infoGroupConfig) {
        ConfirmCallBackListener confirm = new ConfirmCallBackListener(KEY_APPROVAL_SUMBIT_CALLBACK, formPlugin);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u9700\u5ba1\u6838\u4fe1\u606f\u7ec4\uff1a", (String)"ApprovalHelper_8", (String)"sdk-hr", (Object[])new Object[0]));
        boolean firstGroup = false;
        List<Map<String, Object>> headFields = updateFieldMap.get("0000");
        if (!CollectionUtils.isEmpty(headFields)) {
            firstGroup = true;
            sb.append(ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"ApprovalHelper_9", (String)"sdk-hr", (Object[])new Object[0]));
        }
        List mainentry = (List)infoGroupConfig.get("mainentry");
        for (Map entry : mainentry) {
            String gName = (String)entry.get("groupname");
            List<Map<String, Object>> groupFields = updateFieldMap.get(gName);
            if (CollectionUtils.isEmpty(groupFields)) continue;
            if (!firstGroup) {
                firstGroup = true;
                sb.append(gName);
                continue;
            }
            sb.append("\u3001").append(gName);
        }
        view.showConfirm(sb.toString(), MessageBoxOptions.OKCancel, confirm);
    }

    public static void submit(IFormView view) {
        DynamicObjectCollection entity;
        if (!ApprovalHelper.isMobile(view) && !CommonUtil.hasPerm(view.getEntityId(), PERM_SUBMIT_ID, "hssc", view)) {
            view.showErrorNotification(HRBaseUtils.getNoPermMsg());
            return;
        }
        String personIdStr = view.getPageCache().get("personId");
        Long personId = Long.parseLong(personIdStr);
        LOGGER.info(MessageFormat.format("ApprovalHelper#submit:{0}", personId));
        DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile(personId);
        String configJson = view.getPageCache().get("cnfjson");
        if (HRObjectUtils.isEmpty((Object)erFileDy) || HRStringUtils.isEmpty((String)configJson)) {
            LOGGER.error("data_exception_person:{0},configJson:{1}", (Object)personId, (Object)configJson);
            view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"ApprovalHelper_2", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        Map allCache = view.getPageCache().getAll();
        HashMap<String, List<Map<String, Object>>> updateFieldMap = new HashMap<String, List<Map<String, Object>>>(allCache.size());
        for (Map.Entry entry : allCache.entrySet()) {
            String key = (String)entry.getKey();
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            String cacheValue = (String)entry.getValue();
            List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            updateFieldMap.put(key.replace("-entrycache", ""), groupFields);
        }
        ApprovalHelper.compareAndRemoveNoChangeEntry(updateFieldMap, view);
        if (updateFieldMap.size() == 0) {
            view.showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_1", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        Map infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
        OperationServiceImpl operationService = new OperationServiceImpl();
        DynamicObjectCollection backUpEntity = null;
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
        LOGGER.info(MessageFormat.format("personid:{0}, bill:{1} ", personId, bill == null ? null : bill.get("billno")));
        if (bill == null) {
            DynamicObject depempDy;
            if (ApprovalHelper.existConflict(view)) {
                return;
            }
            bill = INFOAPPROVAL_HELPER.generateEmptyDynamicObject();
            bill.set("person", (Object)personId);
            bill.set("employee", (Object)erFileDy.getLong("employee.id"));
            bill.set("cmpemp", (Object)erFileDy.getLong("cmpemp.id"));
            bill.set("billstatus", (Object)"B");
            bill.set("auditstatus", (Object)"B");
            bill.set("creator", (Object)RequestContext.get().getCurrUserId());
            bill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            bill.set("org", erFileDy.get("org"));
            bill.set("affiliateadminorg", erFileDy.get("affiliateadminorg"));
            long depId = erFileDy.getLong("depemp.id");
            if (depId > 0L && (depempDy = DEPEMP_HELPER.queryOne("adminorg", (Object)depId)) != null) {
                bill.set("adminorg", depempDy.get("adminorg"));
            }
            entity = bill.getDynamicObjectCollection("entryentity");
        } else {
            if ("B".equals(bill.getString("billstatus")) || "D".equals(bill.getString("billstatus"))) {
                view.showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5ba1\u6279\u5355\u636e\uff0c\u6682\u65f6\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ApprovalHelper_5", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
                return;
            }
            entity = bill.getDynamicObjectCollection("entryentity");
            backUpEntity = ApprovalHelper.backUpEntity(entity);
            entity.clear();
        }
        ApprovalHelper.handleHeadAudit(entity, updateFieldMap, infoGroupConfig);
        List mainentry = (List)infoGroupConfig.get("mainentry");
        for (Map entry : mainentry) {
            String gName = (String)entry.get("groupname");
            List groupFields = (List)updateFieldMap.get(gName);
            if (CollectionUtils.isEmpty((Collection)groupFields)) continue;
            List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(entry);
            ApprovalHelper.addDataToEntity(gName, Boolean.FALSE, groups, groupFields, entity);
            ApprovalHelper.addDataToEntity(gName, Boolean.TRUE, groups, groupFields, entity);
        }
        if (entity.size() == 0) {
            LOGGER.error("entity is null");
            view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_0", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        if (backUpEntity != null && !ApprovalHelper.check(view, entity, backUpEntity)) {
            return;
        }
        OperationResult result = operationService.localInvokeOperation("submit", new DynamicObject[]{bill}, OperateOption.create());
        if (ApprovalHelper.handleSubmitResult(view, result)) {
            if (ApprovalHelper.isMobile(view)) {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("hspm_approvalsuccess");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                showParameter.setCustomParam("person", (Object)personId);
                view.showForm((FormShowParameter)showParameter);
                view.getPageCache().put("submitVerson", bill.getString("id"));
            } else {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ApprovalHelper_4", (String)"sdk-hr", (Object[])new Object[0]));
                view.updateView();
            }
        }
    }

    private static void handleHeadAudit(DynamicObjectCollection entity, Map<String, List<Map<String, Object>>> updateFieldMap, Map<String, Object> infoGroupConfig) {
        Optional<Map> headOpt;
        List<Map<String, Object>> headFields = updateFieldMap.get("0000");
        List headConfig = (List)infoGroupConfig.get("headentity");
        if (!CollectionUtils.isEmpty(headFields) && !CollectionUtils.isEmpty((Collection)headConfig) && (headOpt = headConfig.stream().filter(val -> "headsculpture".equals(val.get("number"))).findAny()).isPresent()) {
            Map<String, Object> updateField = headFields.get(0);
            DynamicObject newDy = entity.addNew();
            newDy.set("entityname", updateField.get("entityName"));
            newDy.set("fieldname", updateField.get("fieldname"));
            newDy.set("displayname", headOpt.get().get("name"));
            newDy.set("fieldtype", (Object)FieldTypeEnum.PICTURE.getType());
            newDy.set("isnew", updateField.get("isnew"));
            newDy.set("oldvalue", updateField.get("oldvalue"));
            newDy.set("newvalue", updateField.get("newvalue"));
            newDy.set("dataid", updateField.get("dataid"));
            newDy.set("reason", updateField.get("reason"));
            newDy.set("firstgroupnum", updateField.get("groupnumber"));
            newDy.set("firstgroup", (Object)ResManager.loadKDString((String)"\u6863\u6848\u5934\u90e8", (String)"ApprovalHelper_7", (String)"sdk-hr", (Object[])new Object[0]));
            newDy.set("secondgroup", (Object)" ");
        }
    }

    private static boolean check(IFormView view, DynamicObjectCollection newEntity, DynamicObjectCollection backUpEntity) {
        Map<String, DynamicObject> entityMap = backUpEntity.stream().collect(Collectors.toMap(val -> ApprovalHelper.getFullKey(val), val -> val));
        LinkedHashSet<String> notAgreeGroup = new LinkedHashSet<String>(newEntity.size());
        LinkedHashSet newTypeAgreeGroup = new LinkedHashSet(newEntity.size());
        for (DynamicObject dynamicObject : newEntity) {
            String key = ApprovalHelper.getFullKey(dynamicObject);
            DynamicObject oldDy = entityMap.get(key);
            if (oldDy == null) {
                dynamicObject.set("change", (Object)Boolean.TRUE);
                dynamicObject.set("status", (Object)Boolean.FALSE);
                continue;
            }
            if (oldDy.getBoolean("status")) {
                boolean isEquals = ApprovalHelper.isEqualsAfterReject(dynamicObject);
                if (isEquals) {
                    dynamicObject.set("change", (Object)Boolean.FALSE);
                    dynamicObject.set("status", (Object)Boolean.FALSE);
                    dynamicObject.set("reason", null);
                } else {
                    dynamicObject.set("change", (Object)Boolean.TRUE);
                    dynamicObject.set("status", (Object)Boolean.TRUE);
                    dynamicObject.set("reason", (Object)oldDy.getString("reason"));
                }
                String newValue = oldDy.getString("newvalue");
                String gName = dynamicObject.getString("firstgroup");
                Long dataId = dynamicObject.getLong("dataid");
                String group = "" + dataId + InfoGroupApprovalUtil.isText(dynamicObject) + ":" + gName;
                if (!HRStringUtils.isNotEmpty((String)newValue) || Boolean.TRUE.equals(dynamicObject.getBoolean("isdel")) || !newValue.equals(dynamicObject.getString("newvalue"))) continue;
                notAgreeGroup.add(group);
                continue;
            }
            String newValue = oldDy.getString("newvalue");
            if (HRStringUtils.isNotEmpty((String)newValue) && !newValue.equals(dynamicObject.getString("newvalue"))) {
                dynamicObject.set("change", (Object)Boolean.TRUE);
            }
            dynamicObject.set("reason", (Object)oldDy.getString("reason"));
        }
        notAgreeGroup.removeAll(newTypeAgreeGroup);
        if (notAgreeGroup.size() > 0) {
            StringBuilder tip = new StringBuilder();
            HashSet<String> groupNameSet = new HashSet<String>(notAgreeGroup.size());
            for (String gName : notAgreeGroup) {
                if (!groupNameSet.add(gName = gName.substring(gName.indexOf(":") + 1))) continue;
                tip.append(MessageFormat.format("[{0}]", gName));
            }
            String content = MessageFormat.format(ResManager.loadKDString((String)"\u88ab\u9a73\u56de\u4fe1\u606f\u7ec4\u201c{0}\u201d\u4e2d\u5b58\u5728\u672a\u4fee\u6539\u5b57\u6bb5\u3002\u8bf7\u5c06\u5168\u90e8\u88ab\u9a73\u56de\u4fe1\u606f\u4fee\u6539\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u201c\u63d0\u4ea4\u5ba1\u6838\u201d\u3002", (String)"ApprovalHelper_14", (String)"sdk-hr", (Object[])new Object[0]), tip.toString());
            view.showConfirm(content, MessageBoxOptions.None);
            return false;
        }
        return true;
    }

    private static boolean isEqualsAfterReject(DynamicObject dynamicObject) {
        String oldValue = dynamicObject.getString("oldvalue");
        String newValue = dynamicObject.getString("newvalue");
        return HRStringUtils.equals((String)oldValue, (String)newValue);
    }

    public static String getFullKey(DynamicObject dynamicObject) {
        StringBuilder sb = new StringBuilder();
        sb.append(dynamicObject.getString("firstgroupnum")).append(dynamicObject.getString("entityname")).append(dynamicObject.getString("fieldname")).append(dynamicObject.getString("dataid"));
        return sb.toString();
    }

    private static DynamicObjectCollection backUpEntity(DynamicObjectCollection entity) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection(entity.getDynamicObjectType(), null);
        for (DynamicObject dynamicObject : entity) {
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dynamicObjects.addNew());
        }
        return dynamicObjects;
    }

    private static boolean existConflict(IFormView view) {
        String billId = view.getPageCache().get("submitVerson");
        if (HRStringUtils.isNotEmpty((String)billId)) {
            LOGGER.error("existConflict");
            ApprovalHelper.removeFieldCache(view);
            view.showConfirm(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u3002", (String)"ApprovalHelper_1", (String)"sdk-hr", (Object[])new Object[0]), MessageBoxOptions.None);
            return true;
        }
        return false;
    }

    private static void removeFieldCache(IFormView view) {
        Map allCache = view.getPageCache().getAll();
        ArrayList<String> delList = new ArrayList<String>();
        delList.add("submitVerson");
        for (String key : allCache.keySet()) {
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            delList.add(key);
        }
        view.getPageCache().batchRemove(delList);
        ApprovalHelper.updateSyncCacheToDataBase(view);
    }

    private static boolean handleSubmitResult(IFormView view, OperationResult result) {
        LOGGER.info(MessageFormat.format("sumbit_result:{0}", SerializationUtils.toJsonString((Object)result)));
        List successPkIds = result.getSuccessPkIds();
        if (CollectionUtils.isEmpty((Collection)successPkIds)) {
            StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"ApprovalHelper_3", (String)"sdk-hr", (Object[])new Object[0]));
            List errors = result.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)errors) && errors.get(0) != null) {
                tip.append("\r\n").append(((IOperateInfo)errors.get(0)).toString());
            }
            view.showConfirm(tip.toString(), MessageBoxOptions.None);
            return false;
        }
        return true;
    }

    private static void addDataToEntity(String gName, Boolean isNew, List<Map<String, Object>> groups, List<Map<String, Object>> groupFields, DynamicObjectCollection entity) {
        boolean hasChildGroup = groups.size() > 1;
        for (Map<String, Object> group : groups) {
            String SecondGroupName = hasChildGroup ? (String)group.get("gname") : " ";
            List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
            Set pageFields = fields.stream().map(val -> String.valueOf(val.get("pnumber")) + val.get("number")).collect(Collectors.toSet());
            Map<Long, List<Map>> updateMap = groupFields.stream().filter(val -> pageFields.contains(String.valueOf(val.get("entityName")) + val.get("fieldname"))).filter(val -> isNew.equals(val.get("isnew"))).collect(Collectors.groupingBy(val -> (Long)val.get("dataid")));
            if (updateMap.size() <= 0) continue;
            for (Map<String, Object> groupField : groupFields) {
                for (Map.Entry<Long, List<Map>> longListEntry : updateMap.entrySet()) {
                    if (!longListEntry.getKey().equals(groupField.get("dataid"))) continue;
                    List<Map> updateFieldList = longListEntry.getValue();
                    Map<String, Map> fieldMap = updateFieldList.stream().collect(Collectors.toMap(val -> String.valueOf(val.get("entityName")) + val.get("fieldname"), val -> val));
                    for (Map<String, Object> field : fields) {
                        boolean isSingleRowTpl;
                        String pnumber = (String)field.get("pnumber");
                        String number = (String)field.get("number");
                        Map updateField = fieldMap.get(pnumber + number);
                        if (updateField == null || !number.equals(groupField.get("fieldname")) || (isSingleRowTpl = InfoGroupHelper.isSingleRowTpl(String.valueOf(updateField.get("entityName")))) && !ApprovalHelper.fieldIsChange(updateField).booleanValue()) continue;
                        DynamicObject newDy = entity.addNew();
                        newDy.set("entityname", (Object)pnumber);
                        newDy.set("fieldname", (Object)number);
                        Object displayName = updateField.get("displayname");
                        if (displayName != null && HRStringUtils.isNotEmpty((String)displayName.toString())) {
                            newDy.set("displayname", displayName);
                        } else {
                            newDy.set("displayname", field.get("displayname"));
                        }
                        newDy.set("fieldtype", field.get("type"));
                        newDy.set("isnew", updateField.get("isnew"));
                        newDy.set("isdel", updateField.get("isdel"));
                        newDy.set("oldvalue", updateField.get("oldvalue"));
                        newDy.set("newvalue", updateField.get("newvalue"));
                        newDy.set("dataid", updateField.get("dataid"));
                        newDy.set("reason", updateField.get("reason"));
                        newDy.set("firstgroupnum", updateField.get("groupnumber"));
                        newDy.set("firstgroup", (Object)gName);
                        newDy.set("secondgroup", (Object)SecondGroupName);
                        newDy.set("extrainfo", field.get("refkey"));
                    }
                }
            }
        }
    }

    public static DynamicObject getInProcessWorkFlowBill(Long personId) {
        if (personId == null || personId == 0L) {
            LOGGER.warn("personId is null");
            return null;
        }
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B").or("billstatus", "=", (Object)"G").or("billstatus", "=", (Object)"D");
        return INFOAPPROVAL_HELPER.loadDynamicObject(new QFilter[]{personFilter, statusFilter});
    }

    public static void delCacheData(IFormView view) {
        LOGGER.info("delCacheData");
        Map<String, List<Map<String, Object>>> updateFieldMap = ApprovalHelper.getAuditFieldMap(view);
        if (!CollectionUtils.isEmpty(updateFieldMap)) {
            HashMap<Object, HashSet<Long>> delMap = new HashMap<Object, HashSet<Long>>(updateFieldMap.size());
            for (Map.Entry<String, List<Map<String, Object>>> entry : updateFieldMap.entrySet()) {
                for (Map<String, Object> field : entry.getValue()) {
                    if (!Boolean.TRUE.equals(field.get("isnew"))) continue;
                    String entityName = (String)field.get("entityName");
                    HashSet<Long> set = (HashSet<Long>)delMap.get(entityName);
                    if (CollectionUtils.isEmpty((Collection)set)) {
                        set = new HashSet<Long>();
                        delMap.put(entityName, set);
                    }
                    set.add((Long)field.get("dataid"));
                }
            }
            if (!CollectionUtils.isEmpty(delMap)) {
                String personIdStr = view.getPageCache().get("personId");
                Long personId = Long.parseLong(personIdStr);
                DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
                if (bill != null) {
                    DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dy2 : entity) {
                        String entityName;
                        Set set;
                        if (!dy2.getBoolean("isnew") || (set = (Set)delMap.get(entityName = dy2.getString("entityName"))) == null) continue;
                        set.remove(dy2.getLong("dataid"));
                    }
                }
                if (!CollectionUtils.isEmpty(delMap)) {
                    for (Map.Entry entry : delMap.entrySet()) {
                        QFilter idFilter;
                        QFilter statusFilter;
                        Set entryValue = (Set)entry.getValue();
                        String entryKey = (String)entry.getKey();
                        DynamicObject[] query = new HRBaseServiceHelper(entryKey).query("id", new QFilter[]{statusFilter = new QFilter("datastatus", "=", (Object)"-3"), idFilter = new QFilter("id", "in", (Object)entryValue)});
                        if (query == null || query.length == 0) {
                            return;
                        }
                        List<Long> longList = Arrays.stream(query).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                        AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
                        Map<String, Object> resultMap = attacheHandlerService.invokeDel(longList, entryKey, Boolean.TRUE);
                        LOGGER.info(MessageFormat.format("del_result:{0}", SerializationUtils.toJsonString(resultMap)));
                    }
                }
            }
        }
    }

    public static void handleSubmitButtonVisible(IFormView view) {
        String personIdStr = view.getPageCache().get("personId");
        DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(Long.parseLong(personIdStr));
        Map<String, List<Map<String, Object>>> auditMap = ApprovalHelper.getAuditFieldMap(view);
        ApprovalHelper.compareAndRemoveNoChangeEntry(auditMap, view);
        if (auditMap.size() == 0 || ApprovalHelper.removeOldVersonData(view)) {
            ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
            return;
        }
        if (bill != null) {
            if (!"G".equals(bill.getString("billstatus")) || !ApprovalHelper.isChange(bill, auditMap)) {
                ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
                return;
            }
        } else if (HRStringUtils.isNotEmpty((String)view.getPageCache().get("submitVerson"))) {
            ApprovalHelper.removeFieldCache(view);
            ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
            return;
        }
        if (!CommonUtil.hasPerm(view.getEntityId(), PERM_SUBMIT_ID, "hssc", view) && PermCommonUtil.isEnableNoPermBtnHide()) {
            ApprovalHelper.setSubmitButtonVisible(view, Boolean.FALSE);
            return;
        }
        ApprovalHelper.setSubmitButtonVisible(view, Boolean.TRUE);
    }

    private static void setSubmitButtonVisible(IFormView view, Boolean visible) {
        if (ApprovalHelper.isMobile(view)) {
            view.setVisible(visible, new String[]{"toolbar", "blankflex"});
        } else {
            view.setVisible(visible, new String[]{"submit"});
        }
    }

    private static boolean allFieldsAuditPass(DynamicObject bill) {
        DynamicObjectCollection dynamicObjects = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getBoolean("status")) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotPasss(IFormView view, String regNumber) {
        view.showTipNotification("The method has been abandoned ");
        return ApprovalHelper.isNotPasss(view, regNumber, "");
    }

    public static boolean isNotPasss(IFormView view, String regNumber, String groupName) {
        if (view == null || HRStringUtils.isEmpty((String)regNumber)) {
            return false;
        }
        String billId = view.getPageCache().get("submitVerson");
        if (HRStringUtils.isNotEmpty((String)billId)) {
            DynamicObject bill = INFOAPPROVAL_HELPER.queryOne("billstatus,entryentity.firstgroupnum,entryentity.entityname,entryentity.fieldname,entryentity.dataid,entryentity.status", (Object)Long.parseLong(billId));
            if (bill == null) {
                return false;
            }
            if (!"G".equals(bill.getString("billstatus"))) {
                return false;
            }
            List<Map<String, Object>> cacheList = ApprovalHelper.getAuditFieldMap(view).get(groupName);
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entity) {
                if (!regNumber.equals(dynamicObject.getString("firstgroupnum")) || !dynamicObject.getBoolean("status")) continue;
                boolean isExistCache = false;
                if (!CollectionUtils.isEmpty(cacheList)) {
                    for (Map<String, Object> map : cacheList) {
                        if (map.get("isNewModify") != null) continue;
                        StringBuilder fullKey = new StringBuilder(regNumber).append(map.get("entityName")).append(map.get("fieldname")).append(map.get("dataid"));
                        String key = ApprovalHelper.getFullKey(dynamicObject);
                        if (!key.equals(fullKey.toString())) continue;
                        isExistCache = true;
                        break;
                    }
                }
                if (!isExistCache) continue;
                return true;
            }
        }
        return false;
    }

    public static void setSubmitButtonVisibleListener(IFormView view, ProgresssListener listener) {
        ProgressBar bar = (ProgressBar)view.getControl("progressbar");
        if (bar != null) {
            bar.addProgressListener(listener);
            bar.start();
            ProgressBarAp progressBarAp = new ProgressBarAp();
            progressBarAp.setKey("progressbar");
            progressBarAp.setIntervalTime(3000);
            view.updateControlMetadata(progressBarAp.getKey(), progressBarAp.createControl());
        }
    }

    public static HashMap<Integer, String> getChangeBtnNameMaps() {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ApprovalHelper_10", (String)"sdk-hr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ApprovalHelper_11", (String)"sdk-hr", (Object[])new Object[0]));
        return btnNameMaps;
    }

    public static Tuple<Boolean, String> widthDraw(DynamicObject bill) {
        if (bill == null || bill.getPkValue() == null) {
            return Tuple.create((Object)Boolean.FALSE, (Object)"bill is null");
        }
        boolean fail = false;
        try {
            OperationResult operationResult = new OperationServiceImpl().localInvokeOperation("unsubmit", new DynamicObject[]{bill}, OperateOption.create());
            if (operationResult == null || !operationResult.isSuccess()) {
                LOGGER.error("unsubmit operationResult:", (Object)operationResult);
                fail = true;
            }
        }
        catch (Exception exception) {
            LOGGER.error("unsubmit ex:", (Throwable)exception);
            fail = true;
        }
        if (fail) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"ApprovalHelper_12", (String)"sdk-hr", (Object[])new Object[0]));
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"ApprovalHelper_13", (String)"sdk-hr", (Object[])new Object[0]));
    }

    public static boolean isCanWithDraw(DynamicObject bill) {
        boolean can;
        boolean bl = can = bill != null && !bill.getBoolean("rejectrecord") && "D".equals(bill.getString("billstatus"));
        if (!can) {
            return false;
        }
        Map result = WorkflowServiceHelper.canWithdraw((DynamicObject[])new DynamicObject[]{bill});
        return result != null && result.get("wfCanWithdraw") != null && ((List)result.get("wfCanWithdraw")).size() > 0;
    }

    public static boolean dealApprovalCacheForDel(IFormView view, String entityName, Long pk, DynamicObject dyArr, Map<String, Object> tabList) {
        boolean hasAuditData = false;
        if (ApprovalHelper.noNeedDelAudit(view, pk.toString(), entityName)) {
            return false;
        }
        String entrycache = PageCacheUtils.getHomePageCache(view).get(tabList.get("groupname") + "-" + "entrycache");
        List<HashMap<String, Object>> collection = new ArrayList();
        if (HRStringUtils.isNotEmpty((String)entrycache)) {
            collection = (List)SerializationUtils.fromJsonString((String)entrycache, List.class);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            HashMap next = (HashMap)iterator.next();
            if (!pk.toString().equals(next.get("dataid").toString())) continue;
            iterator.remove();
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        DynamicObject emptyDynamicObject = helper.generateEmptyDynamicObject();
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
        if (CollectionUtils.isEmpty(groups)) {
            return false;
        }
        try {
            for (Map<String, Object> group : groups) {
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
                if (CollectionUtils.isEmpty(fields)) continue;
                for (Map<String, Object> field : fields) {
                    if (!Boolean.TRUE.equals(field.get("isaudit")) || !entityName.equals(field.get("pnumber"))) continue;
                    String fieldKey = String.valueOf(field.get("number"));
                    if (entityName.equals("hrpi_pereduexpcert") && fieldKey.contains("-")) {
                        String[] splitArr = fieldKey.split("-");
                        fieldKey = splitArr[0];
                        long certTypeId = dyArr.getLong("certtype.id");
                        if (certTypeId != Long.parseLong(splitArr[1])) continue;
                    }
                    if (field.get("type").toString().equals(FieldTypeEnum.ATTACHMENT.getType())) {
                        List attachmentDatas = AttachmentServiceHelper.getAttachments((String)entityName, (Object)pk, (String)fieldKey);
                        if (CollectionUtils.isEmpty((Collection)attachmentDatas)) {
                            continue;
                        }
                    } else {
                        if ("BooleanProp".equals(FieldTypeEnum.geCodeByFieldType((String)field.get("type")).getCodeSimpleName()) && emptyDynamicObject.get(fieldKey) != null) {
                            ApprovalHelper.addDataMapToCollection(entityName, pk, dyArr, tabList, collection, field, fieldKey);
                            hasAuditData = true;
                            continue;
                        }
                        Object languageValue = emptyDynamicObject.get(fieldKey);
                        if ("MuliLangTextProp".equals(FieldTypeEnum.geCodeByFieldType((String)field.get("type")).getCodeSimpleName())) {
                            languageValue = null;
                        }
                        if (CommonUtil.customObjectEquals(languageValue, dyArr.get(fieldKey), "yyyy-MM-dd")) continue;
                    }
                    ApprovalHelper.addDataMapToCollection(entityName, pk, dyArr, tabList, collection, field, fieldKey);
                    hasAuditData = true;
                }
            }
            if (collection.size() > 0) {
                PageCacheUtils.getHomePageCache(view).put(tabList.get("groupname") + "-" + "entrycache", JSONUtils.toString(collection));
                PageCacheUtils.getHomePageCache(view).put("hasFieldChange-" + entityName + "-" + pk, String.valueOf(true));
            } else {
                PageCacheUtils.getHomePageCache(view).remove(tabList.get("groupname") + "-" + "entrycache");
            }
            ApprovalHelper.updateSyncCacheToDataBase(view);
        }
        catch (Exception exception) {
            LOGGER.error("entrycache-case-error", (Throwable)exception);
        }
        return hasAuditData;
    }

    private static void addDataMapToCollection(String entityName, Long pk, DynamicObject dyArr, Map<String, Object> tabList, List<HashMap<String, Object>> collection, Map<String, Object> field, String fieldKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityName", entityName);
        map.put("dataid", pk);
        map.put("isnew", Boolean.FALSE);
        map.put("isdel", Boolean.TRUE);
        map.put("groupname", tabList.get("groupname"));
        map.put("groupnumber", tabList.get("targetkey"));
        map.put("fieldtype", FieldTypeEnum.geCodeByFieldType((String)field.get("type")).getCodeSimpleName());
        map.put("displayname", field.get("displayname"));
        map.put("fieldname", fieldKey);
        map.put("newvalue", null);
        if (field.get("type").toString().equals(FieldTypeEnum.ATTACHMENT.getType())) {
            map.put("oldvalue", pk);
        } else {
            map.put("oldvalue", BusinessUtils.typeChange(dyArr.get(fieldKey)));
        }
        map.put("reason", null);
        map.put("status", null);
        collection.add(map);
    }

    public static void showNoPassInfoForDelOP(IFormView view) {
        DynamicObject bill;
        Map<String, Object> tableList = ParamAnalysisUtil.getParams(view.getFormShowParameter());
        String cacheValue = PageCacheUtils.getHomePageCache(view).get(tableList.get("groupname") + "-" + "entrycache");
        Object targetKey = tableList.get("targetkey");
        Long personId = (Long)view.getFormShowParameter().getCustomParams().get("person");
        if (HRStringUtils.isNotEmpty((String)cacheValue) && (bill = ApprovalHelper.getInProcessWorkFlowBill(personId)) != null && "G".equals(bill.getString("billstatus"))) {
            String flag = PageCacheUtils.getHomePage(view).getPageCache().get(targetKey + bill.getString("billno"));
            if (HRStringUtils.isNotEmpty((String)flag)) {
                return;
            }
            List collection = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            Map<Object, List<Map>> listMap = collection.stream().filter(map -> Boolean.TRUE.equals(map.get("isdel")) && Boolean.TRUE.equals(map.get("status"))).collect(Collectors.groupingBy(val -> val.get("entityName")));
            if (listMap == null || listMap.size() == 0) {
                return;
            }
            StringBuilder info = new StringBuilder();
            for (Map.Entry<Object, List<Map>> entry : listMap.entrySet()) {
                String entityName = String.valueOf(entry.getKey());
                String groupName = ParamAnalysisUtil.getGroupName(tableList, entityName);
                List<Map> entryValue = entry.getValue();
                Map<Object, List<Map>> collect = entryValue.stream().collect(Collectors.groupingBy(map -> map.get("dataid")));
                for (Map.Entry<Object, List<Map>> listEntry : collect.entrySet()) {
                    List<Map> mapList = listEntry.getValue();
                    if (mapList == null || mapList.size() <= 0) continue;
                    String reason = (String)mapList.get(0).get("reason");
                    info.append(groupName).append(":").append(HRStringUtils.isNotEmpty((String)reason) ? reason : ResManager.loadKDString((String)"\u672a\u586b\u5199\u4e0d\u901a\u8fc7\u7406\u7531", (String)"AbstractMobileFormDrawEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            view.showConfirm(ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7\u8bf4\u660e", (String)"AbstractMobileFormDrawEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), info.toString(), MessageBoxOptions.OK, null, null);
            PageCacheUtils.getHomePage(view).getPageCache().put(targetKey + bill.getString("billno"), "1");
        }
    }

    public static boolean hasAbandonButton(IFormView view, String entityName, Long dataId) {
        List groupFields;
        Map<String, Object> tabList = ParamAnalysisUtil.getParams(view.getFormShowParameter());
        String groupName = (String)tabList.get("groupname");
        String cacheValue = PageCacheUtils.getHomePageCache(view).get(tabList.get("groupname") + "-" + "entrycache");
        if (HRStringUtils.isNotEmpty((String)cacheValue) && !CollectionUtils.isEmpty((Collection)(groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)))) {
            boolean isWaitreSubmit;
            Long personId = (Long)view.getFormShowParameter().getCustomParams().get("person");
            DynamicObject bill = ApprovalHelper.getInProcessWorkFlowBill(personId);
            boolean bl = isWaitreSubmit = bill != null && "G".equals(bill.getString("billstatus"));
            if (!isWaitreSubmit) {
                return false;
            }
            boolean update = false;
            boolean existWaitreSubmit = false;
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            String firstGroupNum = (String)tabList.get("targetkey");
            Map<String, DynamicObject> entityMap = entity.stream().filter(val -> firstGroupNum.equals(val.getString("firstgroupnum"))).collect(Collectors.toMap(val -> ApprovalHelper.getFullKey(val), val -> val));
            if (!CollectionUtils.isEmpty(entityMap)) {
                for (Map map : groupFields) {
                    StringBuilder fullKey;
                    DynamicObject dynamicObject;
                    Object dataIdCache = map.get("dataid");
                    Object entityNameCache = map.get("entityName");
                    if ("hrpi_pereduexpcert".equals(entityNameCache)) {
                        dataIdCache = BusinessUtils.getEduexpByEduCertId((Long)dataIdCache);
                        entityNameCache = "hrpi_pereduexp";
                    }
                    if (!dataId.equals(dataIdCache) || !entityName.equals(entityNameCache) || (dynamicObject = entityMap.get((fullKey = new StringBuilder(firstGroupNum).append(map.get("entityName")).append(map.get("fieldname")).append(map.get("dataid"))).toString())) == null || map.get("isNewModify") != null) continue;
                    Boolean status = dynamicObject.getBoolean("status");
                    if (!status.equals(map.get("status"))) {
                        String reason = dynamicObject.getString("reason");
                        map.put("status", status);
                        map.put("reason", reason);
                        if (!update) {
                            update = true;
                        }
                    }
                    if (!status.booleanValue() || existWaitreSubmit) continue;
                    existWaitreSubmit = true;
                }
            }
            if (update) {
                view.getParentView().getPageCache().put(groupName + "-entrycache", SerializationUtils.toJsonString((Object)groupFields));
            }
            return existWaitreSubmit;
        }
        return false;
    }

    public static void showNotPassInfoComfirm(IFormView view, String key, String entityName, String pkId) {
        List collection;
        Optional<Map> first;
        Map<String, Object> tableList = ParamAnalysisUtil.getParams(view.getFormShowParameter());
        String cacheValue = PageCacheUtils.getHomePageCache(view).get(tableList.get("groupname") + "-" + "entrycache");
        String reason = "";
        if (HRStringUtils.isNotEmpty((String)cacheValue) && (first = (collection = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)).stream().filter(map -> map.get("entityName").equals(entityName) && map.get("dataid").toString().equals(pkId) && Boolean.TRUE.equals(map.get("status")) && Boolean.TRUE.equals(map.get("isdel"))).findFirst()).isPresent()) {
            reason = HRStringUtils.isNotEmpty((String)String.valueOf(first.get().get("reason"))) ? String.valueOf(first.get().get("reason")) : ResManager.loadKDString((String)"\u672a\u586b\u5199\u4e0d\u901a\u8fc7\u7406\u7531", (String)"AbstractMobileFormDrawEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
            view.showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u539f\u56e0\u4e3a\uff1a{0}\u3002\u786e\u8ba4\u540e\u5c06\u4e0d\u518d\u91cd\u590d\u5c55\u793a\u672c\u63d0\u793a\u3002", (String)"AbstractElyCardEdit_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]), reason), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, MessageCallBackType.Plugin));
        }
    }

    private static boolean noNeedDelAuditForEntity(IFormView view, String pkStr, String curEntity) {
        boolean noNeed = true;
        Map<String, Object> tabList = ParamAnalysisUtil.getParams(view.getFormShowParameter());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(curEntity);
        DynamicObject dbDy = helper.queryOne((Object)pkStr);
        if (!ParamAnalysisUtil.existAuditField(tabList, curEntity) || "-3".equals(dbDy.getString("datastatus"))) {
            return true;
        }
        DynamicObject emptyDynamicObject = helper.generateEmptyDynamicObject();
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
        block2: for (Map<String, Object> group : groups) {
            List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
            for (Map<String, Object> field : fields) {
                String entityName = String.valueOf(field.get("pnumber"));
                String fieldName = String.valueOf(field.get("number"));
                if ("hrpi_pereduexpcert".equals(curEntity) && fieldName.contains("-")) {
                    fieldName = fieldName.substring(0, fieldName.indexOf("-"));
                }
                if (!entityName.equals(curEntity) || Boolean.FALSE.equals(field.get("isaudit"))) continue;
                if ("AttachmentProp".equals(FieldTypeEnum.geCodeByFieldType((String)field.get("type")).getCodeSimpleName())) {
                    List attachmentDatas = AttachmentServiceHelper.getAttachments((String)entityName, (Object)pkStr, (String)fieldName);
                    if (CollectionUtils.isEmpty((Collection)attachmentDatas)) continue;
                    noNeed = false;
                    break block2;
                }
                if ("BooleanProp".equals(FieldTypeEnum.geCodeByFieldType((String)field.get("type")).getCodeSimpleName()) && emptyDynamicObject.get(fieldName) != null) {
                    noNeed = false;
                    break block2;
                }
                Object languageValue = emptyDynamicObject.get(fieldName);
                if ("MuliLangTextProp".equals(FieldTypeEnum.geCodeByFieldType((String)field.get("type")).getCodeSimpleName())) {
                    languageValue = null;
                }
                try {
                    if (CommonUtil.customObjectEquals(languageValue, dbDy.get(fieldName), "yyyy-MM-dd")) continue;
                    noNeed = false;
                    break block2;
                }
                catch (Exception exception) {
                    LOGGER.error("parse date error", (Throwable)exception);
                }
            }
        }
        return noNeed;
    }

    public static boolean noNeedDelAudit(IFormView view, String pkStr, String curEntity) {
        Map<String, Object> tabList;
        boolean noNeedDelAudit = ApprovalHelper.noNeedDelAuditForEntity(view, pkStr, curEntity);
        if (noNeedDelAudit && curEntity.equals("hrpi_pereduexp") && ParamAnalysisUtil.existAuditField(tabList = ParamAnalysisUtil.getParams(view.getFormShowParameter()), "hrpi_pereduexpcert")) {
            DynamicObject[] certDyArr;
            HRBaseServiceHelper certHelper = new HRBaseServiceHelper("hrpi_pereduexpcert");
            QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "-3"});
            QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
            for (DynamicObject cert : certDyArr = certHelper.loadDynamicObjectArray("hrpi_pereduexpcert", new QFilter[]{new QFilter("certtype.enable", "=", (Object)"1"), new QFilter("pereduexp", "=", (Object)Long.parseLong(pkStr)), versionFilter, statusFilter, initFilter})) {
                if (ApprovalHelper.noNeedDelAuditForEntity(view, cert.getString("id"), "hrpi_pereduexpcert")) continue;
                noNeedDelAudit = false;
                break;
            }
        }
        return noNeedDelAudit;
    }

    public static boolean dealAuditBeforeDel(IFormView view, String entityName, Long pk, DynamicObject dyArr, Map<String, Object> tabList) {
        boolean hasAuditData = false;
        if (ApprovalHelper.dealApprovalCacheForDel(view, entityName, pk, dyArr, tabList)) {
            hasAuditData = true;
        }
        if (entityName.equals("hrpi_pereduexp")) {
            DynamicObject[] certDyArr;
            HRBaseServiceHelper certHelper = new HRBaseServiceHelper("hrpi_pereduexpcert");
            QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "-3"});
            QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
            for (DynamicObject cert : certDyArr = certHelper.loadDynamicObjectArray("hrpi_pereduexpcert", new QFilter[]{new QFilter("certtype.enable", "=", (Object)"1"), new QFilter("pereduexp", "=", (Object)pk), versionFilter, statusFilter, initFilter})) {
                if (!ApprovalHelper.dealApprovalCacheForDel(view, "hrpi_pereduexpcert", cert.getLong("id"), cert, tabList)) continue;
                hasAuditData = true;
            }
        }
        return hasAuditData;
    }

    public static boolean isHideDelBtnForDel(IFormView view, String dataId) {
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry(view);
        if (currentEntry != null && currentEntry.length > 0) {
            DynamicObjectCollection collection = currentEntry[0].getDynamicObjectCollection("entryentity");
            return collection.stream().anyMatch(dy -> dy.getLong("dataid") == Long.parseLong(dataId) && Boolean.TRUE.equals(dy.getBoolean("isdel")) && Boolean.TRUE.equals(dy.getBoolean("status")));
        }
        return false;
    }

    public static boolean isHideDelBtnForAdd(IFormView view, String dataId) {
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry(view);
        if (currentEntry != null && currentEntry.length > 0) {
            DynamicObjectCollection collection = currentEntry[0].getDynamicObjectCollection("entryentity");
            return collection.stream().anyMatch(dy -> dy.getLong("dataid") == Long.parseLong(dataId) && Boolean.TRUE.equals(dy.getBoolean("isnew")) && Boolean.TRUE.equals(dy.getBoolean("status")));
        }
        return false;
    }

    public static void updateSyncCacheToDataBase(IFormView view) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_infoapprovalcache");
        Long personId = (Long)view.getFormShowParameter().getCustomParam("person");
        if (!(personId != null && personId != 0L || (personId = Long.valueOf(view.getPageCache().get("personId"))) != null && personId != 0L)) {
            LOGGER.error("person_id====null");
            return;
        }
        QFilter filter = new QFilter("personid", "=", (Object)personId);
        DynamicObject queryOne = helper.loadDynamicObject(filter);
        if (queryOne == null) {
            queryOne = helper.generateEmptyDynamicObject();
            queryOne.set("personid", (Object)personId);
        }
        HashMap<String, List> updateFieldMap = new HashMap<String, List>();
        Map allCache = PageCacheUtils.getHomePageCache(view).getAll();
        for (Map.Entry entry : allCache.entrySet()) {
            String key = (String)entry.getKey();
            if (HRStringUtils.isEmpty((String)key) || !key.endsWith("-entrycache")) continue;
            String cacheValue = (String)entry.getValue();
            List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            updateFieldMap.put(key, groupFields);
        }
        queryOne.set("cachelog_tag", (Object)SerializationUtils.toJsonString(updateFieldMap));
        helper.saveOne(queryOne);
    }

    public static void showConfirmWhenFirstOpen(boolean isClick, IFormView view) {
        String flag = PageCacheUtils.getHomePageCache(view.getViewNoPlugin(view.getPageId())).get("isFirstOpen");
        if (flag != null && !isClick) {
            return;
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object person = formShowParameter.getCustomParam("person");
        if (Objects.isNull(person)) {
            return;
        }
        DynamicObject[] currentEntry = CommonUtil.getCurrentEntry(Long.valueOf(String.valueOf(person)));
        if (currentEntry == null || currentEntry.length == 0) {
            return;
        }
        DynamicObject entry = currentEntry[0];
        String billStatus = entry.getString("billstatus");
        if (!"G".equals(billStatus)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = entry.getDynamicObjectCollection("entryentity");
        List entityDys = dynamicObjectCollection.stream().filter(data -> data.getBoolean("status")).collect(Collectors.toList());
        Map entityNameAndDysMap = entityDys.stream().collect(Collectors.groupingBy(data -> data.getString("entityname"), LinkedHashMap::new, Collectors.toList()));
        String notPassReason = entityNameAndDysMap.entrySet().stream().map(data -> {
            String entityName = (String)data.getKey();
            boolean isSingle = InfoGroupHelper.isSingleRowTpl(entityName);
            List dys = (List)data.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < dys.size(); ++i) {
                String reason;
                String displayname;
                String ffirstgroup;
                DynamicObject dy = (DynamicObject)dys.get(i);
                if (!StringUtils.isEmpty((Object)stringBuilder.toString())) {
                    stringBuilder.append("\r\n");
                }
                if (isSingle) {
                    ffirstgroup = dy.getString("firstgroup");
                    stringBuilder.append(ffirstgroup).append(":");
                    displayname = dy.getString("displayname");
                    stringBuilder.append(displayname).append(":");
                    reason = Objects.isNull(dy.getString("reason")) ? "" : dy.getString("reason");
                    stringBuilder.append(reason);
                    continue;
                }
                ffirstgroup = dy.getString("firstgroup");
                stringBuilder.append(ffirstgroup).append(i + 1).append(":");
                displayname = dy.getString("displayname");
                stringBuilder.append(displayname).append(":");
                reason = Objects.isNull(dy.getString("reason")) ? "" : dy.getString("reason");
                stringBuilder.append(reason);
            }
            return stringBuilder.toString();
        }).collect(Collectors.joining("\r\n"));
        if (StringUtils.isEmpty((Object)notPassReason)) {
            return;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5173\u95ed", (String)"AbstractMobileFormDrawEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        view.showConfirm(ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7\u8bf4\u660e", (String)"AbstractMobileFormDrawEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]), notPassReason, MessageBoxOptions.OK, ConfirmTypes.Default, null, btnNameMaps);
        PageCacheUtils.getHomePageCache(view).put("isFirstOpen", String.valueOf(true));
    }
}

