/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import java.util.concurrent.Callable;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;

public class CachedLoadReferenceObjectManagerHelper {
    private static final Log LOGGER = LogFactory.getLog(CachedLoadReferenceObjectManagerHelper.class);

    public static <R> R disabledCache(Callable<R> callable) {
        R apply;
        long start = System.currentTimeMillis();
        LOGGER.info("CachedLoadReferenceObjectManagerHelper#disabledCache start...");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        try {
            apply = callable.call();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("sdk.hr.disabledCacheError", e.getMessage()), new Object[]{e.getMessage()});
        }
        finally {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
            LOGGER.info("CachedLoadReferenceObjectManagerHelper#disabledCache end... use time {}ms.", (Object)(System.currentTimeMillis() - start));
        }
        return apply;
    }
}

