/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.entity.ShowHisVersionEntity;

public class ShowHisVersionEntityHelper {
    private static final Log LOGGER = LogFactory.getLog(ShowHisVersionEntityHelper.class);

    private ShowHisVersionEntityHelper() {
    }

    public static ShowHisVersionEntityHelper getInstance() {
        return Holder.INSTANCE;
    }

    public Map<String, ShowHisVersionEntity> getMainEntityFieldListByBoidName(List<ShowHisVersionEntity> showHisVersionEntityList) {
        return showHisVersionEntityList.stream().filter(ShowHisVersionEntity::isMainEntityField).collect(Collectors.toMap(ShowHisVersionEntity::getListBoidName, showHisVersionEntity -> showHisVersionEntity));
    }

    public Map<String, List<Long>> getShowHisVersionIdListMap(DataSet dataSet, Set<String> queryFieldSet, List<ShowHisVersionEntity> showHisVersionEntityList) {
        HashMap showHisVersionIdListMap = Maps.newHashMap();
        for (ShowHisVersionEntity showHisVersionEntity : showHisVersionEntityList) {
            if (showHisVersionEntity.isMainEntityField() && queryFieldSet.contains(showHisVersionEntity.getRealMainEntityFieldName())) {
                showHisVersionIdListMap.put(showHisVersionEntity.getListBoidName(), Lists.newArrayListWithExpectedSize((int)16));
            } else if (queryFieldSet.contains(showHisVersionEntity.getListBoidName()) && queryFieldSet.contains(showHisVersionEntity.getListFieldName())) {
                showHisVersionIdListMap.put(showHisVersionEntity.getListBoidName(), Lists.newArrayListWithExpectedSize((int)16));
            }
            if (!HRStringUtils.isNotEmpty((String)showHisVersionEntity.getParentEntityName()) || !queryFieldSet.contains(showHisVersionEntity.getListParentIdName())) continue;
            showHisVersionIdListMap.put(showHisVersionEntity.getListParentIdName(), Lists.newArrayListWithExpectedSize((int)16));
        }
        for (Row row : dataSet) {
            for (Map.Entry listListEntry : showHisVersionIdListMap.entrySet()) {
                String listIdName = (String)listListEntry.getKey();
                List listIdValue = (List)listListEntry.getValue();
                Object val = row.get(listIdName);
                if (val == null) continue;
                if (val instanceof DynamicObject) {
                    DynamicObject valDy = (DynamicObject)val;
                    listIdValue.add((Long)valDy.getPkValue());
                    continue;
                }
                listIdValue.add((Long)val);
            }
        }
        return showHisVersionIdListMap;
    }

    public Map<String, List<Long>> getShowHisVersionIdListMap(DynamicObjectCollection collection, List<ShowHisVersionEntity> showHisVersionEntityList) {
        HashMap showHisVersionIdListMap = Maps.newHashMap();
        DataEntityPropertyCollection properties = collection.getDynamicObjectType().getProperties();
        for (ShowHisVersionEntity showHisVersionEntity : showHisVersionEntityList) {
            if (showHisVersionEntity.isMainEntityField() && properties.containsKey((Object)showHisVersionEntity.getRealMainEntityFieldName())) {
                showHisVersionIdListMap.put(showHisVersionEntity.getListBoidName(), Lists.newArrayListWithExpectedSize((int)collection.size()));
            } else if (properties.containsKey((Object)showHisVersionEntity.getListBoidName()) && properties.containsKey((Object)showHisVersionEntity.getListFieldName())) {
                showHisVersionIdListMap.put(showHisVersionEntity.getListBoidName(), Lists.newArrayListWithExpectedSize((int)collection.size()));
            }
            if (!HRStringUtils.isNotEmpty((String)showHisVersionEntity.getParentEntityName()) || !properties.containsKey((Object)showHisVersionEntity.getListParentIdName())) continue;
            showHisVersionIdListMap.put(showHisVersionEntity.getListParentIdName(), Lists.newArrayListWithExpectedSize((int)collection.size()));
        }
        collection.forEach(dynamicObject -> {
            for (Map.Entry listListEntry : showHisVersionIdListMap.entrySet()) {
                String listIdName = (String)listListEntry.getKey();
                List listIdValue = (List)listListEntry.getValue();
                Object val = dynamicObject.get(listIdName);
                if (val == null) continue;
                if (val instanceof DynamicObject) {
                    DynamicObject valDy = (DynamicObject)val;
                    listIdValue.add((Long)valDy.getPkValue());
                    continue;
                }
                listIdValue.add((Long)val);
            }
        });
        return showHisVersionIdListMap;
    }

    public Map<String, Tuple2<String, Map<Long, Object>>> queryHisVersionDysMap(Map<String, List<Long>> hisVersionIdListMap, List<ShowHisVersionEntity> showHisVersionEntityList, QFilter dataStatusAndBsedFilter) {
        HashMap hisVersionDysMap = Maps.newHashMapWithExpectedSize((int)hisVersionIdListMap.size());
        for (ShowHisVersionEntity showHisVersionEntity : showHisVersionEntityList) {
            String listBoidName = showHisVersionEntity.getListBoidName();
            List<Long> listBoidValue = hisVersionIdListMap.get(listBoidName);
            if (CollectionUtils.isEmpty(listBoidValue)) continue;
            LOGGER.info("queryStandardHisVersionDysMap, {}", (Object)showHisVersionEntity);
            Map<Object, Object> hisVersionMap = Maps.newHashMap();
            if (HRStringUtils.isEmpty((String)showHisVersionEntity.getParentEntityName())) {
                hisVersionMap = this.queryStandardHisVersionDysMap(showHisVersionEntity, listBoidValue, hisVersionMap, dataStatusAndBsedFilter);
            } else {
                String listParentIdName = showHisVersionEntity.getListParentIdName();
                List<Long> listParentIdValue = hisVersionIdListMap.get(listParentIdName);
                hisVersionMap = this.queryEntryHisVersionDysMap(showHisVersionEntity, listBoidValue, listParentIdValue, hisVersionMap, dataStatusAndBsedFilter);
            }
            hisVersionDysMap.put(showHisVersionEntity.getListBoidName(), new Tuple2((Object)showHisVersionEntity.getListFieldName(), (Object)hisVersionMap));
        }
        return hisVersionDysMap;
    }

    public Map<Long, Object> queryStandardHisVersionDysMap(ShowHisVersionEntity showHisVersionEntity, List<Long> listBoidValue, Map<Long, Object> hisVersionMap, QFilter dataStatusAndBsedFilter) {
        Object[] hisVersionDys = HRBaseDaoFactory.getInstance((String)showHisVersionEntity.getEntityName()).query(String.join((CharSequence)",", showHisVersionEntity.getEntityBoidName(), showHisVersionEntity.getEntityFieldName()), new QFilter[]{dataStatusAndBsedFilter, new QFilter(showHisVersionEntity.getEntityBoidName(), "in", listBoidValue)});
        if (ArrayUtils.isNotEmpty((Object[])hisVersionDys)) {
            hisVersionMap = Arrays.stream(hisVersionDys).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(showHisVersionEntity.getEntityBoidName()), dynamicObject -> dynamicObject.get(showHisVersionEntity.getEntityFieldName()), (k1, k2) -> k1));
        }
        return hisVersionMap;
    }

    public Map<Long, Object> queryEntryHisVersionDysMap(ShowHisVersionEntity showHisVersionEntity, List<Long> listBoidValue, List<Long> listParentIdValue, Map<Long, Object> hisVersionMap, QFilter dataStatusAndBsedFilter) {
        DynamicObject[] parentBoidDys = HRBaseDaoFactory.getInstance((String)showHisVersionEntity.getParentEntityName()).query(showHisVersionEntity.getParentEntityBoidName(), new QFilter[]{new QFilter("id", "in", listParentIdValue)});
        List listParentBoidValue = Arrays.stream(parentBoidDys).map(dynamicObject -> dynamicObject.getLong(showHisVersionEntity.getParentEntityBoidName())).collect(Collectors.toList());
        Object[] parentHisVersionDys = HRBaseDaoFactory.getInstance((String)showHisVersionEntity.getParentEntityName()).query("id", new QFilter[]{dataStatusAndBsedFilter, new QFilter(showHisVersionEntity.getParentEntityBoidName(), "in", listParentBoidValue)});
        if (ArrayUtils.isNotEmpty((Object[])parentHisVersionDys)) {
            List parentHisIdList = Arrays.stream(parentHisVersionDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            Object[] hisVersionDys = HRBaseDaoFactory.getInstance((String)showHisVersionEntity.getEntityName()).query(String.join((CharSequence)",", showHisVersionEntity.getEntityBoidName(), showHisVersionEntity.getEntityFieldName()), new QFilter[]{new QFilter(showHisVersionEntity.getEntryEntityParentIdName(), "in", parentHisIdList), new QFilter(showHisVersionEntity.getEntityBoidName(), "in", listBoidValue)});
            if (ArrayUtils.isNotEmpty((Object[])hisVersionDys)) {
                hisVersionMap = Arrays.stream(hisVersionDys).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong(showHisVersionEntity.getEntityBoidName()), dynamicObject -> dynamicObject.get(showHisVersionEntity.getEntityFieldName()), (k1, k2) -> k1));
            }
        }
        return hisVersionMap;
    }

    private static class Holder {
        static final ShowHisVersionEntityHelper INSTANCE = new ShowHisVersionEntityHelper();

        private Holder() {
        }
    }
}

