/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.helper;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class ValueConvertHelper {
    private static final Log LOGGER = LogFactory.getLog(ValueConvertHelper.class);
    private static final String BASE_PROPS = "number,name";

    public static String showString(String entityName, String fieldName, String fieldType, String extraInfo, String value) {
        if (HRStringUtils.isEmpty((String)value)) {
            return "-";
        }
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.geCodeByFieldType(fieldType);
        if (fieldTypeEnum != null) {
            switch (fieldTypeEnum) {
                case BILL_STATUS: 
                case COMBO: {
                    return ValueConvertHelper.handleCombo(entityName, fieldName, value);
                }
                case DATE: 
                case CREATE_DATE: 
                case MODIFY_DATE: {
                    return ValueConvertHelper.handleDate(value);
                }
                case DATE_TIME: {
                    return HRDateTimeUtils.format((Date)new Timestamp(Long.parseLong(value)), (String)"yyyy-MM-dd HH:mm:ss");
                }
                case BOOLEAN: {
                    return ValueConvertHelper.handleBoolean(value);
                }
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: 
                case ADDRESSPROP: 
                case HISMODELBASEDATAPROP: {
                    return ValueConvertHelper.handleBaseData(value, extraInfo);
                }
                case MULBASEDATAPROP: {
                    return ValueConvertHelper.handleMulBaseData(value, extraInfo);
                }
                case ADMIN_DIVISION: {
                    return ValueConvertHelper.handleAdminDivisionField(value);
                }
            }
        }
        return value;
    }

    private static String handleDate(String value) {
        Timestamp date = new Timestamp(Long.parseLong(value));
        return HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public static String handleCombo(String entityName, String fieldName, String value) {
        List<ComboItem> items = ComboItemUtil.getComboItem(entityName, fieldName);
        if (!CollectionUtils.isEmpty(items)) {
            for (ComboItem comboItem : items) {
                if (!value.equals(comboItem.getValue())) continue;
                return comboItem.getCaption().getLocaleValue();
            }
        }
        return value;
    }

    public static String handleBoolean(String value) {
        return Boolean.parseBoolean(value) ? ResManager.loadKDString((String)"\u662f", (String)"FieldShowHelper_0", (String)"hr-hspm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FieldShowHelper_1", (String)"hr-hspm-business", (Object[])new Object[0]);
    }

    private static String handleBaseData(String value, String extraInfo) {
        block6: {
            if (HRStringUtils.isNotEmpty((String)extraInfo)) {
                try {
                    HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(extraInfo);
                    DynamicObject dynamicObject = baseServiceHelper.queryOne(BASE_PROPS, (Object)Long.valueOf(value));
                    if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                        if (PropertyHelper.existProperty(dynamicObject, "name")) {
                            return dynamicObject.getString("name");
                        }
                        if (PropertyHelper.existProperty(dynamicObject, "number")) {
                            return dynamicObject.getString("number");
                        }
                        break block6;
                    }
                    return "-";
                }
                catch (Exception exception) {
                    LOGGER.error(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6570\u636e\u5f02\u5e38\u3002", (String)"FieldShowHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]), (Throwable)exception);
                }
            }
        }
        return value;
    }

    public static String handleMulBaseData(String value, String extraInfo) {
        ArrayList<String> list = new ArrayList<String>();
        if (HRStringUtils.isNotEmpty((String)extraInfo) && HRStringUtils.isNotEmpty((String)value)) {
            String[] split = value.split(";");
            if (split == null || split.length == 0) {
                return "-";
            }
            try {
                HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(extraInfo);
                for (int i = 0; i < split.length; ++i) {
                    DynamicObject dynamicObject = baseServiceHelper.queryOne(BASE_PROPS, (Object)Long.valueOf(split[i]));
                    if (HRObjectUtils.isEmpty((Object)dynamicObject)) continue;
                    if (PropertyHelper.existProperty(dynamicObject, "name")) {
                        list.add(dynamicObject.getString("name"));
                        continue;
                    }
                    if (!PropertyHelper.existProperty(dynamicObject, "number")) continue;
                    list.add(dynamicObject.getString("number"));
                }
            }
            catch (Exception exception) {
                LOGGER.error(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6570\u636e\u5f02\u5e38\u3002", (String)"FieldShowHelper_2", (String)"hr-hspm-business", (Object[])new Object[0]), (Throwable)exception);
            }
        }
        return String.join((CharSequence)";", list);
    }

    public static String handleMulBaseData(List data) {
        ArrayList<String> list = new ArrayList<String>();
        if (data != null && data.size() > 0) {
            for (Object dynamicObject : data) {
                DynamicObject fbasedataid = new DynamicObject();
                if (dynamicObject instanceof DynamicObject) {
                    if (!PropertyHelper.existProperty((DynamicObject)dynamicObject, "fbasedataid")) continue;
                    fbasedataid = ((DynamicObject)dynamicObject).getDynamicObject("fbasedataid");
                }
                if (dynamicObject instanceof Map) {
                    if (!((Map)dynamicObject).containsKey("fbasedataid") || !(((Map)dynamicObject).get("fbasedataid") instanceof DynamicObject)) continue;
                    fbasedataid = (DynamicObject)((Map)dynamicObject).get("fbasedataid");
                }
                if (PropertyHelper.existProperty(fbasedataid, "name")) {
                    list.add(fbasedataid.getString("name"));
                    continue;
                }
                if (!PropertyHelper.existProperty(fbasedataid, "number")) continue;
                list.add(fbasedataid.getString("number"));
            }
            return String.join((CharSequence)";", list);
        }
        return "-";
    }

    public static void setValue(DynamicObject updateDy, String fieldName, String fieldType, String value) {
        FieldTypeEnum fieldTypeEnum = NumberUtils.isCreatable((String)fieldType) ? FieldTypeEnum.geCodeByFieldType(fieldType) : FieldTypeEnum.getFieldTypeBySimpleCode(fieldType);
        if (fieldTypeEnum == null) {
            LOGGER.error(MessageFormat.format("cant not found the fieldtype[{0}]", fieldType));
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u6570\u636e\u7c7b\u578b", (String)"InfoGroupUpdateApprovalOp_0", (String)"hr-hspm-opplugin", (Object[])new Object[0]));
        }
        if (!PropertyHelper.existProperty(updateDy, fieldName)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)value)) {
            updateDy.set(fieldName, null);
            return;
        }
        try {
            switch (fieldTypeEnum) {
                case MULILANG_TEXT: {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)updateDy.get(fieldName);
                    ormLocaleValue.setLocaleValue(value);
                    updateDy.set(fieldName, (Object)ormLocaleValue);
                    break;
                }
                case TEXT: {
                    updateDy.set(fieldName, (Object)value);
                    break;
                }
                case COMBO: {
                    updateDy.set(fieldName, (Object)value);
                    break;
                }
                case BOOLEAN: {
                    updateDy.set(fieldName, (Object)Boolean.parseBoolean(value));
                    break;
                }
                case DATE: {
                    updateDy.set(fieldName, (Object)new Timestamp(Long.parseLong(value)));
                    break;
                }
                case LONG: {
                    updateDy.set(fieldName, (Object)Long.parseLong(value));
                    break;
                }
                case INTEGER: 
                case BIG_INT: {
                    updateDy.set(fieldName, (Object)Integer.parseInt(value));
                    break;
                }
                case BASE_DATA: 
                case CREATER: 
                case MODIFIER: 
                case USER: 
                case CITY: 
                case MAIN_ORG: 
                case Currency: 
                case ORGPROP: 
                case QueryProp: 
                case ADDRESSPROP: {
                    BasedataProp prop = (BasedataProp)updateDy.getDynamicObjectType().getProperties().get((Object)fieldName);
                    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(prop.getBaseEntityId());
                    DynamicObject data = hrBaseServiceHelper.queryOne(BASE_PROPS, (Object)Long.valueOf(value));
                    if (HRObjectUtils.isEmpty((Object)data)) {
                        updateDy.set(fieldName, null);
                        break;
                    }
                    updateDy.set(fieldName, (Object)data);
                    break;
                }
                case MULBASEDATAPROP: {
                    updateDy.set(fieldName, (Object)ValueConvertHelper.getMulBaseDataCollection(updateDy, fieldName, value));
                    break;
                }
                case ADMIN_DIVISION: {
                    updateDy.set(fieldName, (Object)value);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0cfieldName\uff1a{0}\u3002", (String)"InfoGroupUpdateApprovalOp_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]), fieldName));
        }
    }

    public static MulBasedataDynamicObjectCollection getMulBaseDataCollection(DynamicObject updateDy, String fieldName, String value) {
        MulBasedataDynamicObjectCollection dynamicObjectCollection = new MulBasedataDynamicObjectCollection();
        if (HRStringUtils.isNotEmpty((String)value)) {
            DynamicObject[] dynamicObjects;
            String[] split = value.split(";");
            List idSet = Arrays.stream(split).map(arg -> Long.parseLong(arg)).collect(Collectors.toList());
            DynamicObjectType dynamicObjectType = updateDy.getDynamicObjectCollection(fieldName).getDynamicObjectType();
            String entityId = ((MulBasedataProp)updateDy.getDynamicObjectType().getProperties().get((Object)fieldName)).getBaseEntityId();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
            for (DynamicObject dynamicObject : dynamicObjects = helper.loadDynamicObjectArray(idSet.toArray())) {
                DynamicObject addNew = new DynamicObject(dynamicObjectType);
                addNew.set("fbasedataid", (Object)dynamicObject);
                dynamicObjectCollection.add(addNew);
            }
        }
        return dynamicObjectCollection;
    }

    public static String handleAdminDivisionField(String value) {
        if (HRStringUtils.isEmpty((String)value)) {
            return "-";
        }
        long adminDivisionId = Long.parseLong(value);
        QFilter idFilter = new QFilter("id", "=", (Object)adminDivisionId);
        DynamicObject admindivisionDynamic = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])idFilter.toArray());
        String admindivisionFullName = admindivisionDynamic != null ? admindivisionDynamic.getString("fullname") : value;
        String[] admindivisionArray = admindivisionFullName.split("_");
        StringBuilder adminDivisionBuilder = new StringBuilder();
        int length = admindivisionArray.length;
        for (int i = 0; i < length; ++i) {
            adminDivisionBuilder.append(admindivisionArray[i]);
            adminDivisionBuilder.append('/');
        }
        if (adminDivisionBuilder.length() > 0) {
            value = adminDivisionBuilder.substring(0, adminDivisionBuilder.length() - 1);
        }
        return value;
    }
}

