/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.revise.service.impl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.hr.hspm.business.repository.CommonQueryRepository;
import kd.sdk.hr.hspm.business.revise.helper.DynamicConvertUtils;
import kd.sdk.hr.hspm.business.revise.helper.ReviseEntityNameHelperEnum;
import kd.sdk.hr.hspm.business.revise.model.ReviseLogEntity;
import kd.sdk.hr.hspm.business.revise.service.IPersonReviseLogService;
import kd.sdk.hr.hspm.common.constants.PersonReviseConstants;

public class PersonReviseLogServiceImpl
implements IPersonReviseLogService,
PersonReviseConstants {
    private static final Log LOG = LogFactory.getLog(PersonReviseLogServiceImpl.class);

    @Override
    public DynamicObject getReviseVersionEntry(long id) {
        DynamicObjectCollection entryentity;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_reviselog");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject log = hrBaseServiceHelper.loadDynamicObject(qFilter);
        if (log != null && !CollectionUtils.isEmpty((Collection)(entryentity = log.getDynamicObjectCollection("entryentity")))) {
            return (DynamicObject)entryentity.get(0);
        }
        return null;
    }

    @Override
    public DynamicObject saveReviseLogDyn(DynamicObject reviseDyn, Long beforeDynId, Long afterDynId, String reviseType) {
        String reviseEntityName = reviseDyn.getDynamicObjectType().getName();
        String logEntityName = ReviseEntityNameHelperEnum.getLogEntityNameByReviseEntityName(reviseEntityName);
        DynamicObject[] reviseDynArr = CommonQueryRepository.getInstance().queryColsInfoById(reviseEntityName, Sets.newHashSet((Object[])new String[]{"id, boid, person"}), new HashSet<Long>(Arrays.asList(beforeDynId, afterDynId)));
        Long reviseRecordId = this.getReviseRecordDyn(logEntityName, reviseDynArr[0].getLong("boid"));
        return this.saveReviseLogDyn(reviseDyn, beforeDynId, afterDynId, reviseType, reviseRecordId);
    }

    private Long getReviseRecordDyn(String logEntityName, Long boId) {
        HashSet queryFields = Sets.newHashSet((Object[])new String[]{"id, boid, createtime, reviserecord"});
        QFilter reviseNumberFilter = new QFilter("revisebo", "=", (Object)boId);
        DynamicObject[] logEntityArr = CommonQueryRepository.getInstance().queryColsInfoByFilter(logEntityName, queryFields, reviseNumberFilter);
        List logEntityDynList = Arrays.stream(logEntityArr).sorted(Comparator.comparing(dyn -> dyn.getDate("createtime"))).collect(Collectors.toList());
        for (int i = logEntityDynList.size() - 1; i >= 0; --i) {
            DynamicObject logEntityDyn = (DynamicObject)logEntityDynList.get(i);
            DynamicObject reviseRecordDyn = logEntityDyn.getDynamicObject("reviserecord");
            if (!Objects.nonNull(reviseRecordDyn)) continue;
            return reviseRecordDyn.getLong("id");
        }
        return ID.genLongId();
    }

    @Override
    public DynamicObject saveReviseLogDyn(DynamicObject reviseDyn, Long beforeDynId, Long afterDynId, String reviseType, Long reviseRecordId) {
        String reviseEntityName = reviseDyn.getDynamicObjectType().getName();
        DynamicObject[] reviseDynArr = CommonQueryRepository.getInstance().loadInfoByIds(reviseEntityName, new HashSet<Long>(Arrays.asList(beforeDynId, afterDynId)));
        Map<Long, DynamicObject> idVsReviseDynMap = Arrays.stream(reviseDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        DynamicObject beforeDyn = this.getReviseDyn(beforeDynId, idVsReviseDynMap);
        DynamicObject afterDyn = this.getReviseDyn(afterDynId, idVsReviseDynMap);
        String baseEntityName = ReviseEntityNameHelperEnum.getBaseEntityNameByReviseEntityName(reviseEntityName);
        DynamicObject logEntityDyn = this.saveReviseLogDyn(reviseDyn, reviseType, baseEntityName, reviseRecordId, reviseEntityName, beforeDyn, afterDyn);
        Long personId = this.getPersonId(beforeDyn, afterDyn);
        PersonReviseLogServiceImpl.saveReviseRecordDyn(reviseRecordId, personId, baseEntityName);
        return logEntityDyn;
    }

    private DynamicObject saveReviseLogDyn(DynamicObject reviseDyn, String reviseType, String baseEntityName, Long reviseRecordId, String reviseEntityName, DynamicObject beforeDyn, DynamicObject afterDyn) {
        Long boId = this.getReviseDynBoId(beforeDyn, afterDyn);
        String logEntityName = ReviseEntityNameHelperEnum.getLogEntityNameByReviseEntityName(reviseEntityName);
        ReviseLogEntity.ReviseLogEntityBuilder reviseLogEntityBuilder = new ReviseLogEntity.ReviseLogEntityBuilder();
        ReviseLogEntity reviseLogEntity = reviseLogEntityBuilder.entityName(baseEntityName).reviseLogEntityName(logEntityName).boId(boId).before(beforeDyn).after(afterDyn).reviseType(reviseType).reviseReason(this.getReviseReasonDyn(reviseDyn)).reviseDesc(this.getReviseDesc(reviseDyn)).operateTime(new Date()).operatePersonId(RequestContext.get().getCurrUserId()).reviseRecordId(reviseRecordId).build();
        DynamicObject logEntityDyn = this.saveReviseLogDyn(reviseLogEntity);
        if ("5".equals(reviseType) && Objects.nonNull(beforeDyn) && Objects.nonNull(afterDyn)) {
            this.updateLastAfterId(logEntityName, beforeDyn, afterDyn);
        }
        return logEntityDyn;
    }

    private static void saveReviseRecordDyn(Long reviseRecordId, Long personId, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_reviserecord");
        DynamicObject reviseRecordDyn = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)reviseRecordId));
        Date date = new Date();
        if (Objects.isNull(reviseRecordDyn)) {
            DynamicObject newDyn = serviceHelper.generateEmptyDynamicObject();
            newDyn.set("id", (Object)reviseRecordId);
            newDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            newDyn.set("createtime", (Object)date);
            newDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newDyn.set("modifytime", (Object)date);
            newDyn.set("modifytime", (Object)date);
            newDyn.set("revisenumber", (Object)entityName);
            newDyn.set("recorddate", (Object)date);
            newDyn.set("issend", (Object)false);
            newDyn.set("person", (Object)personId);
            serviceHelper.save(new DynamicObject[]{newDyn});
        } else {
            reviseRecordDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            reviseRecordDyn.set("modifytime", (Object)date);
            serviceHelper.save(new DynamicObject[]{reviseRecordDyn});
        }
    }

    private void updateLastAfterId(String logEntityName, DynamicObject beforeDyn, DynamicObject afterDyn) {
        long id = afterDyn.getLong("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(logEntityName);
        QFilter reviseAfterIdFilter = new QFilter("reviseafter", "=", (Object)id);
        DynamicObject[] dynArr = helper.query("id, revisebo, reviseafter", new QFilter[]{reviseAfterIdFilter}, "createtime desc");
        if (dynArr.length > 1) {
            DynamicObject secondDyn = dynArr[1];
            secondDyn.set("reviseafter", (Object)beforeDyn.getLong("id"));
            helper.save(new DynamicObject[]{secondDyn});
        }
    }

    private Long getReviseDynBoId(DynamicObject beforeDyn, DynamicObject afterDyn) {
        Long boId = 0L;
        if (beforeDyn != null) {
            return beforeDyn.getLong("boid");
        }
        if (afterDyn != null) {
            return afterDyn.getLong("boid");
        }
        return boId;
    }

    private Long getPersonId(DynamicObject beforeDyn, DynamicObject afterDyn) {
        Long boId = 0L;
        if (beforeDyn != null) {
            return beforeDyn.getLong("person.id");
        }
        if (afterDyn != null) {
            return afterDyn.getLong("person.id");
        }
        return boId;
    }

    private DynamicObject getReviseDyn(Long id, Map<Long, DynamicObject> idVsReviseDynMap) {
        DynamicObject dyn = null;
        if (id != null && id != 0L) {
            dyn = idVsReviseDynMap.get(id);
        }
        return dyn;
    }

    private DynamicObject getReviseReasonDyn(DynamicObject dyn) {
        DynamicObject reviseReasonDyn = null;
        try {
            reviseReasonDyn = dyn.getDynamicObject("revisereason");
        }
        catch (Exception ex) {
            LOG.error("get revisereason error.", (Throwable)ex);
        }
        return reviseReasonDyn;
    }

    private String getReviseDesc(DynamicObject dyn) {
        String reviseDesc = "";
        try {
            reviseDesc = dyn.getString("revisedesc");
        }
        catch (Exception ex) {
            LOG.info("get revisedesc error.");
        }
        return reviseDesc;
    }

    private DynamicObject saveReviseLogDyn(ReviseLogEntity changeDetail) {
        DynamicObject beforeData;
        String reviseType;
        DynamicObject reviseLogDyn = new HRBaseServiceHelper(changeDetail.getReviseLogEntityName()).generateEmptyDynamicObject();
        switch (reviseType = changeDetail.getReviseType()) {
            case "0": {
                reviseLogDyn.set("revisebo", (Object)changeDetail.getAfter().getLong("boid"));
                reviseLogDyn.set("reviseafter", (Object)changeDetail.getAfter().getLong("id"));
                break;
            }
            case "1": {
                reviseLogDyn.set("revisebo", (Object)changeDetail.getBefore().getLong("boid"));
                reviseLogDyn.set("revisebefore", (Object)changeDetail.getBefore().getLong("id"));
                break;
            }
            case "5": {
                reviseLogDyn.set("revisebo", (Object)changeDetail.getBefore().getLong("boid"));
                reviseLogDyn.set("revisebefore", (Object)changeDetail.getBefore().getLong("id"));
                reviseLogDyn.set("reviseafter", (Object)changeDetail.getAfter().getLong("id"));
                break;
            }
        }
        reviseLogDyn.set("revisenumber", (Object)changeDetail.getEntityName());
        reviseLogDyn.set("revisetype", (Object)changeDetail.getReviseType());
        reviseLogDyn.set("revisereason", (Object)changeDetail.getReviseReason());
        reviseLogDyn.set("revisedesc", (Object)changeDetail.getReviseDesc());
        reviseLogDyn.set("revisedate", (Object)changeDetail.getOperateTime());
        reviseLogDyn.set("createtime", (Object)changeDetail.getOperateTime());
        reviseLogDyn.set("creator", (Object)changeDetail.getOperatePersonId());
        reviseLogDyn.set("modifytime", (Object)changeDetail.getOperateTime());
        reviseLogDyn.set("modifier", (Object)changeDetail.getOperateTime());
        reviseLogDyn.set("reviserecord", (Object)changeDetail.getReviseRecordId());
        DynamicObject afterData = changeDetail.getAfter();
        if (Objects.isNull(afterData)) {
            afterData = new HRBaseServiceHelper(changeDetail.getEntityName()).generateEmptyDynamicObject();
        }
        if (Objects.isNull(beforeData = changeDetail.getBefore())) {
            beforeData = new HRBaseServiceHelper(changeDetail.getEntityName()).generateEmptyDynamicObject();
        }
        List<String> compareExcludeFieldList = ReviseEntityNameHelperEnum.getCompareExcludeFieldList(changeDetail.getEntityName());
        DynamicConvertUtils dynamicCompareUtils = new DynamicConvertUtils(compareExcludeFieldList);
        List<DynamicConvertUtils.CompareResult> compareResults = dynamicCompareUtils.compareAndGetAllDiffCol(afterData, beforeData);
        boolean isNeedSave = false;
        if (compareResults != null && compareResults.size() > 0) {
            for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
                if (compareResult.isSame()) continue;
                isNeedSave |= true;
            }
        }
        if (isNeedSave) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reviseLogDyn});
            return reviseLogDyn;
        }
        return null;
    }
}

