/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.service;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisImportBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.ImportRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.annotation.SdkService;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hspm.business.helper.FieldPermHelper;
import kd.sdk.hr.hspm.business.helper.HpfsChgexternalrecordQueueHelper;
import kd.sdk.hr.hspm.common.constants.HspmCommonConstants;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.result.HisResponseParse;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.common.vo.BeforeCreatVo;

@SdkService(name="\u9644\u8868\u516c\u5171\u5904\u7406\u7c7b")
public class AttacheHandlerService {
    private static ThreadPool THREAD\uff3fPOOL = ThreadPools.newFixedThreadPool((String)"AttacheHandlerServiceThread", (int)3);
    private static final Log LOGGER = LogFactory.getLog(AttacheHandlerService.class);
    private static final AttacheHandlerService attacheHandlerService = new AttacheHandlerService();
    private static final Set<String> PHONE_FIELD = new HashSet<String>();
    private static final Set<String> EMAIL_FIELD = new HashSet<String>();
    private static final Set<String> PERSON_COLUMN = new HashSet<String>(Arrays.asList("name", "number"));
    private static final Set<String> FILE_COLUMN = new HashSet<String>(Arrays.asList("name", "number"));
    private static final Set<String> CARD_COLUMN = new HashSet<String>(Collections.singletonList("number"));
    private static final Set<String> PER_NO_COLUMN = new HashSet<String>(Arrays.asList("name", "birthday", "gender", "headsculpture"));
    private static final Set<String> ADDRESS_COLUMN = new HashSet<String>(Arrays.asList("countrycode", "addressinfo"));
    private static final Set<String> CONTACT_COLUMN = new HashSet<String>(Arrays.asList("peremail", "phone", "workphone"));
    private static final Map<String, Set<String>> ENTITY_FIELD_MAP = new HashMap<String, Set<String>>(16);
    private static final HRBaseServiceHelper attachServiceHelper = new HRBaseServiceHelper("bos_attachment");
    private static final Long CHGACTIONID = 1360L;
    private static final String[] PER_BASEINFO = new String[]{"hrpi_pernontsprop", "hrpi_pertsprop", "hrpi_perregion"};
    private static final String[] EDU_INFO = new String[]{"hrpi_pereduexp", "hrpi_pereduexpcert"};

    public static AttacheHandlerService getInstance() {
        return attacheHandlerService;
    }

    public Map<String, Object> getPageCustomParam(FormShowParameter formShowParameter, String entityId) {
        String tabInfo = (String)formShowParameter.getCustomParam("params");
        Map tabMap = (Map)SerializationUtils.fromJsonString((String)tabInfo, Map.class);
        LOGGER.info(MessageFormat.format("AttacheHandlerServiceGetMap:\u3010{0}\u3011,entityName:\u3010{1}\u3011", tabMap, entityId));
        return tabMap;
    }

    public Map<String, Object> buildUniqueParam(FormShowParameter formShowParameter, String entityId) {
        Map<String, Object> tabList = this.getPageCustomParam(formShowParameter, entityId);
        List origList = (List)tabList.get("groups");
        for (Map origMap : origList) {
            Map field;
            String fieldNumber;
            List fields = (List)origMap.get("fields");
            Iterator iterator = fields.iterator();
            while (iterator.hasNext() && !(fieldNumber = (String)(field = (Map)iterator.next()).get("number")).contains("-")) {
                String fieldFormId = (String)field.get("pnumber");
                field.put("origfield", fieldNumber);
                field.put("number", fieldFormId + "-" + fieldNumber);
                field.put("across_entity", "across_entity");
            }
        }
        formShowParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString(tabList));
        return tabList;
    }

    public boolean transferBoolType(BeforeCreatVo beforeCreatVo) {
        Map<String, String> relMap = beforeCreatVo.getRelMap();
        Map<String, Object> dataMap = beforeCreatVo.getDataMap();
        Map<String, Object> labMap = beforeCreatVo.getLabMap();
        String field = (String)labMap.get("number");
        String origWord = relMap.get("isexistprobation");
        int endIndex = origWord.indexOf(65306);
        if (endIndex < 0) {
            relMap.put(field, origWord + "\uff1a");
            return true;
        }
        Object obj = dataMap.get(field);
        if (((Boolean)obj).booleanValue()) {
            String message = String.format(ResManager.loadKDString((String)"%s \u662f", (String)"AttacheHandlerService_18", (String)"sdk-hr", (Object[])new Object[0]), origWord.substring(0, endIndex) + "\uff1a");
            relMap.put(field, message);
        } else {
            String message = String.format(ResManager.loadKDString((String)"%s \u5426", (String)"AttacheHandlerService_19", (String)"sdk-hr", (Object[])new Object[0]), origWord.substring(0, endIndex) + "\uff1a");
            relMap.put(field, message);
        }
        return false;
    }

    public Map<String, Object> invokeSaveOrUpdate(Map<String, DynamicObjectCollection> attachMap) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"saveOrUpdateInfo", (Object[])new Object[]{attachMap});
    }

    public Map<String, Object> invokeSaveBatch(Map<String, Object> attachMap) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{attachMap});
    }

    public Map<String, Object> invokeReviseVersion(Map<String, Object> attachMap) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"reviseVersionBatch", (Object[])new Object[]{attachMap});
    }

    public Map<String, Object> invokeDiscardBO(Map<String, Object> attachMap) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"discardBatch", (Object[])new Object[]{attachMap});
    }

    public Map<String, Object> getActionPersonalChange(Map<String, Object> params) {
        return (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getActionPersonalChange", (Object[])new Object[]{params});
    }

    public Map<String, Object> executeActionPersonalChange(Map<String, Object> params) {
        return (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"executeActionPersonalChange", (Object[])new Object[]{params});
    }

    public Map<String, Object> invokeDel(List<Long> pkIdList, String entityName, Boolean delBoFlag) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"deleteInfo", (Object[])new Object[]{pkIdList, entityName, delBoFlag});
    }

    public DynamicObjectCollection invokeAttachment(String formId, Object pkId, String appId, Map<String, Object> attachmentMap) {
        return (DynamicObjectCollection)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"saveTempAttachments", (Object[])new Object[]{formId, pkId, appId, attachmentMap});
    }

    public void invokeRemoveAttachment(String formId, Object pkId, Object fileUid) {
        HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"removeTempAttachments", (Object[])new Object[]{formId, pkId, fileUid});
    }

    public void removeAllAttachment(String formId, Object dataId) {
        QFilter[] filters = new QFilter[]{new QFilter("FBillType", "=", (Object)formId), new QFilter("FInterID", "=", (Object)dataId.toString())};
        DynamicObject[] dyArray = attachServiceHelper.query("fbilltype,FInterID,fnumber", filters);
        if (dyArray != null && dyArray.length > 0) {
            for (DynamicObject dynamicObject : dyArray) {
                this.invokeRemoveAttachment(formId, dataId, dynamicObject.getString("fnumber"));
            }
        }
    }

    public static boolean isSuccess(Map<String, Object> resultMap) {
        return resultMap != null && Boolean.TRUE.equals(resultMap.get("success"));
    }

    public Map<String, Object> wrapHandleRuleEngine(IFormView view, long erFileId, String listFormId, String type, boolean rpcType) {
        HashMap<String, Object> rpcMap = null;
        if (rpcType) {
            rpcMap = new HashMap<String, Object>(16);
        } else {
            IListView listview = (IListView)view;
            erFileId = (Long)listview.getFocusRowPkId();
        }
        HRBaseServiceHelper erFileHelper = new HRBaseServiceHelper("hspm_ermanfile");
        DynamicObject erFileDy = erFileHelper.loadSingle((Object)erFileId);
        this.handleRuleEngine(view, erFileId, erFileDy, listFormId, type, rpcMap, rpcType);
        return rpcMap;
    }

    public Tuple<Boolean, Long> handleRuleEngine(IFormView view, long erFileId, DynamicObject erFileDy, String relFormId, String type, Map<String, Object> rpcMap, boolean rpcType) {
        Map<String, Object> responseMap;
        String str = "ermanfile_pc_scene";
        if (ClientTypeEnum.EMPLOYEE_MOBILE.getCode().equals(type)) {
            str = "ermanfile_mobile_scene";
        }
        if ((responseMap = this.invokeRuleEngine(erFileDy, relFormId, str)).size() == 0 || !"200".equals(responseMap.get("responseCode"))) {
            String errorMsg = (String)responseMap.get("errorMsg");
            LOGGER.info(MessageFormat.format("ERManFileCnfError==={0}", errorMsg));
            String errorInfo = this.convertRuleEngineErrorMsg((String)responseMap.get("responseCode"));
            if (view != null) {
                view.showErrorNotification(errorInfo);
            }
            this.buildFail(rpcMap, errorInfo);
            return Tuple.create((Object)Boolean.FALSE, (Object)0L);
        }
        Tuple<Boolean, Long> cnfTup = AttacheHandlerService.getInstance().getCnfId(responseMap, relFormId, type);
        LOGGER.info(MessageFormat.format("ERManFileCnfNumber==={0}==={1}==={2}", cnfTup.item2, type, view));
        if ((Long)cnfTup.item2 == 0L) {
            String errorInfo = ResManager.loadKDString((String)"\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u8fd4\u56de\u7684\u914d\u7f6e\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AttacheHandlerService_13", (String)"sdk-hr", (Object[])new Object[0]);
            if (view != null) {
                view.showErrorNotification(errorInfo);
            }
            this.buildFail(rpcMap, errorInfo);
            return cnfTup;
        }
        boolean flag = this.queryCfgInfo(view, cnfTup, rpcMap);
        if (flag) {
            return cnfTup;
        }
        if (ClientTypeEnum.PC.getCode().equals(type) && (rpcType || !"hspm_infoapproval".equals(view.getEntityId()))) {
            this.showFileDetailPage(erFileId, cnfTup, erFileDy, view, rpcMap, rpcType, relFormId);
        }
        this.syncHandler((Long)cnfTup.item2, erFileId);
        return cnfTup;
    }

    private String convertRuleEngineErrorMsg(String responseCodeStr) {
        String errorInfo = ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5339\u914d\u4e0d\u6210\u529f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttacheHandlerService_12", (String)"sdk-hr", (Object[])new Object[0]);
        try {
            int responCode = Integer.parseInt(responseCodeStr);
            if (responCode > 500 && responCode <= 505) {
                errorInfo = ResManager.loadKDString((String)"\u89c4\u5219\u5f15\u64ce\u521d\u59cb\u5316\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AttacheHandlerService_35", (String)"sdk-hr", (Object[])new Object[0]);
            }
        }
        catch (Exception ex) {
            LOGGER.error("ERManFileCnfError convertRuleEngineErrorMsg exception {}");
        }
        return errorInfo;
    }

    private void buildFail(Map<String, Object> rpcMap, String errorInfo) {
        if (rpcMap == null) {
            return;
        }
        rpcMap.put("success", false);
        rpcMap.put("errormsg", errorInfo);
        rpcMap.put("data", null);
    }

    private void buildSuccess(Map<String, Object> rpcMap, Object data) {
        if (rpcMap == null) {
            return;
        }
        rpcMap.put("success", true);
        rpcMap.put("errormsg", null);
        rpcMap.put("data", data);
    }

    private boolean queryCfgInfo(IFormView view, Tuple<Boolean, Long> cnfTup, Map<String, Object> rpcMap) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hspm_multiviewconfig");
        QFilter qFilter = new QFilter("id", "=", cnfTup.item2);
        DynamicObject queryDy = hrBaseServiceHelper.queryOne("number,enable,id", new QFilter[]{qFilter});
        if (queryDy == null) {
            String errorInfo = ResManager.loadKDString((String)"\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u8fd4\u56de\u7684\u914d\u7f6e\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u914d\u7f6e\u65b9\u6848\u3002", (String)"AttacheHandlerService_14", (String)"sdk-hr", (Object[])new Object[0]);
            if (view != null) {
                view.showErrorNotification(errorInfo);
            }
            this.buildFail(rpcMap, errorInfo);
            return true;
        }
        if (!"1".equals(queryDy.getString("enable"))) {
            String errorInfo = ResManager.loadKDString((String)"\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u8fd4\u56de\u7684\u914d\u7f6e\u7f16\u7801\u672a\u627e\u5230\u542f\u7528\u7684\u914d\u7f6e\u65b9\u6848\u3002", (String)"AttacheHandlerService_15", (String)"sdk-hr", (Object[])new Object[0]);
            if (view != null) {
                view.showErrorNotification(errorInfo);
            }
            this.buildFail(rpcMap, errorInfo);
            return true;
        }
        return false;
    }

    private void syncHandler(long cnfId, long erFileId) {
        THREAD\uff3fPOOL.execute(() -> {
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hspm_relatedconfig");
            DynamicObject dynamicObject = baseServiceHelper.queryOne("id,ermanfile,config", new QFilter[]{new QFilter("config", "=", (Object)cnfId)});
            if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                if (erFileId == dynamicObject.getLong("ermanfile.id")) {
                    return;
                }
                dynamicObject.set("ermanfile", (Object)erFileId);
                baseServiceHelper.updateOne(dynamicObject);
            } else {
                DynamicObject newDy = baseServiceHelper.generateEmptyDynamicObject();
                newDy.set("ermanfile", (Object)erFileId);
                newDy.set("config", (Object)cnfId);
                baseServiceHelper.saveOne(newDy);
            }
        });
    }

    private void showFileDetailPage(long erFileId, Tuple<Boolean, Long> cnfTup, DynamicObject erFileDy, IFormView view, Map<String, Object> rpcMap, boolean rpcType, String relFormId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        try {
            Boolean getRule = (Boolean)cnfTup.item1;
            Long cnfId = (Long)cnfTup.item2;
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (!rpcType) {
                relFormId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
            }
            formShowParameter.setFormId(relFormId + "dv");
            formShowParameter.setCustomParam("employee", (Object)erFileDy.getLong("employee.id"));
            formShowParameter.setCustomParam("person", (Object)erFileDy.getLong("person.id"));
            formShowParameter.setCustomParam("depemp", (Object)erFileDy.getLong("depemp.id"));
            formShowParameter.setCustomParam("empentrel", (Object)erFileDy.getLong("empentrel.id"));
            formShowParameter.setCustomParam("cmpemp", (Object)erFileDy.getLong("cmpemp.id"));
            formShowParameter.setCustomParam("empposrel", (Object)erFileDy.getLong("empposrel.id"));
            formShowParameter.setCustomParam("name", (Object)erFileDy.getString("name"));
            formShowParameter.setCustomParam("businessstatus", (Object)erFileDy.getString("businessstatus"));
            formShowParameter.setCustomParam("filebusinessstatus", (Object)erFileDy.getString("businessstatus"));
            formShowParameter.setCustomParam("fileenddate", (Object)erFileDy.getString("enddate"));
            formShowParameter.setCustomParam("cnfid", (Object)cnfId);
            formShowParameter.setCustomParam("defaultrule", (Object)(getRule != false ? "defaultrule" : null));
            DynamicObject depDy = erFileDy.getDynamicObject("depemp.adminorg");
            long adminOrgId = 0L;
            if (depDy != null) {
                adminOrgId = depDy.getLong("id");
            }
            formShowParameter.setCustomParam("adminorgid", (Object)adminOrgId);
            OrmLocaleValue typeName = (OrmLocaleValue)erFileDy.get("filetype.name");
            if (typeName != null) {
                formShowParameter.setCustomParam("filetype", (Object)typeName.getLocaleValue());
            }
            formShowParameter.setCustomParam("filetypenumber", erFileDy.get("filetype.number"));
            formShowParameter.setCustomParam("erfileid", (Object)erFileId);
            if (rpcType) {
                this.buildSuccess(rpcMap, formShowParameter);
            } else {
                formShowParameter.setPageId(view.getPageId() + "_" + "hspm" + "_" + erFileId);
                view.showForm(formShowParameter);
            }
        }
        catch (Exception exc) {
            LOGGER.error("showFilePageDetailError", (Throwable)exc);
            if (exc instanceof KDException) {
                String errorInfo = ResManager.loadKDString((String)"\u6863\u6848\u8be6\u60c5\u9875\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttacheHandlerService_16", (String)"sdk-hr", (Object[])new Object[0]);
                if (view != null) {
                    view.showErrorNotification(errorInfo);
                }
                this.buildFail(rpcMap, errorInfo);
                return;
            }
            String errorInfo = ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttacheHandlerService_17", (String)"sdk-hr", (Object[])new Object[0]);
            if (view != null) {
                view.showErrorNotification(errorInfo);
            }
            this.buildFail(rpcMap, errorInfo);
        }
    }

    public Map<String, Object> invokeRuleEngine(DynamicObject erFileDy, String source, String sceneNumber) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("bizApp", "hspm");
        requestMap.put("sceneNumber", sceneNumber);
        DynamicObject dynamicObject = erFileDy.getDynamicObject("org");
        if (dynamicObject != null) {
            requestMap.put("buNumber", dynamicObject.getString("number"));
            LOGGER.info(MessageFormat.format("invokeRuleEngineOrg==={0}", dynamicObject.getString("number")));
        } else {
            LOGGER.info("invokeRuleEngineOrgEmpty");
        }
        HashMap<String, DynamicObject> paramMap = new HashMap<String, DynamicObject>(16);
        requestMap.put("inputParams", paramMap);
        Map<String, Object> responseMap = new HashMap<String, Object>(16);
        try {
            DynamicObject depEmp = null;
            DynamicObject empentrelDy = null;
            depEmp = erFileDy.getDynamicObject("depemp");
            empentrelDy = erFileDy.getDynamicObject("empentrel");
            if (!"hspmmobile".equals(source)) {
                paramMap.put("ermanfile", erFileDy);
            }
            paramMap.put("depemp", depEmp);
            paramMap.put("empentrel", empentrelDy);
            long cmpId = erFileDy.getLong("cmpemp.id");
            DynamicObject cmpemp = this.getDynamicInfo("hrpi_managingscope", cmpId, "cmpemp");
            paramMap.put("managingscope", cmpemp);
            long employId = erFileDy.getLong("employee.id");
            DynamicObject jobRel = this.getDynamicInfo("hrpi_empjobrel", employId, "employee");
            paramMap.put("empjobrel", jobRel);
            this.printInputLog(erFileDy, depEmp, empentrelDy, cmpemp, jobRel);
            responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
        }
        catch (Exception exc) {
            LOGGER.error("ERManFileListPluginInvokeRuleEngineFail", (Throwable)exc);
            LOGGER.error("ERManFileListPluginInvokeRuleEngineFailMessage", responseMap);
        }
        LOGGER.info(MessageFormat.format("ERManFileListPluginInvokeRuleEngineResult==={0}==={1}==={2}", responseMap, requestMap.get("buNumber"), source));
        return responseMap;
    }

    private void printInputLog(DynamicObject erFileDy, DynamicObject depEmp, DynamicObject empentrelDy, DynamicObject cmpemp, DynamicObject jobRel) {
        long fileId = this.getOkId(erFileDy);
        long depId = this.getOkId(depEmp);
        long eId = this.getOkId(empentrelDy);
        long cId = this.getOkId(cmpemp);
        long jobId = this.getOkId(jobRel);
        String number = null;
        if (empentrelDy != null && empentrelDy.getDataEntityType().getProperties().containsKey((Object)"empnumber")) {
            number = empentrelDy.getString("empnumber");
        }
        LOGGER.info(MessageFormat.format("ERManFileListPluginInvokeRuleEngineParams==={0}=={1}==={2}=={3}==={4}==={5}", fileId, depId, eId, cId, jobId, number));
    }

    private long getOkId(DynamicObject erFileDy) {
        long erMainId = 0L;
        if (erFileDy != null) {
            erMainId = erFileDy.getLong("id");
        }
        return erMainId;
    }

    private DynamicObject getDynamicInfo(String entityName, Long filterId, String filterField) {
        if (filterId == 0L) {
            return null;
        }
        LOGGER.info(MessageFormat.format("ERManFileListGetDynamicInfo==={0}", filterId));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter(filterField, "=", (Object)filterId);
        QFilter cuFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilter, cuFilter};
        return serviceHelper.loadDynamicObject(qFilters);
    }

    public Map<String, Object> invokeCollegeCountryRuleEngine(DynamicObject nonProp, DynamicObject erFileDy, DynamicObject collegeCountry, String sceneNumber) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("bizApp", "hspm");
        requestMap.put("sceneNumber", sceneNumber);
        if (erFileDy != null) {
            DynamicObject dynamicObject = erFileDy.getDynamicObject("org");
            if (dynamicObject != null) {
                requestMap.put("buNumber", dynamicObject.getString("number"));
            } else {
                LOGGER.info("expInvokeRuleEngineOrgEmpty");
            }
        }
        HashMap<String, DynamicObject> paramMap = new HashMap<String, DynamicObject>(16);
        requestMap.put("inputParams", paramMap);
        Map<String, Object> responseMap = new HashMap<String, Object>(16);
        try {
            if (nonProp != null) {
                DynamicObject country = nonProp.getDynamicObject("nationality");
                paramMap.put("country", country);
            }
            paramMap.put("schoolarea", collegeCountry);
            LOGGER.info(MessageFormat.format("EducationEdit==={0}", requestMap));
            responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
        }
        catch (Exception exc) {
            LOGGER.error("EducationEditFail--{0}", (Throwable)exc);
            LOGGER.error("EducationEditFailMsg--{0}", responseMap);
        }
        LOGGER.info(MessageFormat.format("EducationEditResult==={0}", responseMap));
        return responseMap;
    }

    public Tuple<Boolean, Long> getCnfId(Map<String, Object> responseMap, String relFormId, String type) {
        SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult(responseMap);
        List policyResults = sceneResult.getPolicyResults();
        if (policyResults.size() == 0) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hspm_multiviewconfig");
            String mobileType = "1";
            if (ClientTypeEnum.PC.getCode().equals(type)) {
                mobileType = "0";
            }
            QFilter qFilter = new QFilter("orinumber", "=", (Object)"1010_S");
            QFilter sFilter = new QFilter("employee", "=", (Object)mobileType);
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("id", new QFilter[]{qFilter, sFilter});
            LOGGER.info("ERManCnfIdByDefault");
            if (dynamicObject != null) {
                return Tuple.create((Object)Boolean.TRUE, (Object)dynamicObject.getLong("id"));
            }
            return Tuple.create((Object)Boolean.FALSE, (Object)0L);
        }
        for (PolicyResult policyResult : policyResults) {
            DynamicObject dynamicObject;
            Map rosterResults = policyResult.getRosterResults();
            if (rosterResults != null && rosterResults.size() > 0 && (dynamicObject = (DynamicObject)rosterResults.get("result")) != null) {
                return Tuple.create((Object)Boolean.TRUE, (Object)dynamicObject.getLong("id"));
            }
            List ruleResults = policyResult.getRuleResults();
            if (ruleResults == null || ruleResults.size() == 0) {
                long cnfId = this.handlerRule(policyResult.getDefaultResults());
                if (cnfId == 0L) continue;
                return Tuple.create((Object)Boolean.FALSE, (Object)cnfId);
            }
            for (RuleResult ruleResult : ruleResults) {
                long cnfId = this.handlerRule(ruleResult.getMatchResults());
                if (cnfId == 0L) continue;
                return Tuple.create((Object)Boolean.TRUE, (Object)cnfId);
            }
        }
        return Tuple.create((Object)Boolean.FALSE, (Object)0L);
    }

    private long handlerRule(Map<String, Object> matchResults) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hspm_multiviewconfig");
        DynamicObject dynamicObject = baseServiceHelper.generateEmptyDynamicObject();
        if (matchResults != null && matchResults.size() > 0 && (dynamicObject = (DynamicObject)matchResults.get("result")) != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    public void setMainPageStyle(IFormView view) {
        boolean main = AttacheHandlerService.getInstance().judgeIsMain(view.getFormShowParameter());
        if (main) {
            Map params = (Map)SerializationUtils.fromJsonString((String)view.getFormShowParameter().getCustomParams().get("params").toString(), Map.class);
            String pageName = (String)params.get("groupname");
            HashMap<String, Boolean> mapCal = new HashMap<String, Boolean>(16);
            HashMap mapCal2 = new HashMap(16);
            mapCal.put("collapsible", true);
            mapCal.put("text", (Boolean)new LocaleString(pageName));
            HashMap style = new HashMap();
            HashMap<String, String> margin = new HashMap<String, String>();
            margin.put("t", "-34px");
            style.put("m", margin);
            mapCal2.put("s", style);
            view.updateControlMetadata("totalpanel", mapCal);
            view.updateControlMetadata("flexpanelap2", mapCal2);
            view.setVisible(Boolean.FALSE, new String[]{"topflexpanelap", "botflexpanelap"});
            HashMap map = new HashMap(16);
            HashMap<String, String> map1 = new HashMap<String, String>(16);
            map1.put("zh_CN", "70px");
            map.put("w", map1);
            view.updateControlMetadata("edit", map);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"leftflexpanelap"});
            HashMap<String, String> map1 = new HashMap<String, String>(16);
            map1.put("btns", "1");
            map1.put("fc", "#ffffff");
            map1.put("bc", "themeColor");
            view.updateControlMetadata("edit", map1);
            view.updateControlMetadata("btnsave", map1);
            HashMap<String, String> mapCal = new HashMap<String, String>(16);
            mapCal.put("fc", "#212121");
            mapCal.put("btns", "1");
            view.updateControlMetadata("btncancel", mapCal);
        }
    }

    public void commonBtnReg(IFormView view, HRDataBaseEdit thisObj) {
        Button button = (Button)view.getControl("edit");
        Button btnsave = (Button)view.getControl("btnsave");
        Button btncancel = (Button)view.getControl("btncancel");
        button.addClickListener((ClickListener)thisObj);
        btnsave.addClickListener((ClickListener)thisObj);
        btncancel.addClickListener((ClickListener)thisObj);
    }

    public String checkIllegalInput(IFormView view, IDataModel model, List<DrawFormFieldDto> drawFormFields, Set<String> ignoreField, String acrossEntity) {
        StringBuilder error = new StringBuilder();
        try {
            List complexProperties = model.getDataEntity().getDataEntityType().getProperties().getComplexProperties(false);
            Set<String> complexSet = complexProperties.stream().map(IMetadata::getName).collect(Collectors.toSet());
            Set<String> canNotReadFields = FieldPermHelper.getCanNotReadFields(view);
            for (DrawFormFieldDto drawFormFieldDto : drawFormFields) {
                String field = drawFormFieldDto.getField();
                if (ignoreField.contains(field) || canNotReadFields.contains(field)) continue;
                this.chooseDiffType(view, model, error, complexSet, drawFormFieldDto, acrossEntity);
            }
            LOGGER.info(MessageFormat.format("checkIllegalInputErrorMessage==={0}", error));
        }
        catch (Exception exc) {
            LOGGER.error("checkIllegalInputException", (Throwable)exc);
            return null;
        }
        return error.toString();
    }

    private void chooseDiffType(IFormView view, IDataModel model, StringBuilder error, Set<String> complexSet, DrawFormFieldDto drawFormFieldDto, String acrossEntity) {
        boolean emptyValue;
        String field = drawFormFieldDto.getField();
        boolean mustInput = drawFormFieldDto.isMustInput();
        String maxSize = drawFormFieldDto.getMaxSize();
        String name = drawFormFieldDto.getName();
        String className = drawFormFieldDto.getClassSimpleName();
        String emptyTip = String.format(ResManager.loadKDString((String)"%s\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttacheHandlerService_34", (String)"sdk-hr", (Object[])new Object[0]), name);
        if ("AttachmentProp".equals(className)) {
            emptyTip = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"AttacheHandlerService_3", (String)"sdk-hr", (Object[])new Object[0]), name);
            String attachJsonString = view.getPageCache().get(drawFormFieldDto.getField());
            if (HRStringUtils.isEmpty((String)attachJsonString) && mustInput) {
                error.append(emptyTip);
                return;
            }
            if (HRStringUtils.isEmpty((String)attachJsonString)) {
                return;
            }
            List attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
            if ((attachments == null || attachments.size() == 0) && mustInput) {
                error.append(emptyTip);
                return;
            }
            return;
        }
        Object pageValue = model.getValue(field);
        if (mustInput && !complexSet.contains(field) && (emptyValue = CommonUtil.objIsEmpty(pageValue))) {
            error.append(emptyTip);
        }
        switch (className) {
            case "BasedataProp": 
            case "CityProp": 
            case "CurrencyProp": 
            case "AdminDivisionProp": 
            case "OrgProp": 
            case "AddressProp": {
                this.checkBaseData(error, name, pageValue, model, field, mustInput);
                break;
            }
            case "DecimalProp": 
            case "IntegerProp": 
            case "BigIntProp": {
                this.checkDigit(error, name, className, pageValue, mustInput);
                break;
            }
            case "TextProp": 
            case "TextAreaProp": 
            case "I18nNameProp": {
                this.checkText(error, drawFormFieldDto, pageValue, acrossEntity);
                break;
            }
            case "MuliLangTextProp": {
                if (!(pageValue instanceof OrmLocaleValue)) break;
                OrmLocaleValue localValue = (OrmLocaleValue)pageValue;
                if (!localValue.isEmpty() && HRStringUtils.isNotEmpty((String)maxSize) && localValue.getLocaleValue().length() > Integer.parseInt(maxSize)) {
                    error.append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c%2$s]\u3002", (String)"AttacheHandlerService_4", (String)"sdk-hr", (Object[])new Object[0]), name, maxSize));
                    break;
                }
                if (!(pageValue instanceof String) || !HRStringUtils.isNotEmpty((String)((String)pageValue)) || pageValue.toString().length() <= Integer.parseInt(maxSize)) break;
                error.append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c%2$s]\u3002", (String)"AttacheHandlerService_4", (String)"sdk-hr", (Object[])new Object[0]), name, maxSize));
                break;
            }
            case "BooleanProp": {
                if (pageValue == null || pageValue instanceof Boolean) break;
                error.append(String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u5f00\u5173\u63a7\u4ef6\u5b57\u7b26\u3002", (String)"AttacheHandlerService_5", (String)"sdk-hr", (Object[])new Object[0]), name));
                break;
            }
            case "ComboProp": {
                this.checkCombo(error, drawFormFieldDto, field, name, pageValue);
                break;
            }
            case "DateProp": {
                this.checkDate(view, error, field, name, pageValue);
                break;
            }
        }
    }

    private void checkText(StringBuilder error, DrawFormFieldDto drawFormFieldDto, Object pageValue, String acrossEntity) {
        String field = drawFormFieldDto.getField();
        String maxSize = drawFormFieldDto.getMaxSize();
        String name = drawFormFieldDto.getName();
        String className = drawFormFieldDto.getClassSimpleName();
        if (HRStringUtils.isNotEmpty((String)maxSize) && String.valueOf(pageValue).length() > Integer.parseInt(maxSize)) {
            boolean hasDbField = this.judgeHasDbField(drawFormFieldDto, field);
            if (hasDbField) {
                error.append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c%2$s]\u3002", (String)"AttacheHandlerService_4", (String)"sdk-hr", (Object[])new Object[0]), name, maxSize));
            }
        } else if ("TextProp".equals(className)) {
            boolean email;
            String pageStr = (String)pageValue;
            if (HRStringUtils.isEmpty((String)pageStr)) {
                return;
            }
            if (HRStringUtils.isNotEmpty((String)acrossEntity) && field.contains("-")) {
                field = field.substring(field.indexOf("-") + 1);
            }
            if (PHONE_FIELD.contains(field)) {
                String errorPhone = String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u624b\u673a\u53f7\u683c\u5f0f\u3002", (String)"AttacheHandlerService_11", (String)"sdk-hr", (Object[])new Object[0]), name, maxSize);
                this.validatePhoneStyle(error, pageStr, errorPhone);
            } else if (EMAIL_FIELD.contains(field) && !(email = BusinessUtils.isEmail(pageStr))) {
                error.append(String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u90ae\u7bb1\u683c\u5f0f\u3002", (String)"AttacheHandlerService_10", (String)"sdk-hr", (Object[])new Object[0]), name, maxSize));
            }
        }
    }

    private void validatePhoneStyle(StringBuilder error, String pageStr, String errorPhone) {
        TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)pageStr);
        if (!telephoneParseResult.isSuccess()) {
            error.append(errorPhone);
            return;
        }
        List countryList = telephoneParseResult.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])countryList.toArray(new String[0]));
        if (HRObjectUtils.isEmpty((Object)result)) {
            error.append(errorPhone);
            return;
        }
        if (!HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")))) {
            error.append(errorPhone);
        }
    }

    private boolean judgeHasDbField(DrawFormFieldDto drawFormFieldDto, String field) {
        IDataEntityProperty property;
        String alias;
        boolean hasDbField = true;
        String origPageId = drawFormFieldDto.getOrigPageId();
        Map fields = MetadataServiceHelper.getDataEntityType((String)origPageId).getAllFields();
        if (!CollectionUtils.isEmpty((Map)fields) && HRStringUtils.isEmpty((String)(alias = (property = (IDataEntityProperty)fields.get(field)).getAlias()))) {
            hasDbField = false;
        }
        return hasDbField;
    }

    private void checkDate(IFormView view, StringBuilder error, String field, String name, Object pageValue) {
        if (pageValue != null) {
            DateEdit dateEdit = (DateEdit)view.getControl(field);
            String formatString = dateEdit.getFormatString();
            boolean dataFlag = true;
            try {
                if (!(pageValue instanceof Date)) {
                    dataFlag = false;
                } else {
                    HRDateTimeUtils.format((Date)((Date)pageValue), (String)formatString);
                }
            }
            catch (Exception exc) {
                dataFlag = false;
            }
            if (!dataFlag) {
                error.append(String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u65e5\u671f\u63a7\u4ef6\u5b57\u7b26\u3002", (String)"AttacheHandlerService_6", (String)"sdk-hr", (Object[])new Object[0]), name));
            }
        }
    }

    private void checkCombo(StringBuilder error, DrawFormFieldDto drawFormFieldDto, String field, String name, Object pageValue) {
        Set comboItemSet;
        List<ComboItem> comboItem;
        if (pageValue instanceof String && HRStringUtils.isNotEmpty((String)String.valueOf(pageValue)) && (comboItem = field.contains("-") ? ComboItemUtil.getComboItem(drawFormFieldDto.getOrigPageId(), field.substring(0, field.indexOf(45))) : ComboItemUtil.getComboItem(drawFormFieldDto.getOrigPageId(), field)) != null && comboItem.size() > 0 && !(comboItemSet = comboItem.stream().map(ComboItem::getValue).collect(Collectors.toSet())).contains(pageValue)) {
            error.append(String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u4e0b\u62c9\u6846\u5b57\u7b26\u3002", (String)"AttacheHandlerService_7", (String)"sdk-hr", (Object[])new Object[0]), name));
        }
    }

    private void checkDigit(StringBuilder error, String name, String className, Object pageValue, boolean mustInput) {
        boolean numeric = true;
        try {
            if (mustInput && pageValue != null) {
                Long longValue;
                if ("DecimalProp".equals(className)) {
                    BigDecimal bigDecimal = (BigDecimal)pageValue;
                    if (bigDecimal.intValue() != 0) {
                        numeric = CommonUtil.isDecimal(String.valueOf(pageValue));
                    }
                } else if ("IntegerProp".equals(className)) {
                    Integer intValue = (Integer)pageValue;
                    if (intValue != 0) {
                        numeric = CommonUtil.isNumeric(String.valueOf(intValue));
                    }
                } else if ("BigIntProp".equals(className) && (longValue = (Long)pageValue) != 0L) {
                    numeric = CommonUtil.isNumeric(String.valueOf(longValue));
                }
            }
        }
        catch (Exception ex) {
            numeric = false;
            LOGGER.error("checkDigitError", (Throwable)ex);
        }
        if (!numeric) {
            error.append(String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u6570\u503c\u3002", (String)"AttacheHandlerService_8", (String)"sdk-hr", (Object[])new Object[0]), name));
        }
    }

    private void checkBaseData(StringBuilder error, String name, Object pageValue, IDataModel model, String field, boolean mustInput) {
        String baseObjId = null;
        if (pageValue instanceof DynamicObject) {
            DynamicObject pageDy = (DynamicObject)pageValue;
            baseObjId = pageDy.getString("id");
        } else {
            long value;
            if (pageValue != null) {
                baseObjId = String.valueOf(pageValue);
            }
            if (HRStringUtils.isEmpty(baseObjId) && model.getDataEntityType().getProperties().containsKey((Object)(field + "_id")) && (value = ((Long)model.getDataEntity().get(field + "_id")).longValue()) != 0L) {
                baseObjId = String.valueOf(value);
            }
        }
        if (HRStringUtils.isNotEmpty((String)baseObjId)) {
            boolean numeric = CommonUtil.isNumeric(baseObjId);
            if (!numeric) {
                error.append(String.format(ResManager.loadKDString((String)"%s\u503c\u4e3a\u975e\u6cd5\u57fa\u7840\u8d44\u6599\u5b57\u7b26\u3002", (String)"AttacheHandlerService_9", (String)"sdk-hr", (Object[])new Object[0]), name));
            }
        } else if (mustInput) {
            error.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttacheHandlerService_34", (String)"sdk-hr", (Object[])new Object[0]), name));
        }
    }

    @Deprecated
    public Tuple<Boolean, String> getCardCNByEN(String imageStr, String displayName, String number) {
        if ("faceimage".equals(imageStr)) {
            String imageName;
            switch (number) {
                case "1010_S": {
                    imageName = ResManager.loadKDString((String)"\u4eba\u50cf\u9762", (String)"AttacheHandlerService_21", (String)"sdk-hr", (Object[])new Object[0]);
                    break;
                }
                case "1020_S": {
                    imageName = ResManager.loadKDString((String)"\u4e2a\u4eba\u8d44\u6599\u9875", (String)"AttacheHandlerService_29", (String)"sdk-hr", (Object[])new Object[0]);
                    break;
                }
                case "1080_S": {
                    imageName = ResManager.loadKDString((String)"\u5185\u5bb9\u9875", (String)"AttacheHandlerService_30", (String)"sdk-hr", (Object[])new Object[0]);
                    break;
                }
                case "1110_S": {
                    imageName = ResManager.loadKDString((String)"\u9a7e\u9a76\u8bc1\u4e3b\u9875", (String)"AttacheHandlerService_31", (String)"sdk-hr", (Object[])new Object[0]);
                    break;
                }
                case "1120_S": 
                case "1130_S": 
                case "1140_S": {
                    imageName = ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u9762", (String)"AttacheHandlerService_20", (String)"sdk-hr", (Object[])new Object[0]);
                    break;
                }
                default: {
                    imageName = ResManager.loadKDString((String)"\u8bc1\u4ef6\u6b63\u9762", (String)"AttacheHandlerService_23", (String)"sdk-hr", (Object[])new Object[0]);
                }
            }
            return Tuple.create((Object)Boolean.TRUE, (Object)imageName);
        }
        if ("reverseimage".equals(imageStr)) {
            String imageName;
            switch (number) {
                case "1010_S": {
                    imageName = ResManager.loadKDString((String)"\u56fd\u5fbd\u9762", (String)"AttacheHandlerService_22", (String)"sdk-hr", (Object[])new Object[0]);
                    break;
                }
                case "1020_S": 
                case "1080_S": 
                case "1110_S": 
                case "1120_S": 
                case "1130_S": 
                case "1140_S": {
                    imageName = null;
                    break;
                }
                default: {
                    imageName = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53cd\u9762", (String)"AttacheHandlerService_24", (String)"sdk-hr", (Object[])new Object[0]);
                }
            }
            return Tuple.create((Object)HRStringUtils.isNotEmpty(imageName), (Object)imageName);
        }
        return Tuple.create((Object)Boolean.FALSE, null);
    }

    public Tuple<Boolean, String> getCardCNByEN(String imageStr, String displayName, long type) {
        if ("faceimage".equals(imageStr)) {
            String imageName = type == HspmCommonConstants.NUMBER_1010_ID ? ResManager.loadKDString((String)"\u4eba\u50cf\u9762", (String)"AttacheHandlerService_21", (String)"sdk-hr", (Object[])new Object[0]) : (type == HspmCommonConstants.NUMBER_1020_ID ? ResManager.loadKDString((String)"\u4e2a\u4eba\u8d44\u6599\u9875", (String)"AttacheHandlerService_29", (String)"sdk-hr", (Object[])new Object[0]) : (type == HspmCommonConstants.NUMBER_1080_ID ? ResManager.loadKDString((String)"\u5185\u5bb9\u9875", (String)"AttacheHandlerService_30", (String)"sdk-hr", (Object[])new Object[0]) : (type == HspmCommonConstants.NUMBER_1110_ID ? ResManager.loadKDString((String)"\u9a7e\u9a76\u8bc1\u4e3b\u9875", (String)"AttacheHandlerService_31", (String)"sdk-hr", (Object[])new Object[0]) : (type == HspmCommonConstants.NUMBER_1120_ID || type == HspmCommonConstants.NUMBER_1130_ID || type == HspmCommonConstants.NUMBER_1140_ID ? ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\u9762", (String)"AttacheHandlerService_20", (String)"sdk-hr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bc1\u4ef6\u6b63\u9762", (String)"AttacheHandlerService_23", (String)"sdk-hr", (Object[])new Object[0])))));
            return Tuple.create((Object)Boolean.TRUE, (Object)imageName);
        }
        if ("reverseimage".equals(imageStr)) {
            Object imageName = type == HspmCommonConstants.NUMBER_1010_ID ? ResManager.loadKDString((String)"\u56fd\u5fbd\u9762", (String)"AttacheHandlerService_22", (String)"sdk-hr", (Object[])new Object[0]) : (type == HspmCommonConstants.NUMBER_1020_ID || type == HspmCommonConstants.NUMBER_1080_ID || type == HspmCommonConstants.NUMBER_1110_ID || type == HspmCommonConstants.NUMBER_1120_ID || type == HspmCommonConstants.NUMBER_1130_ID || type == HspmCommonConstants.NUMBER_1140_ID ? null : ResManager.loadKDString((String)"\u8bc1\u4ef6\u53cd\u9762", (String)"AttacheHandlerService_24", (String)"sdk-hr", (Object[])new Object[0]));
            return Tuple.create((Object)HRStringUtils.isNotEmpty((String)imageName), (Object)imageName);
        }
        return Tuple.create((Object)Boolean.FALSE, null);
    }

    public void saveHeadsCulpture(String personId, Object newValue) {
        HashMap<String, DynamicObjectCollection> saveOrUpdateMap = new HashMap<String, DynamicObjectCollection>(16);
        HashSet<Long> updateBoIds = new HashSet<Long>();
        Map<String, DynamicObjectCollection> attachMap = this.savePicture("hrpi_person", personId, newValue, saveOrUpdateMap, updateBoIds);
        Map<String, DynamicObjectCollection> finalMap = this.savePicture("hrpi_pernontsprop", personId, newValue, attachMap, updateBoIds);
        Map<String, Object> resultMap = this.invokeSaveOrUpdate(finalMap);
        if (((Boolean)resultMap.get("success")).booleanValue()) {
            AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(Long.parseLong(personId)));
            AttacheHandlerService.getInstance().sendHpfsChgSaveOrUpdateRecord(finalMap, updateBoIds, "hspm_dynfilehead");
        }
    }

    private Map<String, DynamicObjectCollection> savePicture(String pageNumber, String personId, Object newValue, Map<String, DynamicObjectCollection> saveOrUpdateMap, HashSet<Long> updateBoIds) {
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper(pageNumber);
        DynamicObject personDy = null;
        if (HRStringUtils.equals((String)pageNumber, (String)"hrpi_person")) {
            personDy = personHelper.loadSingle((Object)personId);
        } else if (HRStringUtils.equals((String)pageNumber, (String)"hrpi_pernontsprop")) {
            QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
            personDy = personHelper.loadDynamicObject(new QFilter[]{qFilter, statusFilter, new QFilter("person", "=", (Object)Long.parseLong(personId))});
        }
        if (personDy == null) {
            return saveOrUpdateMap;
        }
        updateBoIds.add(personDy.getLong("boid"));
        personDy.set("headsculpture", newValue);
        DynamicObject personDy1 = personHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)personDy, (DynamicObject)personDy1);
        personDy1.set("id", (Object)0);
        DynamicObjectCollection personDys = new DynamicObjectCollection();
        personDys.add((Object)personDy1);
        saveOrUpdateMap.put(pageNumber, personDys);
        return saveOrUpdateMap;
    }

    public static void containFlex(IFormView view, String contentName) {
        FormRoot fr = (FormRoot)view.getRootControl();
        List items = fr.getItems();
        Optional<Control> opt = items.stream().filter(val -> contentName.equals(val.getKey())).findAny();
        if (!opt.isPresent()) {
            String errorInfo = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u201c{0}\u201d\u7f3a\u5c11\u88ab\u547d\u540d\u4e3a\u201c{1}\u201d\u7684\u521d\u59cb\u5316\u9762\u677f\u3002", (String)"AttacheHandlerService_25", (String)"sdk-hr", (Object[])new Object[0]), view.getEntityId(), contentName);
            throw new KDBizException(errorInfo);
        }
    }

    public Map<String, Object> invokeHisNonLineImportData(String importtype, DynamicObject[] importSaveDys) {
        HisImportBo hisImportBo = new HisImportBo();
        hisImportBo.setImportType(importtype);
        hisImportBo.setDataEntities(importSaveDys);
        HisResponse importRespDataHisResponse = HisModelController.getInstance().hisNonLineImportData(hisImportBo);
        return HisResponseParse.parseImportRespData((HisResponse<ImportRespData>)importRespDataHisResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> invokeHisImportDataByBatchEventid(Map<String, DynamicObjectCollection> attachMap, long eventId) {
        if (null != attachMap && !attachMap.isEmpty()) {
            Map<String, Object> result;
            try (TXHandle txHandle = TX.required();){
                HisVersionParamListBo params = this.createParams(attachMap, eventId);
                HisResponse response = HisModelController.getInstance().batchHisVersionChange(params);
                result = HisResponseParse.parseBatchVersionChangeRespData((HisResponse<BatchVersionChangeRespData>)response);
            }
            return result;
        }
        return HisResponseParse.getFail("param is empty.");
    }

    private HisVersionParamListBo createParams(Map<String, DynamicObjectCollection> attachMap, long eventId) {
        HisVersionParamListBo listBo = new HisVersionParamListBo();
        listBo.setEffImmediately(true);
        listBo.setAtomicTrans(true);
        listBo.setEventId(Long.valueOf(eventId));
        ArrayList<HisVersionParamBo> paramBoList = new ArrayList<HisVersionParamBo>(attachMap.size());
        listBo.setListHisVersionParamBo(paramBoList);
        return this.handleData(attachMap, listBo, paramBoList);
    }

    private HisVersionParamListBo handleData(Map<String, DynamicObjectCollection> attachMap, HisVersionParamListBo listBo, List<HisVersionParamBo> paramBoList) {
        for (Map.Entry<String, DynamicObjectCollection> dyInfo : attachMap.entrySet()) {
            HisVersionParamBo paramBo = new HisVersionParamBo();
            String entityName = dyInfo.getKey();
            DynamicObjectCollection dyCollection = dyInfo.getValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            IDataEntityProperty effectiveProp = dataEntityType.findProperty("bsed");
            long[] pkIds = this.getORMHelper().genLongIds(entityName, dyCollection.size());
            for (int i = 0; i < dyCollection.size(); ++i) {
                DynamicObject dyCol = (DynamicObject)dyCollection.get(i);
                if (dyCol.getLong("boid") > 0L || dyCol.getLong("id") == 0L) {
                    dyCol.set("id", (Object)pkIds[i]);
                }
                if (null == effectiveProp) continue;
                dyCollection.forEach(dy -> dy.set("bsed", (Object)new Date()));
            }
            this.setMainBo(listBo, entityName, pkIds);
            paramBo.setEntityNumber(entityName);
            paramBo.setHisDyns((DynamicObject[])dyCollection.toArray((Object[])new DynamicObject[0]));
            paramBoList.add(paramBo);
        }
        listBo.setListHisVersionParamBo(paramBoList);
        return listBo;
    }

    public ORM getORMHelper() {
        return new ORMImpl();
    }

    private void setMainBo(HisVersionParamListBo listBo, String entityName, long[] pkIds) {
        if (null == listBo.getMainBoId() && HRStringUtils.isEmpty((String)listBo.getMainEntityNumber())) {
            listBo.setMainBoId(Long.valueOf(pkIds[0]));
            listBo.setMainEntityNumber(entityName);
        }
    }

    public Style setPadding(FlexPanelAp centerMainAp, String top, String bot, String left, String right) {
        Style style = new Style();
        Padding padding = new Padding();
        if (HRStringUtils.isNotEmpty((String)left)) {
            padding.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)top)) {
            padding.setTop(top);
        }
        if (HRStringUtils.isNotEmpty((String)bot)) {
            padding.setBottom(bot);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            padding.setRight(right);
        }
        style.setPadding(padding);
        centerMainAp.setStyle(style);
        return style;
    }

    public Style setMargin(FlexPanelAp centerMainAp, String top, String bot, String left, String right) {
        Margin margin = new Margin();
        Style style = new Style();
        if (HRStringUtils.isNotEmpty((String)bot)) {
            margin.setBottom(bot);
        }
        if (HRStringUtils.isNotEmpty((String)top)) {
            margin.setTop(top);
        }
        if (HRStringUtils.isNotEmpty((String)left)) {
            margin.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            margin.setRight(right);
        }
        style.setMargin(margin);
        centerMainAp.setStyle(style);
        return style;
    }

    public Style setBorder(FlexPanelAp mainSubAp, String top, String bot, String left, String right) {
        Border border = new Border();
        Style style = new Style();
        if (HRStringUtils.isNotEmpty((String)top)) {
            border.setTop(top);
        }
        if (HRStringUtils.isNotEmpty((String)left)) {
            border.setLeft(left);
        }
        if (HRStringUtils.isNotEmpty((String)bot)) {
            border.setBottom(bot);
        }
        if (HRStringUtils.isNotEmpty((String)right)) {
            border.setRight(right);
        }
        style.setBorder(border);
        mainSubAp.setStyle(style);
        return style;
    }

    public boolean judgeIsMain(FormShowParameter formShowParameter) {
        String type = (String)formShowParameter.getCustomParam("type");
        return HRStringUtils.isNotEmpty((String)type) && "mainentry".equals(type);
    }

    public boolean checkPkId(IFormView view, Long pKId, String cacheKey) {
        try {
            Set pkIdSet;
            String pkIdCacheStr;
            String pkId = (String)view.getFormShowParameter().getCustomParam("pkid");
            if (HRStringUtils.isNotEmpty((String)pkId) && "formidset".equals(cacheKey)) {
                pKId = Long.parseLong(pkId);
            }
            if (HRStringUtils.isNotEmpty((String)(pkIdCacheStr = view.getPageCache().get(cacheKey))) && !CollectionUtils.isEmpty((Collection)(pkIdSet = (Set)SerializationUtils.fromJsonString((String)pkIdCacheStr, Set.class))) && !pkIdSet.contains(pKId) && pKId != 0L) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u975e\u6cd5\u64cd\u4f5c\u5f53\u524d\u6570\u636e\u3002", (String)"AttacheHandlerService_32", (String)"sdk-hr", (Object[])new Object[0]));
                return true;
            }
        }
        catch (Exception esc) {
            LOGGER.error("beforeClickError", (Throwable)esc);
            return false;
        }
        return false;
    }

    public void sendChangeInfoSyncToSysUser(List<Long> personId) {
        LOGGER.info("sendChangeInfoSyncToSysUserStart");
        THREAD\uff3fPOOL.execute(() -> {
            ArrayList userList = new ArrayList(10);
            for (Long id : personId) {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                temp.put("personid", id);
                temp.put("synctype", "update");
                userList.add(temp);
            }
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"syncPersonToSysUer", (Object[])new Object[]{userList});
            LOGGER.info(MessageFormat.format("entityName,syncPersonToSysUer:[{0}]", result));
        });
    }

    public List<Long> validateSyncFieldsDelChange(String entityName, DynamicObject[] dataEntities) {
        return this.validateSyncFieldsDelChange(entityName, Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person.id"))));
    }

    public List<Long> validateSyncFieldsDelChange(String entityName, Map<Long, Long> pkPersonIdMap) {
        try {
            Set<String> setFields = ENTITY_FIELD_MAP.get(entityName);
            if (setFields != null && setFields.size() > 0) {
                Set<Long> longs = pkPersonIdMap.keySet();
                QFilter qFilter = new QFilter("id", "in", longs);
                QFilter typeFilter = null;
                if ("hrpi_percre".equals(entityName)) {
                    typeFilter = new QFilter("credentialstype", "=", (Object)1010);
                } else if ("hrpi_peraddress".equals(entityName)) {
                    typeFilter = new QFilter("addresstype", "=", (Object)1010);
                }
                if (typeFilter == null) {
                    return null;
                }
                QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                DynamicObject[] typeDy = this.getBaseInfoList(entityName, new QFilter[]{qFilter, typeFilter, statusFilter}, "id,person");
                if (typeDy != null && typeDy.length > 0) {
                    return Arrays.stream(typeDy).map(dy -> dy.getLong("person")).collect(Collectors.toList());
                }
            }
        }
        catch (Exception esc) {
            LOGGER.error("validateSyncFieldsDelChange", (Throwable)esc);
            return null;
        }
        return null;
    }

    public boolean validateSyncFieldsUpdateChange(String entityName, DynamicObject[] dataEntities, long personId) {
        HashMap<String, DynamicObjectCollection> datas = new HashMap<String, DynamicObjectCollection>(16);
        datas.put(entityName, Arrays.stream(dataEntities).collect(Collectors.toCollection(DynamicObjectCollection::new)));
        return this.validateSyncFieldsUpdateChange(datas, personId, true);
    }

    public boolean validateSyncFieldsUpdateChange(Map<String, DynamicObjectCollection> datas, long personId, boolean validDb) {
        if (datas == null || datas.size() == 0) {
            return false;
        }
        try {
            for (Map.Entry<String, DynamicObjectCollection> tmpMap : datas.entrySet()) {
                String entityName = tmpMap.getKey();
                if (ENTITY_FIELD_MAP.get(entityName) == null) continue;
                DynamicObjectCollection dys = tmpMap.getValue();
                Set<String> fieldSet = ENTITY_FIELD_MAP.get(entityName);
                String fieldStr = CommonUtil.listToString(new ArrayList<String>(fieldSet), ',');
                DynamicObject dbDy = null;
                QFilter personIdFilter = new QFilter("person", "=", (Object)personId);
                if ("hrpi_percre".equals(entityName)) {
                    if (validDb) {
                        dbDy = this.getBaseInfo(entityName, new QFilter("credentialstype", "=", (Object)1010), personIdFilter, fieldStr);
                    }
                    if (!this.judgeCustomTypeChange(dys, dbDy, "credentialstype.id", fieldSet, validDb)) continue;
                    return true;
                }
                if ("hrpi_peraddress".equals(entityName)) {
                    if (validDb) {
                        dbDy = this.getBaseInfo(entityName, new QFilter("addresstype", "=", (Object)1010), personIdFilter, fieldStr);
                    }
                    if (!this.judgeCustomTypeChange(dys, dbDy, "addresstype.id", fieldSet, validDb)) continue;
                    return true;
                }
                if ("hrpi_person".equals(entityName)) {
                    personIdFilter = new QFilter("id", "=", (Object)personId);
                }
                if (!this.judgeCustomTypeChange(dys, dbDy = this.getBaseInfo(entityName, null, personIdFilter, fieldStr), null, fieldSet, validDb)) continue;
                return true;
            }
        }
        catch (Exception esc) {
            LOGGER.error("validateSyncFieldsUpdateChange", (Throwable)esc);
            return true;
        }
        return false;
    }

    private boolean judgeCustomTypeChange(DynamicObjectCollection dys, DynamicObject dbDy, String field, Set<String> fields, boolean validDb) throws Exception {
        if (dys != null && dys.size() > 0) {
            for (DynamicObject dy : dys) {
                if (HRStringUtils.isNotEmpty((String)field) && !validDb && dy.getLong(field) == 1010L) {
                    return true;
                }
                if (HRStringUtils.isNotEmpty((String)field)) {
                    if (dy.getLong(field) != 1010L) continue;
                    if (dbDy == null) {
                        return true;
                    }
                }
                for (String validateField : fields) {
                    if (CommonUtil.customObjectEquals(dy.get(validateField), dbDy.get(validateField), "yyyy-MM-dd")) continue;
                    return true;
                }
            }
        } else if (dbDy != null) {
            return true;
        }
        return false;
    }

    private DynamicObject getBaseInfo(String entityName, QFilter qFilter, QFilter personIdFilter, String fields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        if (qFilter != null) {
            statusFilter.and(qFilter);
        }
        if (personIdFilter != null) {
            statusFilter.and(personIdFilter);
        }
        return serviceHelper.queryOne(fields, new QFilter[]{statusFilter});
    }

    private DynamicObject[] getBaseInfoList(String entityName, QFilter[] qFilters, String fields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.queryOriginalArray(fields, qFilters);
    }

    public void sendHpfsChgSaveOrUpdateRecord(Map<String, DynamicObjectCollection> attachMap, Set<Long> updateBoId, String formId) {
        LOGGER.info("sendHpfsChgSaveOrUpdateRecordStart");
        THREAD\uff3fPOOL.execute(() -> {
            boolean conPerson = false;
            Set entitySet = attachMap.keySet();
            if (!CollectionUtils.isEmpty(entitySet) && entitySet.contains("hrpi_person") && entitySet.contains("hrpi_pernontsprop")) {
                conPerson = true;
            }
            for (Map.Entry entry : attachMap.entrySet()) {
                DynamicObjectCollection value;
                String entityName = (String)entry.getKey();
                PersonModelClassificationEnum classification = PersonModelUtil.getClassification(entityName);
                if (conPerson && ("hrpi_person".equals(entityName) || "hrpi_pernontsprop".equals(entityName)) || PersonModelClassificationEnum.PERATTACHED != classification && !"hrpi_empjobrel".equals(entityName) && !"hrpi_person".equals(entityName) && !"hrpi_perserlen".equals(entityName) || (value = (DynamicObjectCollection)entry.getValue()) == null || value.size() <= 0) continue;
                for (DynamicObject sendDy : value) {
                    long boId = sendDy.getLong("boid");
                    if (updateBoId != null && updateBoId.contains(boId)) {
                        HpfsChgexternalrecordQueueHelper.sendHisNonLineUpdateMsg(sendDy, entityName, formId);
                        continue;
                    }
                    HpfsChgexternalrecordQueueHelper.sendHisNonLineInsertMsg(sendDy, entityName, formId);
                }
            }
            if (conPerson) {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)attachMap.get("hrpi_person");
                DynamicObjectCollection nonDys = (DynamicObjectCollection)attachMap.get("hrpi_pernontsprop");
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    HashMap<String, DynamicObjectCollection> sendMap = new HashMap<String, DynamicObjectCollection>(16);
                    sendMap.put("hrpi_person", dynamicObjects);
                    sendMap.put("hrpi_pernontsprop", nonDys);
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
                    long personId = dynamicObject.getLong("boid");
                    HpfsChgexternalrecordQueueHelper.createNoPropInsertOrUpdateMsg(personId, sendMap, "hrpi_pernontsprop");
                }
            }
            LOGGER.info("sendHpfsChgSaveOrUpdateRecordEnd");
        });
    }

    public void sendHpfsChgDeleteRecord(DynamicObject[] dyArr, String entityName, String formId) {
        LOGGER.info("sendHpfsChgDeleteRecordStart");
        THREAD\uff3fPOOL.execute(() -> {
            HpfsChgexternalrecordQueueHelper.sendBatchHisNonLineDeleteMsg(dyArr, entityName, formId);
            LOGGER.info("sendHpfsChgDeleteRecordEnd");
        });
    }

    public Map<String, Object> invokeSaveOrUpdate(IFormView view, Map<String, DynamicObjectCollection> attachMap, boolean closeView, String entityName, String type) {
        LOGGER.info("invokeSaveOrUpdate#entityName={},type={}", (Object)entityName, (Object)type);
        String isAttachChanged = view.getPageCache().get("isAttachChanged");
        if ("0".equals(isAttachChanged) && ("0".equals(type) || "-1".equals(type))) {
            attachMap = this.handlerFieldValueChange(view, attachMap, null);
        }
        Map<String, Object> resultMap = null;
        if (attachMap == null || attachMap.size() == 0) {
            LOGGER.warn("AttachInvokeEmpty=====%s", (Object)entityName);
            HashMap<String, Object> retMap = new HashMap<String, Object>(16);
            retMap.put("success", Boolean.TRUE);
            if (!closeView) {
                return retMap;
            }
            this.closeView(view, retMap, view.getParentView());
        }
        Set<Long> updateBoId = BusinessUtils.getUpdateBoIdGenPkId(attachMap, true);
        try {
            Long personId = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person"));
            boolean syncFlag = AttacheHandlerService.getInstance().validateSyncFieldsUpdateChange(attachMap, personId, true);
            LOGGER.info(MessageFormat.format("entityName[{0}] invokeSaveOrUpdate", entityName));
            if (this.isEmpJobRelInfo(entityName, type).booleanValue()) {
                PerChgBizResult perChgBizResult;
                String errMsg;
                Object retDataObj;
                Map<String, Object> params = this.assembleInputParams(view, attachMap, entityName);
                if (params == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u88c5\u64cd\u4f5c\u578b\u4e8b\u52a1\u751f\u6548\u63a5\u53e3\u5165\u53c2\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttacheHandlerService_33", (String)"sdk-hr", (Object[])new Object[0]));
                    return null;
                }
                resultMap = AttacheHandlerService.getInstance().executeActionPersonalChange(params);
                Object statusObj = resultMap.get("success");
                if (!((Boolean)statusObj).booleanValue()) {
                    view.showErrorNotification((String)resultMap.get("errorMsg"));
                    LOGGER.info("executeActionPersonalChange#error={},resultMap={}", (Object)SerializationUtils.toJsonString(params), resultMap);
                    return null;
                }
                if (((Boolean)statusObj).booleanValue() && (retDataObj = resultMap.get("data")) instanceof PerChgBizResult && HRStringUtils.isNotEmpty((String)(errMsg = (perChgBizResult = (PerChgBizResult)retDataObj).getErrMsg()))) {
                    view.showErrorNotification(errMsg);
                    return null;
                }
                LOGGER.info("executeActionPersonalChange#params={},resultMap={}", (Object)SerializationUtils.toJsonString(params), resultMap);
            } else {
                resultMap = AttacheHandlerService.getInstance().invokeSaveOrUpdate(attachMap);
            }
            LOGGER.info(MessageFormat.format("entityName[{0}] invokeSaveOrUpdate result:[{1}]", entityName, resultMap));
            if (((Boolean)resultMap.get("success")).booleanValue() && syncFlag) {
                AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(Collections.singletonList(personId));
            }
            if (!this.isEmpJobRelInfo(entityName, type).booleanValue() && ((Boolean)resultMap.get("success")).booleanValue() && view.getModel().getDataChanged()) {
                String tmpFormId = "dialogpagenumber";
                if ("across_entity".equals(entityName)) {
                    tmpFormId = "pagenumber";
                }
                String formId = AttacheHandlerService.getInstance().getRealFormId(view, tmpFormId, false);
                AttacheHandlerService.getInstance().sendHpfsChgSaveOrUpdateRecord(attachMap, updateBoId, formId);
            }
        }
        catch (Exception exc) {
            LOGGER.error("AttachInvokeSaveException", (Throwable)exc);
            view.showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u8c03\u7528\u4e2d\u53f0\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractFormDrawEdit_3", (String)"sdk-hr", (Object[])new Object[0]));
            return resultMap;
        }
        if (!closeView) {
            return resultMap;
        }
        this.closeView(view, resultMap, view.getParentView());
        return resultMap;
    }

    private Boolean isEmpJobRelInfo(String entityName, String type) {
        if (HRStringUtils.isEmpty((String)entityName)) {
            throw new KDException((Throwable)new RuntimeException(), new ErrorCode("isEmpJobRelInfo", "entityName is not empty"), new Object[0]);
        }
        if (HRStringUtils.equals((String)"hrpi_empjobrel", (String)entityName) && !HRStringUtils.equals((String)"0", (String)type)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Map<String, Object> assembleInputParams(IFormView view, Map<String, DynamicObjectCollection> attachMap, String entityName) {
        DynamicObject dynamicObject;
        DynamicObjectCollection dynamicObjects;
        if (attachMap != null && (dynamicObjects = attachMap.get(entityName)) != null && (dynamicObject = (DynamicObject)dynamicObjects.stream().findFirst().orElse(null)) != null) {
            String chgField = view.getPageCache().get("hspm_empjobrel_dg");
            if (HRStringUtils.isEmpty((String)chgField)) {
                LOGGER.info("assembleInputParamsPrint#field={}", (Object)chgField);
                return null;
            }
            Map data = (Map)SerializationUtils.fromJsonString((String)chgField, Map.class);
            if (HRMapUtils.isEmpty((Map)data)) {
                LOGGER.info("assembleInputParamsPrint#params={}", (Object)data);
                return null;
            }
            Map empJobRelMap = (Map)data.get("hrpi_empjobrel");
            if (HRMapUtils.isEmpty((Map)empJobRelMap)) {
                LOGGER.info("assembleInputParamsPrint#empjobparams={}", (Object)empJobRelMap);
                return null;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            Set sendKeySet = empJobRelMap.keySet();
            HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
            for (String sendKey : sendKeySet) {
                if (HRStringUtils.isEmpty((String)sendKey)) continue;
                Object valueObj = dynamicObject.get(sendKey);
                if (valueObj instanceof DynamicObject) {
                    DynamicObject valueDy = (DynamicObject)valueObj;
                    valueMap.put("1310_S_empjobrel_" + sendKey, valueDy.getLong("id"));
                    continue;
                }
                valueMap.put("1310_S_empjobrel_" + sendKey, valueObj);
            }
            params.put("personId", HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("person")));
            params.put("employeeId", HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("employee")));
            params.put("cmpEmpId", HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("cmpemp")));
            params.put("depEmpId", HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("depemp")));
            params.put("erManFileId", HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("erfileid")));
            params.put("chgActionId", BusinessUtils.queryEmpJobRelActionId());
            if (PropertyHelper.existProperty(dynamicObject, "startdate")) {
                params.put("effectTime", ((Date)dynamicObject.get("startdate")).getTime());
            } else {
                params.put("effectTime", System.currentTimeMillis());
            }
            params.put("scheduleIdsMap", null);
            params.put("valueMap", valueMap);
            return params;
        }
        return null;
    }

    public Map<String, DynamicObjectCollection> handlerFieldValueChange(IFormView view, Map<String, DynamicObjectCollection> attachMap, String acrossEntity) {
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        for (Map.Entry<String, DynamicObjectCollection> entry : attachMap.entrySet()) {
            String tempName = entry.getKey();
            DynamicObjectCollection dynamics = attachMap.get(tempName);
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            IPageCache pageCache = view.getPageCache();
            String content = pageCache.get(tempName + "oldDbData");
            String fields = pageCache.get(tempName + "queryFields");
            if (HRStringUtils.isEmpty((String)content) || HRStringUtils.isEmpty((String)fields)) {
                retMap.put(tempName, dynamics);
                continue;
            }
            Map pageDbData = (Map)SerializationUtils.fromJsonString((String)content, Map.class);
            List queryFields = (List)SerializationUtils.fromJsonString((String)fields, List.class);
            DynamicObject dataEntity = view.getModel().getDataEntity();
            for (DynamicObject dynamicObject : dynamics) {
                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                for (String field : queryFields) {
                    boolean contKey;
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
                    if (property == null) continue;
                    String baseName = property.getName();
                    String name = property.getName();
                    boolean readOnly = property.getReadOnly();
                    if (HRStringUtils.isNotEmpty((String)acrossEntity)) {
                        contKey = pageDbData.containsKey(tempName + "-" + name);
                        baseName = tempName + "-" + baseName;
                        name = tempName + "-" + name;
                    } else {
                        contKey = pageDbData.containsKey(name);
                    }
                    if (!contKey || readOnly) continue;
                    if (DynamicObject.class.equals((Object)property.getPropertyType())) {
                        baseName = baseName + "_id";
                    }
                    boolean sameWord = false;
                    try {
                        sameWord = CommonUtil.customObjectEquals(dataEntity.get(baseName), pageDbData.get(name), "yyyy-MM-dd");
                    }
                    catch (Exception exc) {
                        LOGGER.error("handlerFieldValueChange===", (Object)tempName);
                        LOGGER.error("handlerFieldValueChangeException===", (Throwable)exc);
                    }
                    if (sameWord) continue;
                    dynamicObjects.add((Object)dynamicObject);
                    break;
                }
                LOGGER.info(MessageFormat.format("recordDataChanged==={0}==={1}", tempName, view.getModel().getDataChanged()));
            }
            if (dynamicObjects.size() <= 0) continue;
            retMap.put(tempName, dynamicObjects);
        }
        return retMap;
    }

    public void closeView(IFormView view, Map<String, Object> resultMap, IFormView parentView) {
        if (((Boolean)resultMap.get("success")).booleanValue()) {
            view.getParentView().updateView();
            view.sendFormAction(view.getParentView());
            view.close();
        } else {
            view.showErrorNotification((String)resultMap.get("message"));
        }
    }

    public String getRealFormId(IFormView view, String dialogPageNumber, boolean viewFlag) {
        String tabInfo = (String)view.getFormShowParameter().getCustomParam("params");
        if (HRStringUtils.isEmpty((String)tabInfo)) {
            LOGGER.info(MessageFormat.format("paramTabInfo===={0}", tabInfo));
            if (viewFlag) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u53c2\u6570\u6709\u8bef", (String)"AbstractCardDrawEdit_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        Map tabMap = (Map)SerializationUtils.fromJsonString((String)tabInfo, Map.class);
        String formId = (String)tabMap.get(dialogPageNumber);
        if (HRStringUtils.isEmpty((String)formId)) {
            LOGGER.info(MessageFormat.format("paramFormId===={0}", tabInfo));
            if (viewFlag) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u6570\u636e\u6709\u8bef", (String)"AbstractCardDrawEdit_11", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        return formId;
    }

    public RoundingMode getRoundingMode(String fieldKey) {
        HashSet yearFields = Sets.newHashSet((Object[])new String[]{"adjustcomtime", "adjustlength", "adjustworktime", "comsercount", "entservicelen", "servicelen", "servicelength", "socialworkage"});
        for (String yearField : yearFields) {
            if (!fieldKey.contains(yearField)) continue;
            return RoundingMode.DOWN;
        }
        return RoundingMode.HALF_UP;
    }

    static {
        PHONE_FIELD.add("phone");
        EMAIL_FIELD.add("peremail");
        EMAIL_FIELD.add("busemail");
        ENTITY_FIELD_MAP.put("hrpi_person", PERSON_COLUMN);
        ENTITY_FIELD_MAP.put("hspm_ermanfile", FILE_COLUMN);
        ENTITY_FIELD_MAP.put("hrpi_pernontsprop", PER_NO_COLUMN);
        ENTITY_FIELD_MAP.put("hrpi_percre", CARD_COLUMN);
        ENTITY_FIELD_MAP.put("hrpi_peraddress", ADDRESS_COLUMN);
        ENTITY_FIELD_MAP.put("hrpi_percontact", CONTACT_COLUMN);
    }
}

