/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.business.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dlock.DLock;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkService;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.enums.ConfigAreaEnum;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;

@SdkService(name="\u4fe1\u606f\u7ec4\u670d\u52a1")
public class PageRegConfigService {
    private static final PageRegConfigService pageRegConfigService = new PageRegConfigService();
    private static final Log logger = LogFactory.getLog(PageRegConfigService.class);
    private static final String CONFCACHEKEY_VERSION = "version0";

    public static PageRegConfigService getInstance() {
        return pageRegConfigService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getInfoGroupConfig(long cnfId, String source, String preView) {
        Map cacheMap;
        QFilter statusFilter;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hspm_multiviewconfig");
        QFilter qFilter = new QFilter("id", "=", (Object)cnfId);
        if (HRStringUtils.isEmpty((String)preView)) {
            statusFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(statusFilter);
        }
        statusFilter = ClientTypeEnum.PC.getCode().equals(source) ? new QFilter("employee", "=", (Object)"0") : new QFilter("employee", "=", (Object)"1");
        qFilter.and(statusFilter);
        DynamicObject cnfDy = hrBaseServiceHelper.queryOriginalOne("modifytime", new QFilter[]{qFilter});
        if (cnfDy == null) {
            return null;
        }
        String modTime = cnfDy.getString("modifytime");
        String cacheKey = PageRegConfigService.getConfCacheKey(source, cnfId, modTime, RequestContext.get().getLang());
        HashMap<String, Map<String, Object>> cnfMap = (HashMap<String, Map<String, Object>>)HRAppCache.get((String)"hspm").get(cacheKey, Map.class);
        Map<String, Object> cnfDetailMap = null;
        if (cnfMap == null) {
            cnfMap = new HashMap<String, Map<String, Object>>(16);
        }
        if ((cacheMap = (Map)cnfMap.get(cacheKey)) != null && modTime.equals(cacheMap.get("modifytime"))) {
            this.showLogForQuery("0", (Map)cnfMap.get(cacheKey), cacheKey, source);
            return (Map)cnfMap.get(cacheKey);
        }
        String key = "hspm_multiviewconfig/" + cnfId;
        DLock dl = DLock.create((String)key);
        dl.lock();
        try {
            logger.info(MessageFormat.format("getInfoGroupConfig_required_Lock==>{0}", cacheKey));
            cnfDetailMap = this.getConfigFromDB(cnfId, source);
            cnfMap.put(cacheKey, cnfDetailMap);
            HRAppCache.get((String)"hspm").put(cacheKey, cnfMap);
        }
        catch (Exception esc) {
            HRAppCache.get((String)"hspm").put(cacheKey, new HashMap(16));
            logger.error("getInfoGroupConfigException==>", (Throwable)esc);
        }
        finally {
            this.showLogForQuery("1", cnfDetailMap, cacheKey, source);
            dl.unlock();
        }
        return cnfDetailMap;
    }

    public static String getConfCacheKey(String source, Long cnfId, String modTime, Lang lang) {
        return source + ":" + CONFCACHEKEY_VERSION + cnfId + modTime + lang.getLangTag();
    }

    private void showLogForQuery(String type, Map<String, Object> cnfDetailMap, String cacheKey, String source) {
        logger.info(MessageFormat.format("getInfoGroupConfig_release_Lock==>{0}==>{1}==>{2}", cacheKey, type, source));
        if (cnfDetailMap == null || cnfDetailMap.size() == 0) {
            logger.info(MessageFormat.format("getInfoGroupConfig_emptyMap==>{0}==>{1}", cacheKey, type));
            return;
        }
        String number = (String)cnfDetailMap.get("number");
        String name = (String)cnfDetailMap.get("name");
        String modifyTime = (String)cnfDetailMap.get("modifytime");
        logger.info(MessageFormat.format("getInfoGroupConfig_Key==>{0}==>{1}", number, name, modifyTime));
    }

    private Map<String, Object> getConfigFromDB(long cnfId, String source) {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hspm_multiviewconfig");
        DynamicObject cnfDy = configHelper.loadDynamicObject(new QFilter("id", "=", (Object)cnfId));
        HashMap<String, Object> dbInfo = new HashMap<String, Object>(16);
        dbInfo.put("number", cnfDy.getString("number"));
        dbInfo.put("name", cnfDy.getString("name"));
        DynamicObjectCollection groupEntity = cnfDy.getDynamicObjectCollection("groupentity");
        if (!groupEntity.isEmpty()) {
            this.parsePageRegConfigMainMap(dbInfo, groupEntity, source);
            if (InfoGroupHelper.enableMultiLevelMenu()) {
                this.setMultiLevelMenu(cnfDy, dbInfo);
            }
        }
        this.parsePageRegConfigHeadMap(dbInfo, cnfDy);
        dbInfo.put("modifytime", cnfDy.getString("modifytime"));
        String erFileName = PropertyHelper.setLanguage(cnfDy, "erfiletype", "name");
        dbInfo.put("erfiletype", erFileName);
        return dbInfo;
    }

    private void setMultiLevelMenu(DynamicObject cnfDy, Map<String, Object> dbInfo) {
        DynamicObjectCollection dys = cnfDy.getDynamicObjectCollection("multilevelmenuentity");
        if (!CollectionUtils.isEmpty((Collection)dys)) {
            HashMap<Long, String> multiLevelMenuNameMap = new HashMap<Long, String>(dys.size() * 3);
            for (DynamicObject dy : dys) {
                DynamicObjectCollection dynamicObjects;
                String name = PropertyHelper.getMultiLanguageValue(dy, "onelevelmenu");
                if (HRStringUtils.isEmpty((String)name) || CollectionUtils.isEmpty((Collection)(dynamicObjects = dy.getDynamicObjectCollection("twolevelmenu")))) continue;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (dynamicObject.getDynamicObject("fbasedataid") == null) continue;
                    Long id = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
                    multiLevelMenuNameMap.put(id, name);
                }
            }
            if (multiLevelMenuNameMap.size() > 0 && dbInfo.get("tabentry") instanceof List) {
                List tabList = (List)dbInfo.get("tabentry");
                for (Map map : tabList) {
                    String groupName;
                    String groupId = (String)map.get("gid");
                    if (!HRStringUtils.isNotEmpty((String)groupId) || !HRStringUtils.isNotEmpty((String)(groupName = (String)multiLevelMenuNameMap.get(Long.valueOf(groupId))))) continue;
                    map.put("multilevelmenu", groupName);
                }
            }
        }
    }

    private void parsePageRegConfigHeadMap(Map<String, Object> dbInfo, DynamicObject cnfDy) {
        ArrayList list = new ArrayList();
        DynamicObjectCollection headEntity = cnfDy.getDynamicObjectCollection("headentity");
        for (DynamicObject head : headEntity) {
            HashMap<String, Object> headMap = new HashMap<String, Object>(16);
            DynamicObject dynamicObject = head.getDynamicObject("fieldname");
            if (dynamicObject != null) {
                headMap.put("number", dynamicObject.getString("number"));
                headMap.put("name", dynamicObject.getString("name"));
                headMap.put("configurable", dynamicObject.getBoolean("configurable"));
                headMap.put("source", dynamicObject.getString("source.number"));
                headMap.put("istagshow", dynamicObject.getBoolean("istagshow"));
                headMap.put("isedit", head.getBoolean("headisedit"));
                headMap.put("isaudit", head.getBoolean("headisaudit"));
            }
            list.add(headMap);
        }
        dbInfo.put("headentity", list);
    }

    private void parsePageRegConfigMainMap(Map<String, Object> dbInfo, DynamicObjectCollection groupEntity, String source) {
        ArrayList<Map<String, Object>> tabTempList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> mainTempList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> groupMap = new HashMap<String, String>(16);
        HashSet<String> childSet = new HashSet<String>();
        HashMap<String, Object> subMap = new HashMap<String, Object>(16);
        HashSet<Long> handlerIds = new HashSet<Long>();
        this.childGroup(groupEntity, childSet, groupMap, subMap);
        HashMap<String, Object> mChildMap = new HashMap<String, Object>(16);
        HashMap<String, Object> tChildMap = new HashMap<String, Object>(16);
        ArrayList<DynamicObject> commonDys = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : groupEntity) {
            if (handlerIds.contains(dynamicObject.getLong("parentgroupid"))) continue;
            String configArea = dynamicObject.getString("configarea");
            String cKey = dynamicObject.getString("groupid") + configArea;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            if (childSet.contains(cKey)) {
                Object subData = subMap.get(dynamicObject.getString("groupid"));
                List alreadyData = (List)subData;
                if (alreadyData == null || alreadyData.size() == 0) continue;
                for (DynamicObject subDy : alreadyData) {
                    if (ConfigAreaEnum.MAIN.getValue().equals(configArea) || ConfigAreaEnum.COMMON.getValue().equals(configArea)) {
                        this.setMultiGroupField(mChildMap, subDy, map, mainTempList, groupMap, ConfigAreaEnum.MAIN.getValue());
                        if (ConfigAreaEnum.COMMON.getValue().equals(configArea)) {
                            commonDys.add(0, subDy);
                        }
                    } else if (ConfigAreaEnum.SIDE.getValue().equals(configArea)) {
                        this.setMultiGroupField(tChildMap, subDy, map, tabTempList, groupMap, ConfigAreaEnum.SIDE.getValue());
                    }
                    handlerIds.add(dynamicObject.getLong("groupid"));
                }
                continue;
            }
            if (ConfigAreaEnum.COMMON.getValue().equals(configArea)) {
                commonDys.add(0, dynamicObject);
            }
            this.setOnlyOneGroupField(dynamicObject, map);
            this.addList(tabTempList, mainTempList, configArea, map);
        }
        if (ClientTypeEnum.PC.getCode().equals(source)) {
            this.handlerCommonGroup(commonDys, tabTempList, childSet, groupMap);
        }
        this.setFieldPageNumber(mainTempList, tabTempList, dbInfo, source, subMap);
    }

    private void addList(List<Map<String, Object>> tabTempList, List<Map<String, Object>> mainTempList, String configArea, Map<String, Object> map) {
        if (ConfigAreaEnum.MAIN.getValue().equals(configArea) || ConfigAreaEnum.COMMON.getValue().equals(configArea)) {
            mainTempList.add(map);
        } else if (ConfigAreaEnum.SIDE.getValue().equals(configArea)) {
            tabTempList.add(map);
        }
    }

    private void handlerCommonGroup(List<DynamicObject> commonDy, List<Map<String, Object>> tabTempList, Set<String> repSet, Map<String, String> groupMap) {
        HashMap<String, Object> tChildMap = new HashMap<String, Object>(16);
        for (DynamicObject dynamicObject : commonDy) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String configArea = dynamicObject.getString("configarea");
            String parentKey = dynamicObject.getString("parentgroupid") + configArea;
            if (repSet.contains(parentKey)) {
                this.setMultiGroupField(tChildMap, dynamicObject, map, tabTempList, groupMap, ConfigAreaEnum.COMMON.getValue());
                continue;
            }
            this.setOnlyOneGroupField(dynamicObject, map);
            ArrayList<HashMap<String, Object>> tempList = new ArrayList<HashMap<String, Object>>();
            tempList.add(map);
            tabTempList.addAll(0, tempList);
        }
    }

    private void setFieldPageNumber(List<Map<String, Object>> mainTempList, List<Map<String, Object>> tabTempList, Map<String, Object> dbInfo, String source, Map<String, Object> subMap) {
        DynamicObject[] query;
        HRBaseServiceHelper serviceHelper;
        Map<String, DynamicObject> pageNumberMap = new HashMap<String, DynamicObject>(16);
        Map<String, DynamicObject> numberMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> set = new HashSet<Long>(16);
        HashSet<String> numberSet = new HashSet<String>(16);
        this.getPageNumber(mainTempList, source, subMap, set, numberSet, "maintab");
        this.getPageNumber(tabTempList, source, subMap, set, numberSet, "sidetab");
        if (set.size() > 0) {
            serviceHelper = new HRBaseServiceHelper("hspm_infogrouppagereg");
            query = serviceHelper.query("number,name,pageinfo.number,pageinfo.name,pagetype,dyviewpc,dialogpc,dyviewmobile,dialogmobile", new QFilter[]{new QFilter("id", "in", set)});
            pageNumberMap = Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy, (key1, key2) -> key1));
        }
        if (numberSet.size() > 0) {
            serviceHelper = new HRBaseServiceHelper("hspm_infogrouppagereg");
            query = serviceHelper.query("number,name,pageinfo.number,pageinfo.name,pagetype,dyviewpc,dialogpc,dyviewmobile,dialogmobile", new QFilter[]{new QFilter("number", "in", numberSet)});
            numberMap = Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (key1, key2) -> key1));
        }
        this.setCommonInfo(mainTempList, source, pageNumberMap, numberMap);
        this.setCommonInfo(tabTempList, source, pageNumberMap, numberMap);
        dbInfo.put("mainentry", mainTempList);
        dbInfo.put("tabentry", tabTempList);
    }

    private void setCommonInfo(List<Map<String, Object>> mainTempList, String source, Map<String, DynamicObject> pageNumberMap, Map<String, DynamicObject> numberMap) {
        for (Map<String, Object> manMap : mainTempList) {
            List groups = (List)manMap.get("groups");
            for (Map group : groups) {
                List fields = (List)group.get("fields");
                for (Map fieldMap : fields) {
                    String pNumber = (String)fieldMap.get("pnumber");
                    DynamicObject mapNumber = numberMap.get(pNumber);
                    if (mapNumber == null) continue;
                    fieldMap.put("pnumber", mapNumber.getString("pageinfo.number"));
                    this.setViewAndDialogNumber(source, fieldMap, mapNumber);
                }
            }
            String gid = (String)manMap.get("gid");
            DynamicObject mapNumber = pageNumberMap.get(gid);
            if (mapNumber == null) continue;
            String pageType = mapNumber.getString("pagetype");
            String number = mapNumber.getString("number");
            this.setViewAndDialogNumber(source, manMap, mapNumber);
            manMap.put("mappingFormid", mapNumber.getString("pageinfo.number"));
            manMap.put("pagetype", pageType);
            manMap.put("targetkey", number);
        }
    }

    private void setViewAndDialogNumber(String source, Map<String, Object> manMap, DynamicObject mapNumber) {
        if (ClientTypeEnum.PC.getCode().equals(source) || ClientTypeEnum.EMPLOYEE_PC.getCode().equals(source)) {
            manMap.put("pagenumber", mapNumber.getString("dyviewpc"));
            manMap.put("dialogpagenumber", mapNumber.getString("dialogpc"));
        } else if (ClientTypeEnum.EMPLOYEE_MOBILE.getCode().equals(source)) {
            manMap.put("pagenumber", mapNumber.getString("dyviewmobile"));
            manMap.put("dialogpagenumber", mapNumber.getString("dialogmobile"));
        }
    }

    private void getPageNumber(List<Map<String, Object>> mainTempList, String source, Map<String, Object> subMap, Set<Long> set, Set<String> numberSet, String mainTab) {
        if (ClientTypeEnum.EMPLOYEE_MOBILE.getCode().equals(source) && "sidetab".equals(mainTab)) {
            return;
        }
        if (mainTempList.size() == 0) {
            return;
        }
        for (Map<String, Object> manMap : mainTempList) {
            String groupId = (String)manMap.get("gid");
            if (HRStringUtils.isNotEmpty((String)groupId) && !groupId.startsWith("sub_")) {
                set.add(Long.parseLong(groupId));
            } else {
                Object subObj = subMap.get(groupId);
                if (subObj instanceof DynamicObject) {
                    DynamicObject subObj1 = (DynamicObject)subObj;
                    set.add(Long.parseLong(subObj1.getString("parentgroupid")));
                }
            }
            List groups = (List)manMap.get("groups");
            for (Map group : groups) {
                List fields = (List)group.get("fields");
                for (Map field : fields) {
                    numberSet.add((String)field.get("pnumber"));
                }
            }
        }
    }

    private void setMultiGroupField(Map<String, Object> mChildMap, DynamicObject dynamicObject, Map<String, Object> map, List<Map<String, Object>> allList, Map<String, String> groupMap, String value) {
        String configArea = dynamicObject.getString("configarea");
        String pKey = dynamicObject.getString("parentgroupid") + configArea;
        String cKey = dynamicObject.getString("groupid") + configArea;
        ArrayList<Map<String, Object>> groupList = new ArrayList<Map<String, Object>>();
        if (mChildMap.get(pKey) != null) {
            for (Map<String, Object> tempMap : allList) {
                if ("1".equals(tempMap.get("single")) || !cKey.startsWith("sub_") || !pKey.equals(tempMap.get("groupid"))) continue;
                tempMap.put("groupname", groupMap.get(pKey));
                List oldList = (List)tempMap.get("groups");
                this.setOneGroupField(dynamicObject, groupList, map, pKey, "0", groupMap);
                if (ConfigAreaEnum.COMMON.getValue().equals(value)) {
                    oldList.addAll(0, groupList);
                } else {
                    oldList.addAll(groupList);
                }
                tempMap.put("groups", oldList);
            }
            return;
        }
        this.setOneGroupField(dynamicObject, groupList, map, pKey, "0", groupMap);
        mChildMap.put(pKey, pKey);
        if (ConfigAreaEnum.COMMON.getValue().equals(value)) {
            ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
            tempList.add(map);
            allList.addAll(0, tempList);
        } else {
            allList.add(map);
        }
    }

    private void setOnlyOneGroupField(DynamicObject dynamicObject, Map<String, Object> map) {
        String configArea = dynamicObject.getString("configarea");
        String parentKey = dynamicObject.getString("parentgroupid") + configArea;
        ArrayList<Map<String, Object>> groupList = new ArrayList<Map<String, Object>>();
        this.setOneGroupField(dynamicObject, groupList, map, parentKey, "1", null);
    }

    private void setOneGroupField(DynamicObject dynamicObject, List<Map<String, Object>> groupList, Map<String, Object> map, String pKey, String pageFlag, Map<String, String> fatherGroupMap) {
        HashMap<String, Object> groupMap = new HashMap<String, Object>(16);
        ArrayList fieldList = new ArrayList();
        DynamicObjectCollection fieldDys = dynamicObject.getDynamicObjectCollection("fieldentity");
        for (DynamicObject field : fieldDys) {
            DynamicObject fieldDb = field.getDynamicObject("field");
            if (fieldDb == null) continue;
            int showNum = field.getInt("shownum");
            if (showNum == 0) {
                showNum = 1;
            }
            HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
            fieldMap.put("isedit", field.get("isedit"));
            fieldMap.put("isrequired", field.get("isrequired"));
            fieldMap.put("refkey", fieldDb.get("refkey"));
            fieldMap.put("tablename", fieldDb.get("tablename"));
            String value = PropertyHelper.setLanguageField(field, "displayname");
            if (HRStringUtils.isEmpty((String)value)) {
                fieldMap.put("displayname", PropertyHelper.setLanguageField(fieldDb, "name"));
            } else {
                fieldMap.put("displayname", value);
            }
            fieldMap.put("number", fieldDb.get("number"));
            fieldMap.put("type", fieldDb.get("type"));
            fieldMap.put("pnumber", fieldDb.getString("group.number"));
            ILocaleString localeString = fieldDb.getLocaleString("group.name");
            String localName = localeString != null ? localeString.getLocaleValue() : fieldDb.getString("group.name");
            fieldMap.put("pname", localName);
            fieldMap.put("maxcount", showNum);
            fieldMap.put("scale", fieldDb.get("scale"));
            fieldMap.put("max", fieldDb.get("max"));
            fieldMap.put("min", fieldDb.get("min"));
            fieldMap.put("precision", fieldDb.get("precision"));
            fieldMap.put("isaudit", field.get("isaudit"));
            if (fieldMap.size() <= 0) continue;
            fieldList.add(fieldMap);
        }
        groupMap.put("fields", fieldList);
        groupMap.put("gname", PropertyHelper.setLanguageField(dynamicObject, "groupname"));
        groupList.add(groupMap);
        if (fatherGroupMap != null && "0".equals(pageFlag)) {
            map.put("groupname", fatherGroupMap.get(pKey));
            map.put("single", "0");
        } else {
            map.put("groupname", PropertyHelper.setLanguageField(dynamicObject, "groupname"));
            map.put("single", "1");
        }
        String groupId = dynamicObject.getString("groupid");
        if (!groupId.startsWith("sub_")) {
            map.put("gid", groupId);
        } else {
            String pid = dynamicObject.getString("parentgroupid");
            map.put("gid", pid);
        }
        map.put("groupid", pKey);
        map.put("groups", groupList);
        map.put("seq", dynamicObject.getString("seq"));
    }

    private void childGroup(DynamicObjectCollection groupEntity, Set<String> repSet, Map<String, String> groupMap, Map<String, Object> subMap) {
        for (DynamicObject dynamicObject : groupEntity) {
            String groupId = dynamicObject.getString("groupid");
            String parentGroupId = dynamicObject.getString("parentgroupid");
            String configArea = dynamicObject.getString("configarea");
            String pKey = parentGroupId + configArea;
            String cKey = groupId + configArea;
            if (groupId.startsWith("sub_")) {
                repSet.add(pKey);
                Object child = subMap.get(parentGroupId);
                if (child != null) {
                    List alreadyData = (List)child;
                    alreadyData.add(dynamicObject);
                    subMap.put(parentGroupId, alreadyData);
                    continue;
                }
                ArrayList<DynamicObject> newData = new ArrayList<DynamicObject>();
                newData.add(dynamicObject);
                subMap.put(parentGroupId, newData);
                continue;
            }
            groupMap.put(cKey, PropertyHelper.setLanguageField(dynamicObject, "groupname"));
        }
    }

    public void setCommonCustomParam(FormShowParameter formShowParameter, IFormView view) {
        String formId = formShowParameter.getFormId();
        if (HRStringUtils.isNotEmpty((String)formId) && formId.contains("hspm_ermanfile")) {
            formShowParameter.setCustomParam("customHREntityNumber", (Object)"hspm_erfilequery");
            formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        }
        formShowParameter.setCustomParam("businessstatus", view.getFormShowParameter().getCustomParam("businessstatus"));
        formShowParameter.setCustomParam("name", view.getFormShowParameter().getCustomParam("name"));
        formShowParameter.setCustomParam("filetypenumber", view.getFormShowParameter().getCustomParam("filetypenumber"));
        formShowParameter.setCustomParam("filetype", view.getFormShowParameter().getCustomParam("filetype"));
        formShowParameter.setCustomParam("adminorgid", view.getFormShowParameter().getCustomParam("adminorgid"));
        formShowParameter.setCustomParam("empentrel", view.getFormShowParameter().getCustomParam("empentrel"));
        formShowParameter.setCustomParam("person", view.getFormShowParameter().getCustomParam("person"));
        formShowParameter.setCustomParam("employee", view.getFormShowParameter().getCustomParam("employee"));
        formShowParameter.setCustomParam("depemp", view.getFormShowParameter().getCustomParam("depemp"));
        formShowParameter.setCustomParam("cmpemp", view.getFormShowParameter().getCustomParam("cmpemp"));
        formShowParameter.setCustomParam("empposrel", view.getFormShowParameter().getCustomParam("empposrel"));
    }
}

