/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DynamicPropUtil {
    public static DynamicObject getByMaxModifytime(List<DynamicObject> dynamicObjectList) {
        return (DynamicObject)dynamicObjectList.stream().max((dy1, dy2) -> {
            Date dy2Time;
            Date dy1Time = dy1.getDate("modifytime");
            if (HRDateTimeUtils.dayAfter((Date)dy1Time, (Date)(dy2Time = dy2.getDate("modifytime")))) {
                return 1;
            }
            return -1;
        }).get();
    }

    public static String hisTimeProperties() {
        return "bsed,bsled,firstbsed,changebsed,bred,brled,brfd";
    }

    public static String getSelectProperties(DataEntityPropertyCollection mainProperties, DataEntityPropertyCollection compareProperties, DataEntityPropertyCollection properties, String extraSelectProperties) {
        return DynamicPropUtil.getSelectProperties(mainProperties, compareProperties, properties, extraSelectProperties, "");
    }

    public static String getSelectProperties(DataEntityPropertyCollection mainProperties, DataEntityPropertyCollection compareProperties, DataEntityPropertyCollection properties, String extraSelectProperties, String excludeProperties) {
        ArrayList<String> excludePropertiesList = new ArrayList<String>();
        if (HRStringUtils.isNotEmpty((String)excludeProperties)) {
            excludePropertiesList.addAll(Arrays.asList(excludeProperties.split(",")));
        }
        ArrayList<String> selectPropertiesList = new ArrayList<String>();
        for (IDataEntityProperty prop : properties) {
            String propStr = prop.getName().toLowerCase(Locale.ROOT);
            if (propStr.endsWith("_id") || propStr.endsWith("text") || !mainProperties.containsKey((Object)propStr) || compareProperties.containsKey((Object)propStr) || excludePropertiesList.contains(propStr)) continue;
            selectPropertiesList.add(propStr);
        }
        if (HRStringUtils.isNotEmpty((String)extraSelectProperties)) {
            selectPropertiesList.addAll(Arrays.asList(extraSelectProperties.split(",")));
        }
        return String.join((CharSequence)",", selectPropertiesList);
    }

    public static String getSelectProperties(DataEntityPropertyCollection mainProperties, DataEntityPropertyCollection properties) {
        ArrayList<String> selectPropertiesList = new ArrayList<String>();
        for (IDataEntityProperty prop : properties) {
            String propStr = prop.getName().toLowerCase(Locale.ROOT);
            if (propStr.endsWith("_id") || propStr.endsWith("text") || !mainProperties.containsKey((Object)propStr)) continue;
            selectPropertiesList.add(propStr);
        }
        return String.join((CharSequence)",", selectPropertiesList);
    }
}

