/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class HspmDateUtils
extends HRDateTimeUtils {
    private static final Log logger = LogFactory.getLog(HspmDateUtils.class);

    public static Date getMidnight() {
        return HspmDateUtils.getMidnight(new Date());
    }

    public static Date getMidnight(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = HspmDateUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return HspmDateUtils.parseDate((String)(dateStr + " 00:00:00"));
        }
        catch (ParseException parseException) {
            logger.error("parse date error!", (Throwable)parseException);
            return null;
        }
    }

    public static Date getLastSecond() {
        return HspmDateUtils.getLastSecond(new Date());
    }

    public static Date getLastSecond(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = HspmDateUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return HspmDateUtils.parseDate((String)(dateStr + " 23:59:59"));
        }
        catch (ParseException parseException) {
            logger.error("parse date error!", (Throwable)parseException);
            return null;
        }
    }

    public static BigDecimal dateDiff(Date date) {
        return date == null ? BigDecimal.ZERO : BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"yyyy", (Date)date, (Date)new Date()));
    }

    public static Date getMaxEndDate() {
        return HspmDateUtils.addDay((Date)HspmDateUtils.getSysMaxDate(), (long)-1L);
    }
}

