/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.NoLineTimeHisVersionChangeService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PageCacheUtils {
    private static final Log logger = LogFactory.getLog(PageCacheUtils.class);

    public static IPageCache getHomePageCache(IFormView formView) {
        if (formView.getEntityId().equals("hspm_moberhome") || formView.getEntityId().equals("hspm_myermanfile")) {
            return formView.getPageCache();
        }
        logger.info("currentFormView=====:{}", (Object)formView.getEntityId());
        IFormView parentView = formView.getViewNoPlugin(formView.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            if (parentView.getEntityId().equals("hspm_moberhome") || parentView.getEntityId().equals("hspm_myermanfile")) {
                return parentView.getPageCache();
            }
            return PageCacheUtils.getHomePageCache(parentView);
        }
        return formView.getPageCache();
    }

    public static IFormView getHomePage(IFormView formView) {
        if (formView.getEntityId().equals("hspm_moberhome") || formView.getEntityId().equals("hspm_myermanfile")) {
            return formView;
        }
        if (formView.getParentView() != null) {
            if (formView.getParentView().getEntityId().equals("hspm_moberhome") || formView.getParentView().getEntityId().equals("hspm_myermanfile")) {
                return formView.getParentView();
            }
            return PageCacheUtils.getHomePage(formView.getParentView());
        }
        return formView;
    }

    public static void removeDataIfNeedUpdate(List<HashMap<String, Object>> collection, Long boid, String fieldName, String groupNumber) {
        Iterator<HashMap<String, Object>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            HashMap<String, Object> next = iterator.next();
            if (!boid.equals(next.get("dataid")) || !fieldName.equals(next.get("fieldname")) || !groupNumber.equals(next.get("groupnumber"))) continue;
            iterator.remove();
        }
    }

    public static void updateTempData(DynamicObject[] tempInfo, Map<String, Object> resultMap, String field, Object newValue, String entityName, IFormView view, HRBaseServiceHelper helper) {
        QFilter statusFilter;
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            return;
        }
        Object pkId = view.getFormShowParameter().getCustomParam("pkid");
        if (pkId == null) {
            logger.info("pkid_is_null===={}", (Object)view.getEntityId());
            return;
        }
        QFilter valueFilter = new QFilter(field, "!=", newValue);
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(pkId.toString()));
        if (!helper.isExists(new QFilter[]{valueFilter, idFilter, statusFilter = new QFilter("datastatus", "=", (Object)"-3")})) {
            return;
        }
        if (tempInfo != null && tempInfo.length > 0) {
            List longList = Arrays.stream(tempInfo).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            for (DynamicObject dbDy : tempInfo) {
                dbDy.set(field, newValue);
                dbDy.set("boid", (Object)0);
            }
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setEffImmediately(false);
            hisVersionParamBo.setEntityNumber(entityName);
            hisVersionParamBo.setHisDyns(tempInfo);
            hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
            try {
                NoLineTimeHisVersionChangeService.getInstance().handleNoLineData(hisVersionParamBo);
            }
            catch (Exception exception) {
                logger.error("update_temp_data_error", (Throwable)exception);
            }
            FormShowParameter formShowParameter = view.getFormShowParameter();
            String tabInfo = (String)formShowParameter.getCustomParam("params");
            Map tabList = (Map)SerializationUtils.fromJsonString((String)tabInfo, Map.class);
            if (view.getEntityId().equals("hspm_pereduexp_mdg")) {
                String tabInfoNew = (String)view.getFormShowParameter().getCustomParam("expParams");
                tabList = (Map)SerializationUtils.fromJsonString((String)tabInfoNew, Map.class);
            }
            String entrycache = PageCacheUtils.getHomePageCache(view).get(tabList.get("groupname") + "-" + "entrycache");
            List collection = new ArrayList();
            if (HRStringUtils.isNotEmpty((String)entrycache)) {
                collection = (List)SerializationUtils.fromJsonString((String)entrycache, List.class);
            }
            collection.stream().forEach(map -> {
                if (map.get("fieldname").equals(field) && longList.contains(map.get("dataid"))) {
                    map.put("newvalue", newValue);
                }
            });
            if (collection.size() > 0) {
                PageCacheUtils.getHomePageCache(view).put(tabList.get("groupname") + "-" + "entrycache", SerializationUtils.toJsonString(collection));
            } else {
                PageCacheUtils.getHomePageCache(view).remove(tabList.get("groupname") + "-" + "entrycache");
            }
        }
    }
}

