/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.common.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;

@SdkPublic
public class PersonModelUtil {
    private static Log LOGGER = LogFactory.getLog(PersonModelUtil.class);
    private static final HRBaseServiceHelper PERSONENTITYCONF_HEPLER = new HRBaseServiceHelper("hrpi_personentityconf");
    private static final Map<String, Object> PERSONMODEL_CACHE = new HashMap<String, Object>();
    private static final String ENTITY = "entity";
    private static final String CLASSIFY = "classify";
    private static final int MAX_QUERY_PERSONENTITYCONF = 500;
    private static final String[] MODEL_LIST = new String[]{"person", "employee", "depemp", "cmpemp"};
    private static final String PERSONMODELCLASSIFICATION_CACHEKEY = "PERSONMODELCLASSIFICATION_CACHEKEY:";

    public static PersonModelClassificationEnum getClassification(String pageNumber) {
        if (HRStringUtils.isNotEmpty((String)pageNumber)) {
            String classify;
            String cacheKey = PERSONMODELCLASSIFICATION_CACHEKEY + pageNumber;
            String deadlineKey = "PERSONMODELCLASSIFICATION_CACHEKEY:deadline";
            Date deadline = (Date)PERSONMODEL_CACHE.get(deadlineKey);
            if (deadline != null && deadline.after(new Date()) && (classify = (String)PERSONMODEL_CACHE.get(cacheKey)) != null) {
                return PersonModelClassificationEnum.getByCode(classify);
            }
            QFilter entityFilter = new QFilter("id", ">", (Object)0L);
            DynamicObject[] dyArray = PERSONENTITYCONF_HEPLER.query("entity,classify", new QFilter[]{entityFilter}, "id");
            PERSONMODEL_CACHE.put(deadlineKey, HRDateTimeUtils.addHour((Date)new Date(), (long)2L));
            if (dyArray != null && dyArray.length > 0) {
                if (dyArray.length >= 500) {
                    LOGGER.warn("Maybe more than MAX_QUERY_PERSONENTITYCONF");
                }
                for (DynamicObject dy : dyArray) {
                    String classify2 = dy.getString(CLASSIFY);
                    PERSONMODEL_CACHE.put(PERSONMODELCLASSIFICATION_CACHEKEY + dy.getString(ENTITY), classify2);
                }
                String classify3 = (String)PERSONMODEL_CACHE.get(cacheKey);
                if (classify3 != null) {
                    return PersonModelClassificationEnum.getByCode(classify3);
                }
            } else {
                PERSONMODEL_CACHE.put(cacheKey, "");
            }
        }
        return null;
    }

    public static QFilter getQFilterForHeadArea(String pageNumber, Map<String, Object> values) {
        if (HRStringUtils.isNotEmpty((String)pageNumber) && !CollectionUtils.isEmpty(values)) {
            PersonModelClassificationEnum personModelClassificationEnum = PersonModelUtil.getClassification(pageNumber);
            if (PersonModelClassificationEnum.DEPEMPATTACHED == personModelClassificationEnum) {
                if (PersonModelUtil.validate(pageNumber, values, "depemp")) {
                    Long dataId = Long.valueOf(values.get("depemp").toString());
                    return new QFilter("depemp", "=", (Object)dataId);
                }
            } else if (PersonModelClassificationEnum.CMPEMPATTACHED == personModelClassificationEnum) {
                if (PersonModelUtil.validate(pageNumber, values, "cmpemp")) {
                    Long dataId = Long.valueOf(values.get("cmpemp").toString());
                    return new QFilter("cmpemp", "=", (Object)dataId);
                }
            } else if (PersonModelClassificationEnum.EMPATTACHED == personModelClassificationEnum) {
                if (PersonModelUtil.validate(pageNumber, values, "employee")) {
                    Long dataId = Long.valueOf(values.get("employee").toString());
                    return new QFilter("employee", "=", (Object)dataId);
                }
            } else if (PersonModelClassificationEnum.PERATTACHED == personModelClassificationEnum) {
                if (PersonModelUtil.validate(pageNumber, values, "person")) {
                    Long dataId = Long.valueOf(values.get("person").toString());
                    return new QFilter("person", "=", (Object)dataId);
                }
            } else if (PersonModelClassificationEnum.PERSONMODEL == personModelClassificationEnum) {
                if ("hrpi_person".equals(pageNumber) && PersonModelUtil.validateData(values, "person")) {
                    Long dataId = Long.valueOf(values.get("person").toString());
                    return new QFilter("id", "=", (Object)dataId);
                }
                if ("hrpi_employee".equals(pageNumber) && PersonModelUtil.validateData(values, "hrpi_employee")) {
                    Long dataId = Long.valueOf(values.get("employee").toString());
                    return new QFilter("id", "=", (Object)dataId);
                }
                if ("hrpi_cmpemp".equals(pageNumber) && PersonModelUtil.validateData(values, "cmpemp")) {
                    Long dataId = Long.valueOf(values.get("cmpemp").toString());
                    return new QFilter("id", "=", (Object)dataId);
                }
                if ("hrpi_depemp".equals(pageNumber) && PersonModelUtil.validateData(values, "depemp")) {
                    Long dataId = Long.valueOf(values.get("depemp").toString());
                    return new QFilter("id", "=", (Object)dataId);
                }
            }
        }
        return null;
    }

    public static QFilter getQFilter(String pageNumber, Map<String, Object> values) {
        if (HRStringUtils.isNotEmpty((String)pageNumber) && !CollectionUtils.isEmpty(values)) {
            if ("hrpi_empposorgrel".equals(pageNumber)) {
                if (PersonModelUtil.validate(pageNumber, values, "employee")) {
                    Long dataId = Long.valueOf(values.get("employee").toString());
                    return new QFilter("employee", "=", (Object)dataId);
                }
                return null;
            }
            return PersonModelUtil.getQFilterForHeadArea(pageNumber, values);
        }
        return null;
    }

    private static boolean validate(String pageNumber, Map<String, Object> values, String key) {
        return PersonModelUtil.validateData(values, key) && PropertyHelper.existProperty(pageNumber, key);
    }

    private static boolean validateData(Map<String, Object> values, String key) {
        return values.get(key) != null && Long.parseLong(values.get(key).toString()) > 0L;
    }

    public static void setPersonModelValue(DynamicObject dynamicObject, Map<String, Object> values) {
        if (dynamicObject != null && !CollectionUtils.isEmpty(values)) {
            String pageNumber = dynamicObject.getDataEntityType().getName();
            if (MetadataServiceHelper.getDataEntityType((String)pageNumber) == null) {
                return;
            }
            Map allFields = MetadataServiceHelper.getDataEntityType((String)pageNumber).getAllFields();
            for (String mode : MODEL_LIST) {
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(mode);
                if (!(property instanceof BasedataProp) || values.get(mode) == null) continue;
                dynamicObject.set(mode, values.get(mode));
            }
        }
    }
}

