/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.mobile.file.base;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.helper.CardDrawElyHelper;
import kd.sdk.hr.hspm.business.helper.CardDrawElyMobHelper;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.CardDrawDTO;
import kd.sdk.hr.hspm.common.dto.FieldDTO;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.PageCacheUtils;
import kd.sdk.hr.hspm.common.utils.PageDrawUtil;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;

public class AbstractMobCardEdit
extends AbstractMobFormPlugin
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractMobCardEdit.class);
    protected Map<String, Object> tabList = null;
    protected CardDrawDTO cardDrawDTO = new CardDrawDTO();
    private final List<List<Map<String, String>>> groupDataList = new ArrayList<List<Map<String, String>>>(2);
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    public static final ThreadLocal<Object> INPROCESS_BILL_TL = new ThreadLocal();

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        if (!this.analysisConfigParams(this.getView().getFormShowParameter())) {
            LOGGER.warn("analysisConfigParams fail");
            return;
        }
        this.setTitleField(this.cardDrawDTO.getTitleField());
        this.setBracketField(this.cardDrawDTO.getBracketField());
        this.setTagField(this.cardDrawDTO.getTagField());
        this.setTimeLineField(this.cardDrawDTO.getTimeLineField());
        this.setContentField(this.cardDrawDTO.getContentField());
        this.setData(this.groupDataList);
        this.keepDataId();
        this.draw();
        this.saveCardOpToHomeCache();
    }

    private void saveCardOpToHomeCache() {
        if (this.getView().getParentView() != null) {
            String groupNum = (String)this.tabList.get("targetkey");
            HashMap<String, Boolean> opMap = new HashMap<String, Boolean>(4);
            opMap.put("hasAddOperate", this.hasAddOperate());
            opMap.put("hasDeleteOperate", this.hasDeleteOperate());
            opMap.put("enableEnterDetail", this.enableEnterDetail());
            this.getView().getParentView().getPageCache().put("cardOpCache_" + groupNum, SerializationUtils.toJsonString(opMap));
        }
    }

    private void keepDataId() {
        if (!CollectionUtils.isEmpty(this.groupDataList)) {
            HashSet<String> dataIds = new HashSet<String>();
            for (List<Map<String, String>> list : this.groupDataList) {
                if (CollectionUtils.isEmpty(list)) continue;
                for (Map<String, String> data : list) {
                    dataIds.add(CardDrawElyMobHelper.getDataId(data));
                }
            }
            this.getView().getPageCache().put("data_ids", SerializationUtils.toJsonString(dataIds));
        }
    }

    private boolean analysisConfigParams(FormShowParameter formShowParameter) {
        LOGGER.info(MessageFormat.format("===analysisConfigParams==={0}", formShowParameter.getCustomParams()));
        this.tabList = ParamAnalysisUtil.getParams(formShowParameter);
        return this.tabList != null;
    }

    protected void setTitleField(FieldDTO titleField) {
    }

    protected void setBracketField(FieldDTO bracketField) {
    }

    protected void setTagField(FieldDTO tagField) {
    }

    protected void setContentField(FieldDTO contentField) {
    }

    protected boolean hasContentTitle() {
        return true;
    }

    protected boolean hasDeleteOperate() {
        return false;
    }

    protected boolean hasAddOperate() {
        return false;
    }

    protected boolean enableEnterDetail() {
        return true;
    }

    protected void setTimeLineField(List<Tuple<String, String>> timeLineField) {
    }

    protected void changeLabel(LabelAp labelAp) {
    }

    protected void queryAdditionalField(Map<String, Object> group) {
    }

    protected void setData(List<List<Map<String, String>>> groupDataList) {
        FormShowParameter formShowParameter;
        if (this.tabList == null || (formShowParameter = this.getView().getFormShowParameter()) == null || CollectionUtils.isEmpty((Map)formShowParameter.getCustomParams())) {
            return;
        }
        String groupName = (String)this.tabList.get("groupname");
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(this.tabList);
        if (!CollectionUtils.isEmpty(groups)) {
            for (Map<String, Object> group : groups) {
                this.queryAdditionalField(group);
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
                ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
                if (!CollectionUtils.isEmpty(fields)) {
                    Map<String, List<Map>> groupFields = fields.stream().collect(Collectors.groupingBy(val -> (String)val.get("pnumber")));
                    String entityId = this.getView().getEntityId();
                    for (Map.Entry<String, List<Map<String, Object>>> entry : groupFields.entrySet()) {
                        List selectProps = entry.getValue().stream().map(val -> (String)val.get("number")).collect(Collectors.toList());
                        selectProps.add("datastatus");
                        QFilter qFilter = this.getQFilter(entry, formShowParameter.getCustomParams());
                        if (entry.getKey().equals("hrpi_pereduexpcert")) continue;
                        Object ispreview = formShowParameter.getCustomParam("ispreview");
                        if (qFilter == null && ispreview == null) continue;
                        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entry.getKey());
                        String orderBys = this.getOrderBys(entry.getKey());
                        Object limitParam = formShowParameter.getCustomParams().get("LimitParam");
                        DynamicObject[] dataArray = limitParam == null ? serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter}, orderBys) : serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter}, orderBys, Integer.parseInt(limitParam.toString()));
                        if (dataArray == null || dataArray.length <= 0) break;
                        Map<String, Map<String, Object>> fieldMap = entry.getValue().stream().collect(Collectors.toMap(val -> val.get("number").toString(), val -> val));
                        Set<String> strings = fieldMap.keySet();
                        for (DynamicObject dynamicObject : dataArray) {
                            String schoolRecord;
                            if (this.isAbandonData(groupName, dynamicObject)) continue;
                            this.updateCacheDataIfExist(groupName, dynamicObject);
                            if ("hrpi_pereduexp".equals(entry.getKey()) && fieldMap.containsKey("schoolrecord") && fieldMap.containsKey("graduateschool") && 1386848073895945216L == dynamicObject.getLong("graduateschool.id") && dynamicObject.getLocaleString("schoolrecord") != null && HRStringUtils.isNotEmpty((String)(schoolRecord = dynamicObject.getLocaleString("schoolrecord").getLocaleValue()))) {
                                dynamicObject.set("graduateschool", (Object)schoolRecord);
                            }
                            dataList.add(this.changeToMap(entry.getKey(), fieldMap, dynamicObject));
                        }
                    }
                }
                groupDataList.add(dataList);
            }
        }
    }

    private boolean isAbandonData(String groupName, DynamicObject dynamicObject) {
        List groupFields;
        if (!"-3".equals(dynamicObject.getString("datastatus"))) {
            return false;
        }
        boolean isAbandonData = true;
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isNotEmpty((String)cacheValue) && !CollectionUtils.isEmpty((Collection)(groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)))) {
            Long id = dynamicObject.getLong("id");
            String entityName = dynamicObject.getDynamicObjectType().getName();
            for (Map map : groupFields) {
                Object dataIdCache = map.get("dataid");
                Object entityNameCache = map.get("entityName");
                if ("hrpi_pereduexpcert".equals(entityNameCache)) {
                    dataIdCache = BusinessUtils.getEduexpByEduCertId((Long)dataIdCache);
                    entityNameCache = "hrpi_pereduexp";
                }
                if (!Boolean.TRUE.equals(map.get("isnew")) || !id.equals(dataIdCache) || !entityName.equals(entityNameCache)) continue;
                isAbandonData = false;
                break;
            }
        }
        return isAbandonData;
    }

    private String getGroupAuditCacheValue(String groupName) {
        if (HRStringUtils.isEmpty((String)groupName) || this.getView().getParentView() == null) {
            return null;
        }
        Map allCache = this.getView().getParentView().getPageCache().getAll();
        if (CollectionUtils.isEmpty((Map)allCache)) {
            return null;
        }
        return (String)allCache.get(groupName + "-entrycache");
    }

    private void updateCacheDataIfExist(String groupName, DynamicObject dynamicObject) {
        List groupFields;
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isNotEmpty((String)cacheValue) && !CollectionUtils.isEmpty((Collection)(groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class)))) {
            Long id = dynamicObject.getLong("id");
            String entityName = dynamicObject.getDynamicObjectType().getName();
            for (Map map : groupFields) {
                if (Boolean.TRUE.equals(map.get("isdel")) || !id.equals(map.get("dataid")) || !entityName.equals(map.get("entityName"))) continue;
                String fieldName = (String)map.get("fieldname");
                Object fieldType = map.get("fieldtype");
                Object newValue = map.get("newvalue");
                if (!HRStringUtils.isNotEmpty((String)fieldName) || fieldType == null || newValue == null) continue;
                ValueConvertHelper.setValue(dynamicObject, fieldName, fieldType.toString(), newValue.toString());
            }
        }
    }

    protected QFilter getQFilter(Map.Entry<String, List<Map<String, Object>>> entry, Map<String, Object> values) {
        QFilter qFilter = PersonModelUtil.getQFilter(entry.getKey(), values);
        if (qFilter != null) {
            String filterP;
            List filters;
            qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
            qFilter.and("initstatus", "=", (Object)"2");
            qFilter.and("datastatus", "in", (Object)new String[]{"-3", "1"});
            if (values.get("filterParam") != null && !CollectionUtils.isEmpty((Collection)(filters = SerializationUtils.fromJsonStringToList((String)(filterP = values.get("filterParam").toString()), QFilter.class)))) {
                for (QFilter filter : filters) {
                    qFilter.and(filter);
                }
            }
        }
        return qFilter;
    }

    protected String getOrderBys(String tableName) {
        return "createtime";
    }

    private Map<String, String> changeToMap(String tabName, Map<String, Map<String, Object>> fieldMap, DynamicObject dynamicObject) {
        Map orginalDataMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject);
        HashMap<String, String> dataMap = new HashMap<String, String>(orginalDataMap.size());
        Object ispreview = this.getView().getFormShowParameter().getCustomParam("ispreview");
        for (Map.Entry entry : orginalDataMap.entrySet()) {
            String key = tabName + "." + (String)entry.getKey();
            if (((String)entry.getKey()).equals("id")) {
                dataMap.put(key, entry.getValue().toString());
                continue;
            }
            Map<String, Object> field = fieldMap.get(entry.getKey());
            if (field == null || entry.getValue() == null && ispreview == null) continue;
            if (ispreview != null) {
                dataMap.put(key, (String)field.get("displayname"));
                continue;
            }
            if (this.customValue(dataMap, field, entry.getValue())) continue;
            if (entry.getValue() instanceof List) {
                dataMap.put(key, ValueConvertHelper.handleMulBaseData((List)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof DynamicObject) {
                DynamicObject dynObject = (DynamicObject)entry.getValue();
                String dyName = dynObject.getDynamicObjectType().getName();
                if (PropertyHelper.existProperty(dyName, "name")) {
                    dataMap.put(key, dynObject.getString("name"));
                    continue;
                }
                if (!PropertyHelper.existProperty(dyName, "number")) continue;
                dataMap.put(key, dynObject.getString("number"));
                continue;
            }
            if (entry.getValue() instanceof Date) {
                dataMap.put(key, CardDrawElyMobHelper.handleEndDate(key, (Date)entry.getValue(), this.cardDrawDTO.getTimeLineField()));
                continue;
            }
            if (FieldTypeEnum.COMBO.getType().equals(field.get("type"))) {
                List<ComboItem> items;
                String number = (String)field.get("number");
                String pnumber = (String)field.get("pnumber");
                if (!HRStringUtils.isNotEmpty((String)number) || !HRStringUtils.isNotEmpty((String)pnumber) || CollectionUtils.isEmpty(items = ComboItemUtil.getComboItem(pnumber, number))) continue;
                for (ComboItem comboItem : items) {
                    String value = comboItem.getValue();
                    if (!entry.getValue().equals(value)) continue;
                    if ("isfulltime".equals(number) || "ishighestdegree".equals(number)) {
                        dataMap.put(key, "1".equals(entry.getValue()) ? "true" : "false");
                        continue;
                    }
                    dataMap.put(key, comboItem.getCaption().getLocaleValue());
                }
                continue;
            }
            if (entry.getValue() instanceof OrmLocaleValue) {
                dataMap.put(key, ((OrmLocaleValue)entry.getValue()).getLocaleValue());
                continue;
            }
            if (entry.getValue() instanceof BigDecimal) {
                dataMap.put(key, ((BigDecimal)entry.getValue()).setScale(1, 4).toString());
                continue;
            }
            if (FieldTypeEnum.ADMIN_DIVISION.getType().equals(field.get("type"))) {
                dataMap.put(key, ValueConvertHelper.handleAdminDivisionField((String)entry.getValue()));
                continue;
            }
            dataMap.put(key, entry.getValue().toString());
        }
        return dataMap;
    }

    protected boolean customValue(Map<String, String> dataMap, Map<String, Object> field, Object value) {
        return false;
    }

    protected void draw() {
        boolean hiddenAddBut;
        int index;
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(this.tabList);
        if (CollectionUtils.isEmpty(groups) || CollectionUtils.isEmpty(this.groupDataList)) {
            return;
        }
        String contentFlexKey = this.getContentFlexKey();
        AttacheHandlerService.containFlex(this.getView(), contentFlexKey);
        Container container = (Container)this.getView().getControl(contentFlexKey);
        CardDrawElyMobHelper.fieldSort(this.cardDrawDTO, groups);
        FlexPanelAp containerFlex = CardDrawElyMobHelper.createContainer(contentFlexKey);
        List<Object> dataList = null;
        if (groups.size() == 1 || this.isEduPage(this.tabList)) {
            int groupIndex = 0;
            if (this.isEduPage(this.tabList) && groups.size() > 1) {
                for (int idx = 0; idx < groups.size(); ++idx) {
                    Map<String, Object> group = groups.get(idx);
                    String entityName = ParamAnalysisUtil.getPageNumber(ParamAnalysisUtil.getFields(group));
                    if (!"hrpi_pereduexp".equals(entityName)) continue;
                    groupIndex = idx;
                    break;
                }
            }
            if (!CollectionUtils.isEmpty(this.groupDataList) && !CollectionUtils.isEmpty((Collection)this.groupDataList.get(groupIndex))) {
                dataList = this.groupDataList.get(groupIndex);
                for (index = 0; index < dataList.size(); ++index) {
                    containerFlex.getItems().add(this.drawCard(groups.get(groupIndex), dataList, index, index > 0));
                }
            }
        } else {
            dataList = new ArrayList(16);
            HashMap<String, Map<String, Object>> groupMap = new HashMap<String, Map<String, Object>>(groups.size());
            for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
                List<Map<String, String>> subDataList;
                List<Map<String, String>> list = subDataList = this.groupDataList.size() > groupIndex ? this.groupDataList.get(groupIndex) : null;
                if (subDataList == null || subDataList.size() <= 0) continue;
                Map<String, Object> group = groups.get(groupIndex);
                this.checkData(group.get("gname"));
                String gname = group.get("gname").toString();
                groupMap.put(gname, group);
                for (int index2 = 0; index2 < subDataList.size(); ++index2) {
                    Map<String, String> data = subDataList.get(index2);
                    data.put("@groupname", gname);
                    dataList.add(data);
                }
            }
            if (!CollectionUtils.isEmpty(dataList)) {
                for (index = 0; index < dataList.size(); ++index) {
                    Map data = (Map)dataList.get(index);
                    String gname = (String)data.get("@groupname");
                    Map group = (Map)groupMap.get(gname);
                    if ("hrpi_familymemb".equals(ParamAnalysisUtil.getPageNumber(ParamAnalysisUtil.getFields(group)))) {
                        data.remove("@groupname");
                    }
                    containerFlex.getItems().add(this.drawCard(group, dataList, index, index > 0));
                }
            }
        }
        String isPreviewStr = (String)this.getView().getFormShowParameter().getCustomParam("ispreview");
        boolean isPreview = HRStringUtils.isNotEmpty((String)isPreviewStr);
        boolean bl = hiddenAddBut = !this.hasAddOperate() || this.isViewStatus() || isPreview;
        if (this.isNeedShrink()) {
            containerFlex.getItems().add(this.drawCardDisplayOpPanel(contentFlexKey, true));
            containerFlex.getStyle().getPadding().setBottom("8px");
        }
        if (CollectionUtils.isEmpty((Collection)((Container)containerFlex.buildRuntimeControl()).getItems()) && !this.hasAddOperate()) {
            FlexPanelAp noDataFlex = CardDrawElyMobHelper.createNotDataFlextForCard(contentFlexKey);
            this.getView().updateControlMetadata(contentFlexKey, noDataFlex.createControl());
        } else {
            if (CollectionUtils.isEmpty((Collection)((Container)containerFlex.buildRuntimeControl()).getItems())) {
                containerFlex.getStyle().getPadding().setBottom("0px");
            }
            container.getItems().addAll(((Container)containerFlex.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(container.getItems());
            this.getView().updateControlMetadata(contentFlexKey, containerFlex.createControl());
        }
        if (hiddenAddBut) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
        }
        if (dataList != null && dataList.size() > 0) {
            this.getPageCache().put("first_dataid", CardDrawElyMobHelper.getDataId((Map)dataList.get(0)));
        }
    }

    private boolean isNeedShrink() {
        if (!CollectionUtils.isEmpty(this.groupDataList)) {
            int count = 0;
            for (List<Map<String, String>> list : this.groupDataList) {
                if (CollectionUtils.isEmpty(list) || (count += list.size()) <= 1) continue;
                return true;
            }
        }
        return false;
    }

    protected FlexPanelAp drawCardDisplayOpPanel(String contentFlexKey, boolean toGrow) {
        String key = contentFlexKey + "_cardgrow";
        FlexPanelAp cardDisplayOpPanel = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setId(key).setWrap(true).setMarginTop("8px")).setOverflow("visible").setDirection("row").setJustifyContent("center").setAlignItems("center").setGrow(0).setShrink(0).setBackColor("#ffffff").setAlignSelf("center").setClickable(true).setWidth("100%").setHeight("20px").build();
        String text = toGrow ? ResManager.loadKDString((String)"\u5c55\u5f00", (String)"AbstractMobCardEdit_8", (String)"sdk-hr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6536\u8d77", (String)"AbstractMobCardEdit_9", (String)"sdk-hr", (Object[])new Object[0]);
        LabelAp itemLabel = new HRLabelAp.Builder("key-text").setId(key + "-text").setName(text).setFontSize(12).setClickable(false).setForeColor("#999999").setTextAlign("flex-start").setGrow(0).setShrink(0).build();
        String fontClass = toGrow ? "kdfont kdfont-shouqi7" : "kdfont kdfont-zhankai4";
        VectorAp vectorAp = ((HRVectorAp.Builder)new HRVectorAp.Builder(key + "_pic").setfontClass(fontClass).setWidth(new LocaleString("12px")).setHeight(new LocaleString("12px")).setFontSize(12).setAlignSelf("center").setMarginLeft("6px")).setForeColor("#999999").setClickable(false).build();
        vectorAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiLmtkZm9udCB7XG4gIGZvbnQtc2l6ZTogMTJweDtcbn0ifQ==");
        cardDisplayOpPanel.getItems().add(itemLabel);
        cardDisplayOpPanel.getItems().add(vectorAp);
        return cardDisplayOpPanel;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.cardGrowAndShrink(true);
        PageCacheUtils.getHomePageCache(this.getView()).put(this.tabList.get("mappingFormid") + (String)this.tabList.get("targetkey") + "pageid", this.getView().getPageId());
    }

    public void checkData(Object ... objs) {
        if (objs == null) {
            this.throwDataExcepiton();
        }
        for (int index = 0; index < objs.length; ++index) {
            if (objs[index] != null) continue;
            this.throwDataExcepiton();
        }
    }

    private void throwDataExcepiton() {
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"AbstractMobCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    protected CardDrawDTO adjuestCardDrawFields(CardDrawDTO cardDraw, Map<String, String> data) {
        return cardDraw;
    }

    protected FlexPanelAp drawCard(Map<String, Object> group, List<Map<String, String>> dataList, int index, boolean margin) {
        Map<String, String> data = dataList.get(index);
        this.checkData(CardDrawElyMobHelper.getDataId(data));
        CardDrawDTO newcardDrawDTO = this.adjuestCardDrawFields(this.cardDrawDTO, data);
        newcardDrawDTO.usedFieldSet.clear();
        FlexPanelAp cardContentAp = CardDrawElyMobHelper.createCardContentAp(data);
        List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
        Map<String, Map<String, Object>> fieldMap = fields.stream().collect(Collectors.toMap(val -> CardDrawElyMobHelper.getFullFieldName(val), val -> val));
        Map<String, Tuple<String, String>> timeLineFieldMap = this.getTimeLineFieldSet();
        FlexPanelAp titleRowAp = CardDrawElyMobHelper.createTitleRowAp(fieldMap, newcardDrawDTO, timeLineFieldMap, data);
        if (titleRowAp.getItems().size() > 0) {
            this.changeLabel(titleRowAp);
            cardContentAp.getItems().add(titleRowAp);
        }
        List<Object> contentFields = newcardDrawDTO.getContentField().getFields();
        for (int idx = 0; idx < contentFields.size(); ++idx) {
            FlexPanelAp contentFieldRowAp;
            Map<String, Object> field;
            String fieldName;
            Object conField = contentFields.get(idx);
            if (conField == null) continue;
            String string = fieldName = conField instanceof LabelAp ? ((LabelAp)conField).getKey() : conField.toString();
            if (HRStringUtils.isEmpty((String)data.get(fieldName)) || (field = fieldMap.get(fieldName)) == null || !newcardDrawDTO.usedFieldSet.add(fieldName) || (contentFieldRowAp = CardDrawElyMobHelper.createContentField(field, conField, newcardDrawDTO, timeLineFieldMap, data, this.hasContentTitle())) == null) continue;
            this.changeLabel(contentFieldRowAp);
            if (titleRowAp == null && CollectionUtils.isEmpty((Collection)cardContentAp.getItems())) {
                contentFieldRowAp.getStyle().getMargin().setTop("0px");
            }
            cardContentAp.getItems().add(contentFieldRowAp);
        }
        boolean hasAbandonButton = this.DecorateFirstRow(data, cardContentAp);
        return this.createCard(cardContentAp, margin, data, hasAbandonButton);
    }

    protected boolean DecorateFirstRow(Map<String, String> data, FlexPanelAp cardContentAp) {
        boolean hasAbandonButton = false;
        if (cardContentAp.getItems().size() > 0) {
            String entityName = CardDrawElyMobHelper.getMainTabNameId(data);
            hasAbandonButton = ApprovalHelper.hasAbandonButton(this.getView(), entityName, Long.valueOf(CardDrawElyMobHelper.getDataId(data)));
            if (hasAbandonButton) {
                StringBuilder builder = new StringBuilder("viewop-");
                builder.append((String)this.tabList.get("groupname"));
                builder.append('-').append(CardDrawElyMobHelper.getDataId(data));
                builder.append("-hint");
                VectorAp notpassVectorAp = CardDrawElyHelper.createNotPassVectorAp(builder.toString());
                FlexPanelAp firstRow = (FlexPanelAp)cardContentAp.getItems().get(0);
                firstRow.getItems().add(notpassVectorAp);
            }
            if (this.hasAddOperate()) {
                FlexPanelAp firstRow = (FlexPanelAp)cardContentAp.getItems().get(0);
                FlexPanelAp editVectFlex = new HRFlexPanelAp.Builder(firstRow.getKey() + "-inner").setWrap(false).setHeight("20px").setJustifyContent("flex-end").setAlignItems("center").build();
                editVectFlex.getItems().add(CardDrawElyMobHelper.createEditVectorAp(data));
                firstRow.getItems().add(editVectFlex);
            }
        }
        return hasAbandonButton;
    }

    protected FlexPanelAp createCard(FlexPanelAp cardContentAp, boolean margin, Map<String, String> data, boolean hasAbandonButton) {
        FlexPanelAp cardAp = CardDrawElyMobHelper.createCardAp(data, margin);
        FlexPanelAp contentFlexAp = CardDrawElyMobHelper.createContenFlextAp(data);
        contentFlexAp.getItems().add(cardContentAp);
        Object ispreview = this.getView().getFormShowParameter().getCustomParam("ispreview");
        if (ispreview != null) {
            contentFlexAp.setClickable(false);
        }
        cardAp.getItems().add(contentFlexAp);
        return cardAp;
    }

    public boolean isViewStatus() {
        return OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus();
    }

    protected void changeLabel(FlexPanelAp flexPanelAp) {
        for (ControlAp controlAp : flexPanelAp.getItems()) {
            if (!(controlAp instanceof LabelAp)) continue;
            this.changeLabel((LabelAp)controlAp);
        }
    }

    private Map<String, Tuple<String, String>> getTimeLineFieldSet() {
        HashMap<Object, Tuple<String, String>> timeLineFieldSet = null;
        List<Tuple<String, String>> timeLineField = this.cardDrawDTO.getTimeLineField();
        if (!CollectionUtils.isEmpty(timeLineField)) {
            timeLineFieldSet = new HashMap(timeLineField.size() * 2);
            for (Tuple<String, String> tuple : timeLineField) {
                timeLineFieldSet.put(tuple.item1, tuple);
                timeLineFieldSet.put(tuple.item2, tuple);
            }
        }
        return timeLineFieldSet != null ? timeLineFieldSet : new HashMap<Object, Tuple<String, String>>(0);
    }

    protected String getContentFlexKey() {
        if (this.tabList == null && this.getView() == null || !this.analysisConfigParams(this.getView().getFormShowParameter())) {
            this.throwDataExcepiton();
        }
        return PageDrawUtil.getCardContentKey(this.tabList);
    }

    public void preOpenForm(PreOpenFormEventArgs eventArgs) {
        super.preOpenForm(eventArgs);
        MobileFormShowParameter baseShowParameter = (MobileFormShowParameter)eventArgs.getSource();
        this.tabList = ParamAnalysisUtil.getParams((FormShowParameter)baseShowParameter);
        if (this.tabList != null && this.tabList.get("groupname") != null) {
            eventArgs.getFormShowParameter().setCaption(this.tabList.get("groupname").toString());
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        if (this.hasAddOperate() && !this.isViewStatus()) {
            this.addClickListeners(new String[]{"mbaritemap"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Container) {
            Container container = (Container)evt.getSource();
            if (container.getKey().startsWith("cflext")) {
                String[] keys = this.analyzeContentContainerKey(container.getKey());
                this.adapterTabSelected(keys[1]);
                this.showDetail(keys[2], this.hasAddOperate() ? OperationStatus.EDIT : OperationStatus.VIEW);
            }
        } else if (evt.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)evt.getSource();
            if (menuItem.getKey().startsWith("mbaritemap")) {
                if (CommonUtil.existAuditingEntry(this.getView())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff1a\u5df2\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5ba1\u6279\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"AbstractMobCardEdit_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                    return;
                }
                this.showDetail(null, OperationStatus.ADDNEW);
            }
        } else if (evt.getSource() instanceof Label) {
            Label label = (Label)evt.getSource();
            if (label.getKey().startsWith("del")) {
                this.handleDel(label.getKey());
            } else if (label.getKey().endsWith("_cardgrow")) {
                this.cardGrowAndShrink(false);
            } else if (label.getKey().startsWith("viewdetailop_")) {
                String pkId = label.getKey().replace("viewdetailop_", "");
                this.showDetail(pkId, OperationStatus.VIEW);
            }
        }
    }

    private String[] analyzeContentContainerKey(String key) {
        String[] keys = key.split(":");
        if (keys.length != 3) {
            LOGGER.error(MessageFormat.format("====delKey_exception==={0}", key));
            this.throwDataExcepiton();
        }
        return keys;
    }

    private void adapterTabSelected(String pageNumber) {
        if (pageNumber == null) {
            return;
        }
        Map<String, Object> tabList = ParamAnalysisUtil.getParams(this.getView().getFormShowParameter());
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(tabList);
        if (groups != null && groups.size() > 1) {
            for (Map<String, Object> group : groups) {
                List<Map<String, Object>> fields = ParamAnalysisUtil.getFields(group);
                if (!pageNumber.equals(ParamAnalysisUtil.getPageNumber(fields))) continue;
                this.getPageCache().put("curTabKey", ParamAnalysisUtil.getGroupName(group));
                break;
            }
        }
    }

    private void cardGrowAndShrink(boolean init) {
        List dataIds;
        String dataIdsStr = this.getView().getPageCache().get("data_ids");
        if (HRStringUtils.isNotEmpty((String)dataIdsStr) && !CollectionUtils.isEmpty((Collection)(dataIds = SerializationUtils.fromJsonStringToList((String)dataIdsStr, String.class)))) {
            if (dataIds.size() == 1) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"card" + (String)dataIds.get(0)});
            } else if (dataIds.size() > 1) {
                String firstDataIdStr = this.getView().getPageCache().get("first_dataid");
                List<String> newDatas = dataIds.stream().filter(val -> !val.equals(firstDataIdStr)).map(val -> "card" + val).collect(Collectors.toList());
                if (init) {
                    this.getView().setVisible(Boolean.FALSE, newDatas.toArray(new String[0]));
                    return;
                }
                String contentFlexKey = this.getContentFlexKey();
                String key = contentFlexKey + "_cardgrow";
                boolean shrinkStatus = StringUtils.isEmpty((Object)this.getPageCache().get(key));
                FlexPanelAp flexPanelAp = this.drawCardDisplayOpPanel(contentFlexKey, !shrinkStatus);
                this.getView().updateControlMetadata(flexPanelAp.getKey(), flexPanelAp.createControl());
                if (shrinkStatus) {
                    this.getPageCache().put(key, "true");
                    this.getView().setVisible(Boolean.TRUE, newDatas.toArray(new String[0]));
                } else {
                    this.getPageCache().remove(key);
                    this.getView().setVisible(Boolean.FALSE, newDatas.toArray(new String[0]));
                }
            }
        }
    }

    protected void handleDel(String key) {
        DynamicObject bill;
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParam("person");
        if (!(personId == null || personId.equals(0L) || HRObjectUtils.isEmpty((Object)(bill = ApprovalHelper.getInProcessWorkFlowBill(personId))) || "G".equals(bill.getString("billstatus")))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u4eba\u5458\u6863\u6848\u4fe1\u606f\u53d8\u66f4\u7533\u8bf7\uff0c\u8bf7\u64a4\u9500\u5355\u636e\u6216\u7b49\u5f85\u5ba1\u6279\u7ed3\u675f\u540e\uff0c\u518d\u64cd\u4f5c\u5220\u9664\u3002", (String)"AbstractMobCardEdit_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        if (!this.checkDelPerm(this.getView())) {
            return;
        }
        String[] delKey = this.getDelKey(key);
        String curEntity = delKey[1];
        String pkStr = delKey[2];
        String tips = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"AbstractMobCardEdit_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        if (!ApprovalHelper.noNeedDelAudit(this.getView(), pkStr, curEntity)) {
            tips = ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5305\u542b\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\uff0c\u9700\u8fd4\u56de\u9996\u9875\u64cd\u4f5c\u201c\u63d0\u4ea4\u5ba1\u6838\u201d\uff0c\u7ecf\u5ba1\u6838\u901a\u8fc7\u624d\u53ef\u5220\u9664\u3002", (String)"AbstractMobCardEdit_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
    }

    private boolean existAuditCache(DynamicObject bill, String entityName, Long dataId) {
        Map<String, Object> tabList = ParamAnalysisUtil.getParams(this.getView().getFormShowParameter());
        String groupNum = (String)tabList.get("targetkey");
        if (HRStringUtils.isNotEmpty((String)groupNum)) {
            DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entity) {
                if (!groupNum.equals(dynamicObject.getString("firstgroupnum"))) continue;
                Long dataIdDB = dynamicObject.getLong("dataid");
                String entityNameDB = dynamicObject.getString("entityname");
                if ("hrpi_pereduexpcert".equals(entityNameDB)) {
                    dataIdDB = BusinessUtils.getEduexpByEduCertId(dataIdDB);
                    entityNameDB = "hrpi_pereduexp";
                }
                if (!dataId.equals(dataIdDB) || !entityName.equals(entityNameDB)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDelPerm(IFormView view) {
        String curEntity = this.getView().getEntityId();
        boolean hasPerm = CommonUtil.hasPerm(curEntity, "4715e1f1000000ac", "hssc", view);
        if (!hasPerm) {
            this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
            return false;
        }
        return true;
    }

    private String[] getDelKey(String key) {
        String[] delKey = key.split(":");
        if (delKey.length != 3) {
            LOGGER.error(MessageFormat.format("====delKey_exception==={0}", key));
            this.throwDataExcepiton();
        }
        return delKey;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) {
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        LOGGER.info(MessageFormat.format("confirmCallBack key:{0}", key));
        if (HRStringUtils.isNotEmpty((String)key) && key.startsWith("del")) {
            List dataIds;
            String[] delKey = this.getDelKey(key);
            String curEntity = delKey[1];
            String pkStr = delKey[2];
            String dataIdsStr = this.getView().getPageCache().get("data_ids");
            if (HRStringUtils.isNotEmpty((String)dataIdsStr) && !CollectionUtils.isEmpty((Collection)(dataIds = SerializationUtils.fromJsonStringToList((String)dataIdsStr, String.class))) && !dataIds.contains(pkStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u6cd5\u5220\u9664", (String)"AbstractMobCardEdit_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkDelPerm(this.getView())) {
                return;
            }
            Tuple<Boolean, Boolean> tuple = this.delData(curEntity, Long.parseLong(pkStr));
            if (((Boolean)tuple.item1).booleanValue() && ((Boolean)tuple.item2).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AbstractMobCardEdit_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            } else if (!((Boolean)tuple.item1).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"AbstractMobCardEdit_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Tuple<Boolean, Boolean> delData(String entityName, Long pk) {
        HRBaseServiceHelper serviceHelper;
        AttacheHandlerService attacheHandlerService = AttacheHandlerService.getInstance();
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(entityName);
        DynamicObject dyArr = null;
        if ((PersonModelClassificationEnum.PERATTACHED == classification || "hrpi_empjobrel".equals(entityName)) && (dyArr = (serviceHelper = new HRBaseServiceHelper(entityName)).loadSingle((Object)pk)) == null) {
            return Tuple.create((Object)Boolean.TRUE, (Object)Boolean.TRUE);
        }
        this.tabList = ParamAnalysisUtil.getParams(this.getView().getFormShowParameter());
        if (ApprovalHelper.dealAuditBeforeDel(this.getView(), entityName, pk, dyArr, this.tabList)) {
            return Tuple.create((Object)Boolean.TRUE, (Object)Boolean.FALSE);
        }
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
        HashMap<Long, Long> pkPersonIdMap = new HashMap<Long, Long>(16);
        pkPersonIdMap.put(pk, personId);
        List<Long> personIds = AttacheHandlerService.getInstance().validateSyncFieldsDelChange(entityName, pkPersonIdMap);
        Map<String, Object> resultMap = attacheHandlerService.invokeDel(Collections.singletonList(pk), entityName, Boolean.TRUE);
        if (AttacheHandlerService.isSuccess(resultMap)) {
            List<Long> eudCertIds;
            if ("hrpi_pereduexp".equals(entityName) && !CollectionUtils.isEmpty(eudCertIds = BusinessUtils.getEduCertIdByEduId(pk))) {
                attacheHandlerService.invokeDel(eudCertIds, "hrpi_pereduexpcert", Boolean.TRUE);
                for (Long eudCertId : eudCertIds) {
                    this.handleApprovalDataAfterDelete("hrpi_pereduexpcert", eudCertId);
                }
            }
            if (personIds != null && personIds.size() > 0) {
                AttacheHandlerService.getInstance().sendChangeInfoSyncToSysUser(personIds);
            }
            if (dyArr != null) {
                String realFormId = AttacheHandlerService.getInstance().getRealFormId(this.getView(), "pagenumber", false);
                AttacheHandlerService.getInstance().sendHpfsChgDeleteRecord(new DynamicObject[]{dyArr}, entityName, realFormId);
            }
            this.getView().updateView();
            this.getView().sendFormAction(this.getView());
            this.handleApprovalDataAfterDelete(entityName, pk);
            attacheHandlerService.removeAllAttachment(entityName, pk);
            return Tuple.create((Object)Boolean.TRUE, (Object)Boolean.TRUE);
        }
        return Tuple.create((Object)Boolean.FALSE, (Object)Boolean.FALSE);
    }

    private void handleApprovalDataAfterDelete(String entityName, Long id) {
        DynamicObject bill = this.getInProcessWorkFlowBill();
        if (bill != null && "G".equals(bill.getString("billstatus")) && this.existAuditCache(bill, entityName, id)) {
            this.abandon(entityName, id);
        } else {
            this.deleteApprovalCache(entityName, id);
        }
    }

    protected boolean abandon(String entityName, Long dataId) {
        DynamicObject bill;
        Map<String, Object> tabList = ParamAnalysisUtil.getParams(this.getView().getFormShowParameter());
        String groupName = (String)tabList.get("groupname");
        String cacheValue = this.getGroupAuditCacheValue(groupName);
        if (HRStringUtils.isEmpty((String)cacheValue) || (bill = this.getInProcessWorkFlowBill()) == null || !"G".equals(bill.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean exist = false;
        DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
        List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
        if (!CollectionUtils.isEmpty((Collection)groupFields)) {
            String firstGroupNum = (String)tabList.get("targetkey");
            Iterator iterator = groupFields.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (!dataId.equals(map.get("dataid")) || !entityName.equals(map.get("entityName"))) continue;
                for (DynamicObject dynamicObject : entity) {
                    StringBuilder fullKey = new StringBuilder(firstGroupNum).append(map.get("entityName")).append(map.get("fieldname")).append(map.get("dataid"));
                    if (!ApprovalHelper.getFullKey(dynamicObject).equals(fullKey.toString())) continue;
                    entity.remove((Object)dynamicObject);
                    break;
                }
                iterator.remove();
                if (exist) continue;
                exist = true;
            }
        }
        if (!exist) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AbstractElyCardEdit_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getView().getParentView() != null) {
            if (CollectionUtils.isEmpty((Collection)groupFields)) {
                this.getView().getParentView().getPageCache().batchRemove(Collections.singletonList(groupName + "-entrycache"));
            } else {
                this.getView().getParentView().getPageCache().put(groupName + "-entrycache", SerializationUtils.toJsonString((Object)groupFields));
            }
        }
        if (entity.size() == 0) {
            try {
                WorkflowServiceHelper.withdraw((DynamicObject)bill);
            }
            catch (Exception exception) {
                LOGGER.error("withdraw ex:", (Throwable)exception);
            }
            new OperationServiceImpl().localInvokeOperation("delete", new DynamicObject[]{bill}, OperateOption.create());
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().getPageCache().remove("submitVerson");
            }
        } else {
            INFOAPPROVAL_HELPER.updateOne(bill);
        }
        ApprovalHelper.updateSyncCacheToDataBase(this.getView());
        return true;
    }

    private void deleteApprovalCache(String entityName, Long id) {
        if (this.getView().getParentView() == null) {
            return;
        }
        this.tabList = ParamAnalysisUtil.getParams(this.getView().getFormShowParameter());
        if (this.tabList != null && this.tabList.get("groupname") != null) {
            String groupName = (String)this.tabList.get("groupname");
            Map allCache = this.getView().getParentView().getPageCache().getAll();
            if (!CollectionUtils.isEmpty((Map)allCache)) {
                String cacheKey = groupName + "-entrycache";
                String cacheValue = (String)allCache.get(cacheKey);
                if (HRStringUtils.isEmpty((String)cacheValue)) {
                    return;
                }
                List groupFields = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
                if (!CollectionUtils.isEmpty((Collection)groupFields)) {
                    Iterator it = groupFields.iterator();
                    while (it.hasNext()) {
                        Map map = (Map)it.next();
                        if (!id.equals(map.get("dataid")) || !entityName.equals(map.get("entityName"))) continue;
                        it.remove();
                    }
                }
                if (CollectionUtils.isEmpty((Collection)groupFields)) {
                    this.getView().getParentView().getPageCache().batchRemove(Collections.singletonList(cacheKey));
                } else {
                    this.getView().getParentView().getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)groupFields));
                }
                ApprovalHelper.updateSyncCacheToDataBase(this.getView());
            }
        }
    }

    protected void showDetail(String pkId, OperationStatus status) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        String mdgFormId = this.getDialogEntity();
        if (mdgFormId == null) {
            this.throwDataExcepiton();
        }
        if (!this.checkDialogPagePerm(mdgFormId, status)) {
            return;
        }
        showParameter.setFormId(mdgFormId);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.remove("isfrominitopen");
        showParameter.setCustomParams(customParams);
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(this.tabList);
        if (!CollectionUtils.isEmpty(groups) && groups.size() > 1 && !this.isEduPage(this.tabList)) {
            String curTabKey = this.getPageCache().get("curTabKey");
            Optional<Map> targetGroupOp = groups.stream().filter(val -> curTabKey == null || curTabKey.equalsIgnoreCase((String)val.get("gname"))).findAny();
            groups.clear();
            if (targetGroupOp.isPresent()) {
                groups.add(targetGroupOp.get());
                showParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString(this.tabList));
            }
        }
        showParameter.setCustomParam("pkid", (Object)pkId);
        showParameter.setCaption(this.tabList.get("groupname").toString());
        if (OperationStatus.ADDNEW == status) {
            showParameter.setCustomParam("cus_status", (Object)"cus_addnew");
        } else {
            showParameter.setCustomParam("cus_status", (Object)"cus_edit");
        }
        showParameter.setHasRight(true);
        showParameter.setStatus(status);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkDialogPagePerm(String dialogPageNumber, OperationStatus status) {
        boolean isOldHss;
        boolean bl = isOldHss = this.getView().getParentView() != null && "hss_businessoffice".equals(this.getView().getParentView().getFormShowParameter().getParentFormId());
        if (isOldHss) {
            return true;
        }
        String permItemId = null;
        if (OperationStatus.VIEW == status) {
            permItemId = "47150e89000000ac";
        } else if (OperationStatus.ADDNEW == status) {
            permItemId = "47156aff000000ac";
        } else if (OperationStatus.EDIT == status) {
            permItemId = "47150e89000000ac";
        }
        if (permItemId != null && !CommonUtil.hasPerm(dialogPageNumber, permItemId, "hssc", this.getView())) {
            this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
            return false;
        }
        return true;
    }

    private String getDialogEntity() {
        this.tabList = ParamAnalysisUtil.getParams(this.getView().getFormShowParameter());
        if (this.tabList != null && !CollectionUtils.isEmpty(ParamAnalysisUtil.getGroups(this.tabList))) {
            List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(this.tabList);
            if (groups.size() == 1 || HRStringUtils.isEmpty((String)this.getPageCache().get("curTabKey"))) {
                return ParamAnalysisUtil.getDialogPageNumber(ParamAnalysisUtil.getFields(groups.get(0)));
            }
            String curTabKey = this.getPageCache().get("curTabKey");
            for (Map<String, Object> group : groups) {
                if (!curTabKey.equalsIgnoreCase((String)group.get("gname"))) continue;
                return ParamAnalysisUtil.getDialogPageNumber(ParamAnalysisUtil.getFields(group));
            }
        }
        return null;
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (this.enableEnterDetail() && key.startsWith("cflext") && !this.isViewStatus()) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        } else if (key.startsWith("del") || key.endsWith("_cardgrow") || key.startsWith("viewdetailop_")) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            if (key.startsWith("del")) {
                label.setOperationKey("do_del");
            }
            args.setControl((Control)label);
        } else if (key.endsWith("tab") && key.equals(this.getContentFlexKey() + "tab")) {
            Tab tab = new Tab();
            tab.setKey(key);
            tab.setView(this.getView());
            tab.addTabSelectListener((TabSelectListener)this);
            args.setControl((Control)tab);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.getPageCache().put("curTabKey", tabSelectEvent.getTabKey());
    }

    protected DynamicObject getInProcessWorkFlowBill() {
        Object bill = INPROCESS_BILL_TL.get();
        if (bill instanceof String) {
            return null;
        }
        if (bill instanceof DynamicObject) {
            return (DynamicObject)bill;
        }
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParams().get("person");
        DynamicObject dynamicObject = ApprovalHelper.getInProcessWorkFlowBill(personId);
        INPROCESS_BILL_TL.set(dynamicObject != null ? dynamicObject : "");
        return dynamicObject;
    }

    private boolean isEduPage(Map<String, Object> tabList) {
        String mappingFormId = ParamAnalysisUtil.getMappingFormId(tabList);
        return "hrpi_pereduexp".equals(mappingFormId) || "hrpi_pereduexpcert".equals(mappingFormId);
    }
}

