/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.employee.base;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.business.helper.CardDrawElyMobHelper;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.CardDrawDTO;
import kd.sdk.hr.hspm.common.dto.FieldDTO;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.PageDrawUtil;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;

public interface ElyCardTplEdit {
    public static final Log LOGGER = LogFactory.getLog(ElyCardTplEdit.class);
    public static final ThreadLocal<CardDrawDTO> CARDDRAWDTO_THREADLOCAL = new ThreadLocal();
    public static final ThreadLocal<List<List<Map<String, String>>>> GROUPDATALIST_THREADLOCAL = new ThreadLocal();
    public static final String MULTIVIEW_CONFIG_CACHE = "multiview_config_cache";

    default public void load(IFormView view) {
        if (view == null || !this.analysisConfigParams(view)) {
            LOGGER.warn("analysisConfigParams fail");
            return;
        }
        this.setField();
        this.fieldSort(this.getCardDrawDTO(), this.getMultiViewConfig(view));
        this.setData(this.getGroupDataList());
        this.draw();
    }

    default public boolean analysisConfigParams(IFormView view) {
        LOGGER.info(MessageFormat.format("===analysisConfigParams==={0}", view.getFormShowParameter().getCustomParams()));
        Map<String, Object> tabList = ParamAnalysisUtil.getParams(view.getFormShowParameter());
        if (tabList != null) {
            view.getPageCache().put(MULTIVIEW_CONFIG_CACHE, SerializationUtils.toJsonString(tabList));
            return true;
        }
        return false;
    }

    default public void setField() {
        CardDrawDTO cardDrawDTO = this.getCardDrawDTO();
        this.setTitleField(cardDrawDTO.getTitleField());
        this.setTagField(cardDrawDTO.getTagField());
        this.setTimeLineField(cardDrawDTO.getTimeLineField());
        this.setContentField(cardDrawDTO.getContentField());
        cardDrawDTO.collectionAllFields();
    }

    default public void fieldSort(CardDrawDTO cardDrawDTO, Map<String, Object> config) {
        List<Map<String, Object>> groups = ParamAnalysisUtil.getGroups(config);
        if (!HRObjectUtils.isEmpty((Object)cardDrawDTO) && !CollectionUtils.isEmpty(groups)) {
            CardDrawElyMobHelper.fieldSort(this.getCardDrawDTO(), groups);
        }
    }

    default public void setTitleField(FieldDTO titleField) {
    }

    default public void setTagField(FieldDTO tagField) {
    }

    default public void setTimeLineField(List<Tuple<String, String>> timeLineField) {
    }

    default public void setContentField(FieldDTO contentField) {
    }

    public void setData(List<List<Map<String, String>>> var1);

    public void draw();

    default public CardDrawDTO getCardDrawDTO() {
        CardDrawDTO cardDrawDTO = CARDDRAWDTO_THREADLOCAL.get();
        if (HRObjectUtils.isEmpty((Object)cardDrawDTO)) {
            cardDrawDTO = new CardDrawDTO();
            CARDDRAWDTO_THREADLOCAL.set(cardDrawDTO);
        }
        return cardDrawDTO;
    }

    default public List<List<Map<String, String>>> getGroupDataList() {
        List<List<Map<String, String>>> groupDataList = GROUPDATALIST_THREADLOCAL.get();
        if (CollectionUtils.isEmpty(groupDataList)) {
            groupDataList = new ArrayList<List<Map<String, String>>>(2);
            GROUPDATALIST_THREADLOCAL.set(groupDataList);
        }
        return groupDataList;
    }

    default public Map<String, Object> getMultiViewConfig(IFormView view) {
        String cache;
        if (view != null && (cache = view.getPageCache().get(MULTIVIEW_CONFIG_CACHE)) != null) {
            return (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        throw new KDBizException("not analysis ConfigParams");
    }

    default public String getContentFlexKey(Map<String, Object> tabList) {
        return PageDrawUtil.getCardContentKey(tabList);
    }

    default public String getOrderBys(String tableName) {
        return "createtime";
    }

    default public QFilter getQFilter(Map.Entry<String, List<Map<String, Object>>> entry, Map<String, Object> values) {
        QFilter qFilter = PersonModelUtil.getQFilter(entry.getKey(), values);
        if (qFilter != null) {
            String filterP;
            List filters;
            qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
            qFilter.and("initstatus", "=", (Object)"2");
            qFilter.and("datastatus", "in", (Object)new String[]{"-3", "1"});
            if (values.get("filterParam") != null && !CollectionUtils.isEmpty((Collection)(filters = SerializationUtils.fromJsonStringToList((String)(filterP = values.get("filterParam").toString()), QFilter.class)))) {
                for (QFilter filter : filters) {
                    qFilter.and(filter);
                }
            }
        }
        return qFilter;
    }

    default public Map<String, String> changeToMap(String tabName, Map<String, Map<String, Object>> fieldMap, DynamicObject dynamicObject, boolean ispreview) {
        Map orginalDataMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject);
        HashMap<String, String> dataMap = new HashMap<String, String>(orginalDataMap.size());
        for (Map.Entry entry : orginalDataMap.entrySet()) {
            String key = tabName + "." + (String)entry.getKey();
            if (((String)entry.getKey()).equals("id") || ((String)entry.getKey()).equals("datastatus")) {
                dataMap.put(key, entry.getValue().toString());
                continue;
            }
            Map<String, Object> field = fieldMap.get(entry.getKey());
            if (field == null || !ispreview && entry.getValue() == null) continue;
            if (ispreview) {
                dataMap.put(key, (String)field.get("displayname"));
                continue;
            }
            if (this.customValue(dataMap, field, entry.getValue(), orginalDataMap)) continue;
            if (entry.getValue() instanceof List) {
                dataMap.put(key, ValueConvertHelper.handleMulBaseData((List)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof DynamicObject) {
                DynamicObject dynObject = (DynamicObject)entry.getValue();
                String dyName = dynObject.getDynamicObjectType().getName();
                if (PropertyHelper.existProperty(dyName, "name")) {
                    dataMap.put(key, dynObject.getString("name"));
                    continue;
                }
                if (!PropertyHelper.existProperty(dyName, "number")) continue;
                dataMap.put(key, dynObject.getString("number"));
                continue;
            }
            if (entry.getValue() instanceof Date) {
                dataMap.put(key, CardDrawElyMobHelper.handleEndDate(key, (Date)entry.getValue(), this.getCardDrawDTO().getTimeLineField()));
                continue;
            }
            if (FieldTypeEnum.COMBO.getType().equals(field.get("type"))) {
                List<ComboItem> items;
                String number = (String)field.get("number");
                String pnumber = (String)field.get("pnumber");
                if (!HRStringUtils.isNotEmpty((String)number) || !HRStringUtils.isNotEmpty((String)pnumber) || CollectionUtils.isEmpty(items = ComboItemUtil.getComboItem(pnumber, number))) continue;
                for (ComboItem comboItem : items) {
                    String value = comboItem.getValue();
                    if (!entry.getValue().equals(value)) continue;
                    if ("isfulltime".equals(number) || "ishighestdegree".equals(number)) {
                        dataMap.put(key, "1".equals(entry.getValue()) ? "true" : "false");
                        continue;
                    }
                    dataMap.put(key, comboItem.getCaption().getLocaleValue());
                }
                continue;
            }
            if (entry.getValue() instanceof OrmLocaleValue) {
                dataMap.put(key, ((OrmLocaleValue)entry.getValue()).getLocaleValue());
                continue;
            }
            if (entry.getValue() instanceof BigDecimal) {
                dataMap.put(key, ((BigDecimal)entry.getValue()).setScale(1, AttacheHandlerService.getInstance().getRoundingMode(key)).toString());
                continue;
            }
            if (FieldTypeEnum.ADMIN_DIVISION.getType().equals(field.get("type"))) {
                dataMap.put(key, ValueConvertHelper.handleAdminDivisionField((String)entry.getValue()));
                continue;
            }
            dataMap.put(key, entry.getValue().toString());
        }
        return dataMap;
    }

    default public boolean customValue(Map<String, String> dataMap, Map<String, Object> field, Object value, Map<String, Object> orginalDataMap) {
        return false;
    }

    default public boolean isPreView(IFormView view) {
        String isPreviewStr = (String)view.getFormShowParameter().getCustomParam("ispreview");
        return HRStringUtils.isNotEmpty((String)isPreviewStr);
    }

    default public boolean hasAddOperate() {
        return false;
    }

    default public boolean hasEditOperate() {
        return false;
    }

    default public boolean hasDeleteOperate() {
        return false;
    }
}

