/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.annotation.SdkPlugin;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

@SdkPlugin(name="\u8868\u5355\u7ed8\u753b\u7f16\u8f91\u9875\u9762\u516c\u5171\u62bd\u8c61\u7c7b\uff0c\u6f14\u793a\u4e13\u7528")
public class CommonSingleFormDrawEdit
extends AbstractFormDrawEdit {
    private static final Log logger = LogFactory.getLog(CommonSingleFormDrawEdit.class);

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadDbDataToPage();
    }

    private void loadDbDataToPage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AttacheHandlerService.getInstance().setMainPageStyle(this.getView());
        String tabInfo = (String)formShowParameter.getCustomParam("params");
        Map tabMap = (Map)SerializationUtils.fromJsonString((String)tabInfo, Map.class);
        String relPageNumber = null;
        HashSet<String> pageNumber = new HashSet<String>(16);
        ArrayList<String> fieldList = new ArrayList<String>(10);
        List origList = (List)tabMap.get("groups");
        for (Map origMap : origList) {
            List fields = (List)origMap.get("fields");
            for (Map field : fields) {
                String number = (String)field.get("pnumber");
                pageNumber.add(number);
                relPageNumber = number;
                fieldList.add((String)field.get("number"));
            }
        }
        if (pageNumber.size() != 1) {
            this.getView().setStatus(OperationStatus.VIEW);
            logger.info("notSupportMulGroup");
            return;
        }
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(relPageNumber);
        if (classification == null) {
            this.getView().setStatus(OperationStatus.VIEW);
            logger.info("classificationIsEmpty");
            return;
        }
        String typeConstant = classification.getMainKey();
        this.getPageCache().put("relPageNumber", relPageNumber);
        this.getPageCache().put("selecttype", typeConstant);
        List<DrawFormFieldDto> allFieldList = this.getAllFieldList((String)formShowParameter.getCustomParam("params"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(relPageNumber);
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        String queryFields = CommonUtil.listToString(fieldList, ',');
        DynamicObject personEntityData = this.getPersonEntityData(formShowParameter, relPageNumber, typeConstant, queryFields, serviceHelper, qFilter);
        if (personEntityData != null) {
            this.getPageCache().put("type", "0");
            this.assembleValue(null, allFieldList, personEntityData, relPageNumber, fieldList);
        } else {
            this.getPageCache().put("type", "1");
        }
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttacheHandlerService.getInstance().commonBtnReg(this.getView(), this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("edit".equals(source.getKey())) {
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("btncancel".equals(source.getKey())) {
            if (this.getModel().getDataChanged()) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                this.clickCancelChanged((String)formShowParameter.getCustomParam("type"));
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
        } else if ("btnsave".equals(source.getKey())) {
            String relPageNumber = this.getPageCache().get("relPageNumber");
            String type = this.getPageCache().get("type");
            if ("0".equals(type)) {
                String selectType = this.getPageCache().get("selecttype");
                this.updateAttachData(relPageNumber, this.getView(), true, selectType);
            } else if ("1".equals(type)) {
                this.addAttachData(relPageNumber, this.getView(), this.getModel().getDataEntity(), true);
            }
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    protected Map<String, Object> diffDialogOrForm() {
        Map<String, Object> diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", Boolean.FALSE);
        return diffMap;
    }
}

