/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.template;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.util.StringUtils;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.formplugin.mobile.file.base.AbstractMobileFormDrawEdit;

public class EmployeeMobileFormDrawEdit
extends AbstractMobileFormDrawEdit {
    private static final String FORM_ID = "formId";
    private static final String IS_SINGLE = "isSingle";

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        String formId = ParamAnalysisUtil.getMappingFormId(ParamAnalysisUtil.getParams(formShowParameter));
        boolean trueIsSingle = InfoGroupHelper.isSingleRowTpl(formId);
        if (trueIsSingle) {
            AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, formId);
        }
        super.loadCustomControlMetas(args);
    }

    @Override
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String status = (String)this.getView().getFormShowParameter().getCustomParam("cus_status");
        if ("cus_edit".equals(status)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else {
            if ("cus_addnew".equals(status)) {
                this.getView().setStatus(OperationStatus.ADDNEW);
                return;
            }
            this.getView().setStatus(OperationStatus.VIEW);
        }
        String formId = this.getFormIdFromCache(this.getView().getFormShowParameter());
        boolean isSingle = this.isSingle(formId);
        if (isSingle) {
            this.setValueFromDb(this.getView().getFormShowParameter(), formId, "person");
        } else {
            this.setValueFromDb(this.getView().getFormShowParameter(), formId, null);
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    protected Map<String, Object> diffDialogOrForm() {
        Map<String, Object> diffMap = super.diffDialogOrForm();
        String formId = this.getFormIdFromCache(this.getView().getFormShowParameter());
        boolean isSingle = this.isSingle(formId);
        if (isSingle) {
            diffMap.put("isdia", Boolean.FALSE);
        }
        return diffMap;
    }

    private String getFormIdFromCache(FormShowParameter params) {
        String formId = this.getPageCache().get(FORM_ID);
        if (StringUtils.isEmpty((String)formId)) {
            String trueFormId;
            formId = trueFormId = ParamAnalysisUtil.getMappingFormId(ParamAnalysisUtil.getParams(params));
            this.getPageCache().put(FORM_ID, trueFormId);
        }
        return formId;
    }

    private boolean isSingle(String formId) {
        String isSingle = this.getPageCache().get(IS_SINGLE);
        if (StringUtils.isEmpty((String)isSingle)) {
            boolean trueIsSingle = InfoGroupHelper.isSingleRowTpl(formId);
            isSingle = String.valueOf(trueIsSingle);
            this.getPageCache().put(IS_SINGLE, isSingle);
        }
        return Boolean.parseBoolean(isSingle);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String formId = this.getFormIdFromCache(this.getView().getFormShowParameter());
        Control source = (Control)evt.getSource();
        if ("btn_edit".equals(source.getKey())) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().getFormShowParameter().setCustomParam("cus_status", (Object)"cus_edit");
            this.getView().invokeOperation("refresh");
        } else if ("btn_save".equals(source.getKey())) {
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("pkid");
            Long pkid = Long.parseLong(customParam == null ? "0" : customParam);
            boolean isSingle = this.isSingle(formId);
            if (isSingle) {
                this.acrossEntitySaveOrUpdate();
            } else {
                Map<String, Object> resultMap = null;
                resultMap = pkid != null && pkid != 0L ? this.updateAttachData(formId, this.getView(), false, null) : this.addAttachData("0", formId, this.getView(), this.getModel().getDataEntity(), false);
                this.closeView(this.getView(), resultMap, this.getView().getParentView());
            }
        }
    }
}

