/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.template;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPlugin;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.enums.PersonModelClassificationEnum;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;
import kd.sdk.hr.hspm.common.utils.PersonModelUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

@SdkPlugin(name="\u8868\u5355\u7ed8\u753b\u7f16\u8f91\u9875\u9762\u516c\u5171\u62bd\u8c61\u7c7b\uff0c\u6f14\u793a\u4e13\u7528")
public class ManagePCFullFormDrawEdit
extends AbstractFormDrawEdit {
    private static final Log logger = LogFactory.getLog(ManagePCFullFormDrawEdit.class);

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        String mappingFormId = ParamAnalysisUtil.getMappingFormId(ParamAnalysisUtil.getParams(formShowParameter));
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, mappingFormId);
        super.loadCustomControlMetas(args);
    }

    @Override
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AttacheHandlerService.getInstance().setMainPageStyle(this.getView());
        String mappingFormId = this.getMappingFormId();
        PersonModelClassificationEnum classification = PersonModelUtil.getClassification(mappingFormId);
        if (classification == null) {
            this.getView().setStatus(OperationStatus.VIEW);
            logger.info("classificationIsEmpty");
            return;
        }
        String typeConstant = classification.getMainKey();
        this.setValueFromDb(formShowParameter, this.getMappingFormId(), typeConstant);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private String getMappingFormId() {
        return ParamAnalysisUtil.getMappingFormId(ParamAnalysisUtil.getParams(this.getView().getFormShowParameter()));
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttacheHandlerService.getInstance().commonBtnReg(this.getView(), this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("edit".equals(source.getKey()) || "edit_label".equals(source.getKey())) {
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("btncancel".equals(source.getKey()) || "btncancel_label".equals(source.getKey())) {
            if (this.getModel().getDataChanged()) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String mainType = (String)formShowParameter.getCustomParam("type");
                this.clickCancelChanged(mainType);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
        } else if ("btnsave".equals(source.getKey()) || "btnsave_label".equals(source.getKey())) {
            this.acrossEntitySaveOrUpdate();
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    protected Map<String, Object> diffDialogOrForm() {
        Map<String, Object> diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", Boolean.FALSE);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }
}

