/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.sdk.hr.hspm.business.helper.ImportBasedataHelper;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class InfoClassifyHRImportPlugin
implements HRImportPlugin {
    public static final String HRPI_EMPPOSORGREL_ISLATESTRECORD = "hrpi_empposorgrel.islatestrecord";
    public static final String HRPI_EMPENTREL_LABORRELSTATUS = "hrpi_empentrel.laborrelstatus";
    public static final String HRPI_EMPPOSORGREL_BUSINESSSTATUS = "hrpi_empposorgrel.businessstatus";
    public static final String HRPI_EMPENTREL_ISLATESTRECORD = "hrpi_empentrel.islatestrecord";
    public static final String HRPI_EMPPOSORGREL_EMPPOSING = "hrpi_empposorgrel.empposing";
    private static final Map<String, String> ignoreRefBdNameMap = new HashMap<String, String>(){
        {
            this.put("hrpi_empposorgrel", "adminorg,apositiontype,position,stdposition,job");
            this.put("hspm_ermanfile", "empgroup,org");
        }
    };
    private static final Set<Long> LABORREL_STATUS;
    private static final Set<Long> LABORREL_STATUS_STP;
    private static final Long LABRELSTATUSPRD_ING;
    private static final Long LABRELSTATUSPRD_END;

    public void afterInitContext(AfterInitContextArgs args) {
        args.setDisableRepeatDataValidator(Boolean.valueOf(true));
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        super.beforeValidate(args);
        List importBillDataList = args.getBillDatas();
        for (ImportBillData importBillData : importBillDataList) {
            JSONObject mainEntity = new JSONObject();
            String mainEntityId = importBillData.getMainEntityId();
            mainEntity.put(mainEntityId, importBillData.getData().get((Object)mainEntityId));
            importBillData.getData().fluentClear();
            importBillData.setData(mainEntity);
        }
    }

    public void beforeLoadEntity(BeforeLoadEntityEventArgs args) {
        ArrayList<QFilter> customFilterList = new ArrayList<QFilter>();
        customFilterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        customFilterList.add(new QFilter("datastatus", "=", (Object)"1"));
        args.getCommonFilters().addAll(customFilterList);
    }

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        List<String> ignoreRefBdNameList;
        String entityId = args.getEntityId();
        String fieldId = args.getFieldId();
        String ignoreRefBdNameStr = ignoreRefBdNameMap.get(entityId);
        String baseDataName = args.getBaseDataName();
        if (StringUtils.isNotEmpty((String)ignoreRefBdNameStr) && (ignoreRefBdNameList = Arrays.asList(ignoreRefBdNameStr.split(","))).contains(fieldId)) {
            List<QFilter> sourcQFilters = Arrays.asList(args.getFilters());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(sourcQFilters);
            filters.add(new QFilter("1", "!=", (Object)1));
            args.setFilters(filters.toArray(new QFilter[filters.size()]));
        }
        if (args.isImportInvoke() && "hrpi_personf7query".equals(baseDataName)) {
            List<QFilter> sourcQFilters = Arrays.asList(args.getFilters());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(sourcQFilters);
            List<String> propertys = filters.stream().map(filter -> filter.getProperty()).collect(Collectors.toList());
            InfoClassifyHRImportPlugin.initFilters(propertys, filters);
            Boolean isAllowInfoClassifyEdit = BusinessUtils.isAllowInfoClassifyEdit();
            if (isAllowInfoClassifyEdit.booleanValue()) {
                for (QFilter filter2 : filters) {
                    if (HRPI_EMPENTREL_LABORRELSTATUS.equals(filter2.getProperty())) {
                        QFilter laborrelstatusFilter = new QFilter(HRPI_EMPENTREL_LABORRELSTATUS, "in", LABORREL_STATUS_STP);
                        filter2.or(laborrelstatusFilter);
                    }
                    if (!HRPI_EMPPOSORGREL_BUSINESSSTATUS.equals(filter2.getProperty())) continue;
                    QFilter lastFilter = new QFilter(HRPI_EMPPOSORGREL_ISLATESTRECORD, "=", (Object)"1");
                    QFilter busFilter = new QFilter(HRPI_EMPPOSORGREL_BUSINESSSTATUS, "=", (Object)"2");
                    filter2.or(lastFilter.and(busFilter));
                }
            }
            args.setFilters(filters.toArray(new QFilter[filters.size()]));
        }
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        if (args.isImportInvoke()) {
            String baseDataName = args.getBaseDataName();
            Object[] datas = args.getDatas();
            if (ArrayUtils.isEmpty((Object[])datas)) {
                return;
            }
            if ("hrpi_person".equals(baseDataName) || "hrpi_personf7query".equals(baseDataName)) {
                List<DynamicObject> effectPersonList = this.getEffectPersonList((DynamicObject[])datas);
                args.setDatas(effectPersonList.toArray(new DynamicObject[0]));
            }
        }
    }

    protected List<DynamicObject> getEffectPersonList(DynamicObject[] datas) {
        ArrayList<DynamicObject> effectPersonList = new ArrayList<DynamicObject>(datas.length);
        ArrayList<Long> effectPersonIds = new ArrayList<Long>(datas.length);
        Map<String, List<DynamicObject>> numberToPersonMap = Arrays.stream(datas).collect(Collectors.groupingBy(data -> data.getString("number")));
        for (Map.Entry<String, List<DynamicObject>> numberToPersonEntry : numberToPersonMap.entrySet()) {
            if (numberToPersonEntry.getValue().size() == 1) {
                effectPersonIds.add(numberToPersonEntry.getValue().get(0).getLong("id"));
                continue;
            }
            List<Object> sameNumberPersonIds = numberToPersonEntry.getValue().stream().map(data -> data.getLong("id")).collect(Collectors.toList());
            effectPersonIds.addAll(ImportBasedataHelper.queryPersonBaseData(sameNumberPersonIds));
        }
        for (DynamicObject data2 : datas) {
            if (!effectPersonIds.contains(data2.getLong("id"))) continue;
            effectPersonList.add(data2);
        }
        return effectPersonList;
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Map submitOps = args.getSubmitOPs();
        List importBillDataList = args.getImportBillDatas();
        if (!importBillDataList.isEmpty()) {
            String mainEntityId = ((ImportBillData)importBillDataList.get(0)).getMainEntityId();
            if (submitOps != null && !submitOps.isEmpty()) {
                submitOps.put(mainEntityId, "saveimport");
            }
        }
    }

    private static void initFilters(List<String> propertys, List<QFilter> filters) {
        if (!propertys.contains(HRPI_EMPENTREL_ISLATESTRECORD)) {
            QFilter islatestrecordFilter = new QFilter(HRPI_EMPENTREL_ISLATESTRECORD, "=", (Object)"1");
            filters.add(islatestrecordFilter);
        }
        if (!propertys.contains(HRPI_EMPPOSORGREL_EMPPOSING)) {
            QFilter empposingFilter = new QFilter(HRPI_EMPPOSORGREL_EMPPOSING, "=", (Object)"1");
            filters.add(empposingFilter);
        }
        if (!propertys.contains(HRPI_EMPENTREL_LABORRELSTATUS)) {
            QFilter laborrelstatusFilter = new QFilter(HRPI_EMPENTREL_LABORRELSTATUS, "in", LABORREL_STATUS);
            filters.add(laborrelstatusFilter);
        }
        if (!propertys.contains(HRPI_EMPPOSORGREL_BUSINESSSTATUS)) {
            QFilter busFilter = new QFilter(HRPI_EMPPOSORGREL_BUSINESSSTATUS, "=", (Object)"1");
            filters.add(busFilter);
        }
    }

    static {
        LABRELSTATUSPRD_ING = 1010L;
        LABRELSTATUSPRD_END = 1020L;
        LABORREL_STATUS = new HashSet<Long>();
        QFilter qFilter = new QFilter("labrelstatusprd", "=", (Object)LABRELSTATUSPRD_ING);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            entityCfMap.values().forEach(labrel -> LABORREL_STATUS.add(labrel.getLong("id")));
        }
        LABORREL_STATUS_STP = new HashSet<Long>();
        QFilter sFilter = new QFilter("labrelstatusprd", "=", (Object)LABRELSTATUSPRD_END);
        Map stpMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{sFilter, enableFilter});
        if (!CollectionUtils.isEmpty((Map)stpMap)) {
            stpMap.values().forEach(labrel -> LABORREL_STATUS_STP.add(labrel.getLong("id")));
        }
    }
}

