/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.opplugin;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.hr.hspm.business.helper.ImportBasedataHelper;
import kd.sdk.hr.hspm.common.dto.InfoClassifyEntityKeyDTO;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class InfoClassifyValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        InfoClassifyFormOperateEnum operateKeyEnum = InfoClassifyFormOperateEnum.getInfoClassifyListOperateEnumByOperateKey(operateKey);
        if (HRObjectUtils.isEmpty((Object)((Object)operateKeyEnum))) {
            return;
        }
        switch (operateKeyEnum) {
            case FORM_BTN_SAVE: 
            case FORM_BTN_DO_SAVE: {
                this.validateNew(dataEntities);
                break;
            }
            case FORM_BTN_UPDATE: {
                this.validateOverride(dataEntities);
                break;
            }
            case FORM_BTN_DELETE: {
                this.validateDelete(dataEntities);
                break;
            }
            case FORM_BTN_SAVEIMPORT: {
                this.validateIsAllowInfoClassifyEdit(dataEntities);
                this.validateImport(dataEntities);
                break;
            }
        }
    }

    protected void validateImport(ExtendedDataEntity[] dataEntities) {
        String importType;
        switch (importType = this.getOption().getVariableValue("importtype")) {
            case "new": {
                this.validateImportNew(dataEntities);
                break;
            }
            case "override": {
                this.validateImportOverride(dataEntities);
                break;
            }
            case "overridenew": {
                this.validateImportOverridenew(dataEntities);
                break;
            }
        }
    }

    protected void validateNew(ExtendedDataEntity[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoClassifyValidator_0", (String)"sdk-hr", (Object[])new Object[0]));
    }

    protected void validateOverride(ExtendedDataEntity[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoClassifyValidator_0", (String)"sdk-hr", (Object[])new Object[0]));
    }

    protected void validateDelete(ExtendedDataEntity[] dataEntities) {
    }

    protected void validateImportNew(ExtendedDataEntity[] dataEntities) {
        throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u672a\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u3002", (String)"InfoClassifyValidator_0", (String)"sdk-hr", (Object[])new Object[0]));
    }

    protected void validateImportOverride(ExtendedDataEntity[] dataEntities) {
        this.validateNew(dataEntities);
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String formId = dataEntities[0].getDataEntity().getDataEntityType().getName();
        InfoClassifyEntityKeyDTO infoClassifyEntityKeyDTO = InfoClassifyEntityKeyDTO.getEntityKeyEnumByFormKey(formId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(infoClassifyEntityKeyDTO.getSourceKey());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long boid = dataEntity.getDataEntity().getLong("boid");
            if (boid == 0L) continue;
            String personNumber = dataEntity.getDataEntity().getString("person.number");
            QFilter qFilter = new QFilter("boid", "=", (Object)boid);
            qFilter.and(new QFilter("person.number", "=", (Object)personNumber));
            if (serviceHelper.isExists(qFilter)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u4e1a\u52a1ID\u4e3a\u201c%1$s\u201d\uff0c\u59d3\u540d\u5de5\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"InfoClassifyValidator_4", (String)"sdk-hr", (Object[])new Object[]{boid, personNumber}));
        }
    }

    protected void validateImportOverridenew(ExtendedDataEntity[] dataEntities) {
        this.validateImportOverride(dataEntities);
    }

    protected Date getNowDate() {
        LocalDate localDate = LocalDate.now();
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    protected void commonValidateDate(ExtendedDataEntity dataEntity, Date now) {
        DynamicObject dy = dataEntity.getDataEntity();
        Date startdateDy = dy.getDate("startdate");
        Date enddateDy = dy.getDate("enddate");
        if (!HRObjectUtils.isEmpty((Object)startdateDy)) {
            this.validateDateCompare(dataEntity, startdateDy, now, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"InfoClassifyValidator_1", (String)"sdk-hr", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)enddateDy)) {
            this.validateDateCompare(dataEntity, enddateDy, now, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"InfoClassifyValidator_3", (String)"sdk-hr", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)startdateDy) && !HRObjectUtils.isEmpty((Object)enddateDy)) {
            this.validateDateCompare(dataEntity, startdateDy, enddateDy, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"InfoClassifyValidator_2", (String)"sdk-hr", (Object[])new Object[0]));
        }
    }

    protected void commonValidateDateAllowEqual(ExtendedDataEntity dataEntity, Date now) {
        DynamicObject dy = dataEntity.getDataEntity();
        Date startDate = dy.getDate("startdate");
        Date endDate = dy.getDate("enddate");
        if (!HRObjectUtils.isEmpty((Object)startDate)) {
            this.validateDateCompare(dataEntity, startDate, now, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"InfoClassifyValidator_1", (String)"sdk-hr", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)startDate) && !HRObjectUtils.isEmpty((Object)endDate)) {
            this.validateDateCompareAllowEqual(dataEntity, startDate, endDate, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"InfoClassifyValidator_7", (String)"sdk-hr", (Object[])new Object[0]));
        }
        if (!HRObjectUtils.isEmpty((Object)endDate)) {
            this.validateDateCompare(dataEntity, endDate, now, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"InfoClassifyValidator_3", (String)"sdk-hr", (Object[])new Object[0]));
        }
    }

    protected void commonValidateDateBase(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        Date startDate = dy.getDate("startdate");
        Date endDate = dy.getDate("enddate");
        if (!HRObjectUtils.isEmpty((Object)startDate) && !HRObjectUtils.isEmpty((Object)endDate)) {
            this.validateDateCompareAllowEqual(dataEntity, startDate, endDate, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"InfoClassifyValidator_2", (String)"sdk-hr", (Object[])new Object[0]));
        }
    }

    protected void validateDateCompare(ExtendedDataEntity dataEntity, Date beforeDate, Date afterDate, String errMsg) {
        if (beforeDate == null || afterDate == null) {
            return;
        }
        if (beforeDate.compareTo(afterDate) >= 0) {
            this.addFatalErrorMessage(dataEntity, errMsg);
        }
    }

    protected void validateDateCompareAllowEqual(ExtendedDataEntity dataEntity, Date beforeDate, Date afterDate, String errMsg) {
        if (beforeDate == null || afterDate == null) {
            return;
        }
        if (beforeDate.compareTo(afterDate) > 0) {
            this.addFatalErrorMessage(dataEntity, errMsg);
        }
    }

    private void validateIsAllowInfoClassifyEdit(ExtendedDataEntity[] dataEntities) {
        Boolean isAllowInfoClassifyEdit = BusinessUtils.isAllowInfoClassifyEdit();
        if (!isAllowInfoClassifyEdit.booleanValue()) {
            List<Object> personIdList = Stream.of(dataEntities).map(dataEntity -> dataEntity.getDataEntity().get("person.id")).collect(Collectors.toList());
            DynamicObject[] empDyArr = ImportBasedataHelper.queryEmpByPersonIdList(personIdList);
            Map<Long, List<DynamicObject>> empDyListMap = Stream.of(empDyArr).collect(Collectors.groupingBy(empDy -> empDy.getLong("person.id")));
            for (ExtendedDataEntity dataEntity2 : dataEntities) {
                long labRelStatusPrdId;
                Long personId = dataEntity2.getDataEntity().getLong("person.id");
                List<DynamicObject> empDyList = empDyListMap.get(personId);
                if (CollectionUtils.isEmpty(empDyList)) {
                    this.addFatalErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8be5\u5de5\u53f7\u627e\u4e0d\u5230\u5bf9\u5e94\u5458\u5de5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InfoClassifyValidator_6", (String)"sdk-hr", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject maxEnddateDy = empDyList.get(0);
                if (empDyList.size() > 1) {
                    Optional<DynamicObject> maxEnddateDyOptional = empDyList.stream().max(Comparator.comparing(o -> o.getDate("enddate")));
                    maxEnddateDy = maxEnddateDyOptional.get();
                }
                if ((labRelStatusPrdId = maxEnddateDy.getLong("labrelstatusprd.id")) != 1020L) continue;
                this.addFatalErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u201c\u7528\u5de5\u7ec8\u6b62\u201d\u7684\u5458\u5de5\u8fdb\u884c\u4fe1\u606f\u6279\u91cf\u7ef4\u62a4\u3002", (String)"InfoClassifyValidator_5", (String)"sdk-hr", (Object[])new Object[0]));
            }
        }
    }
}

