/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.hr.hspm.opplugin.ext;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hspm.common.enums.InfoClassifyFormOperateEnum;

public class InfoClassifySingleExtValidator
extends AbstractValidator {
    private boolean isCheck() {
        boolean flag;
        String operateKey = this.getOperateKey();
        boolean bl = flag = HRStringUtils.equals((String)InfoClassifyFormOperateEnum.FORM_BTN_SAVE.getOperateKey(), (String)operateKey) || HRStringUtils.equals((String)InfoClassifyFormOperateEnum.FORM_BTN_SAVEIMPORT.getOperateKey(), (String)operateKey);
        if (flag) {
            String importType = (String)this.getOption().getVariables().get("importtype");
            if (HRStringUtils.isEmpty((String)importType)) {
                return flag;
            }
            flag = HRStringUtils.equals((String)"new", (String)importType) || HRStringUtils.equals((String)"overridenew", (String)importType);
        }
        return flag;
    }

    public void validate() {
        if (!this.isCheck()) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityKey());
        Set personIdSet = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getLong("person.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("person", "in", personIdSet);
        filter.and("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("initstatus", "=", (Object)"2");
        String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728,\u4e0d\u53ef\u518d\u6b21\u65b0\u589e", (String)"InfoClassifySingleExtValidator_0", (String)"sdk-hr", (Object[])new Object[0]);
        DynamicObjectCollection dbCol = serviceHelper.queryOriginalCollection("id,person", filter.toArray());
        Map<Long, DynamicObject> dbMap = dbCol.stream().collect(Collectors.toMap(dy -> dy.getLong("person"), dy -> dy, (k1, k2) -> k1));
        HashSet set = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            Long personId = entity.getDataEntity().getLong("person.id");
            if (!set.add(personId)) {
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            DynamicObject dbDy = dbMap.get(personId);
            if (dbDy == null || dbDy.getLong("id") == entity.getDataEntity().getLong("id")) continue;
            this.addErrorMessage(entity, errorMsg);
        }
    }
}

