/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.ssc.hstc.business.repository.TaskAppropinionsRepository;
import kd.ssc.hstc.business.repository.TaskDecisionitemRepository;
import kd.ssc.hstc.business.repository.TaskHistoryRepository;
import kd.ssc.hstc.business.repository.TaskParamcontrolRepository;
import kd.ssc.hstc.business.repository.TaskRepository;
import kd.ssc.hstc.business.repository.TaskbillChildRepository;
import kd.ssc.hstc.business.repository.TaskbillRepository;
import kd.ssc.hstc.business.service.ArtiCheckPointService;
import kd.ssc.hstc.business.service.TaskApproveService;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.service.WorkflowService;
import kd.ssc.hstc.business.servicehelper.SSCServiceHelper;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.common.enums.ApproveOriginEnum;
import kd.ssc.hstc.formplugin.web.common.TaskApproveHrBaseFormPlugin;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.detail.enums.MsgTypeEnum;
import kd.ssc.hstc.formplugin.web.detail.util.BillAttributeControlUtil;
import kd.ssc.hstc.formplugin.web.detail.util.LogBuildUtil;
import kd.ssc.hstc.formplugin.web.detail.util.WithdrawalSelectorUtil;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveFormHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class HRTaskApproveDetailEdit
extends TaskApproveHrBaseFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(HRTaskApproveDetailEdit.class);
    private static final String FORM_APPROVALPENDING = "task_approvalpending";
    private static final String FORM_DHC_INQUIRYBILL = "dhc_inquirybill";
    private static final String CBK_CHOSE_OPINION = "chooseOpinion";
    private static final String FIELD_ISMUSTINPUT = "isMustInput";
    private static final String IS_MUSTINPUT = "0";
    private static final String IS_NOT_MUSTINPUT = "1";
    private static final String DECISION_REJECTION = "decisionrejection";
    private static final String LABEL_FOLD_OP = "foldapproveop";
    private static final String LABEL_UNFOLD_OP = "unfoldapproveop";

    @Override
    public void initialize() {
        super.initialize();
        TextEdit opinionField = (TextEdit)this.getControl("opinion");
        opinionField.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"save", "submit", "submitandnext", "cancelpending", "cancelrescan", "nexttask", "pendingopinion", "rescanopinion", "approvalrecordtabpage", "pauserecordpanel", "withdrawal", DECISION_REJECTION});
    }

    @Override
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Long taskId = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        Map billInfo = WorkflowService.getTaskBillInfo(Collections.singletonList(taskId));
        List relationIds = WorkflowService.getDecisionItemId(Collections.singletonList(taskId));
        BasedataEdit curDecisionItem = (BasedataEdit)this.getControl("curdecisionitem");
        curDecisionItem.addBeforeF7SelectListener(event -> {
            if (!CollectionUtils.isEmpty((Collection)relationIds)) {
                QFilter idFilter = new QFilter("id", "in", (Object)relationIds);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_decisionitem", (Long)((Long)((List)billInfo.get("sscid")).get(0)));
                event.addCustomQFilter(idFilter.and(baseDataFilter));
            }
        });
        BasedataEdit pendingopinions = (BasedataEdit)this.getControl("pendingopinions");
        pendingopinions.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        pendingopinions.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addClickListeners(new String[]{LABEL_FOLD_OP, LABEL_UNFOLD_OP});
    }

    @Override
    public FormShowParameter doOpenStandardBillView() {
        String billID = TaskApproveFormHelper.getCustomParam(this.getView(), "billid", String.class);
        String metadatatType = TaskApproveFormHelper.getCustomParam(this.getView(), "billnumber", String.class);
        String bindform = TaskApproveFormHelper.getCustomParam(this.getView(), "bindform", String.class);
        Long taskid = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        String pooltype = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype", String.class);
        String pooltypeMyTask = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype-mytask", String.class);
        boolean ifProcessing = TaskApproveFormHelper.getCustomParam(this.getView(), "ifProcessing", Boolean.class);
        if (bindform == null) {
            bindform = metadatatType;
        }
        String aimFormId = MetadataDao.getIdByNumber((String)bindform, (MetaCategory)MetaCategory.Form);
        FormShowParameter parameter = new FormShowParameter();
        if (StringUtils.isNotEmpty((CharSequence)aimFormId)) {
            FormMetadata aimFormMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)aimFormId, (MetaCategory)MetaCategory.Form);
            if ("BillFormModel".equals(aimFormMeta.getModelType())) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setPkId((Object)billID);
                parameter = billShowParameter;
            } else if ("BaseFormModel".equals(aimFormMeta.getModelType())) {
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setPkId((Object)billID);
                parameter = baseShowParameter;
            }
        }
        if (pooltypeMyTask == null) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setFormId(bindform);
        parameter.getOpenStyle().setTargetKey("billcontainer");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setCustomParam("taskID", (Object)taskid.toString());
        parameter.setCustomParam("billID", (Object)billID);
        parameter.setCustomParam("sscId", (Object)this.getPageCache().get("sscid"));
        parameter.setCustomParam("pooltype", (Object)pooltype);
        parameter.setCustomParam("pooltype-mytask", (Object)pooltypeMyTask);
        parameter.setCustomParam("showway", (Object)"hstc");
        parameter.setCustomParam("ifProcessing", (Object)ifProcessing);
        this.getView().getFormShowParameter().setCustomParam("activityNumber", (Object)bindform);
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.BillAttributeControlFormPlugin");
        this.getPageCache().put("pageID", parameter.getPageId());
        this.getPageCache().put("childPageId", parameter.getPageId());
        this.getPageCache().put("SSC_FORM_ISLOAD", "true");
        return parameter;
    }

    @Override
    public void beforeBindData(EventObject events) {
        super.beforeBindData(events);
        if (this.getPageCache().get("billID") == null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String billID = (String)formShowParameter.getCustomParam("billid");
            String imageNumber = (String)formShowParameter.getCustomParam("imageNumber");
            String metadatatType = (String)formShowParameter.getCustomParam("billnumber");
            String bindform = (String)formShowParameter.getCustomParam("bindform");
            String approveop = (String)formShowParameter.getCustomParam("approveop");
            if (bindform == null) {
                bindform = metadatatType;
            }
            Long tasktypeid = (Long)formShowParameter.getCustomParam("tasktypeid");
            Long taskid = (Long)formShowParameter.getCustomParam("taskid");
            Long billTypeId = (Long)formShowParameter.getCustomParam("billtypeid");
            String state = (String)formShowParameter.getCustomParam("state");
            log.info("beforeBindData state:{}", (Object)state);
            String pooltype = (String)formShowParameter.getCustomParam("pooltype");
            String pooltype_mytask = (String)formShowParameter.getCustomParam("pooltype-mytask");
            log.info("beforeBindData pooltype_mytask:{}", (Object)pooltype_mytask);
            this.getView().setEnable(Boolean.valueOf(pooltype_mytask != null), new String[]{"approveop"});
            String sscid = formShowParameter.getCustomParam("sscid") + "";
            String unpassreasondata = (String)formShowParameter.getCustomParam("unpassreasondata");
            String sourcePageId = (String)formShowParameter.getCustomParam("sourcePageId");
            this.getPageCache().put("state", state);
            this.getPageCache().put("billID", billID);
            this.getPageCache().put("metadatatType", metadatatType);
            this.getPageCache().put("bindform", bindform);
            this.getPageCache().put("taskid", taskid.toString());
            this.getPageCache().put("billtypeid", billTypeId.toString());
            this.getPageCache().put("tasktypeid", tasktypeid.toString());
            this.getPageCache().put("imageNumber", imageNumber);
            this.getPageCache().put("sscid", sscid);
            this.getPageCache().put("pooltype", pooltype);
            this.getPageCache().put("pooltype-mytask", pooltype_mytask);
            if (StringUtils.isNotEmpty((CharSequence)unpassreasondata)) {
                this.getPageCache().put("withdrawal", unpassreasondata);
            }
            this.getPageCache().put("pending", unpassreasondata);
            this.getPageCache().put("rescan", unpassreasondata);
            this.getPageCache().put("sourcePageId", sourcePageId);
            this.setAuditButtonVisble(formShowParameter, state);
            this.setApproveopVisibleAndEnable(approveop, formShowParameter, state);
            this.setBillToolbar(billTypeId, tasktypeid);
            this.setApprovalHandleMsg(formShowParameter);
        }
    }

    @Override
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.unfoldOperation(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        ChangeData[] valueSet = args.getChangeSet();
        ChangeData changeData = valueSet[0];
        Object newValue = changeData.getNewValue();
        IPageCache pageCache = this.getPageCache();
        String metadatatType = pageCache.get("metadatatType");
        String taskId = pageCache.get("taskid");
        List relationIds = WorkflowService.getDecisionItemId(Collections.singletonList(Long.parseLong(taskId)));
        if (StringUtils.equals((CharSequence)"operationgroupfield", (CharSequence)name)) {
            this.setApproveInfoVisible(this.getView(), this.getModel(), true, relationIds);
        } else if (StringUtils.equals((CharSequence)"decisionitem", (CharSequence)name)) {
            boolean flag = !CollectionUtils.isEmpty((Collection)relationIds) && (StringUtils.equals((CharSequence)"2", (CharSequence)((String)newValue)) || StringUtils.equals((CharSequence)"4", (CharSequence)((String)newValue)));
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"curdecisionitem"});
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{DECISION_REJECTION});
            pageCache.put(FIELD_ISMUSTINPUT, flag ? IS_MUSTINPUT : IS_NOT_MUSTINPUT);
            if (flag) {
                FieldEdit edit = (FieldEdit)this.getControl("curdecisionitem");
                edit.setMustInput(true);
            } else {
                this.getModel().setValue("curdecisionitem", (Object)"");
                this.getModel().setValue(DECISION_REJECTION, (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{DECISION_REJECTION});
            }
        } else if (StringUtils.equals((CharSequence)"opinion", (CharSequence)name) && FORM_DHC_INQUIRYBILL.equals(metadatatType)) {
            pageCache.put("apprevalmessage_success", newValue.toString());
        } else if (StringUtils.equals((CharSequence)"curdecisionitem", (CharSequence)name) && newValue != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{DECISION_REJECTION});
            this.setDecisionRejectionDefault(taskId);
        }
        IFormView formView = this.getSubViewByPageCachePgID();
        if (formView != null) {
            formView.getModel().setDataChanged(true);
        }
    }

    @Override
    public void click(EventObject evt) {
        String msg;
        long startTime = System.currentTimeMillis();
        super.click(evt);
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        if ("opinion".equals(fieldKey)) {
            this.showOpinionF7Form();
        } else if ("pendingopinion".equals(fieldKey)) {
            this.openPendingDialog();
        } else if ("withdrawal".equals(fieldKey)) {
            this.openWithDrawalDialog();
        }
        if ("save".equals(fieldKey)) {
            msg = ResManager.loadKDString((String)"\u4efb\u52a1\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"TaskApprevalPlugin_56", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TaskApprevalPlugin_57", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.addOperationLog(msg, opName);
            String erpNumber = this.getErpNumberAndCacheBindNum();
            if ("KDCC".equalsIgnoreCase(erpNumber)) {
                OperationResult opResult;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("origin", ApproveOriginEnum.FORM.getValue());
                IFormView subView = this.getSubViewByPageCachePgID();
                if (subView != null) {
                    String subPageId = subView.getPageId();
                    String appId = subView.getServiceAppId(subPageId);
                    map.put("subPageId", subPageId);
                    map.put("appId", appId);
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Long taskBillId = (Long)customParams.get("billtypeid");
                Long taskTypeId = (Long)customParams.get("tasktypeid");
                IFormView formView = this.getSubViewByPageCachePgID();
                if (formView != null) {
                    formView.getModel().setDataChanged(true);
                }
                if ((opResult = TaskApproveService.saveKDCCBillData(map, (Long)taskBillId, (Long)taskTypeId, (String)"7")) != null && !opResult.isSuccess()) {
                    if (subView != null) {
                        subView.showOperationResult(opResult);
                        this.getView().sendFormAction(subView);
                    }
                    return;
                }
            }
            this.doSave();
        } else if ("submit".equals(fieldKey)) {
            msg = ResManager.loadKDString((String)"\u4efb\u52a1\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"TaskApprevalPlugin_58", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            String opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TaskApprevalPlugin_59", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.addOperationLog(msg, opName);
            if (!this.isEmbedBill()) {
                this.doSubmitNew(false);
            }
        } else if ("submitandnext".equals(fieldKey)) {
            msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761\u64cd\u4f5c\u3002", (String)"TaskApprevalPlugin_60", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            String opName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761", (String)"TaskApprevalPlugin_61", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.addOperationLog(msg, opName);
            long endTime = System.currentTimeMillis();
            log.info("HRTaskApproveDetailEdit click\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
            if (!this.isEmbedBill()) {
                this.doSubmitNew(true);
                endTime = System.currentTimeMillis();
                log.info("HRTaskApproveDetailEdit click\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
            }
        } else if ("cancelpending".equals(fieldKey)) {
            if (!super.checkRole("tk_cancelpause")) {
                return;
            }
            this.cancelPause();
            this.getView().updateView("pauserecordpanel");
        } else if (DECISION_REJECTION.equals(fieldKey)) {
            this.openDecisionRejectionDialog();
        } else if (LABEL_FOLD_OP.equals(fieldKey)) {
            this.unfoldOperation(false);
        } else if (LABEL_UNFOLD_OP.equals(fieldKey)) {
            this.unfoldOperation(true);
        }
        long endTime = System.currentTimeMillis();
        log.info("HRTaskApproveDetailEdit click\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.contains("billbar")) {
            this.doBillOpetator(key);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String name = property.getName();
        if ("pendingopinions".equals(name)) {
            Set idSet = WorkflowService.getInstance().getPendingIdBybilltypeAndTasktype();
            String taskid = this.getPageCache().get("taskid");
            Map billInfo = WorkflowService.getTaskBillInfo(Collections.singletonList(Long.valueOf(taskid)));
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_pendingreason", (Long)((Long)((List)billInfo.get("sscid")).get(0)));
            idSet.remove(1950795026489448448L);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)idSet));
            beforeF7SelectEvent.addCustomQFilter(baseDataFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Object source = afterF7SelectEvent.getSource();
        if (source instanceof MulBasedataEdit && "pendingopinions".equals(((MulBasedataEdit)source).getFieldKey())) {
            Object[] primaryKeyValues = afterF7SelectEvent.getListSelectedRowCollection().getPrimaryKeyValues();
            List<Object> rescanids = Arrays.asList(primaryKeyValues);
            String pending = WorkflowService.getInstance().transformPending(rescanids);
            this.getModel().setValue("pendingopinion", (Object)pending);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        TaskCommonService.getInstance().beforeClosed(this.getView(), event);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (CBK_CHOSE_OPINION.equals(closedCallBackEvent.getActionId())) {
            Object rtnData = closedCallBackEvent.getReturnData();
            if (rtnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection rtnCollection = (ListSelectedRowCollection)rtnData;
                String opinion = this.getOpinions(rtnCollection);
                this.getModel().setValue("opinion", (Object)opinion);
                String operation = (String)this.getModel().getValue("operationgroupfield");
                if (IS_NOT_MUSTINPUT.equals(operation)) {
                    this.getPageCache().put("apprevalmessage_success", opinion);
                } else if ("2".equals(operation)) {
                    this.getPageCache().put("apprevalmessage_fail", opinion);
                }
            }
        } else if ("reWithdrawal".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            List<Long> withdrawalids;
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            Object returnData = closedCallBackEvent.getReturnData();
            WithdrawalSelectorUtil withdrawalSelectorUtil = new WithdrawalSelectorUtil();
            if (returnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection withdrawalidList = (ListSelectedRowCollection)returnData;
                withdrawalids = withdrawalidList.stream().map(value -> (Long)value.getPrimaryKeyValue()).collect(Collectors.toList());
            } else {
                Map ret = (Map)returnData;
                withdrawalids = (List<Long>)ret.get("withdrawalids");
            }
            String withdrawal = withdrawalSelectorUtil.transformWithdrawal(withdrawalids);
            this.getModel().setValue("withdrawal", (Object)withdrawal);
            this.getPageCache().put("withdrawal", SerializationUtils.toJsonString(withdrawalids));
        } else if ("rePending".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            Map ret = (Map)closedCallBackEvent.getReturnData();
            List pendingids = (List)ret.get("pendingids");
            String pending = WorkflowService.getInstance().transformPending(pendingids);
            this.getModel().setValue("pendingopinion", (Object)pending);
            this.getPageCache().put("pendingopinion", SerializationUtils.toJsonString((Object)pendingids));
        } else if ("reDecisionRejection".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            String jsonString = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
                Map returnDataMap = (Map)JSON.parseObject((String)jsonString, Map.class);
                String nodeItemId = (String)returnDataMap.get("nodeItemId");
                String nodeShowName = (String)returnDataMap.get("nodeShowName");
                this.getPageCache().put("nodeItemId", nodeItemId);
                this.getModel().setValue(DECISION_REJECTION, (Object)nodeShowName);
            }
        }
    }

    private String getOpinions(ListSelectedRowCollection rtnCollection) {
        Object opinionTmp;
        StringBuilder opinionBuilder = new StringBuilder();
        ArrayList<Long> pkidList = new ArrayList<Long>(rtnCollection.size());
        for (ListSelectedRow row : rtnCollection) {
            Object pkValue = row.getPrimaryKeyValue();
            if (!(pkValue instanceof Long)) continue;
            pkidList.add((Long)pkValue);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkidList)};
        String selectField = "opinions";
        DynamicObjectCollection opinionCollection = TaskAppropinionsRepository.getInstance().getData(selectField, qFilters);
        int opSize = opinionCollection.size();
        if (opSize > 1) {
            int i = 1;
            for (DynamicObject dyo : opinionCollection) {
                Object opinionTmp2 = dyo.get("opinions");
                if (!(opinionTmp2 instanceof String)) continue;
                opinionBuilder.append(i).append(". ");
                opinionBuilder.append((String)opinionTmp2);
                if (i < opSize) {
                    opinionBuilder.append('\n');
                }
                ++i;
            }
        } else if (opSize == 1 && (opinionTmp = ((DynamicObject)opinionCollection.get(0)).get("opinions")) instanceof String) {
            opinionBuilder.append((String)opinionTmp);
        }
        return opinionBuilder.toString();
    }

    private void doSave() {
        boolean isSave = false;
        if (!this.isEmbedBill()) {
            isSave = this.notEmbedBillSave();
        }
        Long taskid = Long.parseLong(this.getPageCache().get("taskid"));
        TaskApproveFormHelper.saveArtiCheckPointInfo(null, taskid, this.getModel(), null, false, null, null);
        if (isSave) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskApproveFormPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void addOperationLog(String msg, String opName) {
        AppLogInfo logInfo = LogBuildUtil.buildLogInfo(this.getView(), msg, null, "task_approve", opName);
        LogServiceHelper.addLog((AppLogInfo)logInfo);
    }

    private void setDecisionRejectionDefault(String taskId) {
        String decisionValue;
        DynamicObject taskDynObj = TaskService.getInstance().getTaskById("billid,assignid,itemid", Long.parseLong(taskId), true);
        String billId = taskDynObj.getString("billid");
        Long workFlowId = taskDynObj.getLong("assignid");
        List rejectNodeList = WorkflowServiceHelper.getRejectNodes((Long)workFlowId, (String)(decisionValue = this.getDecisionValue()));
        if (!CollectionUtils.isEmpty((Collection)rejectNodeList)) {
            WFRejectNodesModel wfRejectNodesModel = (WFRejectNodesModel)rejectNodeList.get(0);
            this.initDecisionRejection(wfRejectNodesModel.getItemId(), billId, wfRejectNodesModel);
        } else {
            this.getModel().setValue(DECISION_REJECTION, (Object)"");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DECISION_REJECTION});
            this.getPageCache().put("nodeItemId", null);
        }
    }

    private String getDecisionValue() {
        String decisionValue = null;
        DynamicObject curDecisionItem = (DynamicObject)this.getModel().getValue("curdecisionitem");
        if (curDecisionItem != null) {
            Long decisionId = (Long)this.getModel().getValue("curdecisionitem_id");
            DynamicObject dynamicObject = TaskDecisionitemRepository.getInstance().loadDataById(decisionId.longValue());
            decisionValue = dynamicObject.getString("decisionvalue");
        }
        return decisionValue;
    }

    private void unfoldOperation(boolean unfold) {
        String state = (String)this.getView().getFormShowParameter().getCustomParam("state");
        if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state) || TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_FOLD_OP, LABEL_UNFOLD_OP});
        } else {
            this.getView().setVisible(Boolean.valueOf(unfold), new String[]{"op_pending"});
            this.getView().setVisible(Boolean.valueOf(unfold), new String[]{LABEL_FOLD_OP});
            this.getView().setVisible(Boolean.valueOf(!unfold), new String[]{LABEL_UNFOLD_OP});
        }
    }

    private void setApprovalHandleMsg(FormShowParameter formShowParameter) {
        String apprevalmessage = (String)formShowParameter.getCustomParam("apprevalmessage");
        String operation = (String)this.getModel().getValue("operationgroupfield");
        if (StringUtils.isBlank((CharSequence)apprevalmessage)) {
            String taskId = this.getPageCache().get("taskid");
            if (IS_NOT_MUSTINPUT.equals(operation)) {
                apprevalmessage = WorkflowService.processDefaultOpinion((long)Long.parseLong(taskId), (boolean)true);
            } else if ("2".equals(operation)) {
                apprevalmessage = WorkflowService.processDefaultOpinion((long)Long.parseLong(taskId), (boolean)false);
            }
        }
        String innermsg = (String)formShowParameter.getCustomParam("innermsg");
        IDataModel dataModel = this.getModel();
        dataModel.setValue("opinion", (Object)apprevalmessage);
        dataModel.setValue("innermsg", (Object)innermsg);
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            this.getPageCache().put("apprevalmessage_success", apprevalmessage);
        } else if ("2".equals(operation)) {
            this.getPageCache().put("apprevalmessage_fail", apprevalmessage);
        }
    }

    private boolean isEmbedBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return formShowParameter.getCustomParam("isembed") == null ? Boolean.FALSE.booleanValue() : ((Boolean)formShowParameter.getCustomParam("isembed")).booleanValue();
    }

    protected String getErpNumberAndCacheBindNum() {
        String erpNumber = this.getPageCache().get("erpNumber");
        if (this.getPageCache().get("erpNumber") != null) {
            return erpNumber;
        }
        String billtypeidStr = this.getPageCache().get("billtypeid");
        long billtypeid = Long.parseLong(billtypeidStr);
        DynamicObject billType = TaskbillRepository.getInstance().queryTaskbillData(billtypeid, "id,externalerp.id,externalerp.number,bindbill.number");
        erpNumber = (String)billType.get("externalerp.number");
        String bindbillNumber = (String)billType.get("bindbill.number");
        this.getPageCache().put("erpNumber", erpNumber.toLowerCase());
        this.getPageCache().put("bindbillNumber", bindbillNumber);
        return erpNumber.toLowerCase();
    }

    private IFormView getSubViewByPageCachePgID() {
        log.info("getSubViewByPageCachePgID:{}", (Object)this.getPageCache().get("pageID"));
        return this.getView().getViewNoPlugin(this.getPageCache().get("pageID"));
    }

    private long getCacheTaskIDLong() {
        String taskID = this.getPageCache().get("taskid");
        return Long.parseLong(taskID);
    }

    private DynamicObject getSubViewBilldata() {
        IFormView subView = this.getSubViewByPageCachePgID();
        if (subView == null) {
            return null;
        }
        return subView.getModel().getDataEntity(true);
    }

    private void doBillOpetator(String key) {
        try {
            String billKey = this.getPageCache().get(key + "_key");
            String billOpetator = this.getPageCache().get(key + "_number");
            String billToolbar = this.getPageCache().get(key + "_toolbar");
            String subViewPageID = this.getPageCache().get("pageID");
            FormView view = (FormView)this.getView();
            String subAppID = view.getServiceAppId(subViewPageID);
            String requestParams = String.format("[{\"key\":\"%s\",\"methodName\":\"itemClick\",\"args\":[\"%s\",\"%s\"],\"postData\":[{},[]]}]", billToolbar, billKey, billOpetator);
            log.info("requestParams:" + requestParams);
            Object resultObject = DispatchServiceHelper.invokeBOSService((String)subAppID, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{subViewPageID, requestParams});
            if (resultObject == null) {
                log.error("kd.ssc.task.formplugin.TaskApprevalPlugin#doBillOpetator: result is blank, key=" + key);
                return;
            }
            String result = resultObject.toString();
            log.info("result:" + result);
            List list = (List)SerializationUtils.fromJsonString((String)result, List.class);
            HashMap<String, Object> arg = new HashMap<String, Object>(2);
            arg.put("pageId", subViewPageID);
            arg.put("actions", list);
            view.getClientProxy().addAction("sendDynamicFormAction", arg);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskApproveFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void setAuditButtonVisble(FormShowParameter formShowParameter, String state) {
        Object taskTypeid = formShowParameter.getCustomParam("tasktypeid");
        Object billTypeId = formShowParameter.getCustomParam("billtypeid");
        boolean isLock = this.isOperLocked(state);
        if (isLock) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"nexttask", "bar_pass", "bd_nopass", "bar_repulse", "bar_rescan", "bar_cancelrescan", "bar_pending", "bar_cancelpause", "opinion", "innermsg", "save", "genvoucher", "bar_return", "bar_returnboth"});
        }
        String taskid = formShowParameter.getCustomParam("taskid") + "";
        DynamicObject dynamicObject = TaskRepository.getInstance().queryTaskData(NumberUtils.toLong((String)taskid, (long)-1L), "source");
        if (dynamicObject == null) {
            return;
        }
        Object source = dynamicObject.get("source");
        HashSet<String> notParSet = new HashSet<String>(Arrays.asList(IS_NOT_MUSTINPUT, "2"));
        boolean processRet = true;
        if (null != source && notParSet.contains(source.toString())) {
            processRet = false;
        } else if (null != source && StringUtils.equals((CharSequence)source.toString(), (CharSequence)"5")) {
            String selectFields = "id,entryentity.childpkid as childpkid";
            QFilter billTypeFilter = new QFilter("id", "=", billTypeId);
            QFilter taskTypeFilter = new QFilter("entryentity.tasktype", "=", taskTypeid);
            DynamicObject dynObjCol = TaskbillRepository.getInstance().queryTaskbillData(selectFields, new QFilter[]{billTypeFilter, taskTypeFilter});
            if (dynObjCol == null) {
                return;
            }
            Long childpkid = dynObjCol.getLong("childpkid");
            QFilter filter = new QFilter("id", "=", (Object)childpkid);
            DynamicObject dyo = TaskbillChildRepository.getInstance().queryTaskbillChildData("taskoriginal", new QFilter[]{filter});
            if (dyo == null) {
                return;
            }
            Object taskoriginal = dyo.get("taskoriginal");
            if (null != taskoriginal && !StringUtils.equals((CharSequence)taskoriginal.toString(), (CharSequence)"2")) {
                processRet = false;
            }
        }
        this.setDecisionItem(processRet);
    }

    private boolean isOperLocked(String state) {
        return TaskStateEnum.AUDIT_PASSED.getValue().equals(state) || TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state);
    }

    private void setDecisionItem(boolean processRet) {
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("decisionitem");
        List comboItems = comboProp.getComboItems();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(12);
        boolean displayImage = false;
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            LocaleString name = comboItem.getName();
            boolean itemVisible = comboItem.isItemVisible();
            if ("5".equals(value) || "6".equals(value) || !processRet && "3".equals(value) || !displayImage && "4".equals(value) || !itemVisible) continue;
            ComboItem citem = new ComboItem();
            citem.setValue(value);
            citem.setCaption(name);
            list.add(citem);
        }
        ComboEdit com = (ComboEdit)this.getControl("decisionitem");
        com.setComboItems(list);
        String decisionItemVal = (String)this.getModel().getValue("decisionitem");
        if (!displayImage && "4".equals(decisionItemVal)) {
            this.getModel().setValue("decisionitem", (Object)"2");
        }
    }

    private void setApproveopVisibleAndEnable(String approveop, FormShowParameter formShowParameter, String state) {
        boolean isFromMytask = false;
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)formShowParameter.getCustomParam("pooltype-mytask")))) {
            isFromMytask = true;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.setApproveInfo(formShowParameter, model);
        this.setOpVisible(approveop, state, view, model);
        this.setApproveInfoVisible(view, model, isFromMytask);
    }

    private void setApproveInfoVisible(IFormView view, IDataModel model, boolean isFromMytask) {
        this.setApproveInfoVisible(view, model, isFromMytask, null);
    }

    private void setApproveInfoVisible(IFormView view, IDataModel model, boolean isFromMytask, List<Long> relationIds) {
        String state = view.getPageCache().get("state");
        String poolType = view.getPageCache().get("pooltype");
        if (!isFromMytask || TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
            view.setVisible(Boolean.FALSE, new String[]{"buttongroup"});
            view.setEnable(Boolean.FALSE, new String[]{"operation", "flexpanelap20", "nexttask", "buttongroup1", "buttongroup", "checkpointpanelap"});
        }
        String operation = (String)model.getValue("operationgroupfield");
        if (TaskStateEnum.PAUSE.getValue().equals(state)) {
            view.setVisible(Boolean.FALSE, new String[]{"operation", "opinion", "decisionitem", "withdrawal", "innermsg", "rescanopinion", "selectbreakrule", "selectsubscorerule", "save", "submit", "submitandnext", "buttongroup", "cancelrescan", "checkpointpanelap", "curdecisionitem", DECISION_REJECTION, "flexpanelap4"});
            view.setEnable(Boolean.FALSE, new String[]{"pendingopinion", "pendingopinions"});
            view.setEnable(Boolean.FALSE, -1, new String[]{"checkboxfield"});
            view.setVisible(Boolean.TRUE, new String[]{"pendingopinion", "cancelpending", "buttongroup1", "pendingopinions"});
        } else if (IS_NOT_MUSTINPUT.equals(operation)) {
            model.setValue("opinion", (Object)this.getPageCache().get("apprevalmessage_success"));
            view.setVisible(Boolean.FALSE, new String[]{"decisionitem", "withdrawal", "pendingopinion", "pendingopinions", "rescanopinion", "cancelpending", "buttongroup1", "cancelrescan", "curdecisionitem", DECISION_REJECTION});
            view.setVisible(Boolean.TRUE, new String[]{"opinion", "innermsg", "save", "submit", "submitandnext", "buttongroup", "operation", "checkpointpanelap", "flexpanelap4"});
            view.setEnable(Boolean.TRUE, -1, new String[]{"checkboxfield"});
            if (this.getPageCache().get("hide-checkpointpanelap") != null) {
                view.setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
            }
            view.setEnable(Boolean.TRUE, new String[]{"rescanopinion", "pendingopinion", "pendingopinions"});
            view.setVisible(Boolean.FALSE, new String[]{"selectsubscorerule"});
            this.setDefaultOpinion(true);
        } else if ("2".equals(operation)) {
            boolean con1;
            model.setValue("opinion", (Object)this.getPageCache().get("apprevalmessage_fail"));
            view.setVisible(Boolean.FALSE, new String[]{"pendingopinion", "pendingopinions", "rescanopinion", "selectbreakrule", "selectsubscorerule", "cancelpending", "buttongroup1", "cancelrescan"});
            view.setVisible(Boolean.TRUE, new String[]{"opinion", "decisionitem", "withdrawal", "innermsg", "save", "submit", "submitandnext", "buttongroup", "checkpointpanelap"});
            if (this.getPageCache().get("hide-checkpointpanelap") != null) {
                view.setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
            }
            this.setDefaultOpinion(false);
            String taskId = this.getPageCache().get("taskid");
            boolean isShowDecisionItem = false;
            String decisionItem = model.getValue("decisionitem").toString();
            boolean bl = con1 = StringUtils.equals((CharSequence)"2", (CharSequence)decisionItem) || StringUtils.equals((CharSequence)"4", (CharSequence)decisionItem);
            if (TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
                isShowDecisionItem = con1 && model.getValue("curdecisionitem") != null;
            } else if (con1) {
                if (CollectionUtils.isEmpty(relationIds)) {
                    relationIds = WorkflowService.getDecisionItemId(Collections.singletonList(Long.parseLong(taskId)));
                }
                isShowDecisionItem = !CollectionUtils.isEmpty(relationIds);
            }
            this.getView().setVisible(Boolean.valueOf(isShowDecisionItem), new String[]{"curdecisionitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{DECISION_REJECTION});
            if (!ObjectUtils.isEmpty((Object)model.getValue(DECISION_REJECTION))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{DECISION_REJECTION});
            }
            this.getPageCache().put(FIELD_ISMUSTINPUT, isShowDecisionItem ? IS_MUSTINPUT : IS_NOT_MUSTINPUT);
            if (isShowDecisionItem) {
                FieldEdit edit = (FieldEdit)this.getControl("curdecisionitem");
                edit.setMustInput(true);
            }
        } else if ("3".equals(operation)) {
            view.setVisible(Boolean.FALSE, new String[]{"opinion", "decisionitem", "withdrawal", "innermsg", "rescanopinion", "selectbreakrule", "selectsubscorerule", "cancelpending", "buttongroup1", "cancelrescan", "curdecisionitem", DECISION_REJECTION});
            view.setVisible(Boolean.TRUE, new String[]{"pendingopinion", "pendingopinions", "save", "submit", "submitandnext", "buttongroup", "buttongroup"});
        }
        if ((TaskStateEnum.AUDIT_PASSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state)) && IS_NOT_MUSTINPUT.equals(operation)) {
            view.setVisible(Boolean.FALSE, new String[]{"buttongroup", "buttongroup1", "op_pending", "op_nopass"});
        } else if ((TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state)) && "2".equals(operation)) {
            view.setVisible(Boolean.FALSE, new String[]{"buttongroup", "buttongroup1", "op_pending", "op_pass"});
        }
    }

    private void setDefaultOpinion(boolean isPassed) {
        String taskId = this.getPageCache().get("taskid");
        String approvalMessage = WorkflowService.processDefaultOpinion((long)Long.parseLong(taskId), (boolean)isPassed);
        Object opinion = this.getModel().getValue("opinion");
        if (ObjectUtils.isEmpty((Object)opinion)) {
            this.getModel().setValue("opinion", (Object)approvalMessage);
        }
    }

    private void setApproveInfo(FormShowParameter formShowParameter, IDataModel model) {
        Object decisionitem = formShowParameter.getCustomParam("decisionitem");
        Object approveop = formShowParameter.getCustomParam("approveop");
        Object pendingopinion = formShowParameter.getCustomParam("pendingopinion");
        List pendingopinions = (List)formShowParameter.getCustomParam("pendingopinions");
        Object rescanopinion = formShowParameter.getCustomParam("rescanopinion");
        Object unpassreasondesc = formShowParameter.getCustomParam("unpassreasondesc");
        if (StringUtils.isNotBlank((Object)approveop)) {
            model.setValue("operationgroupfield", approveop);
        }
        if (StringUtils.isNotBlank((Object)decisionitem)) {
            model.setValue("decisionitem", decisionitem);
            if ("2".equals(decisionitem) || "4".equals(decisionitem)) {
                boolean processTask = !this.isHisTask();
                Long taskid = (Long)formShowParameter.getCustomParam("taskid");
                DynamicObject taskDynObj = TaskService.getInstance().queryTaskData(taskid.longValue(), "decisionitemnew.id,assignid,billid,itemid", processTask);
                model.setValue("curdecisionitem", (Object)taskDynObj.getLong("decisionitemnew.id"));
                this.loadHisDecisionRejection(taskDynObj);
            }
        }
        if (StringUtils.isNotBlank((Object)unpassreasondesc)) {
            model.setValue("withdrawal", unpassreasondesc);
        }
        model.setValue("pendingopinion", pendingopinion);
        if (pendingopinions != null && !pendingopinions.isEmpty()) {
            Object[] fbasedataids = pendingopinions.stream().map(p -> (Map)p.get("fbasedataid")).map(p -> p.get("id")).toArray();
            model.setValue("pendingopinions", (Object)fbasedataids);
        }
        model.setValue("rescanopinion", rescanopinion);
    }

    private boolean isHisTask() {
        Object sourcetaskid = this.getView().getFormShowParameter().getCustomParam("sourcetaskid");
        return sourcetaskid != null && Long.parseLong(sourcetaskid.toString()) > 0L;
    }

    private void loadHisDecisionRejection(DynamicObject taskDynObj) {
        Long workFlowId = taskDynObj.getLong("assignid");
        Long decisionId = taskDynObj.getLong("decisionitemnew.id");
        if (decisionId == 0L) {
            return;
        }
        DynamicObject dynamicObject = TaskDecisionitemRepository.getInstance().loadDataById(decisionId.longValue());
        String decisionValue = dynamicObject.getString("decisionvalue");
        String billId = taskDynObj.getString("billid");
        String itemId = taskDynObj.getString("itemid");
        List rejectNodeList = WorkflowServiceHelper.getRejectNodes((Long)workFlowId, (String)decisionValue);
        if (!CollectionUtils.isEmpty((Collection)rejectNodeList)) {
            for (WFRejectNodesModel wfRejectNodesModel : rejectNodeList) {
                if (itemId == null || !itemId.equals(wfRejectNodesModel.getItemId())) continue;
                this.initDecisionRejection(itemId, billId, wfRejectNodesModel);
                break;
            }
        } else {
            this.initDecisionRejection(itemId, billId, null);
        }
    }

    private void initDecisionRejection(String itemId, String billId, WFRejectNodesModel wfRejectNodesModel) {
        Map latestApprovalRecordMap = WorkflowService.getLatestApprovalRecordMap((String)billId);
        ApprovalRecordItem approvalRecordItem = (ApprovalRecordItem)latestApprovalRecordMap.get(itemId);
        if (approvalRecordItem != null) {
            String decisionRejection = approvalRecordItem.getActivityName() + "-" + approvalRecordItem.getAssignee();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DECISION_REJECTION});
            this.getModel().setValue(DECISION_REJECTION, (Object)decisionRejection);
            this.getPageCache().put("nodeItemId", approvalRecordItem.getActivityId());
        } else if (wfRejectNodesModel != null && wfRejectNodesModel.getName() != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DECISION_REJECTION});
            this.getModel().setValue(DECISION_REJECTION, (Object)wfRejectNodesModel.getName());
            this.getPageCache().put("nodeItemId", itemId);
        } else {
            this.getModel().setValue(DECISION_REJECTION, (Object)"");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DECISION_REJECTION});
            this.getPageCache().put("nodeItemId", null);
        }
    }

    private void setBillToolbar(Long billTypeId, Long tasktypeid) {
        Map<String, Map<String, Object>> needShowButtonAps = BillAttributeControlUtil.getNeedShowButtonAps(billTypeId, tasktypeid);
        int needShowButtonSize = needShowButtonAps.size();
        if (this.getView().getFormShowParameter().getCustomParam("pooltype-mytask") == null) {
            needShowButtonSize = 0;
        }
        for (int i = needShowButtonSize + 1; i <= 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billbar" + i});
        }
        boolean displayImage = false;
        if (!displayImage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_image"});
        }
        int index = 1;
        for (Map.Entry<String, Map<String, Object>> entry : needShowButtonAps.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            String[] ctrlapnames = value.get("ctrlapname").toString().split("\\.");
            String[] ctrlapnumbers = value.get("ctrlapnumber").toString().split("\\.");
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
            IPageCache pageCache = this.getPageCache();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(ctrlapnames[ctrlapnames.length - 1]);
            map.put("text", localeString);
            this.getView().updateControlMetadata("billbar" + index, map);
            pageCache.put("billbar" + index + "_key", key);
            pageCache.put("billbar" + index + "_number", value.get("opkey") == null ? "" : value.get("opkey").toString());
            pageCache.put("billbar" + index + "_toolbar", ctrlapnumbers[0]);
            if (++index <= 10) continue;
            break;
        }
        boolean processTask = !this.isHisTask();
        DynamicObject dynamicObject = TaskService.getInstance().getTaskById("assignid", Long.parseLong(this.getPageCache().get("taskid")), processTask);
        if (StringUtils.isEmpty((CharSequence)((String)dynamicObject.get("assignid")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
            return;
        }
        Long assignId = Long.valueOf((String)dynamicObject.get("assignid"));
        this.getPageCache().put("assignId", assignId.toString());
        TaskInfo task = WorkflowServiceHelper.findTaskById((Long)assignId);
        if (task != null && StringUtils.isNotBlank((CharSequence)task.getControl())) {
            Map map = (Map)SerializationUtils.fromJsonString((String)task.getControl(), Map.class);
            String circulate = (String)map.get("circulate");
            if (!Boolean.parseBoolean(circulate)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btncirculation"});
            }
        }
    }

    private void setOpVisible(String operation, String state, IFormView view, IDataModel model) {
        if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state)) {
            model.setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
        } else if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
            model.setValue("operationgroupfield", (Object)"2");
        } else if (IS_NOT_MUSTINPUT.equals(operation)) {
            model.setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
        } else if ("2".equals(operation)) {
            model.setValue("operationgroupfield", (Object)"2");
        } else if ("3".equals(operation)) {
            model.setValue("operationgroupfield", (Object)"3");
        } else if (TaskStateEnum.PAUSE.getValue().equals(state)) {
            view.setVisible(Boolean.FALSE, new String[]{"operation"});
        }
    }

    private void showOpinionF7Form() {
        Long sscid;
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId("task_appropinions");
        para.setFormId("bos_templatetreelistf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        QFilter qFilter = null;
        FormShowParameter thisPara = this.getView().getFormShowParameter();
        long taskId = Long.parseLong(thisPara.getCustomParam("taskid").toString());
        DynamicObject taskObj = TaskService.getInstance().getTaskById("sscid", taskId, true);
        String operation = (String)this.getModel().getValue("operationgroupfield");
        String approvalOperation = IS_MUSTINPUT;
        if (StringUtils.equals((CharSequence)"2", (CharSequence)operation)) {
            approvalOperation = IS_NOT_MUSTINPUT;
        }
        QFilter defaultSelectedFilter = new QFilter("isdisplay", "=", (Object)Boolean.TRUE).and("approvaloperation", "=", (Object)approvalOperation);
        QFilter commonFilter = new QFilter("isdisplay", "=", (Object)Boolean.FALSE);
        String sscId = "";
        if (taskObj != null && (sscid = Long.valueOf(taskObj.getLong("sscid.id"))) > 0L) {
            sscId = String.valueOf(sscid);
            qFilter = new QFilter("sscid", "=", (Object)sscid);
            qFilter.and(new QFilter("isleaf", "=", (Object)IS_NOT_MUSTINPUT));
            qFilter.and(commonFilter.or(defaultSelectedFilter));
        }
        ListFilterParameter listFilter = new ListFilterParameter();
        if (qFilter != null) {
            listFilter.setFilter(qFilter);
        } else {
            listFilter.setFilter(new QFilter("sscid", "=", (Object)"-1"));
        }
        para.setListFilterParameter(listFilter);
        para.setMultiSelect(!"false".equals(TaskParamcontrolRepository.getInstance().getTaskParamByName("enableOpinionMultiSelect")));
        para.setHasRight(true);
        para.setCustomParam("sscId", (Object)sscId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CBK_CHOSE_OPINION);
        para.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)para);
    }

    private void openPendingDialog() {
        IFormView view = this.getView();
        ListShowParameter para = new ListShowParameter();
        para.setFormId(FORM_APPROVALPENDING);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.getOpenStyle().setTargetKey("tabap");
        para.setHasRight(true);
        String taskid = this.getPageCache().get("taskid");
        ArrayList<Long> taskIds = new ArrayList<Long>(1);
        taskIds.add(Long.valueOf(taskid));
        Map billInfo = WorkflowService.getTaskBillInfo(taskIds);
        Set idSet = WorkflowService.getInstance().getPendingIdBybilltypeAndTasktype();
        ListFilterParameter filter = new ListFilterParameter();
        idSet.remove(1950795026489448448L);
        filter.setFilter(new QFilter("id", "in", (Object)idSet));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_pendingreason", (Long)((Long)((List)billInfo.get("sscid")).get(0)));
        filter.setFilter(baseDataFilter);
        para.setListFilterParameter(filter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rePending"));
        String withdrawal = this.getPageCache().get("pending");
        if (StringUtils.isNotEmpty((CharSequence)withdrawal)) {
            para.setSelectedRows(((ArrayList)SerializationUtils.fromJsonStringToList((String)withdrawal, Long.class)).toArray());
        }
        view.showForm((FormShowParameter)para);
    }

    private void openWithDrawalDialog() {
        IFormView view = this.getView();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("task_withdrawal");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.setHasRight(true);
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setLookUp(true);
        para.setShowTitle(false);
        String taskid = this.getPageCache().get("taskid");
        Map billInfo = WorkflowService.getTaskBillInfo(Collections.singletonList(Long.valueOf(taskid)));
        List billTypeList = (List)billInfo.get("billtype");
        List taskTypeList = (List)billInfo.get("tasktypeid");
        if (billTypeList == null || billTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u6279\u9000\u539f\u56e0\u5217\u8868\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5355\u6b64\u4efb\u52a1\u7684\u4e1a\u52a1\u5355\u636e\uff01", (String)"TaskApprevalPlugin_44", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taskTypeList == null || taskTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u6279\u9000\u539f\u56e0\u5217\u8868\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5355\u6b64\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\uff01", (String)"TaskApprevalPlugin_45", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        WithdrawalSelectorUtil withdrawalSelector = new WithdrawalSelectorUtil();
        Set<Long> idSet = withdrawalSelector.getWithdrawalIdBybilltypeAndTasktype((Long)billTypeList.get(0), (Long)taskTypeList.get(0));
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", idSet));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_withdrawal", (Long)((Long)((List)billInfo.get("sscid")).get(0)));
        QFilter enableFil = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        filter.setFilter(baseDataFilter);
        filter.setFilter(enableFil);
        para.setListFilterParameter(filter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reWithdrawal"));
        String withdrawal = this.getPageCache().get("withdrawal");
        if (StringUtils.isNotEmpty((CharSequence)withdrawal)) {
            para.setSelectedRows(((ArrayList)SerializationUtils.fromJsonStringToList((String)withdrawal, Long.class)).toArray());
        }
        view.showForm((FormShowParameter)para);
    }

    private void doSubmitNew(boolean isNext) {
        IPageCache pageCache = this.getView().getPageCache();
        IDataModel model = this.getModel();
        String operation = (String)model.getValue("operationgroupfield");
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            if (!super.checkRole("tk_mytask_pass")) {
                return;
            }
            if (!ArtiCheckPointService.isArtiCheckPointSelected((IFormView)this.getView(), (IDataModel)model)) {
                return;
            }
        } else if ("2".equals(operation)) {
            if (!super.checkRole("tk_mytask_nopass")) {
                return;
            }
            Long curDecisionItem = (Long)model.getValue("curdecisionitem_id");
            if (StringUtils.equals((CharSequence)IS_MUSTINPUT, (CharSequence)pageCache.get(FIELD_ISMUSTINPUT)) && curDecisionItem == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u51b3\u7b56\u9879\u201d\u3002", (String)"TaskApproveFormPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String withdrawal = (String)model.getValue("withdrawal");
            if (withdrawal != null) {
                withdrawal = withdrawal.replaceAll(" +", "").replaceAll("\n", "");
            }
            if (StringUtils.isEmpty((CharSequence)withdrawal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u6279\u9000\u539f\u56e0\u201d\u3002", (String)"TaskApproveFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("3".equals(operation) ? !super.checkRole("tk_mytask_pause") : "5".equals(operation) && !super.checkRole("tk_cancelpause")) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.taskApproveSubmit(isNext);
        long endTime = System.currentTimeMillis();
        log.info("HRTaskApproveDetailEdit taskApproveSubmit\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
    }

    private void cancelPause() {
        Map resultMap;
        String success;
        String state = this.getSelectRowDataState();
        List<String> pauseStates = Arrays.asList(TaskStateEnum.PAUSE.getValue(), TaskStateEnum.PAUSE_CHECKING.getValue(), TaskStateEnum.PAUSE_RECTIFYING.getValue(), TaskStateEnum.PAUSE_REVIEW.getValue());
        if (!pauseStates.contains(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u6302\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u53d6\u6d88\u6682\u6302", (String)"TaskApprevalPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        long taskId = this.getCacheTaskIDLong();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        IFormView subView = this.getSubViewByPageCachePgID();
        if (subView != null) {
            String subPageId = subView.getPageId();
            String appId = subView.getServiceAppId(subPageId);
            paramMap.put("subPageId", subPageId);
            paramMap.put("appId", appId);
        }
        if ("true".equals(success = (String)(resultMap = SSCServiceHelper.cancelPendTask((Long)taskId, (boolean)false, (Map)paramMap)).get("success"))) {
            List approvalRecordItems = TaskApproveService.setPauseRecord((Long)taskId, (boolean)false);
            String pageId = this.getPageCache().get("hstc_tkappausere_pageid");
            if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                IFormView formView = this.getView().getView(pageId);
                ((ApprovalRecord)formView.getControl("pauserecordap")).setData(approvalRecordItems);
                this.getView().sendFormAction(formView);
            }
            String taskid = this.getPageCache().get("taskid");
            TaskApproveFormHelper.saveArtiCheckPointInfo(null, Long.parseLong(taskid), this.getModel(), null, false, null, null);
            this.getModel().setValue("operationgroupfield", (Object)IS_NOT_MUSTINPUT);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"MytaskListPlugin_48", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("state", TaskStateEnum.TO_BE_AUDIT.getValue());
            this.setApproveInfoVisible(this.getView(), this.getModel(), true);
        } else if ("false".equals(success)) {
            OperationResult opResult = (OperationResult)resultMap.get("billOpResult");
            if (opResult != null) {
                if (!opResult.isSuccess() && subView != null) {
                    subView.showOperationResult(opResult);
                    this.getView().sendFormAction(subView);
                }
            } else {
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (StringUtils.isEmpty((CharSequence)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                }
            }
        }
    }

    private void openDecisionRejectionDialog() {
        String taskId = this.getPageCache().get("taskid");
        String decisionValue = this.getDecisionValue();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("task_decisionrejection");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reDecisionRejection"));
        para.setCustomParam("taskId", (Object)taskId);
        para.setCustomParam("decisionValue", (Object)decisionValue);
        para.setCustomParam("nodeItemId", (Object)this.getPageCache().get("nodeItemId"));
        this.getView().showForm(para);
    }

    private boolean notEmbedBillSave() {
        DynamicObject task = TaskService.getInstance().queryTaskData(Long.parseLong(this.getPageCache().get("taskid")), "pooltype,state,innermsg,completetime,bizdata_tag,apprevalmessage,billtype,approveop,decisionitem,decisionitemnew,unpassreasonid,pendingopinion,pendingopinions,rescanopinion,unpassreasondesc,unpassreasondata,itemid", true);
        DynamicObject billData = this.getSubViewBilldata();
        if (billData == null) {
            log.info("billData is null");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"HRTaskApproveDetailEdit_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"KDCC".equalsIgnoreCase(this.getErpNumberAndCacheBindNum())) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(billData.getDynamicObjectType());
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            String json = jser.serializeToString((Object)billData, null);
            task.set("bizdata_tag", (Object)json);
        }
        if (task == null) {
            log.info("task is null");
            return false;
        }
        String approveOp = (String)this.getModel().getValue("operationgroupfield");
        if (!"3".equals(approveOp)) {
            Object opinionObj = this.getModel().getValue("opinion");
            if (opinionObj != null) {
                String opinion = String.valueOf(opinionObj);
                task.set("apprevalmessage", (Object)(opinion.length() > 2000 ? opinion.substring(0, 2000) : opinion));
            }
            task.set("innermsg", this.getModel().getValue("innermsg"));
        }
        task.set("approveop", this.getModel().getValue("operationgroupfield"));
        task.set("decisionitem", this.getModel().getValue("decisionitem"));
        task.set("decisionitemnew", this.getModel().getValue("curdecisionitem"));
        task.set("itemid", (Object)this.getPageCache().get("nodeItemId"));
        task.set("unpassreasondesc", this.getModel().getValue("withdrawal"));
        task.set("pendingopinion", this.getModel().getValue("pendingopinion"));
        Object pendingopinions = this.getModel().getValue("pendingopinions");
        task.set("pendingopinions", pendingopinions);
        task.set("rescanopinion", this.getModel().getValue("rescanopinion"));
        task.set("unpassreasondata", (Object)this.getPageCache().get("withdrawal"));
        String apprevalmessage = String.valueOf(this.getModel().getValue("opinion"));
        task.set("apprevalmessage", (Object)apprevalmessage);
        String operation = (String)this.getModel().getValue("operationgroupfield");
        if (IS_NOT_MUSTINPUT.equals(operation)) {
            this.getPageCache().put("apprevalmessage_success", apprevalmessage);
        } else if ("2".equals(operation)) {
            this.getPageCache().put("apprevalmessage_fail", apprevalmessage);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        return true;
    }

    private void taskApproveSubmit(boolean isNext) {
        Map resultMap;
        String success;
        DynamicObject billData;
        long startTime = System.currentTimeMillis();
        IDataModel model = this.getModel();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        String taskId = this.getPageCache().get("taskid");
        Long taskIdLong = Long.valueOf(taskId);
        String operation = (String)model.getValue("operationgroupfield");
        String decisionItem = (String)model.getValue("decisionitem");
        Long curDecisionItem = (Long)model.getValue("curdecisionitem_id");
        String opinion = (String)model.getValue("opinion");
        String withdrawal = (String)model.getValue("withdrawal");
        String withdrawalId = this.getPageCache().get("withdrawal");
        String innerMsg = (String)this.getModel().getValue("innermsg");
        String nodeItemId = this.getPageCache().get("nodeItemId");
        DynamicObjectCollection pendingopinions = (DynamicObjectCollection)this.getModel().getValue("pendingopinions");
        List pendingopinionsCollect = pendingopinions.stream().map(p -> p.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        String pendingopinion = (String)this.getModel().getValue("pendingopinion");
        String rescanOpinion = (String)this.getModel().getValue("rescanopinion");
        paramMap.put("taskId", taskIdLong);
        paramMap.put("operation", operation);
        long currUserId = RequestContext.get().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        paramMap.put("decisionItem", decisionItem);
        paramMap.put("curDecisionItem", curDecisionItem);
        paramMap.put("opinion", opinion);
        paramMap.put("withdrawal", withdrawal);
        if (StringUtils.isNotEmpty((CharSequence)withdrawalId)) {
            ArrayList withdrawalIdList = (ArrayList)SerializationUtils.fromJsonStringToList((String)withdrawalId, Long.class);
            paramMap.put("withdrawalIdList", withdrawalIdList);
        }
        paramMap.put("innerMsg", innerMsg);
        paramMap.put("nodeItemId", nodeItemId);
        paramMap.put("reason", pendingopinion);
        paramMap.put("pendingOpinionList", pendingopinionsCollect);
        paramMap.put("rescanOpinion", rescanOpinion);
        paramMap.put("origin", ApproveOriginEnum.FORM.getValue());
        IFormView subView = this.getSubViewByPageCachePgID();
        if (subView != null) {
            String subPageId = subView.getPageId();
            String appId = subView.getServiceAppId(subPageId);
            paramMap.put("subPageId", subPageId);
            paramMap.put("appId", appId);
        }
        if ((billData = this.getSubViewBilldata()) == null) {
            log.info("billData is null");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"HRTaskApproveDetailEdit_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (IS_NOT_MUSTINPUT.equals(operation) || "2".equals(operation)) {
            paramMap.put("billData", billData);
        }
        IFormView formView = this.getSubViewByPageCachePgID();
        long endTime = System.currentTimeMillis();
        log.info("HRTaskApproveDetailEdit taskApproveSubmit before \uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        DynamicObject curtask = TaskService.getInstance().getTaskById("id,receivetime", TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class).longValue(), TaskApproveFormHelper.isProcessingTask(this.getView()));
        if (curtask != null) {
            this.getView().getFormShowParameter().setCustomParam("curtask_receivetime", curtask.get("receivetime"));
            this.getView().getFormShowParameter().setCustomParam("curtask_id", curtask.get("id"));
        }
        if (formView != null) {
            formView.getModel().setDataChanged(true);
        }
        if ("false".equals(success = (String)(resultMap = SSCServiceHelper.taskApproveSubmit((Map)paramMap)).get("success"))) {
            OperationResult opResult = (OperationResult)resultMap.get("billOpResult");
            if (opResult != null) {
                if (!opResult.isSuccess() && subView != null) {
                    subView.showOperationResult(opResult);
                    this.getView().sendFormAction(subView);
                }
            } else {
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (StringUtils.isEmpty((CharSequence)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.POP.getValue().equals(msgType)) {
                    String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519", (String)"TaskApproveFormPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    this.getView().showMessage(errorInfo, msg, MessageTypes.Default);
                }
            }
        } else if ("true".equals(success)) {
            if (IS_NOT_MUSTINPUT.equals(operation) || "2".equals(operation)) {
                startTime = System.currentTimeMillis();
                this.afterApproveSuccess(taskId, operation);
                endTime = System.currentTimeMillis();
                log.info("HRTaskApproveDetailEdit taskApproveSubmit afterApproveSuccess \uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
            } else if ("3".equals(operation)) {
                startTime = System.currentTimeMillis();
                this.afterApproveSuccessByOtherOpr(taskId, operation);
                endTime = System.currentTimeMillis();
                log.info("HRTaskApproveDetailEdit taskApproveSubmit afterApproveSuccessByOtherOpr \uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
            }
            if (isNext) {
                IFormView view = this.getView();
                try {
                    startTime = System.currentTimeMillis();
                    TaskApproveFormHelper.getNextTask(this.getView());
                    endTime = System.currentTimeMillis();
                    log.info("HRTaskApproveDetailEdit taskApproveSubmit before \uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
                }
                catch (Exception e) {
                    log.error("\u4efb\u52a1\u5ba1\u6279\u5b8c\u6210\uff0c\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761\u62a5\u9519", (Throwable)e);
                    view.close();
                }
            } else {
                this.getView().close();
            }
        }
    }

    private String getSelectRowDataState() {
        long taskId = this.getCacheTaskIDLong();
        DynamicObject dynamicObject = TaskRepository.getInstance().queryTaskData(taskId, "state");
        if (dynamicObject == null) {
            return "empty";
        }
        return dynamicObject.getString("state");
    }

    private void afterApproveSuccess(String taskId, String operation) {
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, billtype.id";
        DynamicObject taskHistoryDo = TaskHistoryRepository.getInstance().queryTaskHistoryData(Long.parseLong(taskId), selectFields);
        if (taskHistoryDo == null) {
            QFilter qFilter = new QFilter("sourcetaskid", "=", (Object)Long.valueOf(taskId));
            taskHistoryDo = TaskHistoryRepository.getInstance().queryTaskHistoryData(selectFields, new QFilter[]{qFilter});
        }
        if (taskHistoryDo != null) {
            Long historyId = taskHistoryDo.getLong("id");
            Long billTypeId = taskHistoryDo.getLong("billtype.id");
            Long tasktypeid = taskHistoryDo.getLong("tasktypeid.id");
            TaskApproveFormHelper.saveArtiCheckPointInfo(operation, Long.parseLong(taskId), this.getModel(), historyId, false, billTypeId, tasktypeid);
        } else {
            TaskApproveFormHelper.saveArtiCheckPointInfo(operation, Long.parseLong(taskId), this.getModel(), null, false, null, null);
        }
    }

    private void afterApproveSuccessByOtherOpr(String taskId, String operation) {
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber,billtype.id,tasktypeid.idpooltype,state,innermsg,completetime,bizdata_tag,apprevalmessage,billtype,approveop,decisionitem,decisionitemnew,unpassreasonid,pendingopinion,pendingopinions,rescanopinion,unpassreasondesc,unpassreasondata,itemid";
        DynamicObject task = TaskService.getInstance().queryTaskData(Long.parseLong(taskId), selectFields, true);
        if (task != null) {
            String apprevalmessage = String.valueOf(this.getModel().getValue("opinion"));
            if (IS_NOT_MUSTINPUT.equals(operation)) {
                this.getPageCache().put("apprevalmessage_success", apprevalmessage);
            } else if ("2".equals(operation)) {
                this.getPageCache().put("apprevalmessage_fail", apprevalmessage);
            }
            Long historyId = task.getLong("id");
            Long billTypeId = task.getLong("billtype.id");
            Long tasktypeid = task.getLong("tasktypeid.id");
            TaskApproveFormHelper.saveArtiCheckPointInfo(operation, Long.parseLong(taskId), this.getModel(), historyId, false, billTypeId, tasktypeid);
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
    }
}

