/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.ssc.hstc.AbstractHRTaskDetailPlugin;
import kd.ssc.hstc.business.service.DetailPluginConfService;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.HSTCServiceHelper;
import kd.ssc.hstc.business.servicehelper.SSCServiceHelper;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.common.TaskApproveHrBaseFormPlugin;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveFormHelper;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveShowFormHelper;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.ObjectUtils;

public class HRTaskDetailEdit
extends TaskApproveHrBaseFormPlugin
implements RowClickEventListener {
    private static final Log LOGGER = LogFactory.getLog(HRTaskDetailEdit.class);
    private static final String CACHEKEY_LASTDYN_BTNKEYS = "lastdynBtns";
    private static final String CACHEKEY_SHOWFORMNUMBER = "showFormNumber";
    private static final String BTN_TK_PEND = "tk_pend";
    private static final String BTN_TK_CANCELPEND = "tk_cancelpend";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BILLCONTAINER = "billcontainer";
    private static final String IFAPPENDACTCUSTOMPARAMS = "ifAppendActCustomParams";
    private static final String ACTION_REPENDING = "action_repending";

    @Override
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        Tuple<Boolean, String> tuple = this.appendActCustomParams(formShowParameter);
        formShowParameter.setCustomParam(IFAPPENDACTCUSTOMPARAMS, (Object)Boolean.TRUE);
        if (!((Boolean)tuple.item1).booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage((String)tuple.item2);
        } else {
            String entityNumber = ObjectUtils.getStringValOfObject((Object)formShowParameter.getCustomParam("activityNumber"));
            List actPlugins = DetailPluginConfService.getInstance().getDetailPlugins(entityNumber);
            if (CollectionUtils.isNotEmpty((Collection)actPlugins)) {
                for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                    actPlugin.preOpenForm(args);
                }
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    @Override
    public void appendCustomParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean ifAppendActCustomParams = ObjectUtils.getBooleanValOfObject((Object)formShowParameter.getCustomParam(IFAPPENDACTCUSTOMPARAMS));
        if (ifAppendActCustomParams) {
            formShowParameter.setCustomParam(IFAPPENDACTCUSTOMPARAMS, (Object)Boolean.FALSE);
            this.getView().cacheFormShowParameter();
        } else {
            this.appendActCustomParams(formShowParameter);
        }
        this.doInvokeBizService();
        super.appendCustomParams();
    }

    @Override
    public void entryRowClick(RowClickEvent arg) {
        String pooltype = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype");
        String fromList = TaskApproveFormHelper.getCustomParam(this.getView(), "from");
        boolean isAdminView = "admin".equals(fromList);
        if (isAdminView || "2".equals(pooltype)) {
            return;
        }
        super.entryRowClick(arg);
    }

    @Override
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String pooltype = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype");
        String fromList = TaskApproveFormHelper.getCustomParam(this.getView(), "from");
        boolean isAdminView = "admin".equals(fromList);
        if (isAdminView || "2".equals(pooltype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"checkboxfield"});
            }
        }
        this.setVisibleWithCheckPoint();
    }

    private void setVisibleWithCheckPoint() {
        boolean ifHideCheckpoint = ObjectUtils.getBooleanValOfObject((Object)this.getPageCache().get("hide-checkpointpanelap"));
        boolean ifHideGPTPanel = ObjectUtils.getBooleanValOfObject((Object)this.getPageCache().get("hide-gptpanelap"));
        LOGGER.info("cacheKey:{}, cacheValue:{}", (Object)"hide-checkpointpanelap", (Object)ifHideCheckpoint);
        if (ifHideGPTPanel && ifHideCheckpoint) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"approveop"});
        } else if (ifHideCheckpoint) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
            SplitContainer auditContainer = (SplitContainer)this.getControl("auditsplitcontainer");
            auditContainer.hidePanel(SplitDirection.down, true);
        }
    }

    private Tuple<Boolean, String> appendActCustomParams(FormShowParameter currentShowParameter) {
        long taskId = ObjectUtils.getLongValOfObject((Object)currentShowParameter.getCustomParam("taskid"));
        boolean ifProcessing = ObjectUtils.getBooleanValOfObject((Object)currentShowParameter.getCustomParam("ifProcessing"));
        if (currentShowParameter.getCustomParam("ifProcessing") == null) {
            ifProcessing = ObjectUtils.getLongValOfObject((Object)currentShowParameter.getCustomParam("sourcetaskid")) == 0L;
        }
        boolean nowProcessing = ifProcessing;
        boolean ifPending = false;
        boolean ifAutoPending = false;
        DynamicObject taskInfo = TaskService.getInstance().getTaskById("id,billlongid,billtype.bindbill.number,state,pendingopinions", taskId, ifProcessing);
        if (taskInfo == null) {
            nowProcessing = false;
            taskInfo = TaskService.getInstance().getTaskHistory(taskId, "id,billlongid,billtype.bindbill.number,state");
        }
        if (taskInfo == null) {
            LOGGER.info("taskId:{}", (Object)taskId);
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u4efb\u52a1\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRTaskDetailEdit_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
        if (ifProcessing != nowProcessing) {
            ifProcessing = nowProcessing;
            String invoker = ObjectUtils.getStringValOfObject((Object)currentShowParameter.getCustomParam("invoker"));
            TaskApproveShowFormHelper.setCustomParam(currentShowParameter, taskInfo.getLong("id"), ifPending, invoker);
        }
        String state = taskInfo.getString("state");
        if (ifProcessing) {
            DynamicObjectCollection pendingopinions = taskInfo.getDynamicObjectCollection("pendingopinions");
            if (pendingopinions != null && pendingopinions.stream().anyMatch(pendingopinion -> 1950795026489448448L == pendingopinion.getLong("fbasedataid.id"))) {
                ifAutoPending = true;
            }
            ifPending = TaskStateEnum.PAUSE.getValue().equals(state);
        }
        currentShowParameter.setCustomParam("activityId", (Object)taskInfo.getLong("billlongid"));
        currentShowParameter.setCustomParam("activityNumber", (Object)taskInfo.getString("billtype.bindbill.number"));
        currentShowParameter.setCustomParam("ifProcessing", (Object)ifProcessing);
        currentShowParameter.setCustomParam("ifPending", (Object)ifPending);
        currentShowParameter.setCustomParam("ifAutoPending", (Object)ifAutoPending);
        currentShowParameter.setCustomParam("state", (Object)state);
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private void doInvokeBizService() {
        long taskId = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        boolean flag = false;
        List<AbstractHRTaskDetailPlugin> actPlugins = this.getActPlugins();
        if (CollectionUtils.isNotEmpty(actPlugins)) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                if (!actPlugin.showCustomBizViewAndButtons(this.getView(), taskId)) continue;
                flag = true;
            }
        }
        if (flag) {
            return;
        }
        Long activityId = TaskApproveFormHelper.getCustomParam(this.getView(), "activityId", Long.class);
        String activityNumber = TaskApproveFormHelper.getCustomParam(this.getView(), "activityNumber");
        if (activityNumber == null) {
            return;
        }
        try {
            Map rpcResult = (Map)HSTCServiceHelper.invokeBizShareService((Long)activityId, (String)activityNumber);
            boolean success = ObjectUtils.getBooleanValOfObject(rpcResult.get("success"));
            if (!success) {
                LOGGER.info("fail to getButtonViewByActivityId, rpcResult:{}", (Object)rpcResult);
                String message = ObjectUtils.getStringValOfObject(rpcResult.get("message"));
                this.getView().showErrorNotification(message);
                return;
            }
            Map showInfoMap = (Map)rpcResult.get("data");
            String showFormNum = ObjectUtils.getStringValOfObject(showInfoMap.get("showform"));
            this.getPageCache().put(CACHEKEY_SHOWFORMNUMBER, showFormNum);
            Map customParams = (Map)showInfoMap.get("customParams");
            this.getPageCache().put("showFormShowInfoMap", SerializationUtils.toJsonString((Object)showInfoMap));
            this.getPageCache().put("showFormCustomParams", SerializationUtils.toJsonString((Object)customParams));
            this.getPageCache().put("showFormRpcResult", SerializationUtils.toJsonString((Object)rpcResult));
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e13\u4e1a\u5e94\u7528\u76f8\u5173\u670d\u52a1\u672a\u627e\u5230\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HRTaskDetailEdit_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String fromList = TaskApproveFormHelper.getCustomParam(this.getView(), "from");
        boolean isAdminView = "admin".equals(fromList);
        this.setAuditButtonVisble(isAdminView);
        this.setBizButton(isAdminView);
    }

    @Override
    public FormShowParameter doOpenStandardBillView() {
        long taskId = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        Long activityId = TaskApproveFormHelper.getCustomParam(this.getView(), "activityId", Long.class);
        String showFormNum = this.getPageCache().get(CACHEKEY_SHOWFORMNUMBER);
        if (StringUtils.isEmpty((String)showFormNum)) {
            return null;
        }
        Map customParams = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("showFormCustomParams"), Map.class);
        Map rpcResult = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("showFormRpcResult"), Map.class);
        FormShowParameter formShowParameter = this.genBizFormShowParameter(activityId, showFormNum, customParams);
        this.getPageCache().put("childPageId", formShowParameter.getPageId());
        boolean flag = false;
        List<AbstractHRTaskDetailPlugin> actPlugins = this.getActPlugins();
        if (CollectionUtils.isNotEmpty(actPlugins)) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                if (!actPlugin.showCustomBizView(this.getView(), taskId, formShowParameter, rpcResult)) continue;
                flag = true;
            }
        }
        if (flag) {
            return null;
        }
        return formShowParameter;
    }

    private void setAuditButtonVisble(boolean isAdminView) {
        if (isAdminView) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TK_PEND, BTN_TK_CANCELPEND});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_TK_PEND, BTN_TK_CANCELPEND});
        }
        boolean ifProcessing = TaskApproveFormHelper.isProcessingTask(this.getView());
        String state = TaskApproveFormHelper.getCustomParam(this.getView(), "state");
        boolean ifAutoPending = TaskApproveFormHelper.getCustomParam(this.getView(), "ifAutoPending", Boolean.class);
        if (ifProcessing) {
            boolean ifPending = TaskStateEnum.PAUSE.getValue().equals(state);
            if (ifPending) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TK_PEND});
                if (ifAutoPending) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TK_CANCELPEND});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TK_CANCELPEND});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_TK_PEND, BTN_TK_CANCELPEND});
        }
    }

    private void setBizButton(boolean isAdminView) {
        String showFormNum = this.getPageCache().get(CACHEKEY_SHOWFORMNUMBER);
        if (StringUtils.isEmpty((String)showFormNum)) {
            return;
        }
        Map showInfoMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("showFormShowInfoMap"), Map.class);
        List buttonInfos = (List)showInfoMap.get("buttons");
        List<AbstractHRTaskDetailPlugin> actPlugins = this.getActPlugins();
        if (CollectionUtils.isNotEmpty(actPlugins)) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                buttonInfos = actPlugin.getCustomBtnInfos(this.getView(), buttonInfos);
            }
        } else if (isAdminView) {
            buttonInfos = Lists.newArrayList();
        }
        Container toolBar = (Container)this.getView().getControl(TOOLBARAP);
        String dynBtnsStr = this.getPageCache().get(CACHEKEY_LASTDYN_BTNKEYS);
        if (StringUtils.isNotEmpty((String)dynBtnsStr)) {
            toolBar.deleteControls(dynBtnsStr.split(","));
        }
        if (CollectionUtils.isNotEmpty((Collection)buttonInfos)) {
            this.genBizButtons(buttonInfos, toolBar);
        }
    }

    private void genBizButtons(List<Map<String, Object>> buttonInfos, Container toolBar) {
        LOGGER.info("buttonInfos:{}", buttonInfos);
        int index = 0;
        ArrayList dynBtns = Lists.newArrayListWithCapacity((int)buttonInfos.size());
        for (Map<String, Object> buttonInfo : buttonInfos) {
            String key = "act_" + ObjectUtils.getStringValOfObject((Object)buttonInfo.get("btnkey"));
            LocaleString name = new LocaleString(ObjectUtils.getStringValOfObject((Object)buttonInfo.get("btnname")));
            String operationKey = ObjectUtils.getStringValOfObject((Object)buttonInfo.get("opkey"));
            if ("close".equals(operationKey) || "refresh".equals(operationKey)) continue;
            dynBtns.add(key);
            this.getPageCache().put(key, operationKey);
            BarItemAp barItemAp = ControlUtil.genBarItemAp((String)key, (LocaleString)name, (String)"", (boolean)false);
            ArrayList items = Lists.newArrayListWithExpectedSize((int)2);
            items.add(barItemAp.createControl());
            toolBar.insertControls(index, (List)items);
            ++index;
        }
        this.getPageCache().put(CACHEKEY_LASTDYN_BTNKEYS, String.join((CharSequence)",", dynBtns));
    }

    private FormShowParameter genBizFormShowParameter(Long pkId, String showFormNum, Map<String, Object> customParams) {
        String aimFormId = MetadataDao.getIdByNumber((String)showFormNum, (MetaCategory)MetaCategory.Form);
        FormMetadata aimFormMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)aimFormId, (MetaCategory)MetaCategory.Form);
        FormShowParameter formShowParameter = new FormShowParameter();
        if ("BillFormModel".equals(aimFormMeta.getModelType())) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)pkId);
            formShowParameter = billShowParameter;
        } else if ("BaseFormModel".equals(aimFormMeta.getModelType())) {
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId((Object)pkId);
            formShowParameter = baseShowParameter;
        }
        formShowParameter.setFormId(showFormNum);
        formShowParameter.setAppId("hstc");
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        formShowParameter.setCustomParam("id", (Object)pkId);
        formShowParameter.setCustomParam("showway", (Object)"hstc");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(BILLCONTAINER);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "childviewclose"));
        String fromList = TaskApproveFormHelper.getCustomParam(this.getView(), "from");
        if ("admin".equals(fromList)) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        return formShowParameter;
    }

    public List<AbstractHRTaskDetailPlugin> getActPlugins() {
        String entityNumber = ObjectUtils.getStringValOfObject((Object)this.getPageCache().get(CACHEKEY_SHOWFORMNUMBER));
        List actPlugins = DetailPluginConfService.getInstance().getDetailPlugins(entityNumber);
        if (CollectionUtils.isEmpty((Collection)actPlugins)) {
            entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("activityNumber");
            actPlugins = DetailPluginConfService.getInstance().getDetailPlugins(entityNumber);
        }
        if (CollectionUtils.isNotEmpty((Collection)actPlugins)) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                actPlugin.setView(this.getView());
            }
        }
        return actPlugins;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_TK_PEND.equals(itemKey)) {
            if (!this.checkRole("tk_mytask_pause")) {
                return;
            }
            this.openPendingDialog();
        } else if (BTN_TK_CANCELPEND.equals(itemKey)) {
            if (!this.checkRole("tk_cancelpause")) {
                return;
            }
            this.cancelPauseOp();
        }
        if (!itemKey.startsWith("act_")) {
            return;
        }
        String operateKey = this.getPageCache().get(itemKey);
        LOGGER.info("itemKey:{}", (Object)itemKey);
        FormShowParameter currentShowParameter = this.getView().getFormShowParameter();
        Long bizActiviyId = ObjectUtils.getLongValOfObject((Object)currentShowParameter.getCustomParam("activityId"));
        String showFormNumber = this.getPageCache().get(CACHEKEY_SHOWFORMNUMBER);
        List<AbstractHRTaskDetailPlugin> actPlugins = this.getActPlugins();
        if (CollectionUtils.isEmpty(actPlugins)) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operateKey, (String)showFormNumber, (Object[])new Object[]{bizActiviyId}, (OperateOption)OperateOption.create());
            this.getView().showOperationResult(operationResult);
        } else {
            String childPageId = this.getPageCache().get("childPageId");
            HashMap<String, String> paramsMap = new HashMap<String, String>(2);
            paramsMap.put("childPageId", childPageId);
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                actPlugin.callOperation(this.getView(), showFormNumber, operateKey, bizActiviyId, paramsMap);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        List<AbstractHRTaskDetailPlugin> actPlugins;
        super.closedCallBack(closedCallBackEvent);
        if (ACTION_REPENDING.equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.pauseActionNew((Map)returnData);
        }
        if (CollectionUtils.isNotEmpty(actPlugins = this.getActPlugins())) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                actPlugin.closedCallBack(closedCallBackEvent);
            }
        } else if ("childviewclose".equals(closedCallBackEvent.getActionId())) {
            TaskCommonService taskCommonService = TaskCommonService.getInstance();
            if (taskCommonService.ifUpdateCurrentView(this.getView())) {
                taskCommonService.updateCurrentView(this.getView());
            } else {
                taskCommonService.closeCurrentView(this.getView());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        List<AbstractHRTaskDetailPlugin> actPlugins = this.getActPlugins();
        if (CollectionUtils.isNotEmpty(actPlugins)) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                actPlugin.confirmCallBack(messageBoxClosedEvent);
            }
        }
    }

    private void openPendingDialog() {
        IFormView view = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("task_pendingreasonsel");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey("tabap");
        parameter.setHasRight(true);
        parameter.setCustomParam("sscid", (Object)ObjectUtils.getStringValOfObject((Object)view.getFormShowParameter().getCustomParam("sscid")));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_REPENDING));
        view.showForm(parameter);
    }

    private void pauseActionNew(Map<String, Object> dataMap) {
        Long taskId = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        List pendingids = (List)dataMap.get("pendingids");
        String pending = ObjectUtils.getStringValOfObject((Object)dataMap.get("reason"));
        Map resultMap = SSCServiceHelper.pendTask((Long)taskId, (String)pending, (List)pendingids);
        String success = (String)resultMap.get("success");
        if ("false".equals(success)) {
            String msg = (String)resultMap.get("msg");
            String msgType = (String)resultMap.get("msgType");
            if (StringUtils.isEmpty((String)msgType) || "warn".equals(msgType)) {
                this.getView().showTipNotification(msg);
            } else {
                this.getView().showErrorNotification(msg);
            }
            return;
        }
        TaskCommonService.getInstance().updateCurrentView(this.getView(), true, false, false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"HRTaskDetailEdit_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
    }

    private void cancelPauseOp() {
        long taskId = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        DynamicObject taskInfo = TaskService.getInstance().queryTaskById("state", taskId, true);
        if (taskInfo == null) {
            LOGGER.info("taskId:{}", (Object)taskId);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"HRTaskDetailEdit_5", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        String state = taskInfo.getString("state");
        if (!state.equals(TaskStateEnum.PAUSE.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u6302\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u53d6\u6d88\u6682\u6302\u3002", (String)"HRTaskDetailEdit_3", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            return;
        }
        Map resultMap = SSCServiceHelper.cancelPendTask((Long)taskId, (boolean)false);
        String success = (String)resultMap.get("success");
        if ("false".equals(success)) {
            String msg = (String)resultMap.get("msg");
            String msgType = (String)resultMap.get("msgType");
            if (StringUtils.isEmpty((String)msgType) || "warn".equals(msgType)) {
                this.getView().showTipNotification(msg);
            } else {
                this.getView().showErrorNotification(msg);
            }
            return;
        }
        TaskCommonService.getInstance().updateCurrentView(this.getView(), true, false, false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"HRTaskDetailEdit_4", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        List<AbstractHRTaskDetailPlugin> actPlugins = this.getActPlugins();
        if (CollectionUtils.isNotEmpty(actPlugins)) {
            for (AbstractHRTaskDetailPlugin actPlugin : actPlugins) {
                actPlugin.beforeClosed(event);
            }
        } else {
            TaskCommonService.getInstance().beforeClosed(this.getView(), event);
        }
    }
}

