/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.ssc.hstc.business.service.GptService;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveFormHelper;
import kd.ssc.hstc.util.ControlUtil;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskGptPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaskGptPlugin.class);
    private static final Set<String> BTN_GROUP = new HashSet<String>(Arrays.asList("gptbtn1", "gptbtn2", "gptbtn3"));
    private static final Set<String> CHECKBOX_GROUP = new HashSet<String>(Arrays.asList("checkboxfield1", "checkboxfield2", "checkboxfield3"));
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ssc_hstc_TaskGptPlugin", (int)1, (int)(Runtime.getRuntime().availableProcessors() * 6));

    public void afterCreateNewData(EventObject eventObject) {
        String billtype = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        String gptpromtidStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)"gptpromtidcombo", (String)billtype);
        String fromList = TaskApproveFormHelper.getCustomParam(this.getView(), "from");
        if (ObjectUtils.isEmpty((Object)gptpromtidStr) || "admin".equals(fromList)) {
            LOGGER.info("don't need to show GPT-Panel, billtype:{}", (Object)billtype);
            SplitContainer auditContainer = (SplitContainer)this.getControl("auditsplitcontainer");
            auditContainer.hidePanel(SplitDirection.up, true);
            this.getPageCache().put("hide-gptpanelap", Boolean.TRUE.toString());
        } else {
            for (int i = 1; i <= 3; ++i) {
                String inputcomboKey = "inputcombo" + i;
                String inputStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)inputcomboKey, (String)billtype);
                if (!ObjectUtils.isNotEmpty((Object)inputStr)) continue;
                HashMap ctrl = Maps.newHashMapWithExpectedSize((int)2);
                ctrl.put("text", new LocaleString(inputStr));
                this.getView().updateControlMetadata("gptbtn" + i, (Map)ctrl);
                HashMap ctrlCheckBox = Maps.newHashMapWithExpectedSize((int)2);
                ctrlCheckBox.put("caption", new LocaleString(inputStr));
                this.getView().updateControlMetadata("checkboxfield" + i, (Map)ctrlCheckBox);
            }
            THREAD_POOL.execute(() -> {
                ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield1", (Object)Boolean.TRUE);
                this.askGPT("inputcombo1", this.getModel().getDataEntity().getString("input1"));
            });
            this.getView().addClientCallBack("set_gpt_answer_first");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException exception) {
                LOGGER.error((Throwable)exception);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent event) {
        if ("set_gpt_answer_first".equals(event.getName())) {
            this.getView().addClientCallBack("set_gpt_answer_other");
            if (ObjectUtils.isNotEmpty((Object)this.getModel().getValue("textareafield"))) {
                ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield1", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexloading"});
                this.getView().updateView("textareafield");
                LOGGER.info("textareafield had value");
                return;
            }
            String billtype = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
            String gptpromtidStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)"gptpromtidcombo", (String)billtype);
            String input = this.getModel().getDataEntity().getString("input1");
            String inputStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)"inputcombo1", (String)billtype);
            if (ObjectUtils.isNotEmpty((Object)inputStr)) {
                input = inputStr;
            }
            long gptpromtid = ObjectUtils.getLongValOfObject((Object)gptpromtidStr);
            String finalInput = input;
            Future future = THREAD_POOL.submit(() -> GptService.getInstance().getSyncGPTResult(gptpromtid, finalInput, new HashMap()));
            String cacheKey = gptpromtidStr + input;
            String cacheResult = this.getFromCache(gptpromtid, cacheKey);
            for (int i = 0; i < 10 && !ObjectUtils.isNotEmpty((Object)cacheResult); ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exception) {
                    LOGGER.error((Throwable)exception);
                }
                cacheResult = this.getFromCache(gptpromtid, cacheKey);
            }
            if (ObjectUtils.isNotEmpty((Object)cacheResult)) {
                this.getModel().setValue("textareafield", (Object)cacheResult);
                LOGGER.info("use history answer, cacheKey:{}", (Object)cacheKey);
            } else {
                String text = null;
                try {
                    text = (String)future.get();
                }
                catch (Exception exception) {
                    LOGGER.error((Throwable)exception);
                }
                LOGGER.info("reget text:{}", (Object)text);
                if ("ai.gai.10009".equals(text) || text == null || ObjectUtils.isEmpty((Object)text)) {
                    text = input;
                } else {
                    text = text.replaceAll("<sup.*?</sup>", "");
                    this.saveToCache(gptpromtid, cacheKey, text);
                }
                this.getModel().setValue("textareafield", (Object)text);
            }
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield1", (Object)Boolean.TRUE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexloading"});
        } else if ("set_gpt_answer_other".equals(event.getName())) {
            String billtype = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
            String gptpromtidStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)"gptpromtidcombo", (String)billtype);
            long gptpromtid = ObjectUtils.getLongValOfObject((Object)gptpromtidStr);
            for (int i = 2; i <= 3; ++i) {
                String key = "inputcombo" + i;
                String inputStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)key, (String)billtype);
                String input = this.getModel().getDataEntity().getString("input" + i);
                if (ObjectUtils.isNotEmpty((Object)inputStr)) {
                    input = inputStr;
                }
                String finalInput = input;
                THREAD_POOL.execute(() -> {
                    String cacheKey = gptpromtidStr + finalInput;
                    if (this.getFromCache(gptpromtid, cacheKey) != null) {
                        LOGGER.info("gpt result no change, cacheKey:{}", (Object)cacheKey);
                        return;
                    }
                    String text = GptService.getInstance().getSyncGPTResult(gptpromtid, finalInput, new HashMap());
                    LOGGER.info("gpt result:{}", (Object)text);
                    if (!"ai.gai.10009".equals(text) && ObjectUtils.isNotEmpty((Object)text)) {
                        text = text.replaceAll("<sup.*?</sup>", "");
                        this.saveToCache(gptpromtid, gptpromtidStr + finalInput, text);
                    }
                });
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"gptbtn1", "gptbtn2", "gptbtn3", "gptflexclosebtn"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("gptflexclosebtn".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelgpt"});
        } else if (BTN_GROUP.contains(key)) {
            String input = this.getModel().getDataEntity().getString("input1");
            String inputcomboKey = "inputcombo1";
            if ("gptbtn2".equals(key)) {
                input = this.getModel().getDataEntity().getString("input2");
                inputcomboKey = "inputcombo2";
            } else if ("gptbtn3".equals(key)) {
                input = this.getModel().getDataEntity().getString("input3");
                inputcomboKey = "inputcombo3";
            }
            this.askGPT(inputcomboKey, input);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName().trim();
        LOGGER.info("name:{}", (Object)name);
        if (!CHECKBOX_GROUP.contains(name)) {
            return;
        }
        String inputcomboKey = "inputcombo1";
        String input = this.getModel().getDataEntity().getString("input1");
        if ("checkboxfield2".equals(name)) {
            input = this.getModel().getDataEntity().getString("input2");
            inputcomboKey = "inputcombo2";
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield1", (Object)Boolean.FALSE);
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield3", (Object)Boolean.FALSE);
        } else if ("checkboxfield3".equals(name)) {
            input = this.getModel().getDataEntity().getString("input3");
            inputcomboKey = "inputcombo3";
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield1", (Object)Boolean.FALSE);
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield2", (Object)Boolean.FALSE);
        } else {
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield2", (Object)Boolean.FALSE);
            ControlUtil.setValueNoChangedEvent((IFormView)this.getView(), (String)"checkboxfield3", (Object)Boolean.FALSE);
        }
        this.askGPT(inputcomboKey, input);
    }

    private void askGPT(String inputcomboKey, String input) {
        String cacheKey;
        String cacheResult;
        String inputStr;
        LOGGER.info("kd.ssc.hstc.formplugin.web.TaskGptPlugin.askGPT 202407261630");
        String billtype = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        String gptpromtidStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)"gptpromtidcombo", (String)billtype);
        long gptpromtid = 0L;
        if (ObjectUtils.isNotEmpty((Object)gptpromtidStr)) {
            gptpromtid = ObjectUtils.getLongValOfObject((Object)gptpromtidStr);
        }
        if (gptpromtid == 0L) {
            gptpromtid = this.getModel().getDataEntity().getLong("gptpromtid");
        }
        if (ObjectUtils.isNotEmpty((Object)(inputStr = ControlUtil.getComboPropValueByKey((String)"hstc_taskapprove_basehr", (String)inputcomboKey, (String)billtype)))) {
            input = inputStr;
        }
        if (ObjectUtils.isNotEmpty((Object)(cacheResult = this.getFromCache(gptpromtid, cacheKey = gptpromtidStr + input)))) {
            this.getModel().setValue("textareafield", (Object)cacheResult);
            LOGGER.info("use history answer, cacheKey:{}", (Object)cacheKey);
            return;
        }
        String text = GptService.getInstance().getSyncGPTResult(gptpromtid, input, new HashMap());
        LOGGER.info("gpt result:{}", (Object)text);
        String regex = "<sup.*?</sup>";
        if ("ai.gai.10009".equals(text) || ObjectUtils.isEmpty((Object)text)) {
            text = input;
        } else {
            text = text.replaceAll(regex, "");
            this.saveToCache(gptpromtid, cacheKey, text);
        }
        this.getModel().setValue("textareafield", (Object)text);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexloading"});
    }

    private void saveToCache(long gptpromtid, String key, String value) {
        IAppCache iAppCache = AppCache.get((String)("ssc.hstc.task.gptpromtid_" + gptpromtid));
        if (this.getModel().getDataEntity().getBoolean("issaveappcache")) {
            iAppCache.put(key, (Object)value);
        } else {
            this.getPageCache().put(key, value);
        }
    }

    private String getFromCache(long gptpromtid, String key) {
        IAppCache iAppCache = AppCache.get((String)("ssc.hstc.task.gptpromtid_" + gptpromtid));
        if (this.getModel().getDataEntity().getBoolean("issaveappcache")) {
            if (this.checkAndResetPromptCache(gptpromtid)) {
                return null;
            }
            return (String)iAppCache.get(key, String.class);
        }
        return this.getPageCache().get(key);
    }

    private boolean checkAndResetPromptCache(long gptpromtid) {
        try {
            String modifytimeKey;
            QFilter qFilter = new QFilter("id", "=", (Object)gptpromtid);
            DynamicObject promptDy = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"modifytime", (QFilter[])new QFilter[]{qFilter});
            if (promptDy == null) {
                return true;
            }
            IAppCache iAppCache = AppCache.get((String)("ssc.hstc.task.gptpromtid_" + gptpromtid));
            Long modifytimeCache = (Long)iAppCache.get(modifytimeKey = gptpromtid + "_modifytime", Long.class);
            if (modifytimeCache == null || modifytimeCache.longValue() != promptDy.getDate("modifytime").getTime()) {
                iAppCache.clear();
                long modifytime = promptDy.getDate("modifytime").getTime();
                LOGGER.info("gptpromtid had changed, gptpromtid:{}, modifytimeCache:{}, modifytime:{}", new Object[]{gptpromtid, modifytimeCache, modifytime});
                iAppCache.put(modifytimeKey, (Object)modifytime);
                return true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        return false;
    }
}

