/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.certificate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.sdk.ssc.hstc.common.TaskHandleService;
import kd.sdk.ssc.hstc.constant.OperationResultType;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.HRServiceHelper;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.common.BizTaskCommonList;

public class CertificateLendListPlugin
extends BizTaskCommonList {
    private static final String HYPER_LINK_CONCERT_TYPE_NAME = "soefam_certificate_concerttype_name";
    public static final String ACT_LENDINGREGISTRATION = "act_lendingregistration";
    public static final String ACT_LENDINGTERMINATIO = "act_lendingterminatio";
    public static final String LOANREGPERM = "3JW5EZBSO3HS";
    public static final String TERLENDPERM = "3JW5FQHXZAOP";

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HYPER_LINK_CONCERT_TYPE_NAME.equals(fieldName)) {
            super.openDetailPage(args);
        }
        args.setCancel(true);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String refEntityId;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.contains("manageorg")) {
            Map customParams = args.getCustomParams();
            customParams.put("struct_project_is_to_all_areas", "true");
            List<Long> ids = Collections.singletonList(1040L);
            customParams.put("struct_project_ids", SerializationUtils.toJsonString(ids));
            customParams.put("custom_parent_f7_prop", "manageorg");
        }
        if ("hrpi_personf7query".equals(refEntityId = args.getRefEntityId())) {
            args.setRefEntityId("hrpi_person");
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean superUser = SSCPermissionServiceHelper.isSuperUser();
        if (ACT_LENDINGREGISTRATION.equals(itemKey)) {
            boolean hasPermByPermItemNum = SSCPermissionServiceHelper.checkPer((IFormView)this.getView(), (String)"soefam_certificate", (String)LOANREGPERM);
            if (!superUser && !hasPermByPermItemNum) {
                evt.setCancel(true);
            }
        } else if (ACT_LENDINGTERMINATIO.equals(itemKey)) {
            boolean hasPermByPermItemNum = SSCPermissionServiceHelper.checkPer((IFormView)this.getView(), (String)"soefam_certificate", (String)TERLENDPERM);
            if (!superUser && !hasPermByPermItemNum) {
                evt.setCancel(true);
            }
        }
        super.beforeItemClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListView view = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        List<Object> taskIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        this.clickEventDetail(itemKey, selectedRows, taskIds);
    }

    public void clickEventDetail(String itemKey, ListSelectedRowCollection selectedRows, List<Object> taskIds) {
        QFilter qFilter = new QFilter("id", "in", taskIds);
        qFilter.and(new QFilter("state", "=", (Object)TaskStateEnum.TO_BE_AUDIT.getValue()));
        DynamicObjectCollection tasks = TaskService.getInstance().queryTaskData(qFilter.toArray(), "billlongid,personid", true);
        List billLongIds = tasks.stream().map(task -> task.getLong("billlongid")).collect(Collectors.toList());
        if (ACT_LENDINGREGISTRATION.equals(itemKey)) {
            if (selectedRows.size() > tasks.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u64cd\u4f5c\u501f\u51fa\u767b\u8bb0\u3002", (String)"CertificateLendListPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = (FormShowParameter)HRServiceHelper.invokeSIHCSoefamService((String)"ICertificateMgService", (String)"showCertHandleBox", (Object[])new Object[]{"soefam_certlentoutregbox", billLongIds});
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACT_LENDINGREGISTRATION));
            formShowParameter.setCustomParam("ignorePerm", (Object)"1");
            this.getView().showForm(formShowParameter);
        } else if (ACT_LENDINGTERMINATIO.equals(itemKey)) {
            if (selectedRows.size() > tasks.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u64cd\u4f5c\u7ec8\u6b62\u501f\u51fa\u3002", (String)"CertificateLendListPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = (FormShowParameter)HRServiceHelper.invokeSIHCSoefamService((String)"ICertificateMgService", (String)"showCertHandleBox", (Object[])new Object[]{"soefam_certoverregbox", billLongIds});
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACT_LENDINGTERMINATIO));
            formShowParameter.setCustomParam("ignorePerm", (Object)"1");
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ACT_LENDINGREGISTRATION.equals(actionId) || ACT_LENDINGTERMINATIO.equals(actionId)) {
            List returnData = (List)closedCallBackEvent.getReturnData();
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("isFromList", true);
            paramsMap.put("operationResultType", OperationResultType.PROCESSED.getValue());
            TaskHandleService.getInstance().doSomethingsAfterHandled(this.getView(), (Collection)returnData, paramsMap);
        }
    }
}

