/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.certificate;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.sdk.ssc.hstc.common.TaskHandleService;
import kd.sdk.ssc.hstc.constant.OperationResultType;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.HRServiceHelper;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.common.BizTaskCommonList;

public class CertificateReturnListPlugin
extends BizTaskCommonList {
    private static final String BUT_ACT_CERTRETURNREG = "act_certreturnreg";
    private static final String HYPER_LINK_CONCERT_TYPE_NAME = "soefam_certificate_concerttype_name";
    private static final String FIELD_MANAGEORG = "manageorg";
    private static final Long STRUCT_ID = 1040L;
    private static final String PAGE_HRPI_PERSON = "hrpi_person";
    private static final String PAGE_HRPI_PERSONF7QUERY = "hrpi_personf7query";
    private static final String PAGE_SOEFAM_CERTIFICATE = "soefam_certificate";
    private static final String PERM_RETURN_ID = "3JW5GI1H5H69";
    private static final String CALLBACK_CERTIFICATE_RETURN = "certificateReturnCallBack";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{BUT_ACT_CERTRETURNREG});
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HYPER_LINK_CONCERT_TYPE_NAME.equals(fieldName)) {
            super.openDetailPage(args);
            args.setCancel(true);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String refEntityId;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.contains(FIELD_MANAGEORG)) {
            Map customParams = args.getCustomParams();
            customParams.put("struct_project_is_to_all_areas", "true");
            List<Long> ids = Collections.singletonList(STRUCT_ID);
            customParams.put("struct_project_ids", SerializationUtils.toJsonString(ids));
            customParams.put("custom_parent_f7_prop", FIELD_MANAGEORG);
        }
        if (PAGE_HRPI_PERSONF7QUERY.equals(refEntityId = args.getRefEntityId())) {
            args.setRefEntityId(PAGE_HRPI_PERSON);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean hasPerm;
        String itemKey = evt.getItemKey();
        if (BUT_ACT_CERTRETURNREG.equals(itemKey) && !(hasPerm = SSCPermissionServiceHelper.checkPer((IFormView)this.getView(), (String)PAGE_SOEFAM_CERTIFICATE, (String)PERM_RETURN_ID))) {
            evt.setCancel(true);
        }
        super.beforeItemClick(evt);
        if (evt.isCancel()) {
            return;
        }
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
        List<Object> taskIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectCollection waitTasks = this.getWaitTasks(taskIds);
        if (BUT_ACT_CERTRETURNREG.equals(itemKey) && taskIds.size() > waitTasks.size()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u64cd\u4f5c\u5f52\u8fd8\u767b\u8bb0\u3002", (String)"CertificateReturnListPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
    }

    public DynamicObjectCollection getWaitTasks(List<Object> taskIds) {
        QFilter qFilter = new QFilter("id", "in", taskIds);
        qFilter.and(new QFilter("state", "=", (Object)TaskStateEnum.TO_BE_AUDIT.getValue()));
        return TaskService.getInstance().queryTaskData(qFilter.toArray(), "billlongid,personid", true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
        List<Object> taskIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectCollection waitTasks = this.getWaitTasks(taskIds);
        List billLongIds = waitTasks.stream().map(task -> task.getLong("billlongid")).collect(Collectors.toList());
        if (BUT_ACT_CERTRETURNREG.equals(itemKey)) {
            FormShowParameter formShowParameter = (FormShowParameter)HRServiceHelper.invokeSIHCSoefamService((String)"ICertificateMgService", (String)"showCertHandleBox", (Object[])new Object[]{"soefam_certreturnregbox", billLongIds});
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CERTIFICATE_RETURN));
            formShowParameter.setCustomParam("ignorePerm", (Object)"1");
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        List taskIdList;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CALLBACK_CERTIFICATE_RETURN.equals(actionId) && closedCallBackEvent.getReturnData() != null && (taskIdList = (List)SerializationUtils.deSerializeFromBase64((String)((String)closedCallBackEvent.getReturnData()))) != null && taskIdList.size() > 0) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
            paramsMap.put("isFromList", Boolean.TRUE);
            paramsMap.put("operationResultType", OperationResultType.PROCESSED.getValue());
            TaskHandleService.getInstance().doSomethingsAfterHandled(this.getView(), (Collection)taskIdList, paramsMap);
        }
    }
}

