/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.common;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.hstc.business.repository.TasktypeRepository;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.common.ExpireStateEnum;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.common.constant.TaskMappingConstant;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.util.ObjectUtils;

public class BizTaskCommonList
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(BizTaskCommonList.class);
    private static final String QUALITYJUDGES = "qualityjudges";

    public void preOpenForm(PreOpenFormEventArgs args) {
        List<Long> taskTypeIdList;
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        if (formShowParameter.getCustomParam(QUALITYJUDGES) != null) {
            return;
        }
        Long taskTypeId = (Long)formShowParameter.getCustomParam("showtasktypeid");
        if (taskTypeId != null) {
            taskTypeIdList = new ArrayList(2);
            taskTypeIdList.add(taskTypeId);
        } else {
            taskTypeIdList = (List)formShowParameter.getCustomParam("showtasktypes");
        }
        DynamicObjectCollection taskTypeInfos = TasktypeRepository.getInstance().queryTasktypeDatas(taskTypeIdList, "qualityjudge");
        if (ObjectUtils.isNotEmpty((Object)taskTypeInfos)) {
            Set qualityjudges = taskTypeInfos.stream().map(taskTypeInfo -> taskTypeInfo.getString("qualityjudge")).collect(Collectors.toSet());
            formShowParameter.setCustomParam(QUALITYJUDGES, qualityjudges);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String showPooltype = (String)formShowParameter.getCustomParam("showpooltype");
        String poolType = "1";
        if ("completed".equals(showPooltype)) {
            poolType = "2";
        }
        List listFilter = event.getQFilters();
        QFilter qFilter = TaskCommonService.getInstance().getTaskQFilter(this.getView(), poolType);
        listFilter.add(qFilter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String showPooltype = (String)this.getView().getFormShowParameter().getCustomParam("showpooltype");
        List commonFilterColumns = args.getCommonFilterColumns();
        this.resetComboItemWithState(commonFilterColumns, showPooltype);
        List schemeFilterColumns = args.getSchemeFilterColumns();
        this.resetComboItemWithState(schemeFilterColumns, showPooltype);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List qFilters = args.getQFilters();
        this.extractedFilter(fieldName, qFilters);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        List qfilters = args.getQfilters();
        this.extractedFilter(name, qfilters);
    }

    private void extractedFilter(String name, List<QFilter> qfilters) {
        if ("orgid.name".equals(name)) {
            HashSet<Long> set = new HashSet<Long>();
            JSONArray orgJsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("showorg");
            if (orgJsonArray != null && !orgJsonArray.isEmpty()) {
                for (int i = 0; i < orgJsonArray.size(); ++i) {
                    Object orgId = orgJsonArray.get(i);
                    if (orgId == null) continue;
                    set.add(Long.parseLong(orgId.toString()));
                }
            }
            LOGGER.info("BizTaskCommonList.extractedFilter orgSet={}", (Object)((Object)set).toString());
            qfilters.add(new QFilter("id", "in", set));
        }
    }

    private Set<String> getSet(IFormView view, String key) {
        HashSet<String> set = new HashSet<String>();
        JSONArray orgJsonArray = (JSONArray)view.getFormShowParameter().getCustomParam(key);
        if (orgJsonArray != null && !orgJsonArray.isEmpty()) {
            for (int i = 0; i < orgJsonArray.size(); ++i) {
                set.add(orgJsonArray.get(i).toString());
            }
        }
        return set;
    }

    private void resetComboItemWithState(List<FilterColumn> filterColumns, String showPoolType) {
        Set<String> taskTypeIDSet = this.getSet(this.getView(), "showtasktypes");
        Set expireStateSet = ExpireStateEnum.getHandleDoingExpireState();
        Set stateSet = TaskStateEnum.getHandleDoingState();
        if ("completed".equals(showPoolType)) {
            expireStateSet = ExpireStateEnum.getHandleDoneExpireState();
            Object qualityjudgeOb = this.getView().getFormShowParameter().getCustomParam(QUALITYJUDGES);
            if (qualityjudgeOb != null) {
                Collection qualityJudges = ObjectUtils.getObjectsFromJSONStr((String)qualityjudgeOb.toString(), String.class);
                List doneState = TaskStateEnum.getDoneState((Collection)qualityJudges);
                stateSet.clear();
                stateSet.addAll(doneState);
            }
        }
        Long taskType = (Long)this.getView().getFormShowParameter().getCustomParam("showtasktypeid");
        Iterator<FilterColumn> iterator = filterColumns.iterator();
        while (iterator.hasNext()) {
            FilterColumn filterColumn = iterator.next();
            String fieldName = filterColumn.getFieldName();
            if ("tasktypeid.name".equals(fieldName)) {
                if (taskTypeIDSet.size() < 2) {
                    iterator.remove();
                } else {
                    this.remove(filterColumn, taskTypeIDSet);
                    if (taskType != null) {
                        filterColumn.setDefaultValue(String.valueOf(taskType));
                    }
                }
            }
            if ("expirestate".equals(fieldName)) {
                this.remove(filterColumn, expireStateSet);
            }
            if (!"state".equals(fieldName)) continue;
            this.remove(filterColumn, stateSet);
        }
    }

    public void remove(FilterColumn filterColumn, Set<String> set) {
        List comboItems = null;
        if (filterColumn instanceof CommonFilterColumn) {
            comboItems = ((CommonFilterColumn)filterColumn).getComboItems();
        } else if (filterColumn instanceof SchemeFilterColumn) {
            comboItems = ((SchemeFilterColumn)filterColumn).getComboItems();
        }
        if (comboItems != null && !comboItems.isEmpty()) {
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ComboItem next = (ComboItem)iterator.next();
                String value = next.getValue();
                if (set.contains(value)) continue;
                iterator.remove();
            }
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String showPoolType = (String)this.getView().getFormShowParameter().getCustomParam("showpooltype");
        if ("state".equals(args.getListFieldKey())) {
            List comboItems = args.getComboItems();
            List taskStateList = TaskStateEnum.getDoingState();
            if ("completed".equals(showPoolType)) {
                Object qualityjudgeOb = this.getView().getFormShowParameter().getCustomParam(QUALITYJUDGES);
                if (qualityjudgeOb == null) {
                    return;
                }
                Collection qualityjudges = ObjectUtils.getObjectsFromJSONStr((String)qualityjudgeOb.toString(), String.class);
                taskStateList = TaskStateEnum.getDoneState((Collection)qualityjudges);
            }
            List finalTaskStateList = taskStateList;
            comboItems.removeIf(comboItem -> !finalTaskStateList.contains(comboItem.getValue()));
        } else if ("expirestate".equals(args.getListFieldKey())) {
            List comboItems = args.getComboItems();
            Set expireStateSet = ExpireStateEnum.getHandleDoingExpireState();
            if ("completed".equals(showPoolType)) {
                expireStateSet = ExpireStateEnum.getHandleDoneExpireState();
            }
            Set finalExpireStateSet = expireStateSet;
            comboItems.removeIf(comboItem -> !finalExpireStateSet.contains(comboItem.getValue()));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("subject".equals(fieldName)) {
            if (!SSCPermissionServiceHelper.checkRole((Map)TaskMappingConstant.TASK_PERMISSIN_MAP, (String)fieldName, (IFormView)this.getView(), (String)"40A+670S4LST", (String)"task_task")) {
                args.setCancel(true);
                return;
            }
            args.setCancel(true);
            this.openDetailPage(args);
        }
    }

    public void openDetailPage(HyperLinkClickArgs args) {
        Object qualityjudgeOb;
        Collection qualityjudges;
        IFormView formView = this.getView();
        String showPooltype = (String)formView.getFormShowParameter().getCustomParam("showpooltype");
        long taskId = ObjectUtils.getLongValOfObject((Object)((IListView)formView).getFocusRowPkId());
        boolean ifProcessing = true;
        if ("completed".equals(showPooltype)) {
            ifProcessing = false;
        }
        if ((qualityjudges = (qualityjudgeOb = this.getView().getFormShowParameter().getCustomParam(QUALITYJUDGES)) == null ? new ArrayList(0) : ObjectUtils.getObjectsFromJSONStr((String)this.getView().getFormShowParameter().getCustomParam(QUALITYJUDGES).toString(), String.class)).size() == 1) {
            if (qualityjudges.contains("4")) {
                TaskCommonService.getInstance().getDetailPageParameter(formView, taskId, ifProcessing);
            } else {
                TaskCommonService.getInstance().getApproveDetailPageParameter(formView, taskId, ifProcessing);
            }
        } else {
            DynamicObject taskInfo = TaskService.getInstance().getTaskById("id,tasktypeid.qualityjudge", taskId, ifProcessing);
            if (taskInfo != null && "4".equals(taskInfo.getString("tasktypeid.qualityjudge"))) {
                TaskCommonService.getInstance().getDetailPageParameter(formView, taskId, ifProcessing);
            } else {
                TaskCommonService.getInstance().getApproveDetailPageParameter(formView, taskId, ifProcessing);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Map resultMap;
        String itemKey = evt.getItemKey();
        String ifClickWithSelect = ObjectUtils.getStringValOfObject((Object)this.getView().getFormShowParameter().getCustomParam("ifClickWithSelect"));
        if (itemKey.startsWith("act_") && !Boolean.FALSE.toString().equals(ifClickWithSelect)) {
            this.checkDataSelectAndTip(evt);
        }
        if (evt.isCancel()) {
            return;
        }
        IListView listView = (IListView)this.getView();
        List pkIds = listView.getSelectedRows().stream().map(selectedRow -> ObjectUtils.getLongValOfObject((Object)selectedRow.getPrimaryKeyValue())).collect(Collectors.toList());
        if (itemKey.startsWith("act_") && !CollectionUtils.isEmpty(pkIds) && (resultMap = TaskService.getInstance().checkIfForCurrentPerson(pkIds)) != null && !resultMap.isEmpty()) {
            listView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5904\u7406\u4eba\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u80fd\u5904\u7406\u8be5\u4efb\u52a1\u3002", (String)"BizTaskCommonList_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void checkDataSelectAndTip(BeforeItemClickEvent evt) {
        IListView listView = (IListView)this.getView();
        List pkIds = listView.getSelectedRows().stream().map(selectedRow -> ObjectUtils.getLongValOfObject((Object)selectedRow.getPrimaryKeyValue())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(pkIds)) {
            listView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BizTaskCommonList_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if ("refresh".equals(operationKey)) {
            TaskCommonService.getInstance().refreshTaskTree(this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IFormView currentView = this.getView();
        IFormView parentView = currentView.getViewNoPlugin(currentView.getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        parentView.invokeOperation("close");
        this.getView().sendFormAction(parentView);
    }

    public void clientCallBack(ClientCallBackEvent ee) {
        super.clientCallBack(ee);
        if (ee.getName() != null && "updateview".equals(ee.getName())) {
            TaskCommonService.getInstance().refreshTaskTreeAndList(this.getView());
        }
    }
}

