/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.ssc.hstc.business.repository.TaskbillRepository;
import kd.ssc.hstc.business.service.ArtiCheckPointService;
import kd.ssc.hstc.business.service.EasWorkflowService;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.service.WorkflowService;
import kd.ssc.hstc.common.TaskPoolTypeEnum;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.common.constant.TaskMappingConstant;
import kd.ssc.hstc.common.image.SscImageServiceUtil;
import kd.ssc.hstc.formplugin.web.common.TaskApproveHrBaseFormFunction;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveFormHelper;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskApproveHrBaseFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TaskApproveHrBaseFormFunction {
    private static final Log LOGGER = LogFactory.getLog(TaskApproveHrBaseFormPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        String fromList = ObjectUtils.getStringValOfObject((Object)args.getFormShowParameter().getCustomParam("from"));
        boolean isAdminView = "admin".equals(fromList);
        if (isAdminView) {
            return;
        }
        long taskId = ObjectUtils.getLongValOfObject((Object)args.getFormShowParameter().getCustomParam("taskid"));
        if (!TaskService.getInstance().checkIfForCurrentPerson(Long.valueOf(taskId))) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5904\u7406\u4eba\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u80fd\u5904\u7406\u8be5\u4efb\u52a1\u3002", (String)"TaskApproveHrBaseFormPlugin_2", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"nexttask"});
        String pageId = this.getView().getPageId();
        LOGGER.info("-------TaskApproveHrBaseFormPlugin: {}", (Object)pageId);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        String poolTypeMyTask = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype-mytask");
        if (!StringUtils.equals((CharSequence)"2", (CharSequence)poolTypeMyTask)) {
            AbstractGrid taskBill = (AbstractGrid)this.getView().getControl("entryentity");
            taskBill.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.appendCustomParams();
        this.setEmbedViewVisible();
        boolean showFlag = this.openBillView();
        this.setAuditButtonVisble();
        this.setAuditRecord();
        this.setArtiCheckPoint();
        if (showFlag) {
            LOGGER.info("showFlag:{}", (Object)showFlag);
        }
        TaskApproveFormHelper.setMutexCache(this.getView());
    }

    @Override
    public void appendCustomParams() {
        this.setActRealBillId();
        this.setAssignId();
        this.setErpNumberAndBindbillNumber();
        this.getView().cacheFormShowParameter();
    }

    private void setActRealBillId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskid = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        boolean processingTask = TaskApproveFormHelper.isProcessingTask(this.getView());
        String actrealbillid = TaskService.getInstance().queryRealBillId(taskid, processingTask);
        formShowParameter.setCustomParam("actrealbillid", (Object)actrealbillid);
    }

    private void setAssignId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskid = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        boolean processingTask = TaskApproveFormHelper.isProcessingTask(this.getView());
        DynamicObject taskDy = TaskService.getInstance().queryTaskData(taskid.longValue(), "assignid", processingTask);
        String assignid = taskDy.getString("assignid");
        formShowParameter.setCustomParam("assignid", (Object)assignid);
        if (!StringUtils.isEmpty((CharSequence)assignid)) {
            formShowParameter.setCustomParam("assignId", (Object)Long.valueOf(assignid));
        }
    }

    private void setErpNumberAndBindbillNumber() {
        Long billTypeId = TaskApproveFormHelper.getCustomParam(this.getView(), "billtypeid", Long.class);
        DynamicObject billTypeDy = TaskbillRepository.getInstance().queryTaskbillData(billTypeId.longValue(), "id,externalerp.id,externalerp.number,bindbill.number");
        String erpNumber = billTypeDy.getString("externalerp.number");
        String bindbillNumber = billTypeDy.getString("bindbill.number");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("erpNumber", (Object)erpNumber);
        formShowParameter.setCustomParam("bindbillNumber", (Object)bindbillNumber);
    }

    private void setEmbedViewVisible() {
        if (!TaskApproveFormHelper.isEmbedBill(this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"iframeap"});
        }
    }

    private void setAuditButtonVisble() {
        String state = TaskApproveFormHelper.getCustomParam(this.getView(), "state");
        boolean isLock = TaskStateEnum.isOperLocked((String)state);
        if (isLock) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"nexttask"});
        }
        this.setBtncirculation();
        this.setBtnFixdata();
        this.setBtnImage();
    }

    private void setBtnFixdata() {
        String valueoffrom = TaskApproveFormHelper.getCustomParam(this.getView(), "from");
        String pooltype = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype");
        if (!"admin".equals(valueoffrom) || !TaskPoolTypeEnum.PROCESSING.getValue().equals(pooltype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fixdata"});
        }
    }

    private void setBtncirculation() {
        String assignid = TaskApproveFormHelper.getCustomParam(this.getView(), "assignid");
        if (StringUtils.isEmpty((CharSequence)assignid)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
            return;
        }
        Long assignId = TaskApproveFormHelper.getCustomParam(this.getView(), "assignId", Long.class);
        boolean hisTask = TaskApproveFormHelper.isHisTask(this.getView());
        boolean closeCirculate = WorkflowService.getInstance().isCloseCirculate(assignId, hisTask);
        if (closeCirculate) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncirculation"});
        }
    }

    private void setBtnImage() {
        Long billTypeId = TaskApproveFormHelper.getCustomParam(this.getView(), "billtypeid", Long.class);
        boolean displayImage = SscImageServiceUtil.imageDisplayCtrlById((Long)billTypeId);
        if (!displayImage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_image"});
        }
    }

    @Override
    public boolean openBillView() {
        if (TaskApproveFormHelper.isEmbedBill(this.getView())) {
            LOGGER.info("open embedbill...");
            return true;
        }
        return this.openStandardBillView();
    }

    @Override
    public boolean openStandardBillView() {
        String state = TaskApproveFormHelper.getCustomParam(this.getView(), "state");
        FormShowParameter parameter = this.doOpenStandardBillView();
        if (parameter != null) {
            parameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
            boolean isLock = TaskStateEnum.isOperLocked((String)state);
            if (isLock) {
                parameter.setStatus(OperationStatus.VIEW);
                if (parameter instanceof BillShowParameter) {
                    ((BillShowParameter)parameter).setBillStatus(BillOperationStatus.VIEW);
                }
            }
            parameter.setHasRight(true);
            parameter.addCustPlugin("kd.bos.ext.ssc.plugin.BillFormShowCustomerPlugin");
            TaskApproveFormHelper.setShowBillcontainerPageId(this.getView(), parameter.getPageId());
            this.getView().showForm(parameter);
            return true;
        }
        return false;
    }

    @Override
    public FormShowParameter doOpenStandardBillView() {
        return null;
    }

    private void setAuditRecord() {
        TaskApproveFormHelper.setAuditRecord(this.getView());
        TaskApproveFormHelper.setPauseRecord(this.getView());
    }

    private void setArtiCheckPoint() {
        Long taskid = TaskApproveFormHelper.getCustomParam(this.getView(), "taskid", Long.class);
        Long billTypeId = TaskApproveFormHelper.getCustomParam(this.getView(), "billtypeid", Long.class);
        String pooltype = TaskApproveFormHelper.getCustomParam(this.getView(), "pooltype");
        Long tasktypeid = TaskApproveFormHelper.getCustomParam(this.getView(), "tasktypeid", Long.class);
        Long sourceTaskId = TaskApproveFormHelper.getCustomParam(this.getView(), "sourcetaskid", Long.class);
        Long billId = TaskApproveFormHelper.getCustomParam(this.getView(), "billid", Long.class);
        DynamicObjectCollection articheckpointrecords = ArtiCheckPointService.getInstance().queryArticheckpointrecordByTaskid(taskid);
        if (sourceTaskId != 0L && articheckpointrecords != null && articheckpointrecords.isEmpty()) {
            articheckpointrecords = ArtiCheckPointService.getInstance().queryArticheckpointrecordByTaskid(sourceTaskId);
        }
        if (articheckpointrecords != null && articheckpointrecords.size() > 0) {
            Iterator iterator = articheckpointrecords.iterator();
            while (iterator.hasNext()) {
                DynamicObject artiCheckPointRecord = (DynamicObject)iterator.next();
                if (artiCheckPointRecord != null && artiCheckPointRecord.getLong("articheckpointid") != 0L) continue;
                iterator.remove();
            }
        }
        if (articheckpointrecords == null || articheckpointrecords.size() == 0) {
            if (TaskPoolTypeEnum.COMPLETE.getValue().equals(pooltype)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
                this.getPageCache().put("hide-checkpointpanelap", "true");
                return;
            }
            Map articheckpointrecordsMap = ArtiCheckPointService.getInstance().getArtiCheckPointByBillTypeId(billTypeId, tasktypeid, new ArrayList<Long>(Collections.singletonList(billId)));
            articheckpointrecords = (DynamicObjectCollection)articheckpointrecordsMap.get(billId);
            if (articheckpointrecords == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"checkpointpanelap"});
                this.getPageCache().put("hide-checkpointpanelap", "true");
                return;
            }
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i <= articheckpointrecords.size(); ++i) {
            if (i == 0) {
                this.setArticheckpointTableValue(vs, "0", this.initArticheckpointAllselected(articheckpointrecords), ResManager.loadKDString((String)"\u5168\u9009", (String)"TaskApproveHrBaseFormPlugin_1", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), i);
                continue;
            }
            DynamicObject articheckpointDy = (DynamicObject)articheckpointrecords.get(i - 1);
            this.setArticheckpointTableValue(vs, articheckpointDy.getString("articheckpointid"), articheckpointDy.getString("articheckpointselected"), articheckpointDy.getString("articheckpointname"), i);
        }
        this.getModel().deleteEntryData("entryentity");
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
    }

    private String initArticheckpointAllselected(DynamicObjectCollection articheckpointrecords) {
        long nonselect = articheckpointrecords.stream().filter(dy -> !dy.getBoolean("articheckpointselected")).count();
        return nonselect > 0L ? "0" : "1";
    }

    private void setArticheckpointTableValue(TableValueSetter vs, String articheckpointid, String checkboxfield, String articheckpointname, int row) {
        vs.set("articheckpointid", (Object)articheckpointid, row);
        vs.set("checkboxfield", (Object)checkboxfield, row);
        vs.set("articheckpointname", (Object)articheckpointname, row);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (!TaskApproveFormHelper.preValidate(this.getView())) {
            return;
        }
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        if ("nexttask".equals(fieldKey)) {
            TaskApproveFormHelper.getNextTask(this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        ChangeData changeData = valueSet[0];
        Object newValue = changeData.getNewValue();
        if ("checkboxfield".equals(name)) {
            this.getView().getPageCache().put("checkPass", "true");
            DynamicObject articheckpointDy = changeData.getDataEntity();
            String articheckpointid = articheckpointDy.getString("articheckpointid");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)articheckpointid)) {
                this.changeAllArticheckpoint((Boolean)newValue);
            } else {
                this.changeOneArticheckpoint((Boolean)newValue);
            }
        }
    }

    private void changeAllArticheckpoint(Boolean chooseFlag) {
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        EntryData entryData = cardEntry.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        for (int i = 0; i < dataEntitys.length; ++i) {
            model.beginInit();
            model.setValue("checkboxfield", (Object)chooseFlag, i);
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    private void changeOneArticheckpoint(Boolean chooseFlag) {
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        EntryData entryData = cardEntry.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        chooseFlag = ArtiCheckPointService.isArtiCheckPointSelected((DynamicObject[])dataEntitys);
        for (int i = 0; i < dataEntitys.length; ++i) {
            DynamicObject dataEntity = dataEntitys[i];
            String articheckpointid = dataEntity.getString("articheckpointid");
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)articheckpointid)) continue;
            model.beginInit();
            model.setValue("checkboxfield", (Object)chooseFlag, i);
            model.endInit();
            this.getView().updateView("entryentity");
            return;
        }
    }

    public void entryRowClick(RowClickEvent arg) {
        String key;
        Object source = arg.getSource();
        if (source instanceof CardEntry && "entryentity".equals(key = ((CardEntry)arg.getSource()).getKey())) {
            int row = arg.getRow();
            IPageCache pageCache = this.getView().getPageCache();
            if (!"true".equals(pageCache.get("checkPass"))) {
                IDataModel model = this.getModel();
                Boolean checkboxfieldValue = (Boolean)model.getValue("checkboxfield", row);
                String articheckpointid = (String)model.getValue("articheckpointid", row);
                if (StringUtils.equals((CharSequence)"0", (CharSequence)articheckpointid)) {
                    this.changeAllArticheckpoint(checkboxfieldValue == false);
                } else {
                    model.beginInit();
                    model.setValue("checkboxfield", (Object)(checkboxfieldValue == false ? 1 : 0), row);
                    model.endInit();
                    this.changeOneArticheckpoint(checkboxfieldValue == false);
                }
            }
            pageCache.remove("checkPass");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!TaskApproveFormHelper.preValidate(this.getView())) {
            return;
        }
        String key = evt.getItemKey();
        if ("close".equals(key)) {
            return;
        }
        if ("viewflowchart".equals(key)) {
            if (!this.checkRole("tk_mytask_viewflowchart")) {
                return;
            }
            this.viewflowchart();
        } else if ("btncirculation".equals(key)) {
            TaskApproveFormHelper.showCirculationPage(this.getView(), new CloseCallBack((IFormPlugin)this, "showCirculationPage"));
        } else if ("circulatelog".equals(key)) {
            TaskApproveFormHelper.showCirculateLog(this.getView());
        }
    }

    public boolean checkRole(String itemKey) {
        if (TaskMappingConstant.TASK_PERMISSIN_MAP.containsKey(itemKey)) {
            long userId = RequestContext.get().getCurrUserId();
            boolean superUser = SSCPermissionServiceHelper.isSuperUser();
            boolean hasPermByPermItemNum = SSCPermissionServiceHelper.hasPerm((long)userId, (String)"40A+670S4LST", (String)"task_task", (String)((String)TaskMappingConstant.TASK_PERMISSIN_MAP.get(itemKey)));
            if (superUser || hasPermByPermItemNum) {
                LOGGER.info("HRTaskApproveDetailEdit.hasPermByPermItemNum");
            } else {
                String otherCaption = EntityMetadataCache.getDataEntityType((String)"task_task").getDisplayName().getLocaleValue();
                String permissionName = PermItemHelper.getPermItemNameById((String)((String)TaskMappingConstant.TASK_PERMISSIN_MAP.get(itemKey)));
                String msg = SSCPermissionServiceHelper.getNoPermTips((String)otherCaption, (String)permissionName);
                this.getView().showErrorNotification(msg);
                return false;
            }
        }
        return true;
    }

    private void viewflowchart() {
        if (TaskApproveFormHelper.isEmbedBill(this.getView())) {
            LOGGER.info("open embedbill...");
            return;
        }
        String subViewBilldataId = TaskApproveFormHelper.getCustomParam(this.getView(), "actrealbillid");
        String erpNumber = TaskApproveFormHelper.getCustomParam(this.getView(), "erpNumber");
        String subPageId = TaskApproveFormHelper.getShowBillcontainerPageId(this.getView());
        String pageId = this.getView().getPageId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"eas", (CharSequence)erpNumber)) {
            LOGGER.info("open eas viewflowchart...");
            EasWorkflowService.getInstance().viewFlowchart(subPageId, (Object)subViewBilldataId, pageId);
        } else {
            LOGGER.info("open standard viewflowchart...");
            WorkflowService.getInstance().viewFlowchart(pageId, (Object)subViewBilldataId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"showCirculationPage", (CharSequence)actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u4f20\u9605\u81f3%s\u540d\u8054\u7cfb\u4eba\u3002", (String)"TaskApproveHrBaseFormPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]), returnData));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        TaskApproveFormHelper.releaseMutexCache(this.getView());
    }
}

