/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.sdk.ssc.hstc.common.TaskDetailPageService;
import kd.ssc.hstc.business.servicehelper.HSTCServiceHelper;
import kd.ssc.hstc.common.enums.TaskApprovePageInvokerEnum;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveShowFormHelper;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskCommonService {
    private static final Log LOGGER = LogFactory.getLog(TaskCommonService.class);

    public static TaskCommonService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean ifUpdateCurrentView(IFormView detailView) {
        return TaskDetailPageService.getInstance().ifUpdateCurrentView(detailView);
    }

    public void closeCurrentView(IFormView detailView) {
        LOGGER.info("closeCurrentView");
        TaskDetailPageService.getInstance().closeCurrentView(detailView);
    }

    public void updateCurrentView(IFormView detailView) {
        LOGGER.info("updateCurrentView");
        TaskDetailPageService.getInstance().updateCurrentView(detailView);
    }

    public void beforeClosed(IFormView detailView, BeforeClosedEvent beforeClosedEvent) {
        TaskDetailPageService.getInstance().beforeClosed(detailView, beforeClosedEvent);
    }

    public Tuple<OperationResult, List<Object>> invokeBizOperationAndSendAction(IFormView detailView, String pageNumber, String pageId, String opkey, OperateOption operateOption) {
        Map resultMap;
        List acts;
        if (operateOption == null) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", "hstc");
        }
        if (ObjectUtils.isNotEmpty((Object)(acts = (List)(resultMap = (Map)HSTCServiceHelper.invokeBizOperation((String)pageNumber, (String)pageId, (String)opkey, (OperateOption)operateOption)).get("acts")))) {
            HashMap<String, Object> arg = new HashMap<String, Object>(3);
            arg.put("pageId", pageId);
            arg.put("actions", acts);
            IClientViewProxy clientViewProxy = (IClientViewProxy)detailView.getService(IClientViewProxy.class);
            clientViewProxy.addAction("sendDynamicFormAction", arg);
        }
        LOGGER.info("pageNumber:{}, pageId:{}, opkey:{}, resultMap:{}", new Object[]{pageNumber, pageId, opkey, resultMap});
        OperationResult operationResult = (OperationResult)resultMap.get("operationResult");
        return Tuple.create((Object)operationResult, (Object)acts);
    }

    public void updateCurrentView(IFormView detailView, boolean ifUpdateParentView, boolean ifRefreshTree, boolean ifChildViewClosed) {
        String childPageId;
        IFormView childView;
        if (ifUpdateParentView) {
            this.updateParentView(detailView, ifRefreshTree);
        }
        if ((childView = detailView.getViewNoPlugin(childPageId = detailView.getPageCache().get("childPageId"))) != null && !ifChildViewClosed) {
            detailView.getPageCache().put("ifupdate_currentview", Boolean.TRUE.toString());
            try {
                String pageNumber = (String)detailView.getFormShowParameter().getCustomParam("activityNumber");
                HSTCServiceHelper.invokeBizOperation((String)pageNumber, (String)childPageId, (String)"close", null);
            }
            catch (Throwable throwable) {
                LOGGER.error(throwable);
                childView.close();
            }
            detailView.updateView();
        } else {
            this.updateCurrentView(detailView);
        }
    }

    public void updateParentView(IFormView detailView, boolean ifRefreshTree) {
        IFormView parentView;
        String parentPageId = detailView.getFormShowParameter().getParentPageId();
        try {
            parentView = detailView.getView(parentPageId);
        }
        catch (Throwable throwable) {
            parentView = detailView.getViewNoPlugin(parentPageId);
        }
        if (parentView == null) {
            LOGGER.debug("TaskCommonService_updateParentView parentView is null");
            return;
        }
        if (parentView instanceof ListView) {
            BillList billList = (BillList)parentView.getControl("billlistap");
            if (billList == null) {
                return;
            }
            billList.clearSelection();
            billList.refresh();
            if (ifRefreshTree) {
                this.refreshTaskTree(parentView);
            }
        } else {
            parentView.updateView();
        }
        detailView.sendFormAction(parentView);
    }

    public void refreshDetailTask(IFormView detailView, boolean refreshTree) {
        LOGGER.info("TaskCommonService_refreshDetailTask ", (Object)detailView.getEntityId());
        detailView.updateView();
        if (refreshTree) {
            this.refreshTaskTreeAndListOfDetail(detailView);
        }
    }

    public void refreshTaskTreeAndListOfDetail(IFormView detailView) {
        LOGGER.info("TaskCommonService_refreshTaskTreeAndListOfDetail ", (Object)detailView.getEntityId());
        IFormView listView = detailView.getViewNoPlugin(detailView.getFormShowParameter().getParentPageId());
        if (listView instanceof ListView) {
            listView.addClientCallBack("updateview");
            detailView.sendFormAction(listView);
        }
    }

    public void refreshTaskTreeAndList(IFormView view) {
        if (view instanceof ListView) {
            BillList billList = (BillList)view.getControl("billlistap");
            if (billList == null) {
                return;
            }
            billList.clearSelection();
            billList.refresh();
            this.refreshTaskTree(view);
        }
    }

    public void refreshTaskTree(IFormView listView) {
        IFormView parentView = listView.getViewNoPlugin(listView.getFormShowParameter().getParentPageId());
        if (parentView == null) {
            LOGGER.debug("TaskCommonService_refreshTaskTree parentView is null");
            return;
        }
        String nodeId = (String)listView.getFormShowParameter().getCustomParam("shownodeid");
        LOGGER.debug("TaskCommonService_refreshTaskTree,cur billformid={},nodeid={}", (Object)((ListView)listView).getBillFormId(), (Object)nodeId);
        parentView.addClientCallBack(nodeId);
        listView.sendFormAction(parentView);
    }

    public void close(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            LOGGER.debug("TaskCommonService_close parentView is null");
            return;
        }
        parentView.invokeOperation("close");
        view.sendFormAction(parentView);
    }

    public QFilter getTaskQFilter(IFormView view, String poolType) {
        long showbilltype;
        QFilter qFilter = new QFilter("personid", "=", (Object)RequestContext.get().getCurrUserId());
        FormShowParameter formShowParameter = view.getFormShowParameter();
        long sscId = ObjectUtils.getLongValOfObject((Object)formShowParameter.getCustomParam("showsscid"));
        if (sscId != 0L) {
            qFilter.and(new QFilter("sscid", "=", (Object)sscId));
        }
        qFilter.and(new QFilter("pooltype", "=", (Object)poolType));
        Long taskType = (Long)formShowParameter.getCustomParam("showtasktypeid");
        if (taskType != null) {
            qFilter.and(new QFilter("tasktypeid", "=", (Object)taskType));
        }
        if ((showbilltype = ObjectUtils.getLongValOfObject((Object)formShowParameter.getCustomParam("showbilltype"))) != 0L) {
            qFilter.and(new QFilter("billtype", "=", (Object)showbilltype));
        }
        return qFilter;
    }

    public void getDetailPageParameter(IFormView view, long taskId, boolean ifProcessing) {
        TaskApproveShowFormHelper.showFormToApprove(view, "hstc_taskapprove_acthr", taskId, ifProcessing, null, TaskApprovePageInvokerEnum.MY_TASK_LIST.getValue());
    }

    public void getApproveDetailPageParameter(IFormView view, long taskId, boolean ifProcessing) {
        TaskApproveShowFormHelper.showFormToApprove(view, "hstc_taskapprove_billhr", taskId, ifProcessing, null, TaskApprovePageInvokerEnum.MY_TASK_LIST.getValue());
    }

    public void openDetail(IFormView listView, boolean isApprove) {
        String showPoolType = (String)listView.getFormShowParameter().getCustomParam("showpooltype");
        long taskId = ObjectUtils.getLongValOfObject((Object)((IListView)listView).getFocusRowPkId());
        boolean ifProcessing = true;
        if ("completed".equals(showPoolType)) {
            ifProcessing = false;
        }
        if (isApprove) {
            this.getApproveDetailPageParameter(listView, taskId, ifProcessing);
        } else {
            this.getDetailPageParameter(listView, taskId, ifProcessing);
        }
    }

    public ListShowParameter getShowParameterTaskpool(long sscid, boolean ifProcess, String taskType, QFilter qFilter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("task_billclassifybase");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("sscid", (Object)sscid);
        if (ifProcess) {
            showParameter.setCustomParam("tab", (Object)"process");
        } else {
            showParameter.setCustomParam("tab", (Object)"completed");
        }
        showParameter.setCustomParam("tasktype", (Object)taskType);
        if (qFilter != null) {
            showParameter.setCustomParam("qfilter", (Object)qFilter.toSerializedString());
        }
        return showParameter;
    }

    private static class InstanceHolder {
        private static final TaskCommonService INSTANCE = new TaskCommonService();

        private InstanceHolder() {
        }
    }
}

