/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.common;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.ssc.plugin.TaskListButtonPlugin;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;
import kd.ssc.hstc.business.taskdatasync.cache.FullBizTaskAppCache;
import kd.ssc.hstc.business.taskdatasync.cache.FullBizTaskAppCacheFactory;
import kd.ssc.hstc.business.taskdatasync.util.BizTaskEntityUtil;
import kd.ssc.hstc.common.constant.TaskMappingConstant;
import kd.ssc.hstc.util.ObjectUtils;

public class TaskQueryListPoolPlugin
extends TaskListButtonPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaskQueryListPoolPlugin.class);
    private static final String DEFAULT_ORDERSTR = "tasklevelid.priority asc,receivetime asc";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String mainEntityNumber = this.getMainEntityNumber();
        FullBizTaskAppCache bizTaskAppCache = FullBizTaskAppCacheFactory.getFullBizTaskAppCache((String)mainEntityNumber);
        String cacheValue = bizTaskAppCache.queryCache();
        if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6570\u636e\u6b63\u5728\u540c\u6b65\u66f4\u65b0\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u5217\u8868\u91cd\u8bd5\u3002", (String)"TaskQueryListPoolPlugin_0", (String)"ssc-hstc-formplugin", (Object[])new Object[0]));
        }
    }

    private String getMainEntityNumber() {
        ListView listView = (ListView)this.getView();
        String billFormId = listView.getBillFormId();
        return BizTaskEntityUtil.getMainEntityFormId((String)billFormId);
    }

    public void setFilter(SetFilterEvent event) {
        String orderStr;
        super.setFilter(event);
        boolean isPreview = ObjectUtils.getBooleanValOfObject((Object)this.getView().getFormShowParameter().getCustomParam("isPreview"));
        if (isPreview) {
            List listFilter = event.getQFilters();
            QFilter qFilter = new QFilter("1", "!=", (Object)"1");
            listFilter.add(qFilter);
            LOGGER.info("PreViewing");
        }
        orderStr = ObjectUtils.isEmpty((Object)(orderStr = event.getOrderBy())) || DEFAULT_ORDERSTR.equals(orderStr) ? DEFAULT_ORDERSTR : "tasklevelid.priority asc,receivetime asc," + orderStr;
        event.setOrderBy(orderStr);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (TaskMappingConstant.TASK_PERMISSIN_MAP.containsKey(itemKey)) {
            Boolean updateListFlag = SSCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)false);
            if (updateListFlag.booleanValue()) {
                LOGGER.info("SSCPermissionServiceHelper.updateListFlag");
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            boolean superUser = SSCPermissionServiceHelper.isSuperUser();
            boolean hasPermByPermItemNum = SSCPermissionServiceHelper.hasPerm((long)userId, (String)"40A+670S4LST", (String)"task_task", (String)((String)TaskMappingConstant.TASK_PERMISSIN_MAP.get(itemKey)));
            if (superUser || hasPermByPermItemNum) {
                LOGGER.info("SSCPermissionServiceHelper.hasPermByPermItemNum");
            } else {
                String otherCaption = EntityMetadataCache.getDataEntityType((String)"task_task").getDisplayName().getLocaleValue();
                String permissionName = PermItemHelper.getPermItemNameById((String)((String)TaskMappingConstant.TASK_PERMISSIN_MAP.get(itemKey)));
                String msg = SSCPermissionServiceHelper.getNoPermTips((String)otherCaption, (String)permissionName);
                this.getView().showErrorNotification(msg);
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tk_mytask_exportexcel".equals(itemKey)) {
            return;
        }
        super.itemClick(evt);
    }
}

