/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.contract.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.ssc.hstc.business.service.SSCPermissionServiceHelper;

public class ContractService {
    private static final Log LOGGER = LogFactory.getLog(ContractService.class);
    private static final Map<String, String> ENTITYREFMAP = new HashMap<String, String>();

    public static ContractService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args, Set<String> fixedSet) {
        List columns = args.getListColumns();
        columns.forEach(item -> {
            if (fixedSet.contains(item.getListFieldKey())) {
                item.setFixed(true);
            }
        });
    }

    public void checkPerOfList(BeforeItemClickEvent evt, IFormView view) {
        String billFormId;
        String pageNumber;
        String itemKey = evt.getItemKey();
        if (!itemKey.startsWith("act_")) {
            return;
        }
        if (view instanceof ListView && !evt.isCancel() && !this.checkPer(view, pageNumber = ENTITYREFMAP.get(billFormId = ((ListView)view).getBillFormId()), itemKey, false)) {
            evt.setCancel(true);
        }
    }

    public boolean checkPer(IFormView view, String pageNumber, String itemKey, Boolean isDetail) {
        Tuple<String, String> perInfo = this.getPerInfo(pageNumber, itemKey, isDetail);
        String entityName = (String)perInfo.item1;
        String perId = (String)perInfo.item2;
        LOGGER.info("ContractService.checkPer entityName={}\uff0cperId={}", (Object)entityName, (Object)perId);
        if (entityName == null || perId == null) {
            return true;
        }
        return SSCPermissionServiceHelper.checkPer((IFormView)view, (String)entityName, (String)perId);
    }

    private Tuple<String, String> getPerInfo(String pageNumber, String itemKey, Boolean isDetail) {
        String entityName = null;
        String perId = null;
        if ("hlcm_paper_beginlist".equals(pageNumber)) {
            entityName = "hlcm_paper_beginlist";
            if ("act_beginsign".equals(itemKey)) {
                perId = "2BEGOC9WTO6A";
            } else if ("act_stopsign".equals(itemKey)) {
                perId = "2BEGMIB+UGLX";
            }
        } else if ("hlcm_paper_complist".equals(pageNumber)) {
            entityName = "hlcm_paper_complist";
            if ("act_compsign".equals(itemKey)) {
                perId = "2BEGPA0K7+N/";
            } else if ("act_stopsign".equals(itemKey)) {
                perId = "2BEGMIB+UGLX";
            }
        } else if ("hlcm_paper_checklist".equals(pageNumber)) {
            entityName = "hlcm_paper_checklist";
            if ("act_archive".equals(itemKey)) {
                perId = "2BEGNF7Y+24F";
            }
        } else if ("hlcm_electric_beginlist".equals(pageNumber)) {
            entityName = "hlcm_electric_beginlist";
            if ("act_beginsign".equals(itemKey)) {
                perId = "2BEGOC9WTO6A";
            } else if ("act_stopsign".equals(itemKey)) {
                perId = "2BEGMIB+UGLX";
            }
        } else if ("hlcm_electric_csignlist".equals(pageNumber)) {
            entityName = "hlcm_electric_csignlist";
            if ("act_companysign".equals(itemKey)) {
                perId = "2BEGQLHRN9JX";
            } else if ("act_stopsign".equals(itemKey)) {
                perId = "2BEGMIB+UGLX";
            }
        } else if ("hlcm_electric_checklist".equals(pageNumber)) {
            entityName = "hlcm_electric_checklist";
            if ("act_archive".equals(itemKey)) {
                perId = "2BEGNF7Y+24F";
            }
        }
        return new Tuple((Object)entityName, (Object)perId);
    }

    static {
        ENTITYREFMAP.put("hstc_paperbegin_ql", "hlcm_paper_beginlist");
        ENTITYREFMAP.put("hstc_papercom_ql", "hlcm_paper_complist");
        ENTITYREFMAP.put("hstc_papercheck_ql", "hlcm_paper_checklist");
        ENTITYREFMAP.put("hstc_electricbegin_ql", "hlcm_electric_beginlist");
        ENTITYREFMAP.put("hstc_electriccsign_ql", "hlcm_electric_csignlist");
        ENTITYREFMAP.put("hstc_electriccheck_ql", "hlcm_electric_checklist");
        ENTITYREFMAP.put("hstc_electricbegin_qhl", "hlcm_electric_checklist");
    }

    private static class InstanceHolder {
        private static final ContractService INSTANCE = new ContractService();

        private InstanceHolder() {
        }
    }
}

