/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.contract.electric;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.ssc.hstc.AbstractHRTaskDetailPlugin;
import kd.ssc.hstc.formplugin.web.contract.electric.ElectricSignService;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveFormHelper;

public class ElectricSignDetailEdit
extends AbstractHRTaskDetailPlugin {
    private static final Log LOGGER = LogFactory.getLog(ElectricSignDetailEdit.class);

    public boolean showCustomBizView(IFormView formView, long taskId, FormShowParameter childFormParameter, Map<String, Object> rpcResult) {
        DynamicObject activityListDy;
        String activityNumber = TaskApproveFormHelper.getCustomParam(this.getView(), "activityNumber");
        Long activityId = TaskApproveFormHelper.getCustomParam(this.getView(), "activityId", Long.class);
        if (activityId == null || activityNumber == null) {
            return false;
        }
        if (("hlcm_electric_beginlist".equals(activityNumber) || "hlcm_electric_csignlist".equals(activityNumber) || "hlcm_electric_checklist".equals(activityNumber)) && (activityListDy = BusinessDataServiceHelper.loadSingle((Object)activityId, (String)activityNumber)) != null) {
            long pkId = activityListDy.getLong("signapply.id");
            childFormParameter.setCustomParam("id", (Object)pkId);
            if (childFormParameter instanceof BillShowParameter) {
                ((BillShowParameter)childFormParameter).setPkId((Object)pkId);
            }
            childFormParameter.setStatus(OperationStatus.VIEW);
        }
        return false;
    }

    public boolean callOperation(IFormView currentView, String entityNumber, String opNumber, Long bizActiviyId, Map<String, Object> paramsMap) {
        if ("refresh".equals(opNumber)) {
            currentView.updateView();
            return true;
        }
        if (opNumber != null && !opNumber.startsWith("act_")) {
            opNumber = "act_" + opNumber;
        }
        String activityNumber = TaskApproveFormHelper.getCustomParam(this.getView(), "activityNumber");
        ElectricSignService.getInstance().electricSignOpOfDetail(null, this.getView(), opNumber, activityNumber);
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String activityNumber = TaskApproveFormHelper.getCustomParam(this.getView(), "activityNumber");
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        LOGGER.info("ElectricSignDetailEdit.closedCallBack(ClosedCallBackEvent closedCallBackEvent);ActionId : {} ; activityNumber : {} ", (Object)actionId, (Object)activityNumber);
        if (StringUtils.isNotEmpty((String)activityNumber)) {
            LOGGER.info("ElectricSignDetailEdit -- closedCallBack return data {}--", returnDataObj);
            ElectricSignService.getInstance().closedCallBack(closedCallBackEvent, this.getView(), activityNumber, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String activityNumber = TaskApproveFormHelper.getCustomParam(this.getView(), "activityNumber");
        if (messageBoxClosedEvent.getCallBackId() != null) {
            LOGGER.info("ElectricSignDetailEdit.confirmCallBack();CallBackId : {0} ; activityNumber : {1} ", (Object)messageBoxClosedEvent.getCallBackId(), (Object)activityNumber);
        }
        if (messageBoxClosedEvent.getResult() != null) {
            LOGGER.info("ElectricSignDetailEdit.confirmCallBack();Result : {}", (Object)messageBoxClosedEvent.getResult());
        }
        if (StringUtils.isNotEmpty((String)activityNumber)) {
            ElectricSignService.getInstance().confirmCallBack(messageBoxClosedEvent, this.getView(), activityNumber, null);
        }
    }
}

