/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.contract.papersign;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.ssc.hstc.formplugin.web.contract.common.ContractHandCommonListPlugin;
import kd.ssc.hstc.formplugin.web.contract.common.ContractService;
import kd.ssc.hstc.formplugin.web.contract.papersign.PaperSignService;

public class PaperSignComListPlugin
extends ContractHandCommonListPlugin {
    public void initialize() {
        super.initialize();
        Long activityId = PaperSignService.getInstance().getActivityId("hlcm_papersign_comp");
        if (activityId != null && activityId != 0L) {
            QFilter qFilter = new QFilter("hlcm_paper_complist.activityins", "!=", (Object)0L);
            qFilter.and(new QFilter("hlcm_paper_complist.activity.id", "=", (Object)activityId));
            HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
            map.put("hlcm_papersign_comp", Lists.newArrayList((Object[])new QFilter[]{qFilter}));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setCustomParam("MultEntity_JoinOnRelationMap", map);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        HashSet<String> set = new HashSet<String>();
        set.add("hlcm_paper_complist.person.headsculpture");
        set.add("hlcm_paper_complist.signapply.empname");
        ContractService.getInstance().beforeCreateListColumns(args, set);
    }

    @Override
    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("tasklevelid.priority asc,receivetime asc,hlcm_paper_complist.signapply.signeddate asc");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        PaperSignService.getInstance().paperSignOpOfList((IFormPlugin)this, this.getView(), evt, "hlcm_paper_complist");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        PaperSignService.getInstance().closedCallBack(closedCallBackEvent, this.getView(), "hlcm_paper_complist", (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        PaperSignService.getInstance().confirmCallBack(messageBoxClosedEvent, this.getView(), "hlcm_paper_complist", (IFormPlugin)this);
    }
}

