/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.hstc.formplugin.web.contract.papersign;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageCallBackType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.ssc.hstc.common.TaskHandleService;
import kd.sdk.ssc.hstc.constant.OperationResultType;
import kd.sdk.ssc.hstc.util.ObjectUtils;
import kd.ssc.hstc.business.service.TaskService;
import kd.ssc.hstc.business.servicehelper.HRServiceHelper;
import kd.ssc.hstc.common.TaskStateEnum;
import kd.ssc.hstc.formplugin.web.common.TaskCommonService;
import kd.ssc.hstc.formplugin.web.contract.common.ContractService;
import kd.ssc.hstc.formplugin.web.contract.papersign.PaperSignKDString;
import kd.ssc.hstc.formplugin.web.helper.TaskApproveFormHelper;

public class PaperSignService {
    private static final Log LOG = LogFactory.getLog(PaperSignService.class);
    private static final long BEGIN_ACTIVITYID = 1373940938556191744L;
    private static final long COMP_ACTIVITYID = 1373942639405184000L;
    private static final long CHECK_ACTIVITYID = 1373941983432811520L;

    public static PaperSignService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Long getActivityId(String sourceListFormId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"hrcs_activity", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizobj.id", "=", (Object)sourceListFormId)});
        Long activityId = 0L;
        if (dynamicObject == null) {
            switch (sourceListFormId) {
                case "hlcm_papersign_begin": {
                    activityId = 1373940938556191744L;
                    break;
                }
                case "hlcm_papersign_comp": {
                    activityId = 1373942639405184000L;
                    break;
                }
                case "hlcm_papersign_check": {
                    activityId = 1373941983432811520L;
                    break;
                }
            }
        } else {
            activityId = (Long)dynamicObject.getPkValue();
        }
        return activityId;
    }

    public void paperSignOpOfDetail(IFormPlugin formPlugin, IFormView view, String operateKey, String activityListFormId) {
        boolean checkPer = ContractService.getInstance().checkPer(view, activityListFormId, operateKey, true);
        if (!checkPer) {
            return;
        }
        Long taskId = TaskApproveFormHelper.getCustomParam(view, "taskid", Long.class);
        if (taskId == null) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>();
        idSet.add(taskId);
        if ("act_beginsign".equals(operateKey)) {
            this.beginSign(formPlugin, view, idSet);
        } else if ("act_stopsign".equals(operateKey)) {
            this.stopSign(formPlugin, view, activityListFormId, idSet);
        } else if ("act_compsign".equals(operateKey)) {
            this.comSign(formPlugin, view, idSet);
        } else if ("act_archive".equals(operateKey)) {
            this.archive(formPlugin, view, idSet);
        }
    }

    public void paperSignOpOfList(IFormPlugin formPlugin, IFormView view, ItemClickEvent evt, String activityListFormId) {
        String itemKey = evt.getItemKey();
        if (!itemKey.startsWith("act_")) {
            return;
        }
        ListSelectedRowCollection coll = ((ListView)view).getSelectedRows();
        if (coll == null || coll.isEmpty()) {
            view.showTipNotification(PaperSignKDString.emptyData());
            return;
        }
        Set<Long> idSet = coll.stream().map(dd -> (Long)dd.getPrimaryKeyValue()).collect(Collectors.toSet());
        if ("act_beginsign".equals(itemKey)) {
            this.beginSign(formPlugin, view, idSet);
        } else if ("act_stopsign".equals(itemKey)) {
            this.stopSign(formPlugin, view, activityListFormId, idSet);
        } else if ("act_compsign".equals(itemKey)) {
            this.comSign(formPlugin, view, idSet);
        } else if ("act_archive".equals(itemKey)) {
            this.archive(formPlugin, view, idSet);
        }
    }

    private boolean validateBeforeHandling(IFormPlugin formPlugin, IFormView view, Set<Long> idSet, boolean isPass) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        String type = isPass ? OperationResultType.PROCESSED.getValue() : OperationResultType.TERMINATED.getValue();
        boolean isFromList = formPlugin == null ? Boolean.FALSE : Boolean.TRUE;
        paramsMap.putIfAbsent("operationResultType", type);
        paramsMap.putIfAbsent("isFromList", isFromList);
        Map errorTipsMap = TaskHandleService.getInstance().validateBeforeHandling(view, new ArrayList<Long>(idSet), paramsMap);
        if (errorTipsMap == null || errorTipsMap.isEmpty()) {
            return true;
        }
        for (Long taskId : idSet) {
            List result = (List)errorTipsMap.get(taskId);
            String errorMsg = String.join((CharSequence)System.lineSeparator(), result);
            if (!ObjectUtils.isNotEmpty((Object)errorMsg)) continue;
            view.showErrorNotification(errorMsg);
        }
        return false;
    }

    public void beginSign(IFormPlugin formPlugin, IFormView view, Set<Long> idSet) {
        DynamicObject[] taskArr = this.getTask(idSet);
        if (taskArr == null || taskArr.length == 0) {
            view.showTipNotification(PaperSignKDString.process());
            return;
        }
        ArrayList activityListIdList = Lists.newArrayListWithExpectedSize((int)taskArr.length);
        HashMap activityListIdRefTaskId = Maps.newHashMapWithExpectedSize((int)taskArr.length);
        for (DynamicObject task : taskArr) {
            boolean state2;
            String poolType = task.getString("pooltype");
            String state = task.getString("state");
            if ("1".equals(poolType) && TaskStateEnum.PAUSE.getValue().equals(state)) {
                view.showTipNotification(PaperSignKDString.process());
                return;
            }
            boolean bl = state2 = TaskStateEnum.PROCESSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state);
            if ("2".equals(poolType) && state2) {
                view.showTipNotification(PaperSignKDString.process());
                return;
            }
            activityListIdList.add(task.getLong("billlongid"));
            activityListIdRefTaskId.put(task.getString("billlongid"), task.getLong("id"));
        }
        if (!this.validateBeforeHandling(formPlugin, view, idSet, true)) {
            return;
        }
        this.setCachePage(view, activityListIdRefTaskId);
        this.callHlcm(view, "beginsign", "hlcm_paper_beginlist", activityListIdList, formPlugin, idSet);
    }

    private DynamicObject[] getTask(Set<Long> idSet) {
        QFilter id = new QFilter("id", "in", idSet);
        return TaskService.getInstance().queryTask("id,pooltype,state,billlongid,billtype", new QFilter[]{id});
    }

    public void stopSign(IFormPlugin formPlugin, IFormView view, String activityListFormId, Set<Long> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            view.showTipNotification(PaperSignKDString.processForStop());
            return;
        }
        if (idSet.size() > 1) {
            view.showErrorNotification(PaperSignKDString.oneSize());
            return;
        }
        DynamicObject[] taskArr = this.getTask(idSet);
        if (taskArr == null || taskArr.length == 0) {
            view.showTipNotification(PaperSignKDString.processForStop());
            return;
        }
        ArrayList activityListIdList = Lists.newArrayListWithExpectedSize((int)taskArr.length);
        HashMap activityListIdRefTaskId = Maps.newHashMapWithExpectedSize((int)taskArr.length);
        for (DynamicObject task : taskArr) {
            boolean state2;
            String poolType = task.getString("pooltype");
            String state = task.getString("state");
            if ("1".equals(poolType) && TaskStateEnum.PAUSE.getValue().equals(state)) {
                view.showTipNotification(PaperSignKDString.processForStop());
                return;
            }
            boolean bl = state2 = TaskStateEnum.PROCESSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state);
            if ("2".equals(poolType) && state2) {
                view.showTipNotification(PaperSignKDString.processForStop());
                return;
            }
            activityListIdList.add(task.getLong("billlongid"));
            activityListIdRefTaskId.put(task.getString("billlongid"), task.getLong("id"));
        }
        if (!this.validateBeforeHandling(formPlugin, view, idSet, false)) {
            return;
        }
        this.setCachePage(view, activityListIdRefTaskId);
        this.callHlcmOfStop(view, activityListFormId, activityListIdList, formPlugin);
    }

    public void comSign(IFormPlugin formPlugin, IFormView view, Set<Long> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            view.showTipNotification(PaperSignKDString.processOfCheck());
            return;
        }
        DynamicObject[] taskArr = this.getTask(idSet);
        if (taskArr == null || taskArr.length == 0) {
            return;
        }
        HashMap activityListIdRefTaskId = Maps.newHashMapWithExpectedSize((int)taskArr.length);
        ArrayList activityListIdList = Lists.newArrayListWithExpectedSize((int)taskArr.length);
        for (DynamicObject task : taskArr) {
            boolean state2;
            String poolType = task.getString("pooltype");
            String state = task.getString("state");
            if ("1".equals(poolType) && TaskStateEnum.PAUSE.getValue().equals(state)) {
                view.showTipNotification(PaperSignKDString.processOfCheck());
                return;
            }
            boolean bl = state2 = TaskStateEnum.PROCESSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state);
            if ("2".equals(poolType) && state2) {
                view.showTipNotification(PaperSignKDString.processOfCheck());
                return;
            }
            activityListIdList.add(task.getLong("billlongid"));
            activityListIdRefTaskId.put(task.getString("billlongid"), task.getLong("id"));
        }
        if (!this.validateBeforeHandling(formPlugin, view, idSet, true)) {
            return;
        }
        this.setCachePage(view, activityListIdRefTaskId);
        this.callHlcm(view, "compsign", "hlcm_paper_complist", activityListIdList, formPlugin, idSet);
    }

    public void archive(IFormPlugin formPlugin, IFormView view, Set<Long> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            view.showTipNotification(PaperSignKDString.activityOfProcess());
            return;
        }
        DynamicObject[] taskArr = this.getTask(idSet);
        if (taskArr == null || taskArr.length == 0) {
            return;
        }
        ArrayList activityListIdList = Lists.newArrayListWithExpectedSize((int)taskArr.length);
        HashMap activityListIdRefTaskId = Maps.newHashMapWithExpectedSize((int)taskArr.length);
        for (DynamicObject task : taskArr) {
            boolean state2;
            String poolType = task.getString("pooltype");
            String state = task.getString("state");
            if ("1".equals(poolType) && TaskStateEnum.PAUSE.getValue().equals(state)) {
                view.showTipNotification(PaperSignKDString.activityOfProcess());
                return;
            }
            boolean bl = state2 = TaskStateEnum.PROCESSED.getValue().equals(state) || TaskStateEnum.TERMINATED.getValue().equals(state);
            if ("2".equals(poolType) && state2) {
                view.showTipNotification(PaperSignKDString.activityOfProcess());
                return;
            }
            activityListIdList.add(task.getLong("billlongid"));
            activityListIdRefTaskId.put(task.getString("billlongid"), task.getLong("id"));
        }
        if (!this.validateBeforeHandling(formPlugin, view, idSet, true)) {
            return;
        }
        this.setCachePage(view, activityListIdRefTaskId);
        this.callHlcm(view, "archive", "hlcm_paper_checklist", activityListIdList, formPlugin, idSet);
    }

    private void callHlcmOfStop(IFormView view, String activityListFormId, List<Long> activityListIdList, IFormPlugin formPlugin) {
        Map<String, Object> result;
        LOG.info("PaperSignService_callHlcmOfStop, billFormId={}, size={}", (Object)activityListFormId, (Object)activityListIdList.size());
        HashMap validateInfo = Maps.newHashMapWithExpectedSize((int)3);
        validateInfo.put("operateKey", "terminate");
        validateInfo.put("billFormId", activityListFormId);
        validateInfo.put("selectedKeys", activityListIdList);
        if (formPlugin == null) {
            validateInfo.put("sourcesscdetail", true);
        }
        if ((result = this.callHlcm("preValidateWindow", validateInfo)) != null && !result.isEmpty()) {
            String showType = (String)result.get("showType");
            String msg = (String)result.get("msg");
            LOG.info("PaperSignService_callHlcmOfStop, showType={}, msg={}, size={}", new Object[]{showType, msg, activityListIdList.size()});
            if (StringUtils.isNotEmpty((String)showType)) {
                FormShowParameter formShowParameter;
                if ("11".equals(showType)) {
                    view.showTipNotification(msg);
                } else if ("12".equals(showType)) {
                    view.showErrorNotification(msg);
                } else if ("20".equals(showType) && (formShowParameter = (FormShowParameter)result.get("showParameter")) != null) {
                    formShowParameter.setCustomParam("showway", (Object)"hstc");
                    CloseCallBack terminate_operation = this.getCloseCallBack(formPlugin, "terminate");
                    formShowParameter.setCloseCallBack(terminate_operation);
                    view.showForm(formShowParameter);
                }
            }
        }
    }

    private void callHlcm(IFormView view, String operateKey, String billFormId, List<Long> activityListIdList, IFormPlugin formPlugin, Set<Long> idSet) {
        Map<String, Object> preResult;
        LOG.info("PaperSignService_callhlcm, operateKey={}, billFormId={}, size={}", new Object[]{operateKey, billFormId, activityListIdList.size()});
        HashMap validateInfo = Maps.newHashMapWithExpectedSize((int)3);
        validateInfo.put("operateKey", operateKey);
        validateInfo.put("billFormId", billFormId);
        validateInfo.put("selectedKeys", activityListIdList);
        if (formPlugin == null) {
            validateInfo.put("sourcesscdetail", true);
        }
        if ((preResult = this.callHlcm("preValidateWindow", validateInfo)) != null && !preResult.isEmpty()) {
            LOG.info("PaperSignService_callhlcm, size={}", (Object)preResult.size());
            String showType = (String)preResult.get("showType");
            String msg = (String)preResult.get("msg");
            LOG.info("PaperSignService_callhlcm, showType={}, msg={}", (Object)showType, (Object)msg);
            if (StringUtils.isNotEmpty((String)showType)) {
                if ("10".equals(showType)) {
                    view.showSuccessNotification(msg);
                    this.dealWithHandling(view, formPlugin, new ArrayList<Long>(idSet), true);
                    if (formPlugin == null) {
                        TaskCommonService.getInstance().refreshDetailTask(view, true);
                    } else {
                        TaskCommonService.getInstance().refreshTaskTreeAndList(view);
                    }
                } else if ("11".equals(showType)) {
                    view.showTipNotification(msg);
                } else if ("12".equals(showType)) {
                    view.showErrorNotification(msg);
                    this.dealWithHandling(view, formPlugin, new ArrayList<Long>(idSet), false);
                    if (formPlugin != null) {
                        TaskCommonService.getInstance().refreshTaskTreeAndList(view);
                    }
                } else if ("13".equals(showType)) {
                    HashMap callBackParamMap = Maps.newHashMapWithExpectedSize((int)4);
                    callBackParamMap.put("billFormId", billFormId);
                    callBackParamMap.put("operateKey", operateKey);
                    callBackParamMap.put("selectedKeys", activityListIdList);
                    callBackParamMap.put("passValidateKeys", preResult.get("passValidateKeys"));
                    List<Long> taskIdList = this.getTaskIdList(view, null);
                    this.dealWithCallBack(view, callBackParamMap, operateKey, formPlugin, taskIdList);
                } else if ("20".equals(showType)) {
                    this.setCachePage(view, preResult, activityListIdList);
                    FormShowParameter formShowParameter = (FormShowParameter)preResult.get("showParameter");
                    if (formShowParameter != null) {
                        formShowParameter.setCustomParam("showway", (Object)"hstc");
                        CloseCallBack terminate_operation = this.getCloseCallBack(formPlugin, operateKey);
                        formShowParameter.setCloseCallBack(terminate_operation);
                        view.showForm(formShowParameter);
                    }
                } else if ("30".equals(showType)) {
                    this.setCachePage(view, preResult, activityListIdList);
                    ConfirmCallBackListener confirmCallBackListener = this.getConfirmCallBackListener(formPlugin, operateKey);
                    view.showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            }
        }
    }

    private Map<String, Object> callHlcm(String methodName, Map<String, Object> paramMap) {
        LOG.info("callHlcm, methodName={}", (Object)methodName);
        return (Map)HRServiceHelper.invokeHRHlcmService((String)"IHLCMShowFormService", (String)methodName, (Object[])new Object[]{paramMap});
    }

    private void dealWithCallBack(IFormView view, Map<String, Object> callBackParamMap, String actionId, IFormPlugin formPlugin, List<Long> taskIdList) {
        Map<String, Object> callBackResult;
        if (formPlugin == null) {
            callBackParamMap.put("sourcesscdetail", true);
        }
        if ((callBackResult = this.callHlcm("callBack", callBackParamMap)) != null && !callBackResult.isEmpty()) {
            LOG.info("PaperSignService_dealWithCallBack, size={}", (Object)callBackResult.size());
            String showType = (String)callBackResult.get("showType");
            String msg = (String)callBackResult.get("msg");
            LOG.info("PaperSignService_dealWithCallBack, showType={}, msg={}", (Object)showType, (Object)msg);
            if (StringUtils.isNotEmpty((String)showType)) {
                if ("10".equals(showType)) {
                    view.showSuccessNotification(msg);
                    this.dealWithHandling(view, formPlugin, taskIdList, true);
                    if (formPlugin == null) {
                        TaskCommonService.getInstance().refreshDetailTask(view, true);
                    } else {
                        TaskCommonService.getInstance().refreshTaskTreeAndList(view);
                    }
                } else if ("11".equals(showType)) {
                    view.showTipNotification(msg);
                } else if ("12".equals(showType)) {
                    view.showErrorNotification(msg);
                    this.dealWithHandling(view, formPlugin, taskIdList, false);
                } else if ("20".equals(showType)) {
                    FormShowParameter formShowParameter = (FormShowParameter)callBackResult.get("showParameter");
                    if (formShowParameter != null) {
                        formShowParameter.setCustomParam("showway", (Object)"hstc");
                        CloseCallBack terminate_operation = this.getCloseCallBack(formPlugin, actionId + "callback");
                        formShowParameter.setCloseCallBack(terminate_operation);
                        view.showForm(formShowParameter);
                    }
                } else if ("30".equals(showType)) {
                    ConfirmCallBackListener confirmCallBackListener = this.getConfirmCallBackListener(formPlugin, actionId + "callback");
                    view.showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            }
        }
    }

    private void dealWithHandling(IFormView view, IFormPlugin formPlugin, List<Long> taskIdList, boolean isPass) {
        if (!taskIdList.isEmpty()) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            String value = isPass ? OperationResultType.PROCESSED.getValue() : OperationResultType.TERMINATED.getValue();
            paramsMap.put("operationResultType", value);
            if (formPlugin == null) {
                paramsMap.put("isFromList", false);
                TaskHandleService.getInstance().doSomethingsAfterHandled(view, taskIdList.get(0), paramsMap);
            } else {
                paramsMap.put("isFromList", true);
                TaskHandleService.getInstance().doSomethingsAfterHandled(view, taskIdList, paramsMap);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent, IFormView view, String activityListFormId, IFormPlugin formPlugin) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("terminate".equals(actionId)) {
            view.showSuccessNotification(PaperSignKDString.stopSignSuccess());
            List<Long> taskIdList = this.getTaskIdList(view, null);
            this.dealWithHandling(view, formPlugin, taskIdList, false);
            if (formPlugin == null) {
                TaskCommonService.getInstance().refreshDetailTask(view, true);
            } else {
                TaskCommonService.getInstance().refreshTaskTreeAndList(view);
            }
            return;
        }
        if ("beginsign".equals(actionId) || "compsign".equals(actionId) || "archive".equals(actionId)) {
            List<Long> activityListIdList = this.getPageByKey(view, "cache_selectedKeys");
            if (activityListIdList.isEmpty()) {
                return;
            }
            List<Long> passValidateKeys = this.getPageByKey(view, "cache_passValidateKeys");
            if (passValidateKeys.isEmpty()) {
                return;
            }
            HashMap executeInfo = Maps.newHashMapWithExpectedSize((int)4);
            executeInfo.put("billFormId", activityListFormId);
            executeInfo.put("operateKey", actionId);
            executeInfo.put("passValidateKeys", passValidateKeys);
            executeInfo.put("selectedKeys", activityListIdList);
            List<Long> taskIdList = this.getTaskIdList(view, passValidateKeys);
            this.dealWithCallBack(view, executeInfo, actionId, formPlugin, taskIdList);
            view.getPageCache().remove("cache_passValidateKeys");
            view.getPageCache().remove("cache_selectedKeys");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent, IFormView view, String activityListFormId, IFormPlugin formPlugin) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("beginsign".equals(callBackId) || "compsign".equals(callBackId) || "archive".equals(callBackId)) {
            MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == messageBoxResult) {
                List<Long> passValidateKeys = this.getPageByKey(view, "cache_passValidateKeys");
                if (passValidateKeys.isEmpty()) {
                    return;
                }
                List<Long> activityListIdList = this.getPageByKey(view, "cache_selectedKeys");
                if (activityListIdList.isEmpty()) {
                    return;
                }
                List<Long> taskIdList = this.getTaskIdList(view, passValidateKeys);
                HashMap executeInfo = Maps.newHashMapWithExpectedSize((int)4);
                executeInfo.put("operateKey", callBackId);
                executeInfo.put("billFormId", activityListFormId);
                executeInfo.put("selectedKeys", activityListIdList);
                executeInfo.put("passValidateKeys", passValidateKeys);
                this.dealWithCallBack(view, executeInfo, callBackId, formPlugin, taskIdList);
            }
            view.getPageCache().remove("cache_passValidateKeys");
            view.getPageCache().remove("cache_selectedKeys");
        }
    }

    private void setCachePage(IFormView view, Map<String, Object> preResult, List<Long> activityListIdList) {
        List passValidateKeys = (List)preResult.get("passValidateKeys");
        if (passValidateKeys != null) {
            String passValidateKeyStr = SerializationUtils.toJsonString((Object)passValidateKeys);
            view.getPageCache().put("cache_passValidateKeys", passValidateKeyStr);
        }
        String billIdListStr = SerializationUtils.toJsonString(activityListIdList);
        view.getPageCache().put("cache_selectedKeys", billIdListStr);
    }

    private void setCachePage(IFormView view, Map<String, Long> activityListIdRefTaskId) {
        String billIdListStr = SerializationUtils.toJsonString(activityListIdRefTaskId);
        view.getPageCache().put("cache_activityreftask", billIdListStr);
    }

    private List<Long> getTaskIdList(IFormView view, List<Long> passValidateKeys) {
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        String cache = view.getPageCache().get("cache_activityreftask");
        if (StringUtils.isEmpty((String)cache)) {
            return taskIdList;
        }
        Map activityListIdRefTaskId = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        if (activityListIdRefTaskId == null || activityListIdRefTaskId.isEmpty()) {
            return taskIdList;
        }
        Set entries = activityListIdRefTaskId.entrySet();
        for (Map.Entry next : entries) {
            if (passValidateKeys == null) {
                taskIdList.add((Long)next.getValue());
                continue;
            }
            Long actListId = Long.parseLong((String)next.getKey());
            if (!passValidateKeys.contains(actListId)) continue;
            taskIdList.add((Long)next.getValue());
        }
        LOG.info("PaperSignService_getTaskIdList, taskIdList={}", (Object)taskIdList.size());
        return taskIdList;
    }

    private List<Long> getPageByKey(IFormView view, String cacheKey) {
        String cacheStr = view.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cacheStr)) {
            return new ArrayList<Long>();
        }
        List list = (List)SerializationUtils.fromJsonString((String)cacheStr, List.class);
        if (list == null || list.isEmpty()) {
            return new ArrayList<Long>();
        }
        return list;
    }

    private CloseCallBack getCloseCallBack(IFormPlugin formPlugin, String actionId) {
        CloseCallBack closeCallBack = null == formPlugin ? new CloseCallBack("kd.ssc.hstc.formplugin.web.HRTaskDetailEdit", actionId) : new CloseCallBack(formPlugin, actionId);
        return closeCallBack;
    }

    private ConfirmCallBackListener getConfirmCallBackListener(IFormPlugin formPlugin, String operateKey) {
        ConfirmCallBackListener confirmCallBackListener = formPlugin == null ? new ConfirmCallBackListener(operateKey, "kd.ssc.hstc.formplugin.web.HRTaskDetailEdit", MessageCallBackType.Plugin) : new ConfirmCallBackListener(operateKey, formPlugin);
        return confirmCallBackListener;
    }

    private static class InstanceHolder {
        private static final PaperSignService INSTANCE = new PaperSignService();

        private InstanceHolder() {
        }
    }
}

